/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.util;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import com.ibm.team.jface.util.UIUpdaterJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class UIUpdateManager {
    private UIUpdaterJob fUpdaterRunnable;
    private Object fLock = new Object();
    private Job fJob;
    private UIJob fUIJob;
    private boolean fSystem = true;
    private boolean fUser = false;

    public UIUpdateManager(UIUpdaterJob runnable) {
        this.fUpdaterRunnable = runnable;
    }

    public void schedule() {
        this.schedule(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(long delay) {
        Object object = this.fLock;
        synchronized (object) {
            this.cancel();
            this.fJob = new BackgroundJob(this.fJob, (Job)this.fUIJob);
            this.fUIJob = null;
            if (this.fUser) {
                this.fJob.setUser(this.fUser);
            } else {
                this.fJob.setSystem(this.fSystem);
            }
            this.fJob.schedule(delay);
        }
    }

    public void cancel() {
        if (this.fJob != null) {
            this.fJob.cancel();
        }
        if (this.fUIJob != null) {
            this.fUIJob.cancel();
        }
    }

    public void setSystem(boolean isSystem) {
        this.fSystem = isSystem;
    }

    public void setUser(boolean isUser) {
        this.fUser = isUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        while (true) {
            Job job = null;
            UIJob uiJob = null;
            Object object = this.fLock;
            synchronized (object) {
                job = this.fJob;
                uiJob = this.fUIJob;
            }
            if (job == null && uiJob == null) {
                return;
            }
            if (job != null) {
                job.join();
            }
            if (uiJob == null) continue;
            if (Display.getCurrent() == null) {
                uiJob.join();
                continue;
            }
            try {
                IStatus status = uiJob.runInUIThread((IProgressMonitor)new NullProgressMonitor());
                if (status == null || status.isOK()) continue;
                JFacePlugin.getDefault().log(status);
                continue;
            }
            finally {
                uiJob.cancel();
                continue;
            }
            break;
        }
    }

    private class BackgroundJob
    extends FoundationJob {
        private Job fPredecessor;
        private Job fUIPredecessor;

        public BackgroundJob(Job predecessor, Job uiPredecessor) {
            super(UIUpdateManager.this.fUpdaterRunnable.getName());
            this.fPredecessor = predecessor;
            this.fUIPredecessor = uiPredecessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus runProtected(IProgressMonitor monitor) {
            block45: {
                block44: {
                    block43: {
                        block42: {
                            IStatus iStatus;
                            try {
                                if (!monitor.isCanceled()) break block42;
                                iStatus = Status.CANCEL_STATUS;
                            }
                            catch (Throwable throwable) {
                                Object object = UIUpdateManager.this.fLock;
                                synchronized (object) {
                                    if (UIUpdateManager.this.fJob == this) {
                                        UIUpdateManager.this.fJob = null;
                                    }
                                }
                                throw throwable;
                            }
                            Object object = UIUpdateManager.this.fLock;
                            synchronized (object) {
                                if (UIUpdateManager.this.fJob == this) {
                                    UIUpdateManager.this.fJob = null;
                                }
                            }
                            return iStatus;
                        }
                        try {
                            if (this.fPredecessor != null) {
                                this.fPredecessor.join();
                            }
                            if (this.fUIPredecessor != null && this.fUIPredecessor.getThread() != null && Display.findDisplay((Thread)this.fUIPredecessor.getThread()) != null) {
                                this.fUIPredecessor.join();
                            }
                        }
                        catch (InterruptedException x) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            Object object = UIUpdateManager.this.fLock;
                            synchronized (object) {
                                if (UIUpdateManager.this.fJob == this) {
                                    UIUpdateManager.this.fJob = null;
                                }
                            }
                            return iStatus;
                        }
                        if (!monitor.isCanceled()) break block43;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        Object object = UIUpdateManager.this.fLock;
                        synchronized (object) {
                            if (UIUpdateManager.this.fJob == this) {
                                UIUpdateManager.this.fJob = null;
                            }
                        }
                        return iStatus;
                    }
                    IStatus status = UIUpdateManager.this.fUpdaterRunnable.runInBackground(monitor);
                    if (status == null || status.isOK()) break block44;
                    IStatus iStatus = status;
                    Object object = UIUpdateManager.this.fLock;
                    synchronized (object) {
                        if (UIUpdateManager.this.fJob == this) {
                            UIUpdateManager.this.fJob = null;
                        }
                    }
                    return iStatus;
                }
                if (!monitor.isCanceled()) break block45;
                IStatus iStatus = Status.CANCEL_STATUS;
                Object object = UIUpdateManager.this.fLock;
                synchronized (object) {
                    if (UIUpdateManager.this.fJob == this) {
                        UIUpdateManager.this.fJob = null;
                    }
                }
                return iStatus;
            }
            Object object = UIUpdateManager.this.fLock;
            synchronized (object) {
                UIUpdateManager.this.fUIJob = new ForegroundJob();
                UIUpdateManager.this.fUIJob.setSystem(true);
                UIUpdateManager.this.fUIJob.schedule();
            }
            IStatus iStatus = Status.OK_STATUS;
            Object object2 = UIUpdateManager.this.fLock;
            synchronized (object2) {
                if (UIUpdateManager.this.fJob == this) {
                    UIUpdateManager.this.fJob = null;
                }
            }
            return iStatus;
        }
    }

    private class ForegroundJob
    extends LoggingUIJob {
        public ForegroundJob() {
            super(UIUpdateManager.this.fUpdaterRunnable.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IStatus runProtectedInUI(IProgressMonitor monitor) {
            block21: {
                block20: {
                    IStatus iStatus;
                    try {
                        if (!monitor.isCanceled()) break block20;
                        iStatus = Status.CANCEL_STATUS;
                    }
                    catch (Throwable throwable) {
                        Object object = UIUpdateManager.this.fLock;
                        synchronized (object) {
                            if (UIUpdateManager.this.fUIJob == this) {
                                UIUpdateManager.this.fUIJob = null;
                            }
                        }
                        throw throwable;
                    }
                    Object object = UIUpdateManager.this.fLock;
                    synchronized (object) {
                        if (UIUpdateManager.this.fUIJob == this) {
                            UIUpdateManager.this.fUIJob = null;
                        }
                    }
                    return iStatus;
                }
                IStatus status = UIUpdateManager.this.fUpdaterRunnable.runInUI(monitor);
                if (status == null || status.isOK()) break block21;
                IStatus iStatus = status;
                Object object = UIUpdateManager.this.fLock;
                synchronized (object) {
                    if (UIUpdateManager.this.fUIJob == this) {
                        UIUpdateManager.this.fUIJob = null;
                    }
                }
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            Object object = UIUpdateManager.this.fLock;
            synchronized (object) {
                if (UIUpdateManager.this.fUIJob == this) {
                    UIUpdateManager.this.fUIJob = null;
                }
            }
            return iStatus;
        }
    }
}

