/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.tooltip;

import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.internal.tooltip.FocusTooltip;
import com.ibm.team.jface.internal.tooltip.NavigatorFocusTooltip;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.util.UIUpdaterJob;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TooltipUtils {
    private static UIUpdaterJob fgCurrentUpdater;

    public static void updateTooltipTitle(final Object element, final Tooltip tooltip) {
        if (!(tooltip instanceof FocusTooltip) || tooltip instanceof NavigatorFocusTooltip) {
            return;
        }
        if (fgCurrentUpdater != null) {
            fgCurrentUpdater.cancel();
        }
        if (element == null) {
            return;
        }
        fgCurrentUpdater = new UIUpdaterJob(""){
            private String title;

            @Override
            public IStatus runInBackground(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Object input = element;
                if (input instanceof URI) {
                    try {
                        input = Hyperlinks.resolve((URI)((URI)input), null, (IProgressMonitor)monitor);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                if (monitor.isCanceled() || input == null) {
                    return Status.CANCEL_STATUS;
                }
                IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter(input);
                if (adapter != null && !monitor.isCanceled()) {
                    IDomainAdapter.Info uiContext = new IDomainAdapter.Info();
                    uiContext.isFocusTooltip = true;
                    this.title = adapter instanceof DomainAdapter ? ((DomainAdapter)adapter).generateTitle(input, uiContext) : adapter.generateTitle(input);
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }

            @Override
            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.title != null && !monitor.isCanceled()) {
                    ((FocusTooltip)tooltip).setTitle(this.title);
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        fgCurrentUpdater.setSystem(true);
        fgCurrentUpdater.schedule();
    }
}

