/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.tooltip;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.internal.tooltip.Messages;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import com.ibm.team.jface.preview.IDomainAdapter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public abstract class MarkupJob
extends FoundationJob {
    private Tooltip fToolTip;
    private String fMarkup;
    private Object fJobId;
    private URIReference fContext;

    public MarkupJob(Object jobId, String name) {
        super(name);
        this.fJobId = jobId;
    }

    public boolean belongsTo(Object family) {
        return family == MarkupJobIdentifier.class || this.fJobId != null && this.fJobId.equals(family);
    }

    public final void init(Tooltip toolTip) {
        this.fToolTip = toolTip;
    }

    public String getMarkup() {
        return this.fMarkup;
    }

    public URIReference getContext() {
        return this.fContext;
    }

    protected final IStatus runProtected(IProgressMonitor monitor) {
        Object input;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.fMarkup = this.doRun((IProgressMonitor)subMonitor.newChild(1));
        if (this.fMarkup == null) {
            return Status.OK_STATUS;
        }
        this.fContext = null;
        if (this.fJobId instanceof MarkupJobIdentifier && (input = ((MarkupJobIdentifier)this.fJobId).fInput) != null) {
            this.fContext = Hyperlinks.create((Object)input, (IProgressMonitor)subMonitor.newChild(1));
        }
        if (this.fToolTip.isDisposed() || monitor.isCanceled()) {
            return Status.OK_STATUS;
        }
        LoggingUIJob job = new LoggingUIJob(Messages.MarkupJob_TOOLTIP){

            @Override
            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (MarkupJob.this.fToolTip.isDisposed() || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                MarkupJob.this.fToolTip.setText(MarkupJob.this.fMarkup);
                MarkupJob.this.fToolTip.setContext(MarkupJob.this.fContext);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return Status.OK_STATUS;
    }

    protected String doRun(IProgressMonitor monitor) {
        return this.run();
    }

    @Deprecated
    protected String run() {
        return Messages.MarkupJob_NO_MARKUP;
    }

    public Object getJobIdentifier() {
        return this.fJobId;
    }

    public static class MarkupJobIdentifier {
        private IDomainAdapter.Info fInfo;
        private Object fInput;

        public MarkupJobIdentifier(Object input, IDomainAdapter.Info info) {
            this.fInput = input;
            this.fInfo = info;
        }

        public int hashCode() {
            return this.fInfo.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof MarkupJobIdentifier) {
                MarkupJobIdentifier id = (MarkupJobIdentifier)object;
                return id.fInput == this.fInput && this.fInfo.equals(id.fInfo);
            }
            return false;
        }
    }
}

