/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.tooltip;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.tooltip.IHoverSite;
import com.ibm.team.jface.internal.tooltip.Messages;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HoverTooltip
extends Tooltip {
    private static final String SWT_WEBSITE_CONTROL = "org.eclipse.swt.browser.WebSite";
    private static final String TOOLTIP_ID = HoverTooltip.class.getName();
    private Composite fContentControl;
    private List<Control> fKeyListeningControls = new ArrayList<Control>();
    private Font fFocusFont;
    private boolean fIsFocusable;
    private KeyAdapter fKeyListener;
    private boolean fUseBrowser = true;

    protected HoverTooltip(Shell parent, IHoverSite hoverSite, boolean isFocusable, boolean useBrowser, Point preferredSize) {
        super(parent, hoverSite, preferredSize);
        this.fIsFocusable = isFocusable;
        this.fUseBrowser = useBrowser;
        this.createKeyListener();
    }

    private void addKeyListenerOnFocusControl() {
        Control focusControl = this.getShell().getDisplay().getFocusControl();
        if (focusControl != null && !focusControl.isDisposed()) {
            Composite browser;
            Composite parent;
            Class<?> clazz = focusControl.getClass();
            this.addKeyListenerOnControl(focusControl);
            if (SWT_WEBSITE_CONTROL.equals(clazz.getName()) && (parent = focusControl.getParent()) != null && !parent.isDisposed() && (browser = parent.getParent()) instanceof Browser) {
                this.addKeyListenerOnControl((Control)browser);
            }
        }
    }

    @Override
    public void close() {
        if (this.fIsFocusable) {
            this.removeKeyListenerFromControls();
        }
        if (this.fContentControl instanceof Browser && !this.fContentControl.isDisposed()) {
            this.resetBrowser();
        }
        super.close();
    }

    @Override
    public void open(Point itemLocation, int itemHeight) {
        super.open(itemLocation, itemHeight);
        if (this.fIsFocusable) {
            this.addKeyListenerOnFocusControl();
        }
    }

    @Override
    protected Browser createBrowser(Composite parent) {
        try {
            return super.createBrowser(parent);
        }
        catch (SWTError e) {
            return null;
        }
    }

    @Override
    public Control createContents(Composite parent) {
        Composite stContainer = new Composite(parent, 0);
        stContainer.setBackground(this.getBackground());
        GridLayout grid = new GridLayout(1, false);
        grid.marginWidth = 2;
        grid.marginHeight = 2;
        stContainer.setLayout((Layout)grid);
        if (this.fUseBrowser) {
            this.fContentControl = this.createBrowser(stContainer);
        }
        if (this.fContentControl == null) {
            this.fContentControl = this.createStyledText(stContainer);
        }
        this.updateSize();
        return stContainer;
    }

    @Override
    protected void updateSize() {
        if (this.fContentControl == null || this.fContentControl.isDisposed()) {
            return;
        }
        GridData data = new GridData(4, 4, true, true);
        if (this.fContentControl instanceof Browser) {
            data.widthHint = this.getPreferredWidth();
            data.heightHint = this.getPreferredHeight();
        } else {
            data.widthHint = -1;
            data.heightHint = -1;
        }
        this.fContentControl.setLayoutData((Object)data);
    }

    @Override
    public Control createFooter(Composite parent) {
        if (!this.fIsFocusable) {
            return null;
        }
        Composite footerContainer = new Composite(parent, 0);
        footerContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        footerContainer.setBackground(this.getBackground());
        GridLayout grid = new GridLayout(1, false);
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        grid.verticalSpacing = 0;
        footerContainer.setLayout((Layout)grid);
        Label separator = new Label(footerContainer, 258);
        separator.setLayoutData((Object)new GridData(4, 1, true, false));
        separator.setBackground(footerContainer.getBackground());
        Composite infoContainer = new Composite(footerContainer, 0);
        infoContainer.setBackground(footerContainer.getBackground());
        infoContainer.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        FillLayout fill = new FillLayout(512);
        fill.marginWidth = 2;
        fill.marginHeight = 0;
        infoContainer.setLayout((Layout)fill);
        Label infoLabel = new Label(infoContainer, 131072);
        infoLabel.setText(Messages.HoverTooltip_PRESS_F2_FOCUS);
        infoLabel.setForeground(footerContainer.getDisplay().getSystemColor(16));
        infoLabel.setBackground(footerContainer.getBackground());
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)infoLabel);
        Font f = JFaceResources.getDialogFont();
        FontData defFont = f.getFontData()[0];
        this.fFocusFont = JazzResources.getFont((ResourceManager)resourceManager, FontDescriptor.createFrom((String)defFont.getName(), (int)(defFont.getHeight() - 1), (int)0), f);
        infoLabel.setFont(this.fFocusFont);
        return footerContainer;
    }

    @Override
    public Control createHeader(Composite parent) {
        return null;
    }

    private void createKeyListener() {
        if (this.fKeyListener == null) {
            this.fKeyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    IHoverSite oldSite = HoverTooltip.this.getHoverSite();
                    HoverTooltip.this.close();
                    if (e.keyCode == 0x100000B && oldSite != null) {
                        oldSite.focusRequested();
                    }
                }
            };
        }
    }

    protected StyledText createStyledText(Composite parent) {
        StyledText st = new StyledText(parent, 74);
        st.setLayoutData((Object)new GridData(4, 4, true, true));
        st.setForeground(this.getForeground());
        st.setBackground(this.getBackground());
        return st;
    }

    protected String getBackgroundAsCSS() {
        StringBuffer background = new StringBuffer();
        RGB bgColor = this.getBackground().getRGB();
        background.append("background: rgb(").append(bgColor.red);
        background.append(",").append(bgColor.green).append(",").append(bgColor.blue).append(");");
        return background.toString();
    }

    protected String getFontAsCSS() {
        StringBuffer font = new StringBuffer();
        Font defFont = JFaceResources.getDefaultFont();
        font.append("font: ").append(defFont.getFontData()[0].getHeight()).append(fIsMac ? "px" : "pt");
        font.append(" ").append(defFont.getFontData()[0].getName()).append(";");
        return font.toString();
    }

    protected final boolean isFocusable() {
        return this.fIsFocusable;
    }

    private void addKeyListenerOnControl(Control control) {
        if (control != null && !control.isDisposed()) {
            control.addKeyListener((KeyListener)this.fKeyListener);
            this.fKeyListeningControls.add(control);
        }
    }

    private void removeKeyListenerFromControls() {
        for (Control control : this.fKeyListeningControls) {
            if (control == null || control.isDisposed()) continue;
            control.removeKeyListener((KeyListener)this.fKeyListener);
        }
        this.fKeyListeningControls.clear();
    }

    private boolean isBrowser() {
        return this.fContentControl instanceof Browser;
    }

    protected void setContentControl(Composite contentControl) {
        this.fContentControl = contentControl;
    }

    protected void setFocusable(boolean focusable) {
        this.removeKeyListenerFromControls();
        this.fIsFocusable = focusable;
    }

    private void resetBrowser() {
        if (this.fContentControl instanceof Browser) {
            StringBuffer html = new StringBuffer();
            html.append("<html><body style=\"margin: 1; overflow: auto; ");
            html.append(this.getBackgroundAsCSS());
            html.append("\"></body></html>");
            ((Browser)this.fContentControl).setText(html.toString());
        }
    }

    @Override
    public void setText(String text) {
        if (text.equals(this.getText())) {
            return;
        }
        super.setText(text);
        if (this.fContentControl == null) {
            this.create();
        }
        if (this.fContentControl instanceof Browser) {
            StringBuffer html = new StringBuffer();
            String body = "<body style=\"margin: 1; overflow: hidden; " + this.getFontAsCSS() + this.getBackgroundAsCSS() + "\">\n";
            String BODY_TAG = "<body>";
            int pos = text.indexOf(BODY_TAG);
            if (pos >= 0) {
                String part1 = text.substring(0, pos);
                String part2 = text.substring(pos + BODY_TAG.length());
                html.append(part1);
                html.append(body);
                html.append(part2);
            } else {
                html.append("<html>\n");
                html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
                html.append(body);
                html.append(text);
                html.append("\n</body></html>\n");
            }
            ((Browser)this.fContentControl).setText(html.toString());
        } else {
            String t = XMLString.createFromXMLText((String)text).getPlainText();
            ((StyledText)this.fContentControl).setText(t);
        }
        this.pack();
    }

    protected void setTextControl(StyledText styledText) {
        this.fContentControl = styledText;
    }

    public static HoverTooltip createTooltip(Shell parent, IHoverSite hoverSite, boolean isFocusable, boolean useBrowser, Point preferredSize) {
        Object data;
        if (parent.getData(TOOLTIP_ID) != null && (data = parent.getData(TOOLTIP_ID)).getClass().getName().equals(HoverTooltip.class.getName()) && !((Tooltip)data).isDisposed() && useBrowser == ((HoverTooltip)data).isBrowser()) {
            HoverTooltip toolTip = (HoverTooltip)data;
            toolTip.setHoverSite(hoverSite);
            boolean oldFocusState = toolTip.isFocusable();
            if (oldFocusState && !isFocusable) {
                toolTip.setFocusable(false);
                toolTip.getFooter().dispose();
                toolTip.getShell().layout();
            } else if (!oldFocusState && isFocusable) {
                toolTip.createKeyListener();
                toolTip.setFocusable(true);
                toolTip.setFooter(toolTip.createFooter((Composite)toolTip.getShell()));
                toolTip.getShell().layout();
            } else if (oldFocusState && isFocusable) {
                toolTip.setFocusable(true);
            }
            toolTip.setPreferredSize(preferredSize);
            return toolTip;
        }
        return new HoverTooltip(parent, hoverSite, isFocusable, useBrowser, preferredSize);
    }
}

