/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.dashboard.ISection;
import com.ibm.team.jface.dashboard.Section;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.dashboard.ColorRegistry;
import com.ibm.team.jface.internal.dashboard.views.AccordionTeamCentralLayout;
import com.ibm.team.jface.internal.dashboard.views.Messages;
import com.ibm.team.jface.internal.dashboard.views.MultiTrackingSelectionProvider;
import com.ibm.team.jface.internal.dashboard.views.Perspective;
import com.ibm.team.jface.internal.dashboard.views.PerspectivesManager;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.internal.dashboard.views.SectionsManager;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralLayout;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralUtils;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.internal.TeamRepository;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class TeamCentralView
extends ViewPart
implements IPageChangeProvider {
    public static final String COLOR_ID = "com.ibm.team.jface.dashboard.Color";
    private static TeamCentralView fgInstance;
    private static final String MEMENTO_DIALOG_SETTINGS = "memento";
    public static final String MEMENTO_TEAM_CENTRAL = "teamcentral";
    private static final String PREF_RESTORE_TRIMMED_ON_EVENT = "restoreTrimmedOnEvent";
    private static final String PREF_LAYOUT_NON_ANIMATED = "layoutNonAnimated";
    public static final String PREF_SECTION_MODE = "sectionMode";
    public static final int SECTION_MODE_EXPAND_COLLAPSE = 0;
    public static final int SECTION_MODE_MAXIMIZE_MINIMIZE = 1;
    public static final int SECTION_MODE_OPEN_VIEW = 2;
    private String fViewId = "com.ibm.magnolia.TeamCentral";
    private Color fDashBackgroundColor;
    private IMemento fMemento;
    private MultiTrackingSelectionProvider fMultiTracker;
    private Canvas fParent;
    private Composite fPartControlParent;
    private IPartListener2 fPartListener;
    private PerspectivesManager fPerspectivesManager;
    private boolean fRestoreSectionOnHoverAndFocus = false;
    private boolean fLayoutNonAnimated = false;
    private int fSectionMode = 1;
    private SectionsManager fSectionsManager;
    private ResourceManager fResourceManager;
    private volatile AlertJob fAlertJob;
    private IWorkbenchSiteProgressService fSiteProgressService;
    private final Collator fCollator = Collator.getInstance();
    private ListenerList fPageListeners = new ListenerList();
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (TeamCentralView.COLOR_ID.equals(event.getProperty())) {
                TeamCentralView.this.setBackground((RGB)event.getNewValue());
            }
        }
    };

    public TeamCentralView() {
        if (((Object)((Object)this)).getClass().getName().contains("TeamCentralView")) {
            fgInstance = this;
        }
        this.fMultiTracker = new MultiTrackingSelectionProvider();
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public void setViewId(String viewId) {
        this.fViewId = viewId;
    }

    public void createPartControl(Composite parent) {
        this.fPartControlParent = parent;
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.fPartControlParent.setLayout((Layout)gl);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fMultiTracker);
        this.initPartListener();
        this.fParent = new Canvas(this.fPartControlParent, 262144);
        ColorRegistry colorreg = ColorRegistry.getDefault();
        this.fDashBackgroundColor = JazzResources.getColor(this.fResourceManager, colorreg.getColorDescriptor("TEAM_CENTRAL_BACKGROUND"));
        AccordionTeamCentralLayout teamCentralLayout = new AccordionTeamCentralLayout(this);
        this.fParent.setLayout((Layout)teamCentralLayout);
        this.fParent.setBackground(this.fDashBackgroundColor);
        this.fParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPerspectivesManager = new PerspectivesManager(this.fMemento, this.fViewId);
        this.fSectionsManager = new SectionsManager(this, this.fPerspectivesManager, this.fMultiTracker, this.fMemento, (Composite)this.fParent, this.fViewId);
        this.fSectionsManager.createSections();
        JFacePlugin.getDefault().getWorkbench().getThemeManager().addPropertyChangeListener(this.fPropertyChangeListener);
        this.installActions();
    }

    public void dispose() {
        super.dispose();
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        this.hideAlert();
        ColorRegistry.getDefault().dispose();
        JFacePlugin.getDefault().getWorkbench().getThemeManager().removePropertyChangeListener(this.fPropertyChangeListener);
        this.fResourceManager.dispose();
        fgInstance = null;
    }

    PerspectivesManager getPerspectivesManager() {
        return this.fPerspectivesManager;
    }

    public SectionsManager getSectionsManager() {
        return this.fSectionsManager;
    }

    int indexOf(SectionPart section) {
        SectionPart[] sections = TeamCentralLayout.getVisibleSections((Composite)this.fParent);
        int a = 0;
        while (a < sections.length) {
            if (sections[a] == section) {
                return a;
            }
            ++a;
        }
        return -1;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String settings;
        IDialogSettings section;
        this.fSiteProgressService = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class);
        if (this.fMemento == null && (section = JFacePlugin.getDefault().getDialogSettings().getSection(this.fViewId)) != null && (settings = section.get(MEMENTO_DIALOG_SETTINGS)) != null) {
            try {
                this.fMemento = XMLMemento.createReadRoot((Reader)new StringReader(settings));
                this.initFromMemento(this.fMemento);
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
        super.init(site);
    }

    protected void initFromMemento(IMemento memento) {
        if (memento.getString(PREF_RESTORE_TRIMMED_ON_EVENT) != null) {
            this.fRestoreSectionOnHoverAndFocus = false;
        }
        if (memento.getString(PREF_LAYOUT_NON_ANIMATED) != null) {
            this.fLayoutNonAnimated = Boolean.valueOf(memento.getString(PREF_LAYOUT_NON_ANIMATED));
        }
        this.fSectionMode = memento.getInteger(PREF_SECTION_MODE) != null ? memento.getInteger(PREF_SECTION_MODE) : 1;
    }

    private void initPartListener() {
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(TeamCentralView.this.fViewId)) {
                    TeamCentralView.this.hideAlert();
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(TeamCentralView.this.fViewId)) {
                    TeamCentralView.this.hideAlert();
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (TeamCentralView.this.fViewId.equals(partRef.getId())) {
                    TeamCentralView.this.saveState();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(TeamCentralView.this.fViewId)) {
                    TeamCentralView.this.hideAlert();
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(TeamCentralView.this.fViewId)) {
                    TeamCentralView.this.hideAlert();
                }
            }
        };
        this.getViewSite().getPage().addPartListener(this.fPartListener);
    }

    private void installActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager viewMenuManager = bars.getMenuManager();
        viewMenuManager.add((IContributionItem)new ContributionItem(){

            public void fill(final Menu menu, int index) {
                ActionContributionItem item;
                MenuItem newSectionSubMenuItem = new MenuItem(menu, 64);
                newSectionSubMenuItem.setText(Messages.TeamCentralView_NEW_SECTION);
                Menu sectionsSubMenu = new Menu(newSectionSubMenuItem);
                newSectionSubMenuItem.setMenu(sectionsSubMenu);
                Action[] templateActions = TeamCentralView.this.fSectionsManager.getSectionActions(true);
                int i = 0;
                while (i < templateActions.length) {
                    item = new ActionContributionItem((IAction)templateActions[i]);
                    item.fill(sectionsSubMenu, i);
                    ++i;
                }
                new MenuItem(menu, 2);
                MenuItem visibleSectionsSubMenuItem = new MenuItem(menu, 64);
                visibleSectionsSubMenuItem.setText(Messages.TeamCentralView_VISIBLE_SECTIONS);
                sectionsSubMenu = new Menu(visibleSectionsSubMenuItem);
                visibleSectionsSubMenuItem.setMenu(sectionsSubMenu);
                Action[] actions = TeamCentralView.this.fSectionsManager.getSectionActions(false);
                i = 0;
                while (i < actions.length) {
                    item = new ActionContributionItem((IAction)actions[i]);
                    item.fill(sectionsSubMenu, i);
                    ++i;
                }
                MenuItem dupSection = new MenuItem(menu, 0);
                dupSection.setText(Messages.TeamCentralView_DUPLICATE_LAYOUT);
                dupSection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Perspective currentPerspective = TeamCentralView.this.fPerspectivesManager.getCurrentPerspective();
                        InputDialog inputDialog = new InputDialog(menu.getShell(), Messages.TeamCentralView_DUPLICATE_LAYOUT2, Messages.TeamCentralView_ENTER_NAME_NEW_LAYOUT, NLS.bind((String)Messages.TeamCentralView_COPY_OF_SECTION, (Object)currentPerspective.getName()), new IInputValidator(){

                            public String isValid(String newText) {
                                if (newText.equals("")) {
                                    return Messages.TeamCentralView_INVALID_NAME;
                                }
                                return null;
                            }
                        });
                        if (inputDialog.open() == 0) {
                            String newTitle = inputDialog.getValue();
                            Perspective clonedPerspective = Perspective.cloneFrom(currentPerspective, newTitle);
                            TeamCentralView.this.fPerspectivesManager.addPerspective(clonedPerspective);
                            TeamCentralView.this.fSectionsManager.switchToPerspective(clonedPerspective, true);
                        }
                    }
                });
                new MenuItem(menu, 2);
                TreeSet<Perspective> sortedPerspectives = new TreeSet<Perspective>(new Comparator<Perspective>(){

                    @Override
                    public int compare(Perspective o1, Perspective o2) {
                        String name1 = o1.getName();
                        String name2 = o2.getName();
                        return TeamCentralView.this.fCollator.compare(name1, name2);
                    }
                });
                sortedPerspectives.addAll(TeamCentralView.this.fPerspectivesManager.getPerspectives());
                for (final Perspective perspectiveDesc : sortedPerspectives) {
                    final MenuItem item2 = new MenuItem(menu, 16);
                    item2.setText(perspectiveDesc.getName());
                    item2.setSelection(TeamCentralView.this.fPerspectivesManager.getCurrentPerspective() == perspectiveDesc);
                    item2.setImage(JazzResources.getImageWithDefault(TeamCentralView.this.fResourceManager, ImagePool.SECTN_PERSPECTIVE));
                    item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (item2.getSelection()) {
                                TeamCentralView.this.fSectionsManager.switchToPerspective(perspectiveDesc, true);
                            }
                        }
                    });
                }
                new MenuItem(menu, 2);
                MenuItem settingsSubMenuItem = new MenuItem(menu, 64);
                settingsSubMenuItem.setText(Messages.TeamCentralView_SETTINGS);
                Menu settingsSubMenu = new Menu(settingsSubMenuItem);
                settingsSubMenuItem.setMenu(settingsSubMenu);
                TeamCentralView.this.addSettingsToMenu(settingsSubMenu);
            }

            public boolean isDynamic() {
                return true;
            }
        });
        IToolBarManager viewToolBarManager = bars.getToolBarManager();
        Action expandAll = new Action(){

            public void run() {
                SectionPart[] sections = TeamCentralLayout.getVisibleSections((Composite)TeamCentralView.this.fParent);
                SectionPart rememberLastSelected = TeamCentralView.this.fSectionsManager.getLastSelectedSection();
                int i = 0;
                while (i < sections.length) {
                    SectionPart section = sections[i];
                    section.setSectionExpanded(true, false, false);
                    ++i;
                }
                if (sections.length > 0) {
                    TeamCentralView.this.fSectionsManager.setLastSelectedSection(rememberLastSelected);
                    TeamCentralView.this.layoutAnimated();
                }
            }
        };
        expandAll.setToolTipText(Messages.TeamCentralView_EXPAND_ALL);
        expandAll.setImageDescriptor(ImagePool.EXPAND_ALL);
        viewToolBarManager.add((IAction)expandAll);
        Action refreshAll = new Action(){

            public void run() {
                TeamCentralView.this.refreshAll();
            }
        };
        refreshAll.setToolTipText(Messages.TeamCentralView_REFRESH_ALL);
        refreshAll.setImageDescriptor(ImagePool.REFRESH);
        viewToolBarManager.add((IAction)refreshAll);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)refreshAll);
    }

    protected void refreshAll() {
        SectionPart[] sections = TeamCentralLayout.getVisibleSections((Composite)this.fParent);
        SectionPart rememberLastSelected = this.fSectionsManager.getLastSelectedSection();
        int i = 0;
        while (i < sections.length) {
            SectionPart section = sections[i];
            ISection sec = section.getSectionDescriptor().getSection();
            if (sec instanceof Section) {
                ((Section)sec).refreshContent();
            }
            ++i;
        }
        if (sections.length > 0) {
            this.fSectionsManager.setLastSelectedSection(rememberLastSelected);
        }
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        final ArrayList<ITeamRepository> repositoriesToLogin = new ArrayList<ITeamRepository>(repositories.length);
        ITeamRepository[] iTeamRepositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            TeamRepository repo = (TeamRepository)repository;
            if (repo.getErrorState() == 1) {
                repositoriesToLogin.add(repository);
            }
            ++n2;
        }
        if (!repositoriesToLogin.isEmpty()) {
            FoundationJob loginJob = new FoundationJob(Messages.TeamCentralView_LOG_INTO_REPOSITORIES){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    for (ITeamRepository repository : repositoriesToLogin) {
                        TeamCentralUtils.validateRepository(repository, true, monitor);
                    }
                    return Status.OK_STATUS;
                }
            };
            loginJob.schedule();
        }
    }

    protected void addSettingsToMenu(Menu settingsSubMenu) {
        MenuItem modeOne = new MenuItem(settingsSubMenu, 16);
        modeOne.setText(Messages.TeamCentralView_EXPAND_COLLAPSE_SINGLE_CLICK);
        modeOne.setSelection(this.fSectionMode == 0);
        modeOne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamCentralView.this.fSectionMode = 0;
            }
        });
        MenuItem modeTwo = new MenuItem(settingsSubMenu, 16);
        modeTwo.setText(Messages.TeamCentralView_MAX_RESTORE_DOUBLECLICK);
        modeTwo.setSelection(this.fSectionMode == 1);
        modeTwo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamCentralView.this.fSectionMode = 1;
            }
        });
        MenuItem modeThree = new MenuItem(settingsSubMenu, 16);
        modeThree.setText(Messages.TeamCentralView_OPEN_SECTION_DOUBLECLICK);
        modeThree.setSelection(this.fSectionMode == 2);
        modeThree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamCentralView.this.fSectionMode = 2;
            }
        });
    }

    boolean isMaximizeSupport() {
        return this.fSectionMode == 1;
    }

    boolean isOpenViewSupport() {
        return this.fSectionMode == 2;
    }

    boolean isRestoreSectionOnHoverAndFocus() {
        return this.fRestoreSectionOnHoverAndFocus;
    }

    boolean isLayoutNonAnimated() {
        return this.fLayoutNonAnimated;
    }

    void layoutAnimated() {
        Layout layout = this.fParent.getLayout();
        if (layout instanceof TeamCentralLayout) {
            ((TeamCentralLayout)this.fParent.getLayout()).setLayoutAnimated(true);
        }
        this.fParent.layout();
    }

    public void saveState(IMemento memento) {
        this.saveState();
    }

    private void saveState() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MEMENTO_TEAM_CENTRAL);
        this.saveStateToMemento((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            String sectionName = this.fViewId;
            IDialogSettings section = JFacePlugin.getDefault().getDialogSettings().getSection(sectionName);
            if (section == null) {
                section = JFacePlugin.getDefault().getDialogSettings().addNewSection(sectionName);
            }
            section.put(MEMENTO_DIALOG_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException e) {
            JFacePlugin.getDefault().log("Error while saving Team Dashboard state", e);
        }
    }

    protected void saveStateToMemento(IMemento memento) {
        memento.putString(PREF_LAYOUT_NON_ANIMATED, String.valueOf(this.fLayoutNonAnimated));
        memento.putInteger(PREF_SECTION_MODE, this.fSectionMode);
        if (this.fPerspectivesManager != null) {
            this.fPerspectivesManager.saveState(memento);
        }
        if (this.fSectionsManager != null) {
            this.fSectionsManager.saveState(memento);
        }
    }

    private void setBackground(Control control, Color newColor) {
        if (control.getBackground() == null || control.getBackground().getRGB().equals((Object)this.fDashBackgroundColor.getRGB())) {
            control.setBackground(newColor);
        }
        if (control instanceof Composite) {
            int a = 0;
            while (a < ((Composite)control).getChildren().length) {
                this.setBackground(((Composite)control).getChildren()[a], newColor);
                ++a;
            }
        }
    }

    private void setBackground(RGB color) {
        Color newColor = JazzResources.getColor(this.fResourceManager, color);
        this.setBackground((Control)this.fParent, newColor);
        this.fDashBackgroundColor = newColor;
        Control[] sections = this.fParent.getChildren();
        int a = 0;
        while (a < this.fParent.getChildren().length) {
            ((SectionPart)sections[a]).setHeadBackground(this.fDashBackgroundColor);
            ((SectionPart)sections[a]).updateGradient();
            ++a;
        }
    }

    public void setFocus() {
        Control control;
        ISelectionProvider activeSelectionProvider = this.fMultiTracker.getActiveSelectionProvider();
        if (activeSelectionProvider != null && activeSelectionProvider instanceof Viewer && !(control = ((Viewer)activeSelectionProvider).getControl()).isDisposed()) {
            control.setFocus();
        }
    }

    protected ImageDescriptor getTitleImageDescriptor() {
        return ImagePool.TC_VIEW_GREEN;
    }

    protected void updateTitleImage() {
        this.checkUIThread();
        ImageDescriptor titleImageDescriptor = this.getTitleImageDescriptor();
        AlertJob alertJob = this.fAlertJob;
        if (alertJob != null) {
            alertJob.update(titleImageDescriptor);
        } else {
            this.setTitleImage(JazzResources.getImageWithDefault(this.fResourceManager, titleImageDescriptor));
        }
    }

    void showAlert(boolean showUntilViewOpened) {
        this.checkUIThread();
        this.hideAlert();
        this.fAlertJob = new AlertJob(showUntilViewOpened &= this.getViewSite().getPage().getActivePart() != this, this.getTitleImageDescriptor());
        this.fAlertJob.schedule();
        this.fSiteProgressService.warnOfContentChange();
    }

    private void hideAlert() {
        this.checkUIThread();
        AlertJob currentJob = this.fAlertJob;
        if (currentJob != null) {
            currentJob.stop();
        }
    }

    public static TeamCentralView getDefault() {
        return fgInstance;
    }

    public static SectionsManager getTeamCentralSectionAlignment() {
        if (fgInstance != null) {
            return TeamCentralView.fgInstance.fSectionsManager;
        }
        return null;
    }

    public static Composite getTeamCentralViewComposite() {
        if (fgInstance != null) {
            return TeamCentralView.fgInstance.fParent;
        }
        return null;
    }

    protected Color getBackgroundColor() {
        return this.fDashBackgroundColor;
    }

    protected MultiTrackingSelectionProvider getSelectionTracker() {
        return this.fMultiTracker;
    }

    protected Composite getPartControlParent() {
        return this.fPartControlParent;
    }

    protected Control getPartControl() {
        return this.fParent;
    }

    private void checkUIThread() {
        Display display = this.getViewSite().getShell().getDisplay();
        if (display == null || display.getThread() != Thread.currentThread()) {
            SWT.error((int)22);
        }
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.fPageListeners.add((Object)listener);
    }

    public Object getSelectedPage() {
        return null;
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.fPageListeners.remove((Object)listener);
    }

    void firePageChanged(final PageChangedEvent event) {
        Object[] listeners = this.fPageListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageChangedListener l = (IPageChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++i;
        }
    }

    private class AlertJob
    extends LoggingUIJob {
        private static final long BLINK_INTERVAL = 500L;
        private static final int INTERVAL_COUNT = 10;
        private ResourceManager fAlertImageManager;
        private Image fAlertImage;
        private Image fNormalImage;
        private boolean fAlertIsShowing;
        private int fRemainingIterations;

        public AlertJob(boolean nonStop, ImageDescriptor descriptor) {
            super(Messages.TeamCentralView_TEAM_CENTRAL_ALERT);
            this.fAlertImageManager = new LocalResourceManager(TeamCentralView.this.fResourceManager);
            this.fRemainingIterations = nonStop ? -1 : 10;
            this.fAlertIsShowing = false;
            this.update(descriptor);
            this.setSystem(true);
        }

        public void update(ImageDescriptor descriptor) {
            this.fNormalImage = JazzResources.getImageWithDefault(TeamCentralView.this.fResourceManager, descriptor);
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
            imageDescriptorArray[1] = ImagePool.NEWINFO_OVRL;
            OverlayIcon alertImageDescriptor = new OverlayIcon(descriptor, this.fNormalImage, imageDescriptorArray, new Point(16, 16), 131200);
            this.fAlertImage = JazzResources.getImageWithDefault(this.fAlertImageManager, (ImageDescriptor)alertImageDescriptor);
        }

        public void stop() {
            this.cancel();
            if (this.fAlertIsShowing) {
                TeamCentralView.this.setTitleImage(this.fNormalImage);
            }
            this.dispose();
        }

        @Override
        public IStatus runProtectedInUI(IProgressMonitor monitor) {
            if (this.fAlertImageManager != null) {
                this.fAlertIsShowing = !this.fAlertIsShowing;
                Image image = this.fAlertIsShowing ? this.fAlertImage : this.fNormalImage;
                TeamCentralView.this.setTitleImage(image);
                if (this.fRemainingIterations != 0 || this.fAlertIsShowing) {
                    this.schedule(500L);
                } else {
                    this.dispose();
                }
                if (this.fRemainingIterations > 0) {
                    --this.fRemainingIterations;
                }
            }
            return Status.OK_STATUS;
        }

        private void dispose() {
            if (this.fAlertImageManager != null) {
                this.fAlertImageManager.dispose();
                this.fAlertImageManager = null;
                TeamCentralView.this.fAlertJob = null;
            }
        }
    }
}

