/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

class TeamCentralUtils {
    TeamCentralUtils() {
    }

    public static IStatus validateRepository(ITeamRepository repository, boolean showErrorDialog, IProgressMonitor monitor) {
        if (repository.loggedIn() && repository.getErrorState() == 0) {
            return TeamCentralUtils.assessStatus(repository, false, null);
        }
        boolean inUIthread = Display.getCurrent() != null;
        final IStatus status = inUIthread ? TeamCentralUtils.loginFromUIThread(repository) : TeamCentralUtils.loginFromBackgroundThread(repository, monitor);
        if (showErrorDialog && status.getSeverity() == 4) {
            if (inUIthread) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.TeamCentralUtils_VALIDATION_ERROR, (String)status.getMessage());
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.TeamCentralUtils_VALIDATION_ERROR, (String)status.getMessage());
                    }
                });
            }
        }
        return status;
    }

    private static IStatus loginFromUIThread(final ITeamRepository repository) {
        try {
            final IStatus[] status = new IStatus[1];
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    status[0] = TeamCentralUtils.loginFromBackgroundThread(repository, monitor);
                }
            });
            return status[0];
        }
        catch (InvocationTargetException ex) {
            return TeamCentralUtils.assessStatus(repository, false, (Exception)ex.getCause());
        }
        catch (InterruptedException ex) {
            return TeamCentralUtils.assessStatus(repository, true, null);
        }
    }

    private static IStatus loginFromBackgroundThread(ITeamRepository repository, IProgressMonitor monitor) {
        try {
            repository.login(monitor);
            return TeamCentralUtils.assessStatus(repository, false, null);
        }
        catch (OperationCanceledException oce) {
            return TeamCentralUtils.assessStatus(repository, true, null);
        }
        catch (TeamRepositoryException e) {
            return TeamCentralUtils.assessStatus(repository, false, (Exception)((Object)e));
        }
    }

    private static IStatus assessStatus(ITeamRepository repository, boolean wasCanceled, Exception x) {
        if (repository.loggedIn() && repository.getErrorState() == 0) {
            return Status.OK_STATUS;
        }
        if (wasCanceled) {
            return Status.CANCEL_STATUS;
        }
        String reason = x != null ? x.getLocalizedMessage() : (repository.getErrorState() == 2 ? Messages.TeamCentralUtils_AUTH_ERROR : Messages.TeamCentralUtils_CON_ERROR);
        String message = NLS.bind((String)Messages.TeamCentralUtils_COULD_NOT_LOGIN, (Object)reason, (Object[])new Object[0]);
        return new Status(4, "com.ibm.team.jface", message, (Throwable)x);
    }
}

