/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.Messages;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralView;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class TeamCentralLayout
extends Layout {
    public static final int MARGIN_HEIGHT = 0;
    public static final int SECTION_MARGIN = 0;
    private static final int ANIMATION_SLEEP = 10;
    private static final int ANIMATION_STEPS = 5;
    private static final int ANIMATION_DELAY = 200;
    private boolean fLayoutAnimated = false;
    protected TeamCentralView fTeamCentralView;
    private boolean fAnimationRunning = false;
    private UIJob fCurrentAnimatorJob;
    static final boolean DEBUG = false;

    public Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return this.computeSize(composite, false);
    }

    protected Point computeSize(Composite composite, boolean excludeExpanded) {
        SectionPart[] sections;
        Rectangle tcClientArea = composite.getClientArea();
        int computedX = tcClientArea.width;
        int computedY = 0;
        SectionPart[] sectionPartArray = sections = TeamCentralLayout.getVisibleSections(composite);
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            SectionPart section = sectionPartArray[n2];
            if (!section.isExpanded() || !excludeExpanded) {
                computedY += section.computeSize((int)tcClientArea.width, (int)-1).y;
                computedY += 0;
            }
            ++n2;
        }
        computedY += 0;
        return new Point(computedX, computedY += 0);
    }

    protected final void layout(Composite composite, boolean flushCache) {
        Rectangle dashboardClientArea = composite.getClientArea();
        if (dashboardClientArea.height == 0) {
            return;
        }
        int maximumWidth = dashboardClientArea.width;
        int maximumHeight = dashboardClientArea.height - 0;
        Map<SectionPart, Rectangle> newSectionBounds = this.getLayout(composite, maximumWidth, maximumHeight);
        if (newSectionBounds != null) {
            this.applyLayout(composite, newSectionBounds);
            this.fLayoutAnimated = false;
        }
    }

    abstract Map<SectionPart, Rectangle> getLayout(Composite var1, int var2, int var3);

    protected SectionPart getPreviousSection(SectionPart part) {
        SectionPart[] visibleSections = TeamCentralLayout.getVisibleSections((Composite)this.fTeamCentralView.getPartControl());
        int i = 0;
        while (i < visibleSections.length) {
            SectionPart section = visibleSections[i];
            if (section == part && i > 0) {
                return visibleSections[i - 1];
            }
            ++i;
        }
        return null;
    }

    protected boolean[] getExpandedIndices(SectionPart[] sections) {
        boolean[] ret = new boolean[sections.length];
        int j = 0;
        while (j < sections.length) {
            ret[j] = sections[j].isExpanded();
            ++j;
        }
        return ret;
    }

    protected int countExpanded(boolean[] expandedIndexes) {
        int expanded = 0;
        boolean[] blArray = expandedIndexes;
        int n = expandedIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (b) {
                ++expanded;
            }
            ++n2;
        }
        return expanded;
    }

    protected int getNextExpandedSectionIndex(int i) {
        SectionPart[] visibleSections = TeamCentralLayout.getVisibleSections((Composite)this.fTeamCentralView.getPartControl());
        int j = i + 1;
        while (j < visibleSections.length) {
            if (visibleSections[j].isExpanded()) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    TeamCentralLayout(TeamCentralView teamCentralView) {
        this.fTeamCentralView = teamCentralView;
    }

    TeamCentralView getTeamCentralView() {
        return this.fTeamCentralView;
    }

    boolean getLayoutAnimated() {
        return this.fLayoutAnimated;
    }

    void setLayoutAnimated(boolean layoutAnimated) {
        this.fLayoutAnimated = layoutAnimated;
    }

    static SectionPart[] getVisibleSections(Composite composite) {
        Control[] sections = composite.getChildren();
        ArrayList<SectionPart> visibleChildren = new ArrayList<SectionPart>(sections.length);
        Control[] controlArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            Control section = controlArray[n2];
            if (section.getVisible()) {
                visibleChildren.add((SectionPart)section);
            }
            ++n2;
        }
        return visibleChildren.toArray(new SectionPart[visibleChildren.size()]);
    }

    static int getExpandedSectionsCount(Composite composite) {
        SectionPart[] sections;
        int count = 0;
        SectionPart[] sectionPartArray = sections = TeamCentralLayout.getVisibleSections(composite);
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            SectionPart section = sectionPartArray[n2];
            if (section.isExpanded()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private void applyLayout(Composite composite, Map<SectionPart, Rectangle> newSectionBounds) {
        SectionPart[] sections;
        SectionPart[] sectionPartArray = sections = TeamCentralLayout.getVisibleSections(composite);
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            SectionPart section = sectionPartArray[n2];
            Rectangle newBounds = newSectionBounds.get((Object)section);
            section.setBounds(newBounds);
            section.notifyResize();
            section.layout(true, true);
            ++n2;
        }
        composite.redraw();
        composite.getParent().redraw();
    }

    private void applyLayoutAnimated(Composite composite, Map<SectionPart, Rectangle> newSectionBounds) {
        if (this.fCurrentAnimatorJob != null) {
            this.fCurrentAnimatorJob.cancel();
        }
        SectionPart[] sections = TeamCentralLayout.getVisibleSections(composite);
        Display display = Display.getCurrent();
        Rectangle teamCentralBounds = composite.getBounds();
        ArrayList<SectionPart> sectionCache = new ArrayList<SectionPart>();
        ArrayList<Rectangle> newBoundsCache = new ArrayList<Rectangle>();
        ArrayList<Rectangle> oldBoundsCache = new ArrayList<Rectangle>();
        int a = 0;
        while (a < sections.length) {
            Rectangle oldBounds;
            Rectangle newBounds = newSectionBounds.get((Object)sections[a]);
            if (!newBounds.equals((Object)(oldBounds = sections[a].getBounds()))) {
                sectionCache.add(sections[a]);
                newBoundsCache.add(newBounds);
                oldBoundsCache.add(oldBounds);
            }
            ++a;
        }
        this.fAnimationRunning = true;
        class MyUIJob
        extends LoggingUIJob {
            int fSteps;
            private final /* synthetic */ ArrayList val$sectionCache;
            private final /* synthetic */ ArrayList val$newBoundsCache;
            private final /* synthetic */ ArrayList val$oldBoundsCache;
            private final /* synthetic */ Composite val$composite;
            private final /* synthetic */ Rectangle val$teamCentralBounds;

            MyUIJob(String name, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, Composite composite, Rectangle rectangle) {
                this.val$sectionCache = arrayList;
                this.val$newBoundsCache = arrayList2;
                this.val$oldBoundsCache = arrayList3;
                this.val$composite = composite;
                this.val$teamCentralBounds = rectangle;
                super(name);
                this.fSteps = 1;
            }

            @Override
            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                int a = 0;
                while (a < this.val$sectionCache.size()) {
                    SectionPart section = (SectionPart)((Object)this.val$sectionCache.get(a));
                    Rectangle newBounds = (Rectangle)this.val$newBoundsCache.get(a);
                    Rectangle oldBounds = (Rectangle)this.val$oldBoundsCache.get(a);
                    int newYPos = oldBounds.y + (newBounds.y - oldBounds.y) * this.fSteps / 5;
                    int newYSize = oldBounds.height + (newBounds.height - oldBounds.height) * this.fSteps / 5;
                    if (monitor.isCanceled()) {
                        TeamCentralLayout.this.fCurrentAnimatorJob = null;
                        return Status.CANCEL_STATUS;
                    }
                    if (!section.isDisposed()) {
                        section.setBounds(oldBounds.x, newYPos, oldBounds.width, newYSize);
                    }
                    section.notifyResize();
                    ++a;
                }
                if (this.val$sectionCache.size() > 0) {
                    Rectangle firstSectionBounds = (Rectangle)this.val$oldBoundsCache.get(0);
                    if (!this.val$composite.isDisposed()) {
                        this.val$composite.redraw(firstSectionBounds.x, firstSectionBounds.y, this.val$teamCentralBounds.width, this.val$teamCentralBounds.height - firstSectionBounds.y, false);
                        this.val$composite.update();
                    }
                }
                if (monitor.isCanceled()) {
                    TeamCentralLayout.this.fCurrentAnimatorJob = null;
                    return Status.CANCEL_STATUS;
                }
                long end = System.currentTimeMillis();
                if (this.fSteps < 5) {
                    ++this.fSteps;
                    int sl = 10 - (int)(end - start);
                    if (monitor.isCanceled()) {
                        TeamCentralLayout.this.fCurrentAnimatorJob = null;
                        return Status.CANCEL_STATUS;
                    }
                    this.schedule(sl < 0 ? 0 : sl);
                } else {
                    TeamCentralLayout.this.fAnimationRunning = false;
                    TeamCentralLayout.this.fCurrentAnimatorJob = null;
                }
                if (this.val$sectionCache.size() > 0) {
                    Rectangle firstSectionBounds = (Rectangle)this.val$oldBoundsCache.get(0);
                    if (((Rectangle)this.val$newBoundsCache.get((int)0)).y < firstSectionBounds.y) {
                        firstSectionBounds = (Rectangle)this.val$newBoundsCache.get(0);
                    }
                    if (monitor.isCanceled()) {
                        TeamCentralLayout.this.fCurrentAnimatorJob = null;
                        return Status.CANCEL_STATUS;
                    }
                    if (!this.val$composite.isDisposed()) {
                        this.val$composite.redraw(firstSectionBounds.x, firstSectionBounds.y - 0, this.val$teamCentralBounds.width, this.val$teamCentralBounds.height - firstSectionBounds.y, false);
                        this.val$composite.update();
                    }
                }
                return Status.OK_STATUS;
            }
        }
        this.fCurrentAnimatorJob = new MyUIJob(Messages.TeamCentralLayout_TC_ANIMATION, sectionCache, newBoundsCache, oldBoundsCache, composite, teamCentralBounds);
        this.fCurrentAnimatorJob.setSystem(true);
        this.fCurrentAnimatorJob.schedule(200L);
        while (this.fAnimationRunning && PlatformUI.isWorkbenchRunning() && !this.getTeamCentralView().getViewSite().getShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

