/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.SectionDNDImpl;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralLayout;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralResizer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SectionResizeMouseListener
implements Listener {
    private boolean fMouseDownOnResizableSection;
    private int fMouseYStart;
    private SectionPart fResizeSection;
    private final Display fDisplay;
    private final SectionPart fMousePart;
    private final SectionDNDImpl fDnd;

    public SectionResizeMouseListener(SectionPart part, SectionDNDImpl dnd) {
        this.fMousePart = part;
        this.fDnd = dnd;
        this.fDisplay = part.getDisplay();
    }

    public void handleEvent(Event e) {
        switch (e.type) {
            case 5: {
                this.onMouseMove(e);
                break;
            }
            case 3: {
                this.onMouseDown(e);
                break;
            }
            case 4: {
                this.fMouseDownOnResizableSection = false;
                this.fDnd.setBlockDND(false);
                break;
            }
            case 7: {
                this.fMouseDownOnResizableSection = false;
                this.fDnd.setBlockDND(false);
            }
        }
    }

    private void onMouseMove(Event e) {
        int mouseLocationY;
        SectionPart[] visibleSections;
        boolean layout;
        if (this.isResizeSensitive(e.x, e.y) || this.fMouseDownOnResizableSection) {
            this.fMousePart.fHeader.setCursor(this.fDisplay.getSystemCursor(7));
        } else {
            this.fMousePart.fHeader.setCursor(this.fDisplay.getSystemCursor(0));
        }
        if (this.fMouseDownOnResizableSection && this.fResizeSection != null && (layout = TeamCentralResizer.resize(visibleSections = TeamCentralLayout.getVisibleSections(this.fMousePart.getParent()), this.fResizeSection, this.fMouseYStart - (mouseLocationY = this.fDisplay.getCursorLocation().y), (e.stateMask & 0x40000) != 0))) {
            this.fMousePart.getParent().layout();
            this.fMousePart.getParent().update();
            this.fMouseYStart = mouseLocationY;
        }
    }

    private void onMouseDown(Event e) {
        if (e.button != 1) {
            return;
        }
        this.fResizeSection = this.getSectionToResize();
        if (this.fResizeSection != null) {
            this.fMouseYStart = this.fDisplay.getCursorLocation().y;
            this.fMouseDownOnResizableSection = true;
            this.fDnd.setBlockDND(true);
        }
    }

    private boolean isResizeSensitive(int x, int y) {
        return y < 5;
    }

    private SectionPart getSectionToResize() {
        SectionPart[] visibleSections = TeamCentralLayout.getVisibleSections(this.fMousePart.getParent());
        int i = 0;
        while (i < visibleSections.length) {
            if (visibleSections[i] == this.fMousePart && i > 0) {
                return visibleSections[i - 1];
            }
            ++i;
        }
        return null;
    }
}

