/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.PerspectiveSectionSlot;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;

public class Perspective {
    private static final String EXTENSION_SECTION_SLOT = "section";
    private static int fSectionCounter = 0;
    private static final String MEMENTO_HIDDEN_SLOT = "hidden_slot";
    private static final String MEMENTO_PERSPECTIVE = "perspective";
    private static final String MEMENTO_SLOT = "slot";
    private static final String PERSPECTIVE_ID = "id";
    private static final String PERSPECTIVE_IS_DEFAULT = "isDefault";
    private static final String PERSPECTIVE_NAME = "name";
    private ArrayList fHiddenSectionSlots;
    private String fId;
    private boolean fIsDefault;
    private String fName;
    private ArrayList fSectionSlots;

    Perspective(String id, String name, ArrayList sectionSlots, ArrayList hiddenSectionSlots, boolean isDefault) {
        this.fId = id;
        this.fName = name;
        this.fSectionSlots = sectionSlots;
        this.fHiddenSectionSlots = hiddenSectionSlots;
        this.fIsDefault = isDefault;
    }

    void addSection(PerspectiveSectionSlot sectionSlot) {
        if (!this.fSectionSlots.contains(sectionSlot)) {
            this.fSectionSlots.add(sectionSlot);
        }
        if (this.fHiddenSectionSlots.contains(sectionSlot)) {
            this.fHiddenSectionSlots.remove(sectionSlot);
        }
    }

    boolean containsSection(String sectionId) {
        for (PerspectiveSectionSlot secSlot : this.fSectionSlots) {
            if (!secSlot.getSectionId().equals(sectionId)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Perspective)) {
            return false;
        }
        return this.fId.equals(((Perspective)obj).getId());
    }

    ArrayList getAllContainedSectionSlots() {
        ArrayList allSlots = new ArrayList(this.fSectionSlots);
        allSlots.addAll(this.fHiddenSectionSlots);
        return allSlots;
    }

    ArrayList getHiddenSectionSlots() {
        return this.fHiddenSectionSlots;
    }

    String getId() {
        return this.fId;
    }

    String getName() {
        return this.fName;
    }

    public ArrayList getSectionSlots() {
        return this.fSectionSlots;
    }

    public int hashCode() {
        return this.fId.hashCode();
    }

    boolean isDefault() {
        return this.fIsDefault;
    }

    void removeSection(String sectionId, boolean delete) {
        for (PerspectiveSectionSlot secSlot : this.fSectionSlots) {
            if (!secSlot.getSectionId().equals(sectionId)) continue;
            this.fSectionSlots.remove(secSlot);
            if (delete) break;
            this.fHiddenSectionSlots.add(secSlot);
            break;
        }
    }

    void save(IMemento memento) {
        IMemento perspectiveMemento = memento.createChild(MEMENTO_PERSPECTIVE);
        perspectiveMemento.putString(PERSPECTIVE_ID, this.getId());
        perspectiveMemento.putString(PERSPECTIVE_NAME, this.getName());
        perspectiveMemento.putString(PERSPECTIVE_IS_DEFAULT, String.valueOf(this.fIsDefault));
        for (PerspectiveSectionSlot secSlot : this.fSectionSlots) {
            IMemento sectionSlotMemento = perspectiveMemento.createChild(MEMENTO_SLOT);
            secSlot.save(sectionSlotMemento);
        }
        for (PerspectiveSectionSlot hiddenSecSlot : this.fHiddenSectionSlots) {
            IMemento hiddenSectionSlotMemento = perspectiveMemento.createChild(MEMENTO_HIDDEN_SLOT);
            hiddenSecSlot.save(hiddenSectionSlotMemento);
        }
    }

    void setId(String id) {
        this.fId = id;
    }

    void setName(String name) {
        this.fName = name;
    }

    static Perspective cloneFrom(Perspective perspectiveDescriptor, String name) {
        String id = Perspective.createUId(perspectiveDescriptor.getId());
        Perspective clonedPerspective = new Perspective(id, name, new ArrayList(), new ArrayList(), false);
        ArrayList sectionSlotsToClone = perspectiveDescriptor.getSectionSlots();
        for (PerspectiveSectionSlot sectionSlot : sectionSlotsToClone) {
            clonedPerspective.getSectionSlots().add(PerspectiveSectionSlot.cloneFrom(sectionSlot, null, clonedPerspective, sectionSlot.getSectionId()));
        }
        ArrayList hiddenSectionSlotsToClone = perspectiveDescriptor.getHiddenSectionSlots();
        for (PerspectiveSectionSlot hiddenSectionSlot : hiddenSectionSlotsToClone) {
            clonedPerspective.getHiddenSectionSlots().add(PerspectiveSectionSlot.cloneFrom(hiddenSectionSlot, null, clonedPerspective, hiddenSectionSlot.getSectionId()));
        }
        return clonedPerspective;
    }

    static Perspective createFrom(IConfigurationElement configElement) {
        String perspectiveId = configElement.getAttribute(PERSPECTIVE_ID);
        String name = configElement.getAttribute(PERSPECTIVE_NAME);
        boolean isDefault = Boolean.valueOf(configElement.getAttribute(PERSPECTIVE_IS_DEFAULT));
        ArrayList<PerspectiveSectionSlot> sectionSlotList = new ArrayList<PerspectiveSectionSlot>();
        IConfigurationElement[] sectionSlots = configElement.getChildren(EXTENSION_SECTION_SLOT);
        int i = 0;
        while (i < sectionSlots.length) {
            PerspectiveSectionSlot secSlot = PerspectiveSectionSlot.createFrom(sectionSlots[i]);
            sectionSlotList.add(secSlot);
            ++i;
        }
        return new Perspective(perspectiveId, name, sectionSlotList, new ArrayList(), isDefault);
    }

    static Perspective createFrom(IMemento memento) {
        String id = memento.getString(PERSPECTIVE_ID);
        String name = memento.getString(PERSPECTIVE_NAME);
        boolean isDefault = Boolean.valueOf(memento.getString(PERSPECTIVE_IS_DEFAULT));
        Assert.isNotNull((Object)id);
        ArrayList<PerspectiveSectionSlot> sections = new ArrayList<PerspectiveSectionSlot>();
        IMemento[] sectionSlots = memento.getChildren(MEMENTO_SLOT);
        int j = 0;
        while (j < sectionSlots.length) {
            PerspectiveSectionSlot secSlot = PerspectiveSectionSlot.createFrom(sectionSlots[j]);
            sections.add(secSlot);
            ++j;
        }
        ArrayList<PerspectiveSectionSlot> hiddenSections = new ArrayList<PerspectiveSectionSlot>();
        IMemento[] hiddenSectionSlots = memento.getChildren(MEMENTO_HIDDEN_SLOT);
        int j2 = 0;
        while (j2 < hiddenSectionSlots.length) {
            PerspectiveSectionSlot hiddenSecSlot = PerspectiveSectionSlot.createFrom(hiddenSectionSlots[j2]);
            hiddenSections.add(hiddenSecSlot);
            ++j2;
        }
        return new Perspective(id, name, sections, hiddenSections, isDefault);
    }

    static Perspective[] createPerspectives(IMemento memento) {
        ArrayList<Perspective> perspectives = new ArrayList<Perspective>();
        if (memento != null && memento.getChildren(MEMENTO_PERSPECTIVE).length > 0) {
            IMemento[] perspectiveDescriptors = memento.getChildren(MEMENTO_PERSPECTIVE);
            int i = 0;
            while (i < perspectiveDescriptors.length) {
                Perspective perspective = Perspective.createFrom(perspectiveDescriptors[i]);
                perspectives.add(perspective);
                ++i;
            }
        }
        return perspectives.toArray(new Perspective[perspectives.size()]);
    }

    private static String createUId(String sourceId) {
        StringBuffer strBuf = new StringBuffer(sourceId);
        strBuf.append('#').append(++fSectionCounter);
        return strBuf.toString();
    }
}

