/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard;

import java.util.Hashtable;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class ColorRegistry {
    private static ColorRegistry fgInstance;
    public static final String TEAM_CENTRAL_BACKGROUND = "TEAM_CENTRAL_BACKGROUND";
    public static final String SECTION_HEADER_GRADIENT_START = "SECTION_HEADER_GRADIENT_START";
    public static final String SECTION_HEADER_GRADIENT_END = "SECTION_HEADER_GRADIENT_END";
    public static final String SECTION_HEADER_INNER_BORDER = "SECTION_HEADER_INNER_BORDER";
    public static final String SECTION_HEADER_OUTER_BORDER_TOP = "SECTION_HEADER_OUTER_BORDER_TOP";
    public static final String SECTION_HEADER_OUTER_BORDER_BOTTOM = "SECTION_HEADER_OUTER_BORDER_BOTTOM";
    public static final String SECTION_HEADER_SEPARATOR = "SECTION_HEADER_SEPARATOR";
    public static final String TWISTIE_HOVERED = "TWISTIE_HOVERED";
    public static final String TWISTIE_NORMAL = "TWISTIE_NORMAL";
    @Deprecated
    public static final String SECTION_HIGHLIGHT = "SECTION_HIGHLIGHT";
    @Deprecated
    public static final String SECTION_INNER = "SECTION_INNER";
    @Deprecated
    public static final String SECTION_INNER_MOST = "SECTION_INNER_MOST";
    @Deprecated
    public static final String SECTION_MOST_INNER_MOST = "SECTION_MOST_INNER_MOST";
    @Deprecated
    public static final String SECTION_OUTER = "SECTION_OUTER";
    @Deprecated
    public static final String SECTION_OUTER_MOST = "SECTION_OUTER_MOST";
    @Deprecated
    public static final String SECTION_STROKE = "SECTION_STROKE";
    private Hashtable<Object, ColorDescriptor> fColors = new Hashtable();
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private FormColors fFormColors = new FormColors((Display)this.fResourceManager.getDevice());

    private ColorRegistry() {
        this.init();
    }

    public void dispose() {
        fgInstance = null;
        this.fResourceManager.dispose();
        this.fFormColors.dispose();
    }

    public ColorDescriptor getColorDescriptor(Object obj) {
        return this.fColors.get(obj);
    }

    private void init() {
        this.setColor(TEAM_CENTRAL_BACKGROUND, this.blend(22, 25, 20));
        this.setColor(SECTION_HEADER_OUTER_BORDER_TOP, this.blend(18, 22, 60));
        this.setColor(SECTION_HEADER_INNER_BORDER, ColorDescriptor.createFrom((RGB)new RGB(255, 255, 255)));
        this.setColor(SECTION_HEADER_GRADIENT_START, this.blend(22, 25, 70));
        this.setColor(SECTION_HEADER_GRADIENT_END, ColorDescriptor.createFrom((RGB)this.getSystemColor(22)));
        this.setColor(SECTION_HEADER_OUTER_BORDER_BOTTOM, this.blend(18, 22, 80));
        this.setColor(SECTION_HEADER_SEPARATOR, ColorDescriptor.createFrom((RGB)this.getSystemColor(25)));
        this.setColor(TWISTIE_NORMAL, ColorDescriptor.createFrom((Color)this.fFormColors.getColor("org.eclipse.ui.forms.TB_TOGGLE")));
        this.setColor(TWISTIE_HOVERED, ColorDescriptor.createFrom((Color)this.fFormColors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER")));
    }

    private ColorDescriptor blend(int c1, int c2, int ratio) {
        return ColorDescriptor.createFrom((RGB)FormColors.blend((RGB)this.getSystemColor(c1), (RGB)this.getSystemColor(c2), (int)ratio));
    }

    private RGB getSystemColor(int code) {
        return this.fResourceManager.getDevice().getSystemColor(code).getRGB();
    }

    public Image replaceColor(RGB colorSearch, RGB colorReplace, Image image, boolean disposeSrc) {
        ImageData imgData = image.getImageData();
        int a = 0;
        while (a < imgData.palette.getRGBs().length) {
            if (imgData.palette.getRGBs()[a].equals((Object)colorSearch)) {
                imgData.palette.getRGBs()[a] = colorReplace;
            }
            ++a;
        }
        if (disposeSrc) {
            image.dispose();
        }
        return new Image((Device)Display.getDefault(), imgData);
    }

    public void setColor(Object key, ColorDescriptor colorDesc) {
        this.fColors.put(key, colorDesc);
    }

    public static ColorRegistry getDefault() {
        if (fgInstance == null) {
            fgInstance = new ColorRegistry();
        }
        return fgInstance;
    }
}

