/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.alerts;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.internal.alerts.InfoPop;
import com.ibm.team.jface.internal.alerts.InfoPopAnimator;
import com.ibm.team.jface.internal.alerts.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class InfoPopManager {
    private static final boolean STACK_ALERTS = true;
    static final boolean STACK_EVERY_ALERT = true;
    private static boolean ANIMATE = true;
    private static final int DISPATCH_INTERVAL = 220;
    public static final Object INFOPOP_JOB_FAMILY = InfoPopManager.class;
    static InfoPopManager fInstance;
    InfoPopAnimator fAnimator;
    private Job fDispatchLoop;
    private ArrayList fPopupQueue;
    boolean fStopped = false;

    public static InfoPopManager getDefault() {
        return Holder.INSTANCE;
    }

    private InfoPopManager() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReplaces(InfoPop newInfoPop) {
        ArrayList arrayList = this.fPopupQueue;
        synchronized (arrayList) {
            for (Object obj : this.fPopupQueue) {
                InfoPop infoPop = (InfoPop)obj;
                if (infoPop == newInfoPop || !infoPop.getEvent().isSameTo(newInfoPop.getEvent())) continue;
                this.close(infoPop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] popupQueueToArray() {
        ArrayList arrayList = this.fPopupQueue;
        synchronized (arrayList) {
            return this.fPopupQueue.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(InfoPop infoPop) {
        if (infoPop.getState() == 0) {
            ArrayList arrayList = this.fPopupQueue;
            synchronized (arrayList) {
                this.fPopupQueue.remove(infoPop);
            }
        } else if (infoPop.getState() != 3) {
            infoPop.setState(2);
        }
    }

    private void createInfoPopDispatchLoop() {
        this.fDispatchLoop = new FoundationJob(Messages.InfoPopManager_INFOPOP_MANAGER){

            public boolean belongsTo(Object family) {
                return INFOPOP_JOB_FAMILY.equals(family);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus runProtected(IProgressMonitor monitor) {
                if (!InfoPopManager.this.fAnimator.animationIsRunning() && !InfoPopManager.this.isMouseInAnyPopup()) {
                    Object[] obj = InfoPopManager.this.popupQueueToArray();
                    int i = 0;
                    while (i < obj.length) {
                        if (monitor.isCanceled()) {
                            return Status.OK_STATUS;
                        }
                        InfoPop infoPop = (InfoPop)obj[i];
                        if (infoPop != null) {
                            switch (infoPop.getState()) {
                                case 3: {
                                    ArrayList arrayList = InfoPopManager.this.fPopupQueue;
                                    synchronized (arrayList) {
                                        InfoPopManager.this.fPopupQueue.remove(infoPop);
                                        break;
                                    }
                                }
                                case 2: {
                                    if (InfoPopManager.this.fAnimator.animationIsRunning()) break;
                                    InfoPopManager.this.fAnimator.fadeOut(infoPop);
                                    infoPop.setState(3);
                                    break;
                                }
                                case 0: {
                                    if (InfoPopManager.this.fAnimator.animationIsRunning()) break;
                                    InfoPopManager.this.fAnimator.fadeIn(infoPop);
                                    infoPop.setState(1);
                                    infoPop.setVisibleSince(System.currentTimeMillis());
                                    break;
                                }
                                case 1: {
                                    if (infoPop.isSticky() || infoPop.getAutoCloseTimeout() == -1 || infoPop.fMouseInPopup || System.currentTimeMillis() <= infoPop.getVisibleSince() + (long)infoPop.getAutoCloseTimeout()) break;
                                    infoPop.setState(2);
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (!InfoPopManager.this.fPopupQueue.isEmpty() && !monitor.isCanceled()) {
                    this.schedule(220L);
                }
                return Status.OK_STATUS;
            }
        };
        this.fDispatchLoop.setSystem(true);
    }

    private void init() {
        this.fPopupQueue = new ArrayList();
        this.fAnimator = new InfoPopAnimator(this.fPopupQueue, ANIMATE);
        this.createInfoPopDispatchLoop();
    }

    private boolean isMouseInAnyPopup() {
        Object[] obj = this.popupQueueToArray();
        int i = 0;
        while (i < obj.length) {
            InfoPop infoPop = (InfoPop)obj[i];
            if (infoPop.fMouseInPopup) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void open(InfoPop infoPop) {
        this.requestOpen(infoPop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestOpen(InfoPop infoPop) {
        infoPop.setState(0);
        ArrayList arrayList = this.fPopupQueue;
        synchronized (arrayList) {
            for (InfoPop queuedPop : this.fPopupQueue) {
                boolean disposed;
                String category = queuedPop.getEvent().getCategory();
                boolean bl = disposed = queuedPop.getState() == 3;
                if (disposed) continue;
                queuedPop.addEvent(infoPop.getEvent());
                return;
            }
            if (this.fPopupQueue.isEmpty()) {
                this.fDispatchLoop.schedule(220L);
            }
            if (!this.fPopupQueue.contains(infoPop)) {
                this.fPopupQueue.add(infoPop);
            }
        }
    }

    private void stop() {
        this.fStopped = true;
        if (this.fDispatchLoop != null) {
            this.fDispatchLoop.cancel();
        }
        if (this.fAnimator != null) {
            this.fAnimator.dispose();
        }
        Job.getJobManager().cancel(INFOPOP_JOB_FAMILY);
    }

    public static void stopManager() {
        if (fInstance != null) {
            fInstance.stop();
        }
    }

    /* synthetic */ InfoPopManager(InfoPopManager infoPopManager) {
        this();
    }

    private static class Holder {
        private static final InfoPopManager INSTANCE = new InfoPopManager(null);

        private Holder() {
        }
    }
}

