/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal;

import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.common.IEventGroup;
import com.ibm.team.foundation.common.IEventType;
import com.ibm.team.foundation.rcp.core.ClientEventTypeManager;
import com.ibm.team.foundation.rcp.core.extensionpoint.ExtensionPointHandler;
import com.ibm.team.foundation.rcp.core.extensionpoint.ExtensionPointManager;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.itemview.IItemViewUIAdvisor;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ItemViewAdvisorManager {
    private static final String ITEM_VIEWER_ADVISOR_EXTENSION_POINT = "itemViewUIAdvisor";
    private static ItemViewAdvisorManager fgInstance;
    private ItemViewUIConfigurer fConfigurer = new ItemViewUIConfigurer();

    private ItemViewAdvisorManager() {
        ExtensionPointManager expManager = JFacePlugin.getDefault().getExtensionPointManager();
        ExtensionPointHandler itemViewAdvisorHandler = new ExtensionPointHandler(expManager, ITEM_VIEWER_ADVISOR_EXTENSION_POINT, ITEM_VIEWER_ADVISOR_EXTENSION_POINT){

            protected Object elementAdded(IConfigurationElement element) {
                try {
                    IItemViewUIAdvisor advisor = (IItemViewUIAdvisor)element.createExecutableExtension("class");
                    advisor.configure(ItemViewAdvisorManager.this.fConfigurer);
                }
                catch (CoreException e) {
                    JFacePlugin.getDefault().log(e.getMessage(), e);
                }
                return element;
            }

            protected void elementsRemoved(List removed) {
            }
        };
        itemViewAdvisorHandler.init();
        Collection eventTypes = ClientEventTypeManager.getDefault().getEventTypes();
        for (IEventType eventType : eventTypes) {
            ImageDescriptor eventTypeImageDescriptor = ImageDescriptor.createFromURL((URL)eventType.getIconUrl());
            if (eventTypeImageDescriptor == ImageDescriptor.getMissingImageDescriptor()) {
                eventTypeImageDescriptor = ImagePool.NEWS;
            }
            this.fConfigurer.addItemImage(eventType.getCategoryId(), eventTypeImageDescriptor);
            JazzResources.registerUrl(eventTypeImageDescriptor, eventType.getIconUrl());
        }
        Collection eventGroups = ClientEventTypeManager.getDefault().getEventGroups();
        for (IEventGroup eventGroup : eventGroups) {
            ItemViewerFilter displayFilter = this.createDisplayFilter(eventGroup.getId(), eventGroup.getName(), eventGroup.getEventTypeIds());
            displayFilter.setEnabledByDefault(!eventGroup.isVisibleByDefault());
            this.fConfigurer.addFilter(displayFilter);
        }
    }

    private ItemViewerFilter createDisplayFilter(String id, String name, final Collection<String> categoryIds) {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof GenericAggregationBin) {
                    element = ((GenericAggregationBin)element).getMostRecent();
                }
                if (element instanceof NewsItem) {
                    NewsItem item = (NewsItem)element;
                    String newsCategory = item.getCategory();
                    for (String string : categoryIds) {
                        if (!string.equals(newsCategory)) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        return new ItemViewerFilter(filter, id, name, 0);
    }

    public static ItemViewUIConfigurer getConfigurer() {
        if (fgInstance == null) {
            fgInstance = new ItemViewAdvisorManager();
        }
        return ItemViewAdvisorManager.fgInstance.fConfigurer;
    }
}

