/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.IElementSelectorStatusListener;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.Messages;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class FilteringElementSelector {
    public static final boolean LAST_RESULT = true;
    private Display fDisplay;
    private String fProgressMessage = "";
    private double fActualWork;
    private int fTotalWork;
    private Label fProgressLabel;
    private int fProgressCounter;
    private ProgressUpdateJob fProgressUpdateJob;
    private ArrayList fStatusListeners = new ArrayList();
    private Table fTable;
    private int fNumberOfVisibleItems;
    private int fExpectedItemCount;
    private Color fDashLineColor;
    private int fScrollbarWidth;
    private int fTableWidthDelta;
    private int fDashLineIndex = -1;
    private Image fSeparatorIcon;
    private DashLine fDashLine = new DashLine();
    private int fNextElement;
    private List fItems;
    private Object[] fHistoryMatches;
    private Object[] fSearchMatches;
    private TableItem[] fLastSelection;
    private String[] fLastLabels;
    private ElementLabelProvider fLabelProvider;
    private SyncJob fSyncJob;
    private int fSearchJobTicket;
    private String fPattern;
    private AbstractSearchJob fSearchJob;
    private Object[] fLastCompletedResult;
    private static final int HISTORY = 1;
    private static final int INDEX = 2;
    private static final int FULL = 3;
    private static final char SEPARATOR = '-';
    private static final boolean VIRTUAL = false;
    private static final String PLUGIN_ID = "com.ibm.team.jface";
    private static final Object[] EMTPY_ELEMENT_ARRAY = new Object[0];
    private static final Object DASH_LINE = new Object();
    private ResourceManager fResourceManager;

    public FilteringElementSelector(Composite parent, int flags, String initalPattern, ElementLabelProvider labelProvider) {
        Assert.isNotNull((Object)labelProvider);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fDisplay = parent.getDisplay();
        this.fPattern = initalPattern;
        this.fTable = new Table(parent, flags);
        this.fTable.setFont(parent.getFont());
        this.fLabelProvider = labelProvider;
        this.fItems = new ArrayList(500);
        this.fTable.setHeaderVisible(false);
        this.fTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int itemHeight = FilteringElementSelector.this.fTable.getItemHeight();
                Rectangle clientArea = FilteringElementSelector.this.fTable.getClientArea();
                FilteringElementSelector.this.fNumberOfVisibleItems = clientArea.height / itemHeight + 1;
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    int index = FilteringElementSelector.this.fTable.getSelectionIndex();
                    if (index == FilteringElementSelector.this.fDashLineIndex - 1) {
                        e.doit = false;
                        FilteringElementSelector.this.setTableSelection(index + 2);
                    }
                } else if (e.keyCode == 0x1000001) {
                    int index = FilteringElementSelector.this.fTable.getSelectionIndex();
                    if (FilteringElementSelector.this.fDashLineIndex != -1 && index == FilteringElementSelector.this.fDashLineIndex + 1) {
                        e.doit = false;
                        FilteringElementSelector.this.setTableSelection(index - 2);
                    }
                }
            }
        });
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilteringElementSelector.this.fLastSelection != null) {
                    int i = 0;
                    while (i < FilteringElementSelector.this.fLastSelection.length) {
                        TableItem item = FilteringElementSelector.this.fLastSelection[i];
                        if (!item.isDisposed()) {
                            item.setText(FilteringElementSelector.this.fLastLabels[i]);
                        }
                        ++i;
                    }
                }
                TableItem[] items = FilteringElementSelector.this.fTable.getSelection();
                FilteringElementSelector.this.fLastSelection = new TableItem[items.length];
                FilteringElementSelector.this.fLastLabels = new String[items.length];
                int i = 0;
                while (i < items.length) {
                    String qualifiedText;
                    TableItem item;
                    ((FilteringElementSelector)FilteringElementSelector.this).fLastSelection[i] = item = items[i];
                    ((FilteringElementSelector)FilteringElementSelector.this).fLastLabels[i] = item.getText();
                    Object data = item.getData();
                    if (!(data instanceof DashLine) && (qualifiedText = FilteringElementSelector.this.fLabelProvider.getHighLightedText(data)).length() > FilteringElementSelector.this.fLastLabels[i].length()) {
                        item.setText(qualifiedText);
                    }
                    ++i;
                }
            }
        });
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteringElementSelector.this.stop(true);
                FilteringElementSelector.this.fResourceManager.dispose();
                if (FilteringElementSelector.this.fProgressUpdateJob != null) {
                    FilteringElementSelector.this.fProgressUpdateJob.stop();
                    FilteringElementSelector.this.fProgressUpdateJob = null;
                }
                FilteringElementSelector.this.fStatusListeners.clear();
                FilteringElementSelector.this.fLabelProvider.dispose();
            }
        });
        this.fDashLineColor = this.computeDashLineColor();
        this.fScrollbarWidth = this.computeScrollBarWidth();
        this.fTableWidthDelta = this.fTable.computeTrim((int)0, (int)0, (int)0, (int)0).width - this.fScrollbarWidth;
        this.fSeparatorIcon = JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.SEPARATOR_ICON);
        GC gc = null;
        try {
            gc = new GC((Drawable)this.fTable);
            gc.setFont(this.fTable.getFont());
            this.fDashLine.initialize(gc, this.getSeparatorMessage());
        }
        finally {
            gc.dispose();
        }
        if (this.isPatternEmpty()) {
            this.scheduleSyncJob();
        }
    }

    public void startup() {
        if (this.isPatternEmpty()) {
            this.reset();
        } else {
            this.scheduleSearchJob(3);
        }
    }

    public void setProgressLabel(Label progressLabel) {
        this.fProgressLabel = progressLabel;
    }

    public synchronized void addStatusListener(IElementSelectorStatusListener listener) {
        if (!this.fStatusListeners.contains(listener)) {
            this.fStatusListeners.add(listener);
        }
    }

    public synchronized void removeStatusListener(IElementSelectorStatusListener listener) {
        this.fStatusListeners.remove(listener);
    }

    public Table getTable() {
        return this.fTable;
    }

    public void setFocus() {
        this.fTable.setFocus();
        if (this.fTable.getSelectionCount() == 0 && this.fTable.getItemCount() > 0) {
            this.setTableSelection(0);
        }
    }

    public Object[] getSelection() {
        TableItem[] items = this.fTable.getSelection();
        ArrayList<Object> result = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            if (!(data instanceof DashLine)) {
                result.add(data);
            }
            ++i;
        }
        return result.toArray();
    }

    protected boolean isPatternEmpty() {
        return this.fPattern == null || this.fPattern.length() == 0;
    }

    protected void deleteItem(int index) {
        if (index < 0) {
            return;
        }
        TableItem item = this.fTable.getItem(index);
        item.dispose();
        this.fItems.remove(index);
        int count = this.fTable.getItemCount();
        if (count > 0) {
            item = this.fTable.getItem(0);
            if (item.getData() instanceof DashLine) {
                item.dispose();
                this.fItems.remove(0);
                this.fDashLineIndex = -1;
                if (count > 1) {
                    this.setTableSelection(0);
                }
            } else {
                if (index >= count) {
                    index = count - 1;
                }
                this.setTableSelection(index);
            }
        } else {
            this.fTable.notifyListeners(13, new Event());
        }
    }

    ElementLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    private int getNumberOfVisibleItems() {
        return this.fNumberOfVisibleItems;
    }

    private void internalReset(Object[] historyMatches) {
        this.fLastSelection = null;
        this.fLastLabels = null;
        this.fExpectedItemCount = 0;
        this.fDashLineIndex = -1;
        this.fNextElement = 0;
        Object[] historyItems = historyMatches;
        if (historyItems.length == 0) {
            this.shortenTable();
            this.notifyReset();
            return;
        }
        this.fExpectedItemCount = historyItems.length;
        int lastIndex = historyItems.length - 1;
        Object last = null;
        Object type = historyItems[0];
        int i = 0;
        while (i < historyItems.length) {
            Object next = i == lastIndex ? null : historyItems[i + 1];
            this.addSingleElement(type, this.fLabelProvider.getImageDescriptor(type), this.fLabelProvider.getText(last, type, next), this.fLabelProvider.getFont(type));
            last = type;
            type = next;
            ++i;
        }
        this.shortenTable();
        this.notifyReset();
        this.setTableSelection(-1);
    }

    private void reset() {
        new ResetJob(this).schedule();
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean stopSyncJob) {
        if (this.fSyncJob != null && stopSyncJob) {
            this.fSyncJob.stop();
            this.fSyncJob = null;
        }
        if (this.fSearchJob != null) {
            this.fSearchJob.stop();
            this.fSearchJob = null;
        }
    }

    public void forceSearch() {
        this.stop(false);
        if (this.isPatternEmpty()) {
            this.reset();
        } else {
            this.fLastCompletedResult = null;
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    protected abstract SyncJob createSyncJob();

    private void scheduleSyncJob() {
        this.fSyncJob = this.createSyncJob();
        if (this.fSyncJob != null) {
            this.fSyncJob.schedule();
        }
    }

    private void syncJobDone() {
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                FilteringElementSelector.this.fSyncJob = null;
                if (!FilteringElementSelector.this.isPatternEmpty()) {
                    FilteringElementSelector.this.scheduleSearchJob(3);
                }
            }
        });
    }

    private boolean isSyncJobRunning() {
        return this.fSyncJob != null;
    }

    protected abstract AbstractSearchJob createSearchJob();

    protected abstract AbstractSearchJob createCachedSearchJob(Object[] var1);

    @Deprecated
    protected Object[] getHistoryElements() {
        return new Object[0];
    }

    protected Object[] getHistoryElements(IProgressMonitor monitor) {
        return this.getHistoryElements();
    }

    protected abstract boolean canUseCachedResult();

    protected String getSeparatorMessage() {
        return Messages.FilteringElementSelector_WORKSPACE_MATCHES;
    }

    protected void rememberResult(int ticket, final Object[] result) {
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                if (FilteringElementSelector.this.fLastCompletedResult == null) {
                    FilteringElementSelector.this.fLastCompletedResult = result;
                }
            }
        });
    }

    private void scheduleSearchJob(int mode) {
        ++this.fSearchJobTicket;
        if (this.fLastCompletedResult != null && this.canUseCachedResult()) {
            this.fSearchJob = this.createCachedSearchJob(this.fLastCompletedResult);
        } else {
            this.fLastCompletedResult = null;
            this.fSearchJob = this.createSearchJob();
        }
        this.fSearchJob.initialize(this.fSearchJobTicket, mode);
        this.fSearchJob.schedule();
    }

    private void searchJobDone(int ticket) {
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                FilteringElementSelector.this.shortenTable();
                FilteringElementSelector.this.checkEmptyList();
                FilteringElementSelector.this.fSearchJob = null;
            }
        });
    }

    private void searchJobCanceled(int ticket, final boolean removePendingItems) {
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                if (removePendingItems) {
                    FilteringElementSelector.this.shortenTable();
                    FilteringElementSelector.this.checkEmptyList();
                }
                FilteringElementSelector.this.fSearchJob = null;
            }
        });
    }

    private void searchJobFailed(int ticket, final CoreException e) {
        this.searchJobDone(ticket);
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                FilteringElementSelector.this.notifyError(e);
            }
        });
        JFacePlugin.getDefault().log(e.getMessage(), e);
    }

    public void setSearchPattern(String text) {
        this.stop(false);
        this.fPattern = text;
        if (this.isPatternEmpty()) {
            this.reset();
        } else {
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public String getSearchPattern() {
        return this.fPattern;
    }

    private void clear(int ticket) {
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                FilteringElementSelector.this.fNextElement = 0;
                FilteringElementSelector.this.fDashLineIndex = -1;
                FilteringElementSelector.this.fLastSelection = null;
                FilteringElementSelector.this.fLastLabels = null;
                FilteringElementSelector.this.fExpectedItemCount = 0;
            }
        });
    }

    private void addHistory(int ticket, List elements) {
        this.addAll(ticket, elements);
    }

    private void addAll(int ticket, final List elements) {
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                int size = elements.size();
                int i = 0;
                while (i < size) {
                    Object element = elements.get(i);
                    FilteringElementSelector.this.addSingleElement(element, FilteringElementSelector.this.getImageDescriptor(element), FilteringElementSelector.this.fLabelProvider.getText(element), FilteringElementSelector.this.fLabelProvider.getFont(element));
                    ++i;
                }
                FilteringElementSelector.this.shortenTable();
            }
        });
    }

    private void addDashLineAndUpdateLastHistoryEntry(int ticket, final Object next) {
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                if (FilteringElementSelector.this.fNextElement > 0) {
                    TableItem last;
                    TableItem item = FilteringElementSelector.this.fTable.getItem(FilteringElementSelector.this.fNextElement - 1);
                    String label = item.getText();
                    String newLabel = FilteringElementSelector.this.fLabelProvider.getText(null, item.getData(), next);
                    if (newLabel.length() > label.length()) {
                        item.setText(newLabel);
                    }
                    if (FilteringElementSelector.this.fLastSelection != null && FilteringElementSelector.this.fLastSelection.length > 0 && (last = FilteringElementSelector.this.fLastSelection[FilteringElementSelector.this.fLastSelection.length - 1]) == item) {
                        ((FilteringElementSelector)FilteringElementSelector.this).fLastLabels[((FilteringElementSelector)FilteringElementSelector.this).fLastLabels.length - 1] = newLabel;
                    }
                }
                FilteringElementSelector.this.fDashLineIndex = FilteringElementSelector.this.fNextElement;
                FilteringElementSelector.this.addDashLine();
            }
        });
    }

    private void addDashLine() {
        TableItem item = null;
        if (this.fItems.size() > this.fNextElement) {
            item = (TableItem)this.fItems.get(this.fNextElement);
        } else {
            item = new TableItem(this.fTable, 0);
            this.fItems.add(item);
        }
        this.fillDashLine(item);
        ++this.fNextElement;
    }

    private void addSingleElement(Object element, ImageDescriptor imageDescriptor, String label, Font font) {
        TableItem item = null;
        Object old = null;
        if (this.fItems.size() > this.fNextElement) {
            item = (TableItem)this.fItems.get(this.fNextElement);
            old = item.getData();
            item.setForeground(null);
        } else {
            item = new TableItem(this.fTable, 0);
            this.fItems.add(item);
        }
        item.setData(element);
        item.setImage(JazzResources.getImageWithDefault(this.fResourceManager, imageDescriptor));
        item.setFont(font);
        if (this.fNextElement == 0) {
            if (this.needsSelectionChange(old, element) || this.fLastSelection != null) {
                item.setText(label);
                this.setTableSelection(0);
            } else {
                this.fLastSelection = new TableItem[]{item};
                this.fLastLabels = new String[]{label};
            }
        } else {
            item.setText(label);
        }
        ++this.fNextElement;
    }

    private boolean needsSelectionChange(Object oldElement, Object newElement) {
        int[] selected = this.fTable.getSelectionIndices();
        if (selected.length != 1) {
            return true;
        }
        if (selected[0] != 0) {
            return true;
        }
        if (oldElement == null) {
            return true;
        }
        return !oldElement.equals(newElement);
    }

    private void setHistoryResult(int ticket, final Object[] types) {
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                FilteringElementSelector.this.fExpectedItemCount = types.length;
                int lastHistoryLength = FilteringElementSelector.this.fHistoryMatches.length;
                FilteringElementSelector.this.fHistoryMatches = types;
                int length = FilteringElementSelector.this.fHistoryMatches.length + FilteringElementSelector.this.fSearchMatches.length;
                int dash = FilteringElementSelector.this.fHistoryMatches.length > 0 && FilteringElementSelector.this.fSearchMatches.length > 0 ? 1 : 0;
                FilteringElementSelector.this.fTable.setItemCount(length + dash);
                if (length == 0) {
                    FilteringElementSelector.this.fTable.redraw();
                    return;
                }
                int update = Math.max(lastHistoryLength, FilteringElementSelector.this.fHistoryMatches.length);
                if (update > 0) {
                    FilteringElementSelector.this.fTable.clear(0, update + dash - 1);
                }
            }
        });
    }

    private void setSearchResult(int ticket, final Object[] types) {
        this.syncExec(ticket, new Runnable(){

            @Override
            public void run() {
                FilteringElementSelector filteringElementSelector = FilteringElementSelector.this;
                filteringElementSelector.fExpectedItemCount = filteringElementSelector.fExpectedItemCount + types.length;
                FilteringElementSelector.this.fSearchMatches = types;
                int length = FilteringElementSelector.this.fHistoryMatches.length + FilteringElementSelector.this.fSearchMatches.length;
                int dash = FilteringElementSelector.this.fHistoryMatches.length > 0 && FilteringElementSelector.this.fSearchMatches.length > 0 ? 1 : 0;
                FilteringElementSelector.this.fTable.setItemCount(length + dash);
                if (length == 0) {
                    FilteringElementSelector.this.fTable.redraw();
                    return;
                }
                if (FilteringElementSelector.this.fHistoryMatches.length == 0) {
                    FilteringElementSelector.this.fTable.clear(0, length + dash - 1);
                } else {
                    FilteringElementSelector.this.fTable.clear(FilteringElementSelector.this.fHistoryMatches.length - 1, length + dash - 1);
                }
            }
        });
    }

    private void setData(TableItem item) {
        int index = this.fTable.indexOf(item);
        Object element = this.getElement(index);
        if (element == DASH_LINE) {
            item.setData((Object)this.fDashLine);
            this.fillDashLine(item);
        } else {
            item.setData(element);
            item.setImage(JazzResources.getImageWithDefault(this.fResourceManager, this.getImageDescriptor(element)));
            item.setText(this.fLabelProvider.getText(this.getElement(index - 1), element, this.getElement(index + 1)));
            item.setFont(this.fLabelProvider.getFont(element));
            item.setForeground(null);
        }
    }

    private Object getElement(int index) {
        int dash;
        if (index < 0) {
            return null;
        }
        if (index < this.fHistoryMatches.length) {
            return this.fHistoryMatches[index];
        }
        int n = dash = this.fHistoryMatches.length > 0 && this.fSearchMatches.length > 0 ? 1 : 0;
        if (index == this.fHistoryMatches.length && dash == 1) {
            return DASH_LINE;
        }
        if ((index = index - this.fHistoryMatches.length - dash) >= this.fSearchMatches.length) {
            return null;
        }
        return this.fSearchMatches[index];
    }

    private ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor descriptor = this.fLabelProvider.getImageDescriptor(element);
        return descriptor == null ? ImageDescriptor.getMissingImageDescriptor() : descriptor;
    }

    private void scheduleProgressUpdateJob() {
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                if (FilteringElementSelector.this.fProgressCounter == 0) {
                    FilteringElementSelector.this.clearProgressStatus();
                    FilteringElementSelector.this.notifyStarted();
                    FilteringElementSelector.this.fTable.setCursor(FilteringElementSelector.this.fDisplay.getSystemCursor(3));
                    FilteringElementSelector.this.fProgressUpdateJob = new ProgressUpdateJob(FilteringElementSelector.this);
                    FilteringElementSelector.this.fProgressUpdateJob.schedule(300L);
                }
                FilteringElementSelector filteringElementSelector = FilteringElementSelector.this;
                filteringElementSelector.fProgressCounter = filteringElementSelector.fProgressCounter + 1;
            }
        });
    }

    private void stopProgressUpdateJob() {
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                FilteringElementSelector filteringElementSelector = FilteringElementSelector.this;
                filteringElementSelector.fProgressCounter = filteringElementSelector.fProgressCounter - 1;
                if (FilteringElementSelector.this.fProgressCounter == 0 && FilteringElementSelector.this.fProgressUpdateJob != null) {
                    FilteringElementSelector.this.fProgressUpdateJob.stop();
                    FilteringElementSelector.this.fProgressUpdateJob = null;
                    FilteringElementSelector.this.fTable.setCursor(null);
                    FilteringElementSelector.this.clearProgressStatus();
                    FilteringElementSelector.this.notifyStopped();
                }
            }
        });
    }

    private void setProgressStatus(String message, double actualWork, int totalWork) {
        this.fProgressMessage = message == null ? "" : message;
        this.fActualWork = actualWork;
        this.fTotalWork = totalWork;
    }

    private void clearProgressStatus() {
        this.setProgressStatus("", 0.0, 0);
        if (this.fProgressLabel != null) {
            this.fProgressLabel.setText(this.fProgressMessage);
        }
    }

    private void updateProgressMessage() {
        if (this.fProgressLabel != null) {
            this.fProgressLabel.setText(this.fProgressMessage);
        }
    }

    private synchronized void notifyStopped() {
        Iterator iterator = this.fStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((IElementSelectorStatusListener)iterator.next()).stopped();
        }
    }

    private synchronized void notifyStarted() {
        Iterator iterator = this.fStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((IElementSelectorStatusListener)iterator.next()).started(this.fProgressMessage);
        }
    }

    private synchronized void notifyProgress() {
        Iterator iterator = this.fStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((IElementSelectorStatusListener)iterator.next()).progress(this.fProgressMessage, this.fActualWork, this.fTotalWork);
        }
    }

    private synchronized void notifyError(CoreException e) {
        Iterator iterator = this.fStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((IElementSelectorStatusListener)iterator.next()).error(e);
        }
    }

    private synchronized void notifyReset() {
        Iterator iterator = this.fStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((IElementSelectorStatusListener)iterator.next()).reset();
        }
    }

    private void syncExec(final Runnable runnable) {
        if (this.fDisplay.isDisposed()) {
            return;
        }
        this.fDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                if (FilteringElementSelector.this.fTable.isDisposed()) {
                    return;
                }
                runnable.run();
            }
        });
    }

    private void syncExec(final int ticket, final Runnable runnable) {
        if (this.fDisplay.isDisposed()) {
            return;
        }
        this.fDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                if (FilteringElementSelector.this.fTable.isDisposed() || ticket != FilteringElementSelector.this.fSearchJobTicket) {
                    return;
                }
                runnable.run();
            }
        });
    }

    private void fillDashLine(TableItem item) {
        Rectangle bounds = item.getImageBounds(0);
        Rectangle area = this.fTable.getBounds();
        boolean willHaveScrollBar = this.fExpectedItemCount + 1 > this.fNumberOfVisibleItems;
        item.setText(this.fDashLine.getText(area.width - bounds.x - bounds.width - this.fTableWidthDelta - (willHaveScrollBar ? this.fScrollbarWidth : 0)));
        item.setImage(this.fSeparatorIcon);
        item.setForeground(this.fDashLineColor);
        item.setData((Object)this.fDashLine);
    }

    private void shortenTable() {
        if (this.fNextElement < this.fItems.size()) {
            this.fTable.setRedraw(false);
            try {
                this.fTable.remove(this.fNextElement, this.fItems.size() - 1);
            }
            finally {
                this.fTable.setRedraw(true);
            }
        }
        int i = this.fItems.size() - 1;
        while (i >= this.fNextElement) {
            this.fItems.remove(i);
            --i;
        }
    }

    private void checkEmptyList() {
        if (this.fTable.getItemCount() == 0) {
            this.fTable.notifyListeners(13, new Event());
        }
    }

    private void setTableSelection(int index) {
        if (index < 0) {
            this.fTable.deselectAll();
        } else {
            this.fTable.setSelection(index);
        }
        this.fTable.notifyListeners(13, new Event());
    }

    private Color computeDashLineColor() {
        Color bg;
        int bGray;
        Color fg = this.fTable.getForeground();
        int fGray = (int)(0.3 * (double)fg.getRed() + 0.59 * (double)fg.getGreen() + 0.11 * (double)fg.getBlue());
        int gray = (int)((double)(fGray + (bGray = (int)(0.3 * (double)(bg = this.fTable.getBackground()).getRed() + 0.59 * (double)bg.getGreen() + 0.11 * (double)bg.getBlue()))) * 0.66);
        if (gray > 255) {
            gray = (int)((double)((fGray + bGray) / 2) * 0.66);
        }
        return JazzResources.getColor(this.fResourceManager, new RGB(gray, gray, gray));
    }

    private int computeScrollBarWidth() {
        Composite t = new Composite((Composite)this.fTable.getShell(), 512);
        int result = t.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        t.dispose();
        return result;
    }

    public int getItemCount() {
        int count = this.fTable.getItemCount();
        if (this.fDashLineIndex > -1) {
            --count;
        }
        return count;
    }

    private static abstract class AbstractJob
    extends FoundationJob {
        protected FilteringElementSelector fViewer;

        protected AbstractJob(String name, FilteringElementSelector viewer) {
            super(name);
            this.fViewer = viewer;
            this.setSystem(true);
        }

        protected final IStatus runProtected(IProgressMonitor parent) {
            ProgressMonitor monitor = new ProgressMonitor(parent, this.fViewer);
            try {
                this.fViewer.scheduleProgressUpdateJob();
                IStatus iStatus = this.doRun((IProgressMonitor)monitor);
                return iStatus;
            }
            finally {
                this.fViewer.stopProgressUpdateJob();
            }
        }

        protected abstract IStatus doRun(IProgressMonitor var1);
    }

    protected static abstract class AbstractSearchJob
    extends AbstractJob {
        private static final int UI_UPDATE_SIZE = 10;
        private int fMode;
        protected int fTicket;
        protected ElementLabelProvider fLabelProvider;

        protected AbstractSearchJob(FilteringElementSelector viewer) {
            super(Messages.FilteringElementSelector_SEARCH_JOB, viewer);
            this.fViewer = viewer;
            this.fLabelProvider = this.fViewer.getLabelProvider();
        }

        void initialize(int ticket, int mode) {
            this.fMode = mode;
            this.fTicket = ticket;
        }

        public void stop() {
            this.cancel();
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                this.internalRun(monitor);
            }
            catch (CoreException e) {
                this.fViewer.searchJobFailed(this.fTicket, e);
                return new Status(2, FilteringElementSelector.PLUGIN_ID, 4, Messages.FilteringElementSelector_SEARCH_FAILED, (Throwable)e);
            }
            catch (InterruptedException e) {
                return this.canceled(e, true);
            }
            catch (OperationCanceledException e) {
                return this.canceled((Exception)((Object)e), false);
            }
            this.fViewer.searchJobDone(this.fTicket);
            return this.ok();
        }

        protected abstract Object[] getHistoryResult(IProgressMonitor var1) throws CoreException;

        protected abstract SearchResult getSearchResult(Object[] var1, IProgressMonitor var2) throws CoreException;

        private void internalRun(IProgressMonitor monitor) throws CoreException, InterruptedException {
            block10: {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.fViewer.clear(this.fTicket);
                ArrayList<Object> elements = new ArrayList<Object>();
                Object[] historyElements = this.getHistoryResult(monitor);
                if (historyElements.length > 0) {
                    int i = 0;
                    while (i < historyElements.length) {
                        elements.add(historyElements[i]);
                        ++i;
                    }
                }
                this.fViewer.fExpectedItemCount = elements.size();
                this.fViewer.addHistory(this.fTicket, elements);
                if ((this.fMode & 2) == 0) {
                    return;
                }
                SearchResult searchResult = this.getSearchResult(historyElements, monitor);
                Object[] result = searchResult.getResult();
                FilteringElementSelector filteringElementSelector = this.fViewer;
                filteringElementSelector.fExpectedItemCount = filteringElementSelector.fExpectedItemCount + result.length;
                if (result.length == 0 && searchResult.isLast()) {
                    return;
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                int processed = 0;
                int nextIndex = 0;
                if (historyElements.length > 0) {
                    this.fViewer.addDashLineAndUpdateLastHistoryEntry(this.fTicket, null);
                }
                do {
                    long startTime = System.currentTimeMillis();
                    elements.clear();
                    int delta = Math.min(nextIndex == 0 ? this.fViewer.getNumberOfVisibleItems() : 10, result.length - processed);
                    if (delta == 0) {
                        if (searchResult.isLast() || (searchResult = this.getSearchResult(historyElements, monitor)).getCount() == 0 && searchResult.isLast()) break block10;
                        result = searchResult.getResult();
                        processed = 0;
                        nextIndex = 0;
                        delta = Math.min(10, result.length);
                    }
                    processed += delta;
                    while (delta > 0) {
                        elements.add(result[nextIndex]);
                        ++nextIndex;
                        --delta;
                    }
                    this.fViewer.addAll(this.fTicket, elements);
                    long sleep = 100L - (System.currentTimeMillis() - startTime);
                    if (sleep <= 0L) continue;
                    Thread.sleep(sleep);
                } while (!monitor.isCanceled());
                throw new OperationCanceledException();
            }
        }

        private void internalRunVirtual(IProgressMonitor monitor) throws CoreException, InterruptedException {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fViewer.clear(this.fTicket);
            Object[] historyElements = this.getHistoryResult(monitor);
            this.fViewer.setHistoryResult(this.fTicket, historyElements);
            if ((this.fMode & 2) == 0) {
                return;
            }
            SearchResult result = this.getSearchResult(historyElements, monitor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fViewer.setSearchResult(this.fTicket, result.getResult());
        }

        private IStatus canceled(Exception e, boolean removePendingItems) {
            this.fViewer.searchJobCanceled(this.fTicket, removePendingItems);
            return new Status(8, FilteringElementSelector.PLUGIN_ID, 8, Messages.FilteringElementSelector_OPERATION_CANCELED, (Throwable)e);
        }

        private IStatus ok() {
            return new Status(0, FilteringElementSelector.PLUGIN_ID, 0, "", null);
        }
    }

    private static class DashLine {
        private int fSeparatorWidth;
        private String fMessage;
        private int fMessageLength;

        private DashLine() {
        }

        public String getText(int width) {
            StringBuffer dashes = new StringBuffer();
            int chars = (width - this.fMessageLength) / this.fSeparatorWidth / 2 - 2;
            int i = 0;
            while (i < chars) {
                dashes.append('-');
                ++i;
            }
            StringBuffer result = new StringBuffer();
            result.append(dashes);
            result.append(this.fMessage);
            result.append(dashes);
            return result.toString();
        }

        public void initialize(GC gc, String message) {
            this.fSeparatorWidth = gc.getAdvanceWidth('-');
            this.fMessage = " " + message + " ";
            this.fMessageLength = gc.textExtent((String)this.fMessage).x;
        }
    }

    protected static abstract class ElementLabelProvider {
        protected ElementLabelProvider() {
        }

        public abstract String getText(Object var1);

        public String getHighLightedText(Object element) {
            return this.getText(element);
        }

        public String getText(Object last, Object current, Object next) {
            return this.getText(current);
        }

        public abstract ImageDescriptor getImageDescriptor(Object var1);

        public Font getFont(Object element) {
            return null;
        }

        public void dispose() {
        }
    }

    private static class ProgressMonitor
    extends ProgressMonitorWrapper {
        private FilteringElementSelector fViewer;
        private String fName;
        private int fTotalWork;
        private double fWorked;
        private boolean fDone;

        public ProgressMonitor(IProgressMonitor monitor, FilteringElementSelector viewer) {
            super(monitor);
            this.fViewer = viewer;
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.fName = name;
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            if (this.fName == null) {
                this.fName = name;
            }
            this.fTotalWork = totalWork;
            if (!this.isCanceled()) {
                this.fViewer.setProgressStatus(this.fName, 0.0, totalWork);
            }
        }

        public void worked(int work) {
            super.worked(work);
            this.internalWorked(work);
        }

        public void done() {
            this.fDone = true;
            if (!this.isCanceled()) {
                this.fViewer.setProgressStatus("", 0.0, 0);
            }
            super.done();
        }

        public void internalWorked(double work) {
            this.fWorked += work;
            if (!this.isCanceled()) {
                this.fViewer.setProgressStatus(this.getMessage(), this.fWorked, this.fTotalWork);
            }
        }

        private String getMessage() {
            if (this.fDone) {
                return "";
            }
            if (this.fTotalWork == 0) {
                return this.fName;
            }
            return MessageFormat.format(Messages.FilteringElementSelector_PERCENT_VALUE, this.fName, new Integer((int)(this.fWorked * 100.0 / (double)this.fTotalWork)));
        }
    }

    private static class ProgressUpdateJob
    extends LoggingUIJob {
        private FilteringElementSelector fViewer;
        private boolean fStopped;

        public ProgressUpdateJob(FilteringElementSelector viewer) {
            super(Messages.FilteringElementSelector_PROGRESS_UPDATE_JOB);
            this.fViewer = viewer;
        }

        public void stop() {
            this.fStopped = true;
            this.cancel();
        }

        @Override
        public IStatus runProtectedInUI(IProgressMonitor monitor) {
            if (this.stopped()) {
                return new Status(8, FilteringElementSelector.PLUGIN_ID, 8, "", null);
            }
            this.fViewer.updateProgressMessage();
            this.fViewer.notifyProgress();
            if (!this.stopped()) {
                this.schedule(300L);
            }
            return new Status(0, FilteringElementSelector.PLUGIN_ID, 0, "", null);
        }

        private boolean stopped() {
            return this.fStopped || this.fViewer.getTable().isDisposed();
        }
    }

    protected static class ResetJob
    extends FoundationJob {
        private final FilteringElementSelector fViewer;

        public ResetJob(FilteringElementSelector viewer) {
            super("");
            this.fViewer = viewer;
        }

        public void stop() {
            this.cancel();
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            Object[] tempMatches;
            IStatus iStatus;
            Object[] historyMatches = null;
            try {
                historyMatches = this.fViewer.getHistoryElements();
                iStatus = Status.OK_STATUS;
                tempMatches = historyMatches;
            }
            catch (OperationCanceledException e) {
                Object[] tempMatches2;
                Status status;
                try {
                    status = new Status(8, FilteringElementSelector.PLUGIN_ID, 8, Messages.FilteringElementSelector_OPERATION_CANCELED, (Throwable)e);
                    tempMatches2 = historyMatches;
                }
                catch (Throwable throwable) {
                    Object[] tempMatches3 = historyMatches;
                    this.fViewer.syncExec(new Runnable(this, tempMatches3){
                        final /* synthetic */ ResetJob this$1;
                        private final /* synthetic */ Object[] val$tempMatches;
                        {
                            this.this$1 = resetJob;
                            this.val$tempMatches = objectArray;
                        }

                        @Override
                        public void run() {
                            this.this$1.fViewer.internalReset(this.val$tempMatches);
                        }
                    });
                    throw throwable;
                }
                this.fViewer.syncExec(new /* invalid duplicate definition of identical inner class */);
                return status;
            }
            this.fViewer.syncExec(new /* invalid duplicate definition of identical inner class */);
            return iStatus;
        }
    }

    protected static class SearchResult {
        private final boolean fLast;
        private final Object[] fResult;

        public SearchResult(Object[] result, boolean last) {
            Assert.isLegal((result != null ? 1 : 0) != 0);
            this.fLast = last;
            this.fResult = result;
        }

        public int getCount() {
            return this.fResult.length;
        }

        public boolean isLast() {
            return this.fLast;
        }

        public Object[] getResult() {
            return this.fResult;
        }
    }

    protected static abstract class SyncJob
    extends AbstractJob {
        public SyncJob(FilteringElementSelector viewer) {
            super(Messages.FilteringElementSelector_REFRESHING_PROVIDER, viewer);
        }

        public void stop() {
            this.cancel();
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                IStatus iStatus = this.doSync(monitor);
                return iStatus;
            }
            catch (OperationCanceledException e) {
                Status status = new Status(8, FilteringElementSelector.PLUGIN_ID, 8, Messages.FilteringElementSelector_OPERATION_CANCELED, (Throwable)e);
                return status;
            }
            finally {
                this.fViewer.syncJobDone();
            }
        }

        protected abstract IStatus doSync(IProgressMonitor var1);
    }
}

