/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.charts;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.charts.BarViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class MultiBarViewer
extends BarViewer {
    private static final int FOCUS_BORDER_SIZE = "carbon".equals(SWT.getPlatform()) ? 4 : 2;
    private static final int MARGIN_WIDTH = 5;
    private static final int MINIMAL_BAR_HEIGHT = 10;
    private static final int PREFERRED_BAR_HEIGHT = 15;
    private static final int ANNOTATION_SPACING = 5;
    private Color fNonFocusBarOutline;
    private Color fNonSelectedBarColor;
    private Color fSelectedBarBackgroundColor;
    private Color fSelectedBarForegroundColor;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public MultiBarViewer(Composite composite, String chartName, boolean useGradients) {
        super(composite, chartName, useGradients);
        this.fNonSelectedBarColor = JazzResources.getColor(this.fResourceManager, new RGB(224, 224, 224));
        this.fNonFocusBarOutline = JazzResources.getColor(this.fResourceManager, new RGB(170, 170, 170));
        this.fSelectedBarForegroundColor = JazzResources.getColor(this.fResourceManager, new RGB(224, 224, 224));
        this.fSelectedBarBackgroundColor = JazzResources.getColor(this.fResourceManager, new RGB(192, 192, 192));
    }

    @Override
    public void dispose() {
        this.fResourceManager.dispose();
        super.dispose();
    }

    @Override
    public Object getElement(Point position) {
        Object[] elements = this.fContentProvider.getElements(null);
        if (elements == null || elements.length == 0) {
            return null;
        }
        if (elements.length == 1) {
            return elements[0];
        }
        int singleBarWidth = this.getChartBounds().width / elements.length;
        int index = position.x / singleBarWidth;
        if (index >= 0 && elements.length > index) {
            return elements[index];
        }
        return null;
    }

    @Override
    public Rectangle getElementBounds(Point position) {
        Object[] elements = this.fContentProvider.getElements(null);
        if (elements.length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int singleBarWidth = this.getChartBounds().width / elements.length;
        int index = position.x / singleBarWidth;
        int x = singleBarWidth * index;
        int y = this.getChartBounds().y;
        int width = singleBarWidth;
        int height = this.getChartBounds().height;
        return new Rectangle(x, y, width, height);
    }

    @Override
    public Point getMinimalSize() {
        GC gc = new GC((Drawable)this.fComposite);
        int textHeight = gc.textExtent((String)"Fog").y;
        int barMinHeight = 10;
        gc.dispose();
        return new Point(-1, textHeight * 2 + barMinHeight + (!"".equals(this.fChartName) ? textHeight : 0) + 3);
    }

    @Override
    public Point getPreferredSize() {
        GC gc = new GC((Drawable)this.fComposite);
        int textHeight = gc.textExtent((String)"Fog").y;
        int barMinHeight = 15;
        gc.dispose();
        return new Point(-1, textHeight * 2 + barMinHeight + (!"".equals(this.fChartName) ? textHeight : 0) + 3);
    }

    @Override
    protected void onPaint(GC gc) {
        Object[] elements = this.fContentProvider.getElements(null);
        float[] relatives = this.getRelativesToMax();
        if (elements.length == 0) {
            return;
        }
        Rectangle barBounds = new Rectangle(0, 0, this.getChartBounds().width / elements.length, this.getChartBounds().height);
        int modulo = this.getChartBounds().width % elements.length;
        int curX = 0;
        int chartLabelHeight = 0;
        if (!"".equals(this.fChartName)) {
            chartLabelHeight = gc.textExtent((String)this.fChartName).y;
            barBounds.y += chartLabelHeight;
            gc.drawString(String.valueOf(this.fChartName) + ": ", 0, 0, true);
        }
        int a = 0;
        while (a < elements.length) {
            boolean useShortText;
            Font font = this.fChartElementProvider.getFont(elements[a]);
            Font annotationFont = this.fChartElementProvider.getAnnotationFont(elements[a]);
            String header = this.fChartElementProvider.getValueAsString(elements[a]);
            String annotation = this.fChartElementProvider.getAnnotation(elements[a]);
            Font defaultFont = gc.getFont();
            if (this.fChartElementProvider.getFont(elements[a]) != null) {
                gc.setFont(font);
            }
            Point headerSize = gc.textExtent(header);
            int headerWidth = headerSize.x;
            int headerHeight = headerSize.y;
            Point annotationSize = null;
            if (annotation != null) {
                if (this.fChartElementProvider.getFont(elements[a]) != null) {
                    gc.setFont(annotationFont);
                }
                annotationSize = gc.textExtent(annotation);
                headerWidth = annotationSize.x + 5 + headerSize.x;
                headerHeight = Math.max(annotationSize.y, headerSize.y);
                gc.setFont(font != null ? font : defaultFont);
            }
            String footer = (useShortText = this.useShortText(gc, elements[a])) ? this.fChartElementProvider.getShortText(elements[a]) : this.fChartElementProvider.getText(elements[a]);
            Point footerSize = gc.textExtent(footer);
            int footerWidth = footerSize.x;
            int footerHeight = footerSize.y + 3;
            int availBarWidth = barBounds.width - 10;
            if (modulo > 0) {
                ++availBarWidth;
            }
            int availBarHeight = barBounds.height - headerHeight - footerHeight - chartLabelHeight;
            int relBarHeight = Math.round((float)availBarHeight * relatives[a]);
            int relBarYPos = barBounds.height - (relBarHeight + headerHeight) - 3;
            gc.setBackground(this.fComposite.getBackground());
            gc.setForeground(this.getTextColor());
            int headerYPosition = relBarYPos - headerHeight - (relBarHeight == 0 ? 1 : 0);
            gc.setFont(font != null ? font : defaultFont);
            gc.drawString(header, curX + availBarWidth / 2 - headerWidth / 2 + 5, headerYPosition);
            if (annotation != null) {
                if (annotationFont != null) {
                    gc.setFont(annotationFont);
                }
                gc.drawString(annotation, curX + availBarWidth / 2 - headerWidth / 2 + 5 + 5 + headerSize.x, headerYPosition);
                gc.setFont(font != null ? font : defaultFont);
            }
            if (a == 0) {
                gc.setForeground(this.fNonFocusBarOutline);
                gc.drawLine(5, this.getChartBounds().height - footerHeight - 1, this.getChartBounds().width - 5, this.getChartBounds().height - footerHeight - 1);
            }
            if (relBarHeight > 0) {
                boolean isSelected;
                boolean bl = isSelected = this.fSelectedBar == elements[a];
                if (this.fUseGradients) {
                    gc.setForeground(isSelected ? this.fSelectedBarForegroundColor : this.fComposite.getDisplay().getSystemColor(25));
                    gc.setBackground(isSelected ? this.fSelectedBarBackgroundColor : this.fNonSelectedBarColor);
                    gc.fillGradientRectangle(curX + 1 + 5, relBarYPos + 1, availBarWidth - 1, relBarHeight - 2, true);
                } else {
                    gc.setBackground(isSelected ? this.fSelectedBarBackgroundColor : this.fNonSelectedBarColor);
                    gc.fillRectangle(curX + 1 + 5, relBarYPos + 1, availBarWidth - 1, relBarHeight - 2);
                }
                gc.setForeground(this.fNonFocusBarOutline);
                gc.drawRectangle(curX + 5, relBarYPos, availBarWidth, relBarHeight - 1);
            }
            if (this.fFocussedBar == elements[a]) {
                Rectangle focusBounds = new Rectangle(curX + 5 + 1, relBarYPos + 1, availBarWidth - 1, relBarHeight - 2);
                if (relBarHeight == 0) {
                    focusBounds.height = 2;
                    focusBounds.y = relBarYPos - 3;
                }
                int focusBorderSize = relBarHeight != 0 ? FOCUS_BORDER_SIZE : 0;
                gc.setForeground(this.fComposite.getDisplay().getSystemColor(2));
                gc.drawFocus(focusBounds.x - focusBorderSize, focusBounds.y - focusBorderSize, focusBounds.width + focusBorderSize * 2, focusBounds.height + focusBorderSize * 2);
            }
            gc.setBackground(this.fComposite.getBackground());
            gc.setForeground(this.getTextColor());
            gc.drawString(footer, curX + availBarWidth / 2 - footerWidth / 2 + 5, this.getChartBounds().height - footerHeight + 3);
            curX += barBounds.width;
            if (modulo > 0) {
                ++curX;
            }
            --modulo;
            ++a;
        }
    }

    private boolean useShortText(GC gc, Object element) {
        Object[] elements = this.fContentProvider.getElements(null);
        int cellWidth = this.getChartBounds().width / elements.length - 5;
        return gc.textExtent((String)this.fChartElementProvider.getText((Object)element)).x > cellWidth;
    }

    private Color getTextColor() {
        int color = this.isEnabled() ? 24 : 17;
        return this.fComposite.getDisplay().getSystemColor(color);
    }
}

