/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.calendar;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.team.jface.calendar.Messages;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class DatePicker {
    public static final int LONG = 1;
    public static final int SHORT = 3;
    private static final String MINUTES_VALIDATOR = "[0-9]|[0-5][0-9]";
    private static final String VALIDATOR_24_HOUR = "0?[0-9]|1[0-9]|2[0-4]";
    private static final String VALIDATOR_12_HOUR = "0?[0-9]|1[0-2]";
    private static final int COMBO_WIDTH = 62;
    private static final String GTK = "gtk";
    private Calendar fCalendar;
    private Shell fPicker;
    private DateTime fDateTime;
    private Locale fLocale;
    private boolean fSelected;
    private boolean fExit;
    private int fFormatStyle;
    private Combo fHours;
    private Combo fMinutes;
    private Combo fAmPm;
    private Link fOk;
    private ViewModes fViewMode;

    public DatePicker(Shell parentShell, Locale locale, int formatStyle) {
        this.init(parentShell, locale, formatStyle, ViewModes.DATE);
    }

    public DatePicker(Shell parentShell, Locale locale) {
        this.init(parentShell, locale, 2, ViewModes.DATE);
    }

    public DatePicker(Shell parentShell, int formatStyle, ViewModes viewMode) {
        this.init(parentShell, null, formatStyle, viewMode);
    }

    public DatePicker(Shell parentShell, int formatStyle) {
        this.init(parentShell, null, formatStyle, ViewModes.DATE);
    }

    public DatePicker(Shell parentShell) {
        this.init(parentShell, null, 2, ViewModes.DATE);
    }

    private void init(Shell parentShell, Locale locale, int formatStyle, ViewModes viewMode) {
        this.fViewMode = viewMode;
        this.fLocale = locale;
        this.fPicker = new Shell(parentShell, 0);
        this.fPicker.setLayout((Layout)new GridLayout(1, false));
        this.fPicker.setLayoutData((Object)new GridData(1808));
        this.fPicker.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                DatePicker.this.close();
            }
        });
        this.fFormatStyle = formatStyle;
        this.createPickerArea();
        Dialog.applyDialogFont((Control)this.fPicker);
    }

    private void createPickerArea() {
        Color white = this.fPicker.getDisplay().getSystemColor(1);
        this.fPicker.setBackground(white);
        Composite area = new Composite((Composite)this.fPicker, 0);
        area.setBackground(white);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(1808));
        this.createCalendar(area, white);
        if (this.fViewMode == ViewModes.DATETIME) {
            this.createTimeOfDay(area, white);
        }
        this.createButtonBar(area, white);
    }

    private void createTimeOfDay(Composite parent, Color white) {
        int i;
        Composite area = new Composite(parent, 0);
        area.setBackground(white);
        GridLayout layout = new GridLayout(5, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 10;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(1808));
        Label label = new Label(area, 0);
        label.setText(Messages.DatePicker_TIME);
        label.setLayoutData((Object)new GridData());
        label.setBackground(white);
        label.setToolTipText(Messages.DatePicker_TIME_DESCRIPTION);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        intFormat.setMinimumIntegerDigits(2);
        KeyListener keyListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\n' || e.character == '\r') {
                    if (DatePicker.this.fViewMode == ViewModes.DATETIME) {
                        if (DatePicker.this.timeIsValid()) {
                            DatePicker.this.rememberDate();
                        } else {
                            DatePicker.this.fOk.setEnabled(false);
                        }
                    } else {
                        DatePicker.this.rememberDate();
                    }
                } else {
                    DatePicker.this.fOk.setEnabled(DatePicker.this.timeIsValid());
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        };
        this.fHours = new Combo(area, 4);
        this.fHours.setTextLimit(2);
        if (DatePicker.getUses24HourFormat()) {
            i = 0;
            while (i < 24) {
                this.fHours.add(intFormat.format((long)i));
                ++i;
            }
        } else {
            i = 1;
            while (i <= 12) {
                this.fHours.add(intFormat.format((long)i));
                ++i;
            }
        }
        this.fHours.setBackground(white);
        GridData comboLayoutData = new GridData();
        if (GTK.equals(SWT.getPlatform())) {
            comboLayoutData.widthHint = 62;
        }
        this.fHours.setLayoutData((Object)comboLayoutData);
        this.fHours.addKeyListener(keyListener);
        Label separator = new Label(area, 0);
        separator.setText(this.getTimeSeparator());
        separator.setBackground(white);
        separator.setLayoutData((Object)new GridData());
        this.fMinutes = new Combo(area, 4);
        this.fMinutes.setTextLimit(2);
        int i2 = 0;
        while (i2 <= 45) {
            this.fMinutes.add(intFormat.format((long)i2));
            i2 += 15;
        }
        this.fMinutes.setBackground(white);
        this.fMinutes.setLayoutData((Object)comboLayoutData);
        this.fMinutes.addKeyListener(keyListener);
        this.fAmPm = new Combo(area, 12);
        this.fAmPm.setItems(new String[]{Messages.DatePicker_AM, Messages.DatePicker_PM});
        this.fAmPm.setBackground(white);
        this.fAmPm.setLayoutData((Object)new GridData());
        this.fAmPm.addKeyListener(keyListener);
        this.fAmPm.setVisible(!DatePicker.getUses24HourFormat());
        if (!DatePicker.getUses24HourFormat() && DatePicker.getAmPmAppearsFirst()) {
            this.fAmPm.moveAbove((Control)this.fHours);
        }
        Calendar initialDate = this.fLocale != null ? Calendar.getInstance(this.fLocale) : Calendar.getInstance();
        initialDate.set(11, 12);
        initialDate.set(12, 0);
        initialDate.set(13, 0);
        this.setDate(initialDate.getTime());
    }

    private void createButtonBar(Composite area, Color white) {
        Link cancel;
        Composite okcancel = new Composite(area, 0);
        okcancel.setLayoutData((Object)new GridData(4, 4, true, true));
        okcancel.setBackground(white);
        GridLayout okcancellayout = new GridLayout(2, false);
        okcancellayout.marginHeight = 0;
        okcancellayout.marginWidth = 0;
        okcancel.setLayout((Layout)okcancellayout);
        if (!"carbon".equals(SWT.getPlatform())) {
            this.fOk = new Link(okcancel, 0);
            cancel = new Link(okcancel, 0);
        } else {
            cancel = new Link(okcancel, 0);
            this.fOk = new Link(okcancel, 0);
        }
        this.fOk.setBackground(white);
        this.fOk.setLayoutData((Object)new GridData(1, 4, true, true));
        this.fOk.setText(NLS.bind((String)"<a>{0}</a>", (Object)IDialogConstants.OK_LABEL));
        this.fOk.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (DatePicker.this.fViewMode == ViewModes.DATETIME) {
                    if (DatePicker.this.timeIsValid()) {
                        DatePicker.this.rememberDate();
                    } else {
                        DatePicker.this.close();
                    }
                } else {
                    DatePicker.this.rememberDate();
                }
            }
        });
        cancel.setBackground(white);
        cancel.setLayoutData((Object)new GridData(131072, 4, true, true));
        cancel.setText(NLS.bind((String)"<a>{0}</a>", (Object)IDialogConstants.CANCEL_LABEL));
        cancel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this.close();
            }
        });
    }

    protected boolean timeIsValid() {
        boolean isValid = true;
        if (DatePicker.getUses24HourFormat()) {
            if (!Pattern.matches(VALIDATOR_24_HOUR, this.fHours.getText())) {
                isValid = false;
            }
        } else if (!Pattern.matches(VALIDATOR_12_HOUR, this.fHours.getText())) {
            isValid = false;
        }
        if (!Pattern.matches(MINUTES_VALIDATOR, this.fMinutes.getText())) {
            isValid = false;
        }
        return isValid;
    }

    private void createCalendar(Composite area, Color white) {
        area.setBackground(white);
        this.fDateTime = new DateTime(area, 1024);
        this.fCalendar = this.fLocale != null ? Calendar.getInstance(this.fLocale) : Calendar.getInstance();
        this.fDateTime.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (DatePicker.this.closeOnDoubleClick(e.x, e.y)) {
                    DatePicker.this.rememberDate();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.fDateTime.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\n' || e.character == '\r') {
                    DatePicker.this.rememberDate();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private boolean closeOnDoubleClick(int x, int y) {
        if ("win32".equals(SWT.getPlatform()) || GTK.equals(SWT.getPlatform())) {
            return y >= 32;
        }
        return true;
    }

    public void setLocation(int x, int y) {
        this.fPicker.setLocation(x, y);
    }

    public void setDate(Date date) {
        this.fCalendar.setTime(date);
        this.fDateTime.setYear(this.fCalendar.get(1));
        this.fDateTime.setMonth(this.fCalendar.get(2));
        this.fDateTime.setDay(this.fCalendar.get(5));
        if (this.fViewMode == ViewModes.DATETIME) {
            NumberFormat intFormat = NumberFormat.getIntegerInstance();
            intFormat.setMinimumIntegerDigits(2);
            if (DatePicker.getUses24HourFormat()) {
                this.fHours.select(this.fCalendar.get(11));
                this.fMinutes.setText(String.valueOf(intFormat.format((long)this.fCalendar.get(12))));
            } else {
                int hour = this.fCalendar.get(10);
                if (hour == 0) {
                    hour = 12;
                }
                this.fHours.select(hour - 1);
                this.fMinutes.setText(String.valueOf(intFormat.format((long)this.fCalendar.get(12))));
                this.fAmPm.select(this.fCalendar.get(9) == 0 ? 0 : 1);
            }
        }
    }

    public Date getDateObject() {
        if (this.fSelected) {
            return this.fCalendar.getTime();
        }
        return null;
    }

    public String getDate() {
        if (this.fSelected) {
            DateFormat df = this.fLocale != null ? DateFormat.getDateInstance((int)this.fFormatStyle, (Locale)this.fLocale) : DateFormat.getDateInstance((int)this.fFormatStyle);
            return df.format(this.fCalendar.getTime());
        }
        return null;
    }

    public String getDate(int style) {
        if (this.fSelected) {
            DateFormat df = this.fLocale != null ? DateFormat.getDateInstance((int)style, (Locale)this.fLocale) : DateFormat.getDateInstance((int)style);
            return df.format(this.fCalendar.getTime());
        }
        return null;
    }

    private void rememberDate() {
        this.fSelected = true;
        this.fCalendar.clear();
        if (this.fViewMode == ViewModes.DATETIME) {
            int hourOfDay = Integer.valueOf(this.fHours.getText().trim());
            if (!DatePicker.getUses24HourFormat()) {
                hourOfDay = Integer.valueOf(this.fHours.getText().trim());
                if (this.fAmPm.getSelectionIndex() == 1) {
                    if (hourOfDay < 12) {
                        hourOfDay += 12;
                    }
                } else if (hourOfDay == 12) {
                    hourOfDay -= 12;
                }
            }
            this.fCalendar.set(this.fDateTime.getYear(), this.fDateTime.getMonth(), this.fDateTime.getDay(), hourOfDay, Integer.valueOf(this.fMinutes.getText()));
        } else {
            this.fCalendar.set(this.fDateTime.getYear(), this.fDateTime.getMonth(), this.fDateTime.getDay());
        }
        this.close();
    }

    public void open() {
        this.fPicker.pack();
        this.fPicker.open();
        Display display = this.fPicker.getDisplay();
        this.fExit = false;
        while (!this.fPicker.isDisposed() && !this.fExit) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this.fPicker.isDisposed()) {
            this.fPicker.close();
            this.fPicker.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return this.fPicker.computeSize(wHint, hHint);
    }

    public void close() {
        this.fExit = true;
    }

    public static boolean getUses24HourFormat() {
        DateFormat format = DateFormat.getTimeInstance((int)3);
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleFormat = (SimpleDateFormat)format;
            String pattern = simpleFormat.toPattern();
            return DatePicker.indexOfUnescaped(pattern, 'a') == -1;
        }
        return true;
    }

    private static boolean getAmPmAppearsFirst() {
        DateFormat format = DateFormat.getTimeInstance((int)3);
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleFormat = (SimpleDateFormat)format;
            String pattern = simpleFormat.toPattern();
            int aIndex = DatePicker.indexOfUnescaped(pattern, 'a');
            int hIndex = DatePicker.indexOfUnescaped(pattern, 'h');
            if (aIndex == -1 || hIndex == -1) {
                return false;
            }
            return aIndex < hIndex;
        }
        return false;
    }

    private static int indexOfUnescaped(String pattern, char c) {
        int i = 0;
        while (true) {
            if ((i = pattern.indexOf(c, i)) == -1) {
                return -1;
            }
            if (i <= 0 || pattern.charAt(i - 1) != '\'') break;
            ++i;
        }
        return i;
    }

    public String getTimeSeparator() {
        String separatorText = ":";
        Pattern separatorPattern = Pattern.compile("[0-9][^0-9][0-9][0-9]");
        Matcher matcher = separatorPattern.matcher(DateFormat.getTimeInstance((int)this.fFormatStyle).format(new Date()));
        if (matcher != null && matcher.find()) {
            separatorText = matcher.group().substring(matcher.group().length() - 3, matcher.group().length() - 2);
            return separatorText;
        }
        return separatorText;
    }

    public static enum ViewModes {
        DATE,
        DATETIME;

    }
}

