/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import java.lang.reflect.Method;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class StandardControlLabelProvider {
    private boolean fIsFontAware = false;
    private boolean fIsForegroundAware = false;
    private boolean fIsBackgroundAware = false;
    private boolean fIsTextAware = false;
    private boolean fIsImageAware = false;
    private Font fOrigFont;
    private Color fOrigForeground;
    private Color fOrigBackground;
    private Object fElement;
    private Control fControl;
    private IViewerLabelProvider fLabelProvider;
    private HyperlinkAdapter fHyperlinkListener;
    private boolean fHasSetText = true;
    private Method fsetTextMethod;
    private boolean fHasSetImage = true;
    private Method fSetImageMethod;
    private ILabelProviderListener fListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            StandardControlLabelProvider.this.internalApplyLabel();
        }
    };

    public StandardControlLabelProvider(Control control) {
        this.fControl = control;
        this.fOrigFont = this.fControl.getFont();
        this.fOrigBackground = this.fControl.getBackground();
        this.fOrigForeground = this.fControl.getForeground();
        this.fControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StandardControlLabelProvider.this.fLabelProvider.dispose();
                StandardControlLabelProvider.this.fLabelProvider = null;
                StandardControlLabelProvider.this.fOrigBackground = null;
                StandardControlLabelProvider.this.fOrigFont = null;
                StandardControlLabelProvider.this.fOrigForeground = null;
                StandardControlLabelProvider.this.fsetTextMethod = null;
                if (StandardControlLabelProvider.this.fControl instanceof Hyperlink) {
                    Hyperlink hyperlink = (Hyperlink)StandardControlLabelProvider.this.fControl;
                    hyperlink.removeHyperlinkListener((IHyperlinkListener)StandardControlLabelProvider.this.fHyperlinkListener);
                }
            }
        });
        if (this.fControl instanceof Hyperlink) {
            Hyperlink hyperlink = (Hyperlink)this.fControl;
            this.fHyperlinkListener = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    StandardControlLabelProvider.this.internalApplyLabel();
                }

                public void linkEntered(HyperlinkEvent e) {
                    StandardControlLabelProvider.this.internalApplyLabel();
                }

                public void linkExited(HyperlinkEvent e) {
                    StandardControlLabelProvider.this.internalApplyLabel();
                }
            };
            hyperlink.addHyperlinkListener((IHyperlinkListener)this.fHyperlinkListener);
        }
    }

    public void setLabelProvider(IViewerLabelProvider labelProvider) {
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        this.fLabelProvider = labelProvider;
        this.fLabelProvider.addListener(this.fListener);
    }

    public boolean isBackgroundAware() {
        return this.fIsBackgroundAware;
    }

    public void setBackgroundAware(boolean isBackgroundAware) {
        this.ensureStdLabelProvider();
        this.fIsBackgroundAware = isBackgroundAware;
    }

    public boolean isFontAware() {
        return this.fIsFontAware;
    }

    public void setFontAware(boolean isFontAware) {
        this.ensureStdLabelProvider();
        this.fIsFontAware = isFontAware;
    }

    public boolean isForegroundAware() {
        return this.fIsForegroundAware;
    }

    public void setForegroundAware(boolean isForegroundAware) {
        this.ensureStdLabelProvider();
        this.fIsForegroundAware = isForegroundAware;
    }

    public Object getElement() {
        return this.fElement;
    }

    public void setElement(Object element) {
        this.fElement = element;
        this.internalApplyLabel();
    }

    public boolean isTextAware() {
        return this.fIsTextAware;
    }

    public void setTextAware(boolean isTextAware) {
        this.ensureStdLabelProvider();
        this.fIsTextAware = isTextAware;
    }

    public boolean isImageAware() {
        return this.fIsImageAware;
    }

    public void setImageAware(boolean isImageAware) {
        this.fIsImageAware = isImageAware;
    }

    public Control getControl() {
        return this.fControl;
    }

    private void ensureStdLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new StandardLabelProvider(new ElementRemovedNotifierImpl());
            this.fLabelProvider.addListener(this.fListener);
        }
    }

    private void internalApplyLabel() {
        if (this.fElement != null && (this.fIsBackgroundAware || this.fIsFontAware || this.fIsForegroundAware || this.fIsTextAware)) {
            ViewerLabel label = this.createLabel();
            this.ensureStdLabelProvider();
            this.fLabelProvider.updateLabel(label, this.fElement);
            this.applyLabel(this.fControl, label);
            this.fControl.redraw();
        }
    }

    protected void applyLabel(Control control, ViewerLabel label) {
        if (this.fIsBackgroundAware) {
            this.fControl.setBackground(label.getBackground());
        }
        if (this.fIsForegroundAware) {
            this.fControl.setForeground(label.getForeground());
        }
        if (this.fIsFontAware) {
            this.fControl.setFont(label.getFont());
        }
        if (this.fHasSetText && this.fIsTextAware && label.getText() != null) {
            this.applyText(label.getText());
        }
        if (this.fHasSetImage && this.fIsImageAware && label.getImage() != null) {
            this.applyImage(label.getImage());
        }
    }

    protected void applyImage(Image image) {
        try {
            if (this.fSetImageMethod == null) {
                this.fSetImageMethod = this.fControl.getClass().getMethod("setImage", Image.class);
            }
            this.fSetImageMethod.invoke((Object)this.fControl, image);
        }
        catch (Exception e) {
            this.fHasSetImage = false;
        }
    }

    protected void applyText(String text) {
        try {
            if (this.fsetTextMethod == null) {
                this.fsetTextMethod = this.fControl.getClass().getMethod("setText", String.class);
            }
            this.fsetTextMethod.invoke((Object)this.fControl, text);
        }
        catch (Exception e) {
            this.fHasSetText = false;
        }
    }

    private ViewerLabel createLabel() {
        ViewerLabel label = new ViewerLabel(null, null);
        if (this.fOrigBackground != null && !this.fOrigBackground.isDisposed()) {
            label.setBackground(this.fOrigBackground);
        }
        if (this.fOrigFont != null && !this.fOrigFont.isDisposed()) {
            label.setFont(this.fOrigFont);
        }
        if (this.fOrigForeground != null && !this.fOrigForeground.isDisposed()) {
            label.setForeground(this.fOrigForeground);
        }
        return label;
    }
}

