/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;

public class GenericAggregationBin
implements IAdaptable {
    private List fItems;
    private Date fLatestItemDate = new Date(0L);
    private Object fLatestItem;

    public GenericAggregationBin() {
        this.fItems = new ArrayList(5);
    }

    public void add(Object item) {
        Date itemDate = this.getDate(item);
        if (itemDate != null && itemDate.after(this.fLatestItemDate)) {
            this.fLatestItem = item;
            this.fLatestItemDate = itemDate;
        }
        if (this.fItems.size() == 0 || !this.fItems.contains(item)) {
            this.fItems.add(item);
        }
    }

    public boolean containsUnread() {
        for (Object obj : this.fItems) {
            if (this.isRead(obj)) continue;
            return true;
        }
        return false;
    }

    public List getAllItems() {
        return new ArrayList(this.fItems);
    }

    public Object getAdapter(Class adapter) {
        Object mostRecent = this.getMostRecent();
        if (adapter == IReadStateTracker.class) {
            return ((IAdaptable)mostRecent).getAdapter(IReadStateTracker.class);
        }
        if (adapter == IDateProvider.class) {
            return ((IAdaptable)mostRecent).getAdapter(IDateProvider.class);
        }
        return Adapters.getAdapter((Object)mostRecent, (Class)adapter);
    }

    public List getItems() {
        return this.fItems;
    }

    public Date getLatestItemDate() {
        return this.fLatestItemDate;
    }

    public Object getMostRecent() {
        if (this.fLatestItem != null) {
            return this.fLatestItem;
        }
        Date date = new Date(0L);
        Object obj = null;
        int a = 0;
        while (a < this.fItems.size()) {
            Object item = this.fItems.get(a);
            Date itemDate = this.getDate(item);
            if (itemDate != null && itemDate.after(date)) {
                date = itemDate;
                obj = item;
            }
            ++a;
        }
        this.fLatestItem = obj;
        this.fLatestItemDate = date;
        if (obj == null && this.fItems.size() > 0) {
            obj = this.fItems.get(this.fItems.size() - 1);
        }
        return obj;
    }

    public int getSize() {
        return this.fItems.size();
    }

    public int indexOf(Object item) {
        return this.fItems.indexOf(item);
    }

    public void remove(Object item) {
        this.fItems.remove(item);
        if (this.fLatestItem == item) {
            this.fLatestItem = null;
            if (this.fItems.size() > 0) {
                this.fLatestItemDate = this.getDate(this.getMostRecent());
            }
        }
    }

    private Date getDate(Object obj) {
        Object adapter;
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof IAdaptable && (adapter = ((IAdaptable)obj).getAdapter(IDateProvider.class)) != null) {
            return ((IDateProvider)adapter).getDate();
        }
        adapter = Platform.getAdapterManager().getAdapter(obj, IDateProvider.class);
        if (adapter != null) {
            return ((IDateProvider)adapter).getDate();
        }
        return null;
    }

    private boolean isRead(Object obj) {
        Object adapter;
        if (obj instanceof IAdaptable && (adapter = ((IAdaptable)obj).getAdapter(IReadStateTracker.class)) != null) {
            return ((IReadStateTracker)adapter).isMarkedRead();
        }
        adapter = Platform.getAdapterManager().getAdapter(obj, IReadStateTracker.class);
        if (adapter != null) {
            return ((IReadStateTracker)adapter).isMarkedRead();
        }
        return false;
    }
}

