/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public abstract class DoubleBufferPainter {
    private Image fBuffer;

    public DoubleBufferPainter(final Canvas canvas) {
        int style = canvas.getStyle();
        final boolean useDoubleBuffer = (style & 0x40000) != 0 && (style & 0x20000000) == 0;
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (useDoubleBuffer) {
                    DoubleBufferPainter.this.doubleBufferPaint(canvas, event);
                } else {
                    DoubleBufferPainter.this.doPaint(event);
                }
            }
        });
        if (useDoubleBuffer) {
            canvas.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DoubleBufferPainter.this.fBuffer != null) {
                        DoubleBufferPainter.this.fBuffer.dispose();
                        DoubleBufferPainter.this.fBuffer = null;
                    }
                }
            });
        }
    }

    public abstract void doPaint(PaintEvent var1);

    private void doubleBufferPaint(Canvas canvas, PaintEvent event) {
        GC eventGC = event.gc;
        Point size = canvas.getSize();
        if (size.x <= 1 || size.y <= 1) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)canvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            canvas.drawBackground(gc, 0, 0, size.x, size.y);
            gc.setForeground(event.gc.getForeground());
            gc.setFont(event.gc.getFont());
            event.gc = gc;
            this.doPaint(event);
        }
        finally {
            gc.dispose();
        }
        eventGC.drawImage(this.fBuffer, 0, 0);
    }
}

