/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class DimmedIconDescriptor
extends ImageDescriptor {
    private ImageDescriptor fOriginal;

    public DimmedIconDescriptor(ImageDescriptor original) {
        this.fOriginal = original;
    }

    public ImageData getImageData() {
        int srcY;
        if (this.fOriginal == null) {
            return null;
        }
        Image img = this.fOriginal.createImage();
        ImageData src = img.getImageData();
        Point size = new Point(img.getBounds().width, img.getBounds().height);
        ImageData imageData = new ImageData(size.x, size.y, 24, new PaletteData(255, 65280, 0xFF0000));
        imageData.alphaData = new byte[imageData.width * imageData.height];
        boolean transparency = false;
        byte[] alphaData = imageData.alphaData;
        int i = 0;
        while (i < alphaData.length) {
            int alpha = alphaData[i] & 0xFF;
            if (alpha != 0 && alpha != 255) {
                return imageData;
            }
            if (!transparency && alpha == 0) {
                transparency = true;
            }
            ++i;
        }
        if (transparency) {
            PaletteData palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
            ImageData mask = new ImageData(imageData.width, imageData.height, 1, palette);
            int y = 0;
            while (y < mask.height) {
                int x = 0;
                while (x < mask.width) {
                    mask.setPixel(x, y, imageData.getAlpha(x, y) == 255 ? 1 : 0);
                    ++x;
                }
                ++y;
            }
        } else {
            imageData.alphaData = null;
        }
        PaletteData srcPalette = src.palette;
        ImageData srcMask = null;
        int alphaMask = 0;
        int alphaShift = 0;
        if (src.maskData != null) {
            srcMask = src.getTransparencyMask();
            if (src.depth == 32) {
                alphaMask = ~(srcPalette.redMask | srcPalette.greenMask | srcPalette.blueMask);
                while (alphaMask != 0 && (alphaMask >>> alphaShift & 1) == 0) {
                    ++alphaShift;
                }
            }
        }
        int dstY = srcY = 0;
        while (srcY < src.height) {
            int srcX;
            int dstX = srcX = 0;
            while (srcX < src.width) {
                if (dstX >= 0 && dstX < imageData.width && dstY >= 0 && dstY < imageData.height) {
                    int srcPixel = src.getPixel(srcX, srcY);
                    int srcAlpha = 255;
                    if (src.maskData != null) {
                        if (src.depth == 32) {
                            srcAlpha = (srcPixel & alphaMask) >>> alphaShift;
                            if (srcAlpha == 0) {
                                srcAlpha = srcMask.getPixel(srcX, srcY) != 0 ? 255 : 0;
                            }
                        } else if (srcMask.getPixel(srcX, srcY) == 0) {
                            srcAlpha = 0;
                        }
                    } else if (src.transparentPixel != -1) {
                        if (src.transparentPixel == srcPixel) {
                            srcAlpha = 0;
                        }
                    } else if (src.alpha != -1) {
                        srcAlpha = src.alpha;
                    } else if (src.alphaData != null) {
                        srcAlpha = src.getAlpha(srcX, srcY);
                    }
                    if (srcAlpha != 0) {
                        int srcBlue;
                        int srcGreen;
                        int srcRed;
                        if (srcPalette.isDirect) {
                            srcRed = srcPixel & srcPalette.redMask;
                            srcRed = srcPalette.redShift < 0 ? srcRed >>> -srcPalette.redShift : srcRed << srcPalette.redShift;
                            srcGreen = srcPixel & srcPalette.greenMask;
                            srcGreen = srcPalette.greenShift < 0 ? srcGreen >>> -srcPalette.greenShift : srcGreen << srcPalette.greenShift;
                            srcBlue = srcPixel & srcPalette.blueMask;
                            srcBlue = srcPalette.blueShift < 0 ? srcBlue >>> -srcPalette.blueShift : srcBlue << srcPalette.blueShift;
                        } else {
                            RGB rgb = srcPalette.getRGB(srcPixel);
                            srcRed = rgb.red;
                            srcGreen = rgb.green;
                            srcBlue = rgb.blue;
                        }
                        RGB dimmed = this.dim(new RGB(srcRed, srcGreen, srcBlue));
                        imageData.setPixel(dstX, dstY, (dimmed.red & 0xFF) << 0 | (dimmed.green & 0xFF) << 8 | (dimmed.blue & 0xFF) << 16);
                        imageData.setAlpha(dstX, dstY, srcAlpha);
                    }
                }
                ++srcX;
                ++dstX;
            }
            ++srcY;
            ++dstY;
        }
        img.dispose();
        return imageData;
    }

    private RGB dim(RGB color) {
        float[] hsb = color.getHSB();
        return new RGB(hsb[0], hsb[1] / 2.0f, Math.min(hsb[2] * 2.0f, 1.0f));
    }

    public int hashCode() {
        if (this.fOriginal != null) {
            return this.fOriginal.hashCode() + 31;
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (this.fOriginal == null) {
            return super.equals(obj);
        }
        DimmedIconDescriptor other = (DimmedIconDescriptor)((Object)obj);
        return this.fOriginal.equals(other.fOriginal);
    }
}

