/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.internal.HyperlinkHandlerRegistry;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;

public class BrowserLocationListener
extends LocationAdapter {
    protected final String ABOUT_BLANK = "about:blank";
    private ContextProvider fContextProvider;

    public BrowserLocationListener() {
        this(null);
    }

    public BrowserLocationListener(ContextProvider contextProvider) {
        this.fContextProvider = contextProvider;
    }

    public void changing(LocationEvent event) {
        String location = event.location;
        if (location.startsWith("about:blank")) {
            return;
        }
        try {
            URI uri = new URI(location);
            HyperlinkHandler handler = HyperlinkHandlerRegistry.getDefault().getCustomOpenHandler(uri);
            if (handler != null) {
                if (!handler.shouldOpen(uri)) {
                    return;
                }
                event.doit = false;
                Hyperlinks.open((URI)this.normalize(uri), (ContextProvider)this.fContextProvider);
            } else {
                String scheme = uri.getScheme();
                if ("http".equals(scheme) || "https".equals(scheme) || "ftp".equals(scheme) || "mailto".equals(scheme) || "file".equals(scheme)) {
                    Hyperlinks.open((URI)this.normalize(uri), (ContextProvider)this.fContextProvider);
                    event.doit = false;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private URI normalize(URI uri) {
        if (uri.toString().endsWith("/")) {
            try {
                String s = uri.toString();
                uri = new URI(s.substring(0, s.length() - 1));
            }
            catch (URISyntaxException x) {
                throw new RuntimeException(x);
            }
        }
        return uri;
    }
}

