/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.service.managers.clearquest.common;

import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.interop.service.managers.clearquest.common.Messages;
import java.net.URI;
import java.net.URLDecoder;
import java.text.MessageFormat;

public class CQRepositoryInfoParser {
    private static final int UNIQUE_ID_PREFIX_LENGTH = "CQ:cq.repo.cq-record:".length();
    private static CQRepositoryInfoParser singleton = new CQRepositoryInfoParser();

    private CQRepositoryInfoParser() {
    }

    public static CQRepositoryInfoParser getCQRepositoryInfoParser() {
        return singleton;
    }

    public String deriveCQRecordTypeNameFromExternalTypeName(String externalTypeName) throws InteropException {
        int indexOfThirdLastDot = externalTypeName.lastIndexOf(46);
        if (indexOfThirdLastDot != -1) {
            return externalTypeName.substring(indexOfThirdLastDot + 1);
        }
        throw new InteropException(MessageFormat.format(Messages.getString("CQRepositoryInfoParser.ERROR_TYPE_NAME_MISSING_A_DOT"), externalTypeName));
    }

    public String deriveCQRecordTypeNameFromUniqueId(String uniqueId, String attachmentFieldName) throws InteropException {
        String decodedUniqueId;
        block10: {
            block9: {
                decodedUniqueId = null;
                try {
                    decodedUniqueId = URLDecoder.decode(uniqueId, "UTF-8");
                }
                catch (Exception e) {
                    throw new InteropException(e);
                }
                try {
                    if (attachmentFieldName == null || !decodedUniqueId.contains(attachmentFieldName) || decodedUniqueId.split("/").length != 5) break block9;
                    return "attachments";
                }
                catch (Exception e) {
                    throw new InteropException(MessageFormat.format(Messages.getString("CQRepositoryInfoParser.ERROR_TYPE_NAME_MALFORMED_IN_SOME_WAY"), decodedUniqueId), e);
                }
            }
            if (decodedUniqueId.startsWith("CQ:repo/cq-record:")) {
                int indexOfFirstSlash = decodedUniqueId.indexOf(47, UNIQUE_ID_PREFIX_LENGTH);
                if (indexOfFirstSlash != -1) {
                    return decodedUniqueId.substring(UNIQUE_ID_PREFIX_LENGTH, indexOfFirstSlash);
                }
                throw new InteropException(MessageFormat.format(Messages.getString("CQRepositoryInfoParser.ERROR_TYPE_NAME_MISSING_A_SLASH"), decodedUniqueId));
            }
            if (!decodedUniqueId.contains("CQ:cq.user")) break block10;
            return "users";
        }
        int indexOfFirstSlash = decodedUniqueId.indexOf(47);
        int indexOfSecondColon = decodedUniqueId.indexOf(58, decodedUniqueId.indexOf(58) + 1);
        if (indexOfFirstSlash == -1 || indexOfSecondColon == -1) {
            throw new InteropException(MessageFormat.format(Messages.getString("CQRepositoryInfoParser.ERROR_TYPE_NAME_MISSING_A_SLASH_OR_COLON"), decodedUniqueId));
        }
        return decodedUniqueId.substring(indexOfSecondColon + 1, indexOfFirstSlash);
    }

    public String deriveCQRecordTypeNameFromURI(URI uri, String attachmentFieldName) throws InteropException {
        return this.deriveCQRecordTypeNameFromUniqueId(uri.toASCIIString(), attachmentFieldName);
    }
}

