/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.rcp.ui.internal;

import com.ibm.team.interop.client.admin.IItemConnectorAdminClient;
import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.common.ISyncRuleHandle;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.interop.common.dto.IManagerInfoDTO;
import com.ibm.team.interop.common.dto.ITransformerInfoDTO;
import com.ibm.team.interop.common.dto.ITypeInfoDTO;
import com.ibm.team.interop.rcp.ui.InteropRcpUiPlugin;
import com.ibm.team.interop.rcp.ui.internal.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.AbstractWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.SaveConflictException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;

public class SyncRuleWorkingCopy
extends AbstractWorkingCopy {
    private final Job fRevertJob = new Job(Messages.SyncRuleWorkingCopy_FETCHING_SYNCRULE_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            SyncRuleWorkingCopy.this.doRevert(monitor);
            return Status.OK_STATUS;
        }
    };
    private final ISharedItemChangeListener fChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                IItem item = event.getSharedItem();
                if (item instanceof ISyncRule && event.getAfterState() == null) {
                    SyncRuleWorkingCopy.this.unregisterSharedItemListener();
                    SyncRuleWorkingCopy.this.fSyncRule = InteropFactory.INSTANCE.createSyncRule();
                    SyncRuleWorkingCopy.this.fExternalRepositoryConnection = null;
                }
                SyncRuleWorkingCopy.this.setValid(false);
                SyncRuleWorkingCopy.this.fRevertJob.setSystem(true);
                SyncRuleWorkingCopy.this.fRevertJob.schedule();
            }
        }
    };
    private final ITeamRepository fRepository;
    private IProcessArea fProcessArea;
    private IProjectArea fProjectArea;
    private ISyncRule fSyncRule;
    private IExternalRepositoryConnection fExternalRepositoryConnection;
    private Throwable fLastError;
    private boolean fNoLicense;
    private IItemConnectorAdminClient fAdminClient;
    private ILicenseClient fLicenseClient;
    private IManagerInfoDTO[] fItemManagerInfo;
    private final Map<IManagerInfoDTO, ITypeInfoDTO[]> fItemManagerTypeInfoMap = Collections.synchronizedMap(new HashMap());
    private IManagerInfoDTO[] fExternalManagerInfo;
    private final Map<IManagerInfoDTO, ITypeInfoDTO[]> fExternalManagerTypeInfoMap = Collections.synchronizedMap(new HashMap());
    private ITransformerInfoDTO[] fTransformerInfo;
    private List<IExternalRepositoryConnection> fExternalRepositoryConnections;
    private List<ISyncRule> fProjectAreaSyncRules;
    private static Charset UTF8 = Charset.forName("UTF-8");

    public SyncRuleWorkingCopy(ISyncRule syncRule, ITeamRepository repository, IProcessArea processArea) {
        if (syncRule == null) {
            throw new IllegalArgumentException("syncRule cannot be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("repository cannot be null");
        }
        this.fRepository = repository;
        this.fProcessArea = processArea;
        this.fSyncRule = syncRule.isWorkingCopy() ? syncRule : (ISyncRule)syncRule.getWorkingCopy();
        this.setValid(false);
    }

    public ISyncRule getSyncRule() {
        this.waitForRevertJob();
        return this.fSyncRule;
    }

    public void dispose() {
        this.unregisterSharedItemListener();
    }

    public ImageDescriptor getImage() {
        return InteropRcpUiPlugin.SYNC_RULE_IMAGE_DESCRIPTOR;
    }

    public String getName() {
        this.waitForRevertJob();
        String name = this.fSyncRule.getName();
        if (name == null || name.length() == 0) {
            return Messages.SyncRuleWorkingCopy_DEFAULT_NAME;
        }
        return name;
    }

    public String getToolTipText() {
        return Messages.SyncRuleWorkingCopy_TOOLTIP;
    }

    public void revert(IProgressMonitor progress) throws CoreException {
        this.setValid(false);
        this.fRevertJob.setSystem(false);
        this.fRevertJob.schedule();
    }

    public void save(IProgressMonitor progress) throws CoreException, SaveConflictException {
        IStatus status = this.doSave(false);
        if (status.getSeverity() == 4) {
            if (status.getException() instanceof StaleDataException) {
                throw new SaveConflictException();
            }
            throw new CoreException(status);
        }
    }

    public void saveAndOverwrite(IProgressMonitor progress) throws CoreException {
        IStatus status = this.doSave(true);
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    public IStatus importFromFile(File file) {
        IStatus status;
        block15: {
            if (this.fNoLicense) {
                return Status.OK_STATUS;
            }
            this.setValid(false);
            InputStreamReader reader = null;
            status = Status.OK_STATUS;
            try {
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), UTF8);
                    this.fSyncRule.importDefinition((Reader)reader);
                }
                catch (Exception e) {
                    status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setValid(true);
        return status;
    }

    public IStatus exportToFile(File file) {
        IStatus status;
        block13: {
            if (this.fNoLicense) {
                return Status.OK_STATUS;
            }
            OutputStreamWriter writer = null;
            status = Status.OK_STATUS;
            try {
                try {
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);
                    this.fSyncRule.exportDefinition((Writer)writer);
                }
                catch (Exception e) {
                    status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return status;
    }

    public IProjectArea getProjectArea() {
        this.waitForRevertJob();
        return this.fProjectArea;
    }

    public IExternalRepositoryConnection getExternalRepositoryConnection() {
        this.waitForRevertJob();
        return this.fExternalRepositoryConnection;
    }

    public void updateExternalRepositoryConnection(IExternalRepositoryConnection externalConnection) {
        this.fExternalRepositoryConnection = externalConnection;
    }

    public IManagerInfoDTO[] getItemManagerInfo() {
        this.waitForRevertJob();
        return this.fItemManagerInfo;
    }

    public ITypeInfoDTO[] getItemManagerTypeInfo(IManagerInfoDTO managerInfo) {
        this.waitForRevertJob();
        return this.fItemManagerTypeInfoMap.get(managerInfo);
    }

    public IManagerInfoDTO[] getExternalManagerInfo() {
        this.waitForRevertJob();
        return this.fExternalManagerInfo;
    }

    public ITypeInfoDTO[] getExternalManagerTypeInfo(IManagerInfoDTO managerInfo, IExternalRepositoryConnection externalConnection, IProgressMonitor monitor) {
        if (this.fNoLicense) {
            return null;
        }
        this.fLastError = null;
        try {
            this.loadExternalManagerTypeInfo(managerInfo, externalConnection, monitor);
        }
        catch (Exception e) {
            this.fLastError = e;
            return null;
        }
        return this.fExternalManagerTypeInfoMap.get(managerInfo);
    }

    public ITransformerInfoDTO[] getValueTransformerInfo() {
        this.waitForRevertJob();
        return this.fTransformerInfo;
    }

    public List<IExternalRepositoryConnection> getExternalRepositoryConnections() {
        this.waitForRevertJob();
        return this.fExternalRepositoryConnections;
    }

    public List<ISyncRule> getSyncRulesInProjectArea() {
        this.waitForRevertJob();
        return this.fProjectAreaSyncRules;
    }

    public Throwable getLastError() {
        return this.fLastError;
    }

    public boolean isLicensed() {
        return !this.fNoLicense;
    }

    private void doRevert(IProgressMonitor monitor) {
        if (this.fNoLicense) {
            this.setValid(true);
            return;
        }
        this.fProjectAreaSyncRules = Collections.emptyList();
        this.fExternalRepositoryConnection = null;
        this.fItemManagerInfo = new IManagerInfoDTO[0];
        this.fExternalManagerInfo = new IManagerInfoDTO[0];
        this.fTransformerInfo = new ITransformerInfoDTO[0];
        this.fExternalRepositoryConnections = Collections.emptyList();
        this.fLastError = null;
        try {
            this.licenseClient().assertLicense("com.ibm.team.interop.server.saveSyncRule", monitor);
        }
        catch (LicenseNotGrantedException e) {
            this.fLastError = new TeamRepositoryException(Messages.ExternalConnection_NOT_LICENSED, (Throwable)e);
            this.fNoLicense = true;
            this.setValid(true);
            return;
        }
        catch (Throwable e) {
            this.fLastError = e;
            this.fNoLicense = true;
            this.setValid(true);
            return;
        }
        try {
            this.unregisterSharedItemListener();
            if (!this.fSyncRule.isNewItem()) {
                this.fSyncRule = (ISyncRule)this.fRepository.itemManager().fetchCompleteItem((IItemHandle)this.fSyncRule, 1, monitor);
                this.fSyncRule = (ISyncRule)this.fSyncRule.getWorkingCopy();
            }
            if (this.fProcessArea instanceof IProjectArea) {
                this.fProjectArea = (IProjectArea)this.fProcessArea;
            } else {
                IProjectAreaHandle projectAreaHandle = this.fProcessArea != null ? this.fProcessArea.getProjectArea() : this.fSyncRule.getProjectArea();
                if (projectAreaHandle != null) {
                    this.fProjectArea = (IProjectArea)this.fRepository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
                }
                if (this.fProcessArea == null) {
                    this.fProcessArea = this.fProjectArea;
                }
            }
            if (this.fProcessArea != null) {
                ISyncRuleHandle[] syncRuleHandles = this.adminClient().findSyncRulesByProjectArea(this.fProcessArea.getProjectArea(), monitor);
                this.fProjectAreaSyncRules = syncRuleHandles.length == 0 ? Collections.emptyList() : this.fRepository.itemManager().fetchCompleteItems(Arrays.asList(syncRuleHandles), 0, monitor);
            }
            this.loadExternalRepositoryConnection(monitor);
            this.fItemManagerInfo = this.adminClient().getItemManagerInfo(monitor);
            this.loadItemManagerTypeInfo(monitor);
            this.fExternalManagerInfo = this.adminClient().getExternalManagerInfo(monitor);
            this.fTransformerInfo = this.adminClient().getValueTransformerInfo(monitor);
            IExternalRepositoryConnection[] externalConnections = this.adminClient().getAllExternalRepositoryConnections(monitor);
            if (externalConnections.length != 0) {
                this.fExternalRepositoryConnections = Arrays.asList(externalConnections);
            }
            this.registerSharedItemListener();
        }
        catch (Throwable e) {
            this.fLastError = e;
        }
        this.setValid(true);
    }

    private void loadExternalRepositoryConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fSyncRule.getExternalRepository() == null) {
            this.fExternalRepositoryConnection = null;
        } else {
            IExternalRepositoryConnection tempConnection = (IExternalRepositoryConnection)this.fRepository.itemManager().fetchCompleteItem((IItemHandle)this.fSyncRule.getExternalRepository(), 2, monitor);
            this.fExternalRepositoryConnection = this.adminClient().findExternalRepositoryConnection(tempConnection.getName(), monitor);
        }
    }

    private void loadItemManagerTypeInfo(IProgressMonitor monitor) {
        this.fItemManagerTypeInfoMap.clear();
        IManagerInfoDTO[] iManagerInfoDTOArray = this.fItemManagerInfo;
        int n = this.fItemManagerInfo.length;
        int n2 = 0;
        while (n2 < n) {
            IManagerInfoDTO managerInfo = iManagerInfoDTOArray[n2];
            try {
                ITypeInfoDTO[] typeInfo = this.adminClient().getItemManagerTypeInfo(managerInfo, this.fProcessArea, monitor);
                this.fItemManagerTypeInfoMap.put(managerInfo, typeInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    private void loadExternalManagerTypeInfo(IManagerInfoDTO managerInfo, IExternalRepositoryConnection externalConnection, IProgressMonitor monitor) throws TeamRepositoryException {
        ITypeInfoDTO[] typeInfo = this.adminClient().getExternalManagerTypeInfo(managerInfo, externalConnection, monitor);
        this.fExternalManagerTypeInfoMap.put(managerInfo, typeInfo);
    }

    private void waitForRevertJob() {
        try {
            this.fRevertJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private IStatus doSave(boolean overwrite) {
        SaveJob saveJob = new SaveJob(overwrite);
        saveJob.setSystem(false);
        saveJob.schedule();
        try {
            saveJob.join();
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException(e.getMessage());
        }
        return saveJob.getStatus();
    }

    private void registerSharedItemListener() {
        if (this.fSyncRule != null && !this.fSyncRule.isNewItem()) {
            this.fRepository.itemManager().addItemChangeListener((IItem)this.fSyncRule, this.fChangeListener);
        }
        if (this.fExternalRepositoryConnection != null) {
            this.fRepository.itemManager().addItemChangeListener((IItem)this.fExternalRepositoryConnection, this.fChangeListener);
        }
    }

    private void unregisterSharedItemListener() {
        if (this.fSyncRule != null && !this.fSyncRule.isNewItem() && this.fRepository != null) {
            this.fRepository.itemManager().removeItemChangeListener((IItem)this.fSyncRule, this.fChangeListener);
        }
        if (this.fExternalRepositoryConnection != null) {
            this.fRepository.itemManager().removeItemChangeListener((IItem)this.fExternalRepositoryConnection, this.fChangeListener);
        }
    }

    private IItemConnectorAdminClient adminClient() {
        if (this.fAdminClient == null) {
            this.fAdminClient = (IItemConnectorAdminClient)this.fRepository.getClientLibrary(IItemConnectorAdminClient.class);
        }
        return this.fAdminClient;
    }

    private ILicenseClient licenseClient() {
        if (this.fLicenseClient == null) {
            this.fLicenseClient = (ILicenseClient)this.fRepository.getClientLibrary(ILicenseClient.class);
        }
        return this.fLicenseClient;
    }

    private class SaveJob
    extends Job {
        private final boolean fOverwrite;
        private IStatus fStatus;

        SaveJob(boolean overwrite) {
            super(Messages.SyncRuleWorkingCopy_SAVE_SYNCRULE_JOB_NAME);
            this.fOverwrite = overwrite;
        }

        IStatus getStatus() {
            return this.fStatus == null ? Status.OK_STATUS : this.fStatus;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (SyncRuleWorkingCopy.this.fNoLicense) {
                return Status.OK_STATUS;
            }
            int tryCount = 0;
            int MAX_TRY_COUNT = this.fOverwrite ? 2 : 1;
            SyncRuleWorkingCopy.this.fLastError = null;
            while (tryCount++ < MAX_TRY_COUNT) {
                try {
                    boolean isNew = SyncRuleWorkingCopy.this.fSyncRule.isNewItem();
                    if (tryCount > 1) {
                        StringWriter writer = new StringWriter();
                        SyncRuleWorkingCopy.this.fSyncRule.exportDefinition((Writer)writer);
                        SyncRuleWorkingCopy.this.fSyncRule = (ISyncRule)SyncRuleWorkingCopy.this.fRepository.itemManager().fetchCompleteItem((IItemHandle)SyncRuleWorkingCopy.this.fSyncRule, 1, monitor);
                        SyncRuleWorkingCopy.this.fSyncRule = (ISyncRule)SyncRuleWorkingCopy.this.fSyncRule.getWorkingCopy();
                        StringReader reader = new StringReader(writer.toString());
                        SyncRuleWorkingCopy.this.fSyncRule.importDefinition((Reader)reader);
                    }
                    if (isNew && SyncRuleWorkingCopy.this.fProcessArea != null) {
                        SyncRuleWorkingCopy.this.fSyncRule.setProjectArea(SyncRuleWorkingCopy.this.fProcessArea.getProjectArea());
                    }
                    SyncRuleWorkingCopy.this.fSyncRule = SyncRuleWorkingCopy.this.adminClient().saveSyncRule(SyncRuleWorkingCopy.this.fSyncRule, monitor);
                    SyncRuleWorkingCopy.this.fSyncRule = (ISyncRule)SyncRuleWorkingCopy.this.fSyncRule.getWorkingCopy();
                    SyncRuleWorkingCopy.this.loadExternalRepositoryConnection(monitor);
                    return Status.OK_STATUS;
                }
                catch (StaleDataException isNew) {
                }
                catch (Exception e) {
                    SyncRuleWorkingCopy.this.fLastError = e;
                    this.fStatus = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                    return Status.OK_STATUS;
                }
            }
            this.fStatus = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)Messages.SyncRuleWorkingCopy_ERROR_STALE_DATA);
            return Status.OK_STATUS;
        }
    }
}

