/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.rcp.ui.internal;

import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.common.ISyncRuleHandle;
import com.ibm.team.interop.rcp.ui.InteropRcpUiPlugin;
import com.ibm.team.interop.rcp.ui.internal.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SyncRuleAssociateSelectionDialog
extends ElementListSelectionDialog {
    private final IProcessArea fProcessArea;
    private Job fFetchingJob;

    public SyncRuleAssociateSelectionDialog(Shell parent, ILabelProvider renderer, IProcessArea processArea) {
        super(parent, renderer);
        this.fProcessArea = processArea;
        this.setElements(new String[]{Messages.SyncRuleAssociateSelectionDialog_FETCHING_NOTIFICATION});
        this.setTitle(Messages.SyncRuleAssociateSelectionDialog_ASSOCIATE_DIALOG_TITLE);
        this.setMessage(Messages.SyncRuleAssociateSelectionDialog_ASSOCIATE_DIALOG_DESCRIPTION);
        this.setEmptyListMessage(Messages.SyncRuleAssociateSelectionDialog_ASSOCIATE_DIALOG_EMPTY_LIST_MESSAGE);
        this.setMultipleSelection(true);
        this.fFetchingJob = new Job(Messages.SyncRuleAssociateSelectionDialog_FETCHING_SYNCRULES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ITeamRepository repository = (ITeamRepository)SyncRuleAssociateSelectionDialog.this.fProcessArea.getOrigin();
                    IInteropManager interopManager = (IInteropManager)repository.getClientLibrary(IInteropManager.class);
                    ISyncRuleHandle[] syncRuleHandles = interopManager.getAllSyncRules(monitor);
                    IProjectAreaHandle projectAreaHandle = SyncRuleAssociateSelectionDialog.this.fProcessArea.getProjectArea();
                    ISyncRuleHandle[] associatedItemHandles = interopManager.findSyncRulesByProjectArea(projectAreaHandle, monitor);
                    HashSet<UUID> associatedUUIDs = new HashSet<UUID>(associatedItemHandles.length);
                    ISyncRuleHandle[] iSyncRuleHandleArray = associatedItemHandles;
                    int n = associatedItemHandles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISyncRuleHandle itemHandle = iSyncRuleHandleArray[n2];
                        associatedUUIDs.add(itemHandle.getItemId());
                        ++n2;
                    }
                    ArrayList<ISyncRuleHandle> syncRuleHandleList = new ArrayList<ISyncRuleHandle>();
                    ISyncRuleHandle[] iSyncRuleHandleArray2 = syncRuleHandles;
                    int n3 = syncRuleHandles.length;
                    n = 0;
                    while (n < n3) {
                        ISyncRuleHandle syncRuleHandle = iSyncRuleHandleArray2[n];
                        if (!associatedUUIDs.contains(syncRuleHandle.getItemId())) {
                            syncRuleHandleList.add(syncRuleHandle);
                        }
                        ++n;
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!SyncRuleAssociateSelectionDialog.this.getParentShell().isDisposed()) {
                        Object[] elements;
                        if (syncRuleHandleList.size() != 0) {
                            List syncRuleItems = repository.itemManager().fetchCompleteItems(syncRuleHandleList, 0, monitor);
                            elements = syncRuleItems.toArray();
                        } else {
                            elements = new Object[]{};
                        }
                        SyncRuleAssociateSelectionDialog.this.getParentShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SyncRuleAssociateSelectionDialog.this.setListElements(elements);
                            }
                        });
                    }
                }
                catch (TeamRepositoryException e) {
                    SyncRuleAssociateSelectionDialog.this.getParentShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SyncRuleAssociateSelectionDialog.this.setListElements(new String[]{Messages.SyncRuleAssociateSelectionDialog_ERROR_FETCHING_NOTIFICATION});
                        }
                    });
                    InteropRcpUiPlugin.getDefault().log(Messages.SyncRuleAssociateSelectionDialog_ERROR_FETCHING_SYNCRULE, e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.fFetchingJob.setSystem(false);
        this.fFetchingJob.schedule();
    }

    public boolean close() {
        this.fFetchingJob.cancel();
        return super.close();
    }
}

