/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.rcp.ui.internal;

import com.ibm.team.interop.client.admin.IItemConnectorAdminClient;
import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.interop.rcp.ui.internal.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.AbstractWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.SaveConflictException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExternalRepositoryConnectionWorkingCopy
extends AbstractWorkingCopy {
    private Job fRevertJob = new Job(Messages.ExternalRepositoryConnectionWorkingCopy_RELOADING_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            ExternalRepositoryConnectionWorkingCopy.this.doRevert(monitor);
            return Status.OK_STATUS;
        }
    };
    private Job fSaveJob = new Job(Messages.ExternalRepositoryConnectionWorkingCopy_SAVING_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            ExternalRepositoryConnectionWorkingCopy.this.doSave(monitor);
            return Status.OK_STATUS;
        }
    };
    private final ITeamRepository fRepository;
    private IExternalRepositoryConnection fExternalRepositoryConnection;
    private IProjectArea fProjectArea;
    private List<IProjectArea> fConnectedProjectAreas;
    private IStatus fStatus = Status.OK_STATUS;
    private boolean fNoLicense;
    private IItemConnectorAdminClient fAdminClient;
    private ILicenseClient fLicenseClient;

    public ExternalRepositoryConnectionWorkingCopy(IExternalRepositoryConnection externalRepositoryConnection, ITeamRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("repository cannot be null");
        }
        this.fRepository = repository;
        if (externalRepositoryConnection == null) {
            this.fExternalRepositoryConnection = InteropFactory.INSTANCE.creatExternalRepositoryConnection();
        } else if (externalRepositoryConnection.isWorkingCopy()) {
            this.fExternalRepositoryConnection = externalRepositoryConnection;
        } else {
            this.fExternalRepositoryConnection = (IExternalRepositoryConnection)externalRepositoryConnection.getWorkingCopy();
            this.fExternalRepositoryConnection.setUsername(externalRepositoryConnection.getUsername());
            this.fExternalRepositoryConnection.setPassword(externalRepositoryConnection.getPassword());
        }
    }

    public IExternalRepositoryConnection getExternalRepositoryConnection() {
        return this.fExternalRepositoryConnection;
    }

    public ITeamRepository getRepository() {
        return this.fRepository;
    }

    public IProjectArea getProjectArea() {
        this.waitForRevertJob();
        return this.fProjectArea;
    }

    public void updateProjectArea(IProjectArea projectArea) {
        this.fProjectArea = projectArea;
    }

    public List<IProjectArea> getConnectedProjectAreas() {
        this.waitForRevertJob();
        return this.fConnectedProjectAreas;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public boolean isLicensed() {
        return !this.fNoLicense;
    }

    public void dispose() {
    }

    public ImageDescriptor getImage() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public void revert(IProgressMonitor progress) {
        this.setValid(false);
        this.doRevert(progress);
    }

    public void save(IProgressMonitor progress) throws CoreException, SaveConflictException {
        if (this.fNoLicense) {
            return;
        }
        this.fSaveJob.setSystem(false);
        this.runJob(this.fSaveJob);
        if (!this.fStatus.isOK()) {
            throw new CoreException(this.fStatus);
        }
    }

    public void saveAndOverwrite(IProgressMonitor progress) throws CoreException {
    }

    private void doRevert(IProgressMonitor monitor) {
        if (this.fNoLicense) {
            this.setValid(true);
            return;
        }
        this.fProjectArea = null;
        this.fConnectedProjectAreas = Collections.emptyList();
        try {
            this.licenseClient().assertLicense("com.ibm.team.interop.server.saveSyncRule", monitor);
        }
        catch (LicenseNotGrantedException e) {
            this.fStatus = StatusUtil.newStatus((Object)((Object)this), (String)Messages.ExternalConnection_NOT_LICENSED, (Throwable)e);
            this.fNoLicense = true;
            this.setValid(true);
            return;
        }
        catch (Throwable e) {
            this.fStatus = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
            this.fNoLicense = true;
            this.setValid(true);
            return;
        }
        try {
            List handles;
            if (!this.fExternalRepositoryConnection.isNewItem()) {
                IExternalRepositoryConnection connection = this.adminClient().findExternalRepositoryConnection(this.fExternalRepositoryConnection.getName(), monitor);
                if (connection == null) {
                    this.fExternalRepositoryConnection = InteropFactory.INSTANCE.creatExternalRepositoryConnection();
                    this.setValid(true);
                    return;
                }
                this.fExternalRepositoryConnection = (IExternalRepositoryConnection)connection.getWorkingCopy();
                this.fExternalRepositoryConnection.setUsername(connection.getUsername());
                this.fExternalRepositoryConnection.setPassword(connection.getPassword());
            }
            if (this.fExternalRepositoryConnection.getProjectArea() != null) {
                this.fProjectArea = (IProjectArea)this.fRepository.itemManager().fetchCompleteItem((IItemHandle)this.fExternalRepositoryConnection.getProjectArea(), 0, monitor);
            }
            if ((handles = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.fRepository, false)).size() != 0) {
                this.fConnectedProjectAreas = this.fRepository.itemManager().fetchCompleteItems(handles, 0, monitor);
            }
            this.fStatus = Status.OK_STATUS;
        }
        catch (TeamRepositoryException e) {
            this.fStatus = StatusUtil.newStatus((Object)((Object)this), (String)Messages.ExternalRepositoryConnectionWorkingCopy_ERROR_RELOADING, (Throwable)e);
        }
        this.setValid(true);
    }

    private void doSave(IProgressMonitor monitor) {
        try {
            this.fExternalRepositoryConnection = this.adminClient().saveExternalRepositoryConnection(this.fExternalRepositoryConnection, monitor);
            this.fExternalRepositoryConnection = (IExternalRepositoryConnection)this.fExternalRepositoryConnection.getWorkingCopy();
            this.fStatus = Status.OK_STATUS;
        }
        catch (TeamRepositoryException e) {
            this.fStatus = StatusUtil.newStatus((Object)((Object)this), (String)Messages.ExternalRepositoryConnectionWorkingCopy_ERROR_SAVING, (Throwable)e);
        }
    }

    private void runJob(Job job) {
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void waitForRevertJob() {
        try {
            this.fRevertJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private IItemConnectorAdminClient adminClient() {
        if (this.fAdminClient == null) {
            this.fAdminClient = (IItemConnectorAdminClient)this.fRepository.getClientLibrary(IItemConnectorAdminClient.class);
        }
        return this.fAdminClient;
    }

    private ILicenseClient licenseClient() {
        if (this.fLicenseClient == null) {
            this.fLicenseClient = (ILicenseClient)this.fRepository.getClientLibrary(ILicenseClient.class);
        }
        return this.fLicenseClient;
    }
}

