/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.views;

import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.common.ISyncRuleHandle;
import com.ibm.team.interop.common.internal.query.BaseExternalProxyQueryModel;
import com.ibm.team.interop.ide.ui.internal.views.Messages;
import com.ibm.team.interop.ide.ui.internal.views.SyncStatusView;
import com.ibm.team.interop.rcp.ui.internal.ExternalProxyWorkingCopy;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IEnum;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SyncStatusContentProvider
implements IStructuredContentProvider {
    private final Job fQueryJob = new Job(Messages.SyncStatusContentProvider_STATUS_QUERY_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed() && !monitor.isCanceled()) {
                    SyncStatusContentProvider.this.fViewer.getControl().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                                SyncStatusContentProvider.this.fStatusView.updateStatus(Messages.SyncStatusContentProvider_QUERYING_DESCRIPTION);
                            }
                        }
                    });
                    SyncStatusContentProvider.this.queryForElements(monitor, SyncStatusContentProvider.this.fViewer.getControl().getDisplay());
                }
                if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed() && !monitor.isCanceled()) {
                    SyncStatusContentProvider.this.fViewer.getControl().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                                SyncStatusContentProvider.this.fViewer.refresh();
                                SyncStatusContentProvider.this.fStatusView.updateStatus();
                            }
                        }
                    });
                }
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                SyncStatusContentProvider.this.reportError(Messages.SyncStatusContentProvider_ERROR_QUERYING_SYNC_STATUS, e);
            }
            return Status.OK_STATUS;
        }
    };
    private final Job fUpdateLinksJob = new Job(Messages.SyncStatusContentProvider_FETCH_LINK_INFO_JOB_NAME){

        protected IStatus run(IProgressMonitor monitor) {
            if (SyncStatusContentProvider.this.fElements == null) {
                return null;
            }
            int count = SyncStatusContentProvider.this.fElements.size();
            final String queryStatus = SyncStatusContentProvider.this.getContentDescription();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)count);
            for (ExternalProxyWorkingCopy workingCopy : SyncStatusContentProvider.this.fElements) {
                if (monitor.isCanceled()) {
                    if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                        SyncStatusContentProvider.this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                                    SyncStatusContentProvider.this.fStatusView.updateStatus(NLS.bind((String)Messages.SyncStatusContentProvider_UPDATING_LINKS_CANCELED_DESCRIPTION, (Object)queryStatus, (Object[])new Object[0]));
                                }
                            }
                        });
                    }
                    return Status.CANCEL_STATUS;
                }
                if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                    final int countToGo = count;
                    SyncStatusContentProvider.this.fViewer.getControl().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                                SyncStatusContentProvider.this.fStatusView.updateStatus(NLS.bind((String)Messages.SyncStatusContentProvider_UPDATING_LINKS_DESCRIPTION, (Object)queryStatus, (Object[])new Object[]{Integer.toString(countToGo)}));
                            }
                        }
                    });
                }
                try {
                    workingCopy.revert(ExternalProxyWorkingCopy.RevertMode.LINKS, (IProgressMonitor)progress.newChild(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --count;
            }
            if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                SyncStatusContentProvider.this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                            SyncStatusContentProvider.this.fStatusView.updateStatus();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };
    private final IChangeListener fChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property != IWorkingCopy.PROP_VALID) {
                return;
            }
            final ExternalProxyWorkingCopy proxyWorkingCopy = (ExternalProxyWorkingCopy)source;
            if (!proxyWorkingCopy.isValid()) {
                return;
            }
            if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                SyncStatusContentProvider.this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SyncStatusContentProvider.this.fViewer.getControl().isDisposed()) {
                            if (proxyWorkingCopy.getExternalProxy().isNewItem()) {
                                proxyWorkingCopy.removeListener(SyncStatusContentProvider.this.fChangeListener);
                                SyncStatusContentProvider.this.fViewer.remove((Object)proxyWorkingCopy);
                                SyncStatusContentProvider.this.fElements.remove(proxyWorkingCopy);
                            } else {
                                SyncStatusContentProvider.this.fViewer.update((Object)proxyWorkingCopy, null);
                            }
                        }
                    }
                });
            }
        }
    };
    private final SyncStatusView fStatusView;
    private final TableViewer fViewer;
    private QueryInput fQueryInput;
    private List<ExternalProxyWorkingCopy> fElements;

    public SyncStatusContentProvider(SyncStatusView statusView, TableViewer viewer) {
        this.fStatusView = statusView;
        this.fViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        if (this.fElements == null) {
            return new Object[0];
        }
        return this.fElements.toArray();
    }

    public void dispose() {
        this.removeChangeListeners();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof QueryInput) {
            this.fQueryInput = (QueryInput)newInput;
            this.refresh();
        } else {
            this.disposeWorkingCopies();
            this.fQueryInput = null;
            this.fElements = null;
        }
    }

    public void refresh() {
        if (this.fQueryInput != null) {
            this.fQueryJob.setSystem(false);
            this.fQueryJob.schedule();
        }
    }

    public QueryInput getInput() {
        return this.fQueryInput;
    }

    public String getContentDescription() {
        if (this.fQueryInput == null) {
            return Messages.SyncStatusContentProvider_NO_RESULTS_DESCRIPTION;
        }
        String description = NLS.bind((String)Messages.SyncStatusContentProvider_NUM_RESULTS_DESCRIPTION, (Object)this.fQueryInput.getDescription(), (Object[])new Object[]{this.fElements == null ? "0" : Integer.toString(this.fElements.size())});
        return description;
    }

    private void queryForElements(IProgressMonitor monitor, Display display) throws TeamRepositoryException {
        IItemQueryPage page;
        int i;
        if (!this.fViewer.getControl().isDisposed()) {
            this.fViewer.getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SyncStatusContentProvider.this.disposeWorkingCopies();
                }
            });
        }
        this.fElements = null;
        ITeamRepository repository = this.fQueryInput.getRepository();
        List<ISyncRule> syncRules = null;
        int numSyncRuleArgs = 0;
        int numStatuses = 0;
        if (repository == null) {
            if (this.fQueryInput.getProcessArea() != null) {
                syncRules = this.getAssociatedSyncRules(this.fQueryInput.getProcessArea(), monitor);
                repository = this.teamRepository((IItemHandle)this.fQueryInput.getProcessArea());
            } else {
                syncRules = this.fQueryInput.getSyncRules();
            }
            if (syncRules != null && syncRules.size() != 0) {
                numSyncRuleArgs = syncRules.size();
                if (repository == null) {
                    repository = this.teamRepository((IItemHandle)syncRules.get(0));
                }
            }
        }
        if (repository == null) {
            return;
        }
        if (syncRules == null) {
            syncRules = this.getAllSyncRules(repository, monitor);
            numSyncRuleArgs = syncRules.size();
        }
        if (this.fQueryInput.getStatuses() != null) {
            numStatuses = this.fQueryInput.getStatuses().length;
        }
        IQueryService queryService = ((TeamRepository)repository).getQueryService();
        BaseExternalProxyQueryModel.ExternalProxyQueryModel qm = BaseExternalProxyQueryModel.ExternalProxyQueryModel.ROOT;
        IItemQuery q = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)qm);
        Object[] queryArgs = new Object[numSyncRuleArgs + numStatuses];
        IPredicate filter = null;
        if (numSyncRuleArgs != 0) {
            IItemHandleInputArg[] handleArgs = new IItemHandleInputArg[numSyncRuleArgs];
            i = 0;
            while (i < numSyncRuleArgs) {
                handleArgs[i] = q.newItemHandleArg();
                queryArgs[i] = syncRules.get(i);
                ++i;
            }
            filter = qm.syncRule()._in(handleArgs);
        } else {
            filter = qm.syncRule()._isNull()._not();
        }
        if (numStatuses != 0) {
            IPredicate statusFilter = null;
            i = 0;
            while (i < numStatuses) {
                statusFilter = i == 0 ? qm.lastSyncStatus()._eq((IEnum)q.newEnumArg()) : statusFilter._or(qm.lastSyncStatus()._eq((IEnum)q.newEnumArg()));
                queryArgs[i + numSyncRuleArgs] = new Integer(this.fQueryInput.getStatuses()[i].ordinal());
                ++i;
            }
            filter = filter == null ? statusFilter : filter._and(statusFilter);
        }
        if (filter != null) {
            q.filter(filter);
        }
        if ((page = queryService.queryItems(q, queryArgs, 100)).getResultSize() == 0) {
            return;
        }
        ArrayList proxies = new ArrayList(page.getResultSize());
        while (page != null) {
            List items = repository.itemManager().fetchCompleteItems(page.getItemHandles(), 1, monitor);
            proxies.addAll(items);
            if (!page.hasNext()) break;
            page = (IItemQueryPage)queryService.fetchPage(page.getToken(), page.getNextStartPosition(), page.getSize());
        }
        HashMap<UUID, ISyncRule> syncRulesByItemId = new HashMap<UUID, ISyncRule>();
        for (ISyncRule syncRule : syncRules) {
            syncRulesByItemId.put(syncRule.getItemId(), syncRule);
        }
        this.fElements = new ArrayList<ExternalProxyWorkingCopy>(page.getResultSize());
        for (IExternalProxy proxy : proxies) {
            ISyncRule syncRule = null;
            if (proxy.getSyncRuleHandle() != null) {
                syncRule = (ISyncRule)syncRulesByItemId.get(proxy.getSyncRuleHandle().getItemId());
            }
            this.fElements.add(new ExternalProxyWorkingCopy(repository, proxy, syncRule, display));
        }
        if (!this.fViewer.getControl().isDisposed()) {
            this.fViewer.getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SyncStatusContentProvider.this.addChangeListeners();
                }
            });
        }
        this.fUpdateLinksJob.setSystem(false);
        this.fUpdateLinksJob.schedule();
    }

    private void addChangeListeners() {
        if (this.fElements != null) {
            for (ExternalProxyWorkingCopy proxyWorkingCopy : this.fElements) {
                proxyWorkingCopy.addListener(this.fChangeListener);
            }
        }
    }

    private void removeChangeListeners() {
        if (this.fElements != null) {
            for (ExternalProxyWorkingCopy proxyWorkingCopy : this.fElements) {
                proxyWorkingCopy.removeListener(this.fChangeListener);
            }
        }
    }

    private void disposeWorkingCopies() {
        this.removeChangeListeners();
        if (this.fElements != null) {
            for (ExternalProxyWorkingCopy proxyWorkingCopy : this.fElements) {
                proxyWorkingCopy.dispose();
            }
        }
    }

    private List<ISyncRule> getAssociatedSyncRules(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ISyncRuleHandle[] itemHandles = this.interopManager((IItemHandle)processArea).findSyncRulesByProjectArea(processArea.getProjectArea(), monitor);
        if (itemHandles == null) {
            return new ArrayList<ISyncRule>();
        }
        List items = this.itemManager((IItemHandle)processArea).fetchCompleteItems(Arrays.asList(itemHandles), 0, monitor);
        return items;
    }

    private List<ISyncRule> getAllSyncRules(ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        ISyncRuleHandle[] itemHandles = this.interopManager(repository).getAllSyncRules(monitor);
        if (itemHandles == null) {
            return new ArrayList<ISyncRule>();
        }
        List items = repository.itemManager().fetchCompleteItems(Arrays.asList(itemHandles), 0, monitor);
        return items;
    }

    private void reportError(final String title, final Throwable e) {
        if (!this.fViewer.getControl().isDisposed()) {
            this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)SyncStatusContentProvider.this.fViewer.getControl().getShell(), (String)title, null, (IStatus)new Status(4, "com.ibm.team.interop.ide.ui", e.getLocalizedMessage(), e));
                }
            });
        }
    }

    private ITeamRepository teamRepository(IItemHandle itemHandle) {
        return (ITeamRepository)itemHandle.getOrigin();
    }

    private IItemManager itemManager(IItemHandle itemHandle) {
        return this.teamRepository(itemHandle).itemManager();
    }

    private IInteropManager interopManager(IItemHandle itemHandle) {
        return (IInteropManager)this.teamRepository(itemHandle).getClientLibrary(IInteropManager.class);
    }

    private IInteropManager interopManager(ITeamRepository repository) {
        return (IInteropManager)repository.getClientLibrary(IInteropManager.class);
    }

    public static class QueryInput {
        private final ITeamRepository fRepository;
        private final IProcessArea fProcessArea;
        private final List<ISyncRule> fSyncRules;
        private final IExternalProxy.SynchronizationStatus[] fStatuses;
        private final String fQueryName;
        private String fDescription;

        public QueryInput(ITeamRepository repository, IExternalProxy.SynchronizationStatus[] statuses, String queryName) {
            this.fRepository = repository;
            this.fProcessArea = null;
            this.fSyncRules = null;
            this.fStatuses = statuses;
            this.fQueryName = queryName;
        }

        public QueryInput(IProcessArea processArea, IExternalProxy.SynchronizationStatus[] statuses, String queryName) {
            this.fRepository = null;
            this.fProcessArea = processArea;
            this.fSyncRules = null;
            this.fStatuses = statuses;
            this.fQueryName = queryName;
        }

        public QueryInput(List<ISyncRule> syncRules, IExternalProxy.SynchronizationStatus[] statuses, String queryName) {
            this.fRepository = null;
            this.fProcessArea = null;
            this.fSyncRules = syncRules;
            this.fStatuses = statuses;
            this.fQueryName = queryName;
        }

        public ITeamRepository getRepository() {
            return this.fRepository;
        }

        public IProcessArea getProcessArea() {
            return this.fProcessArea;
        }

        public List<ISyncRule> getSyncRules() {
            return this.fSyncRules;
        }

        public IExternalProxy.SynchronizationStatus[] getStatuses() {
            return this.fStatuses;
        }

        public String getDescription() {
            if (this.fDescription == null) {
                String repositoryName = null;
                String processAreaName = null;
                if (this.fRepository != null) {
                    repositoryName = this.fRepository.getName() != null ? this.fRepository.getName() : this.fRepository.getRepositoryURI();
                } else if (this.fProcessArea != null) {
                    processAreaName = this.fProcessArea.getName();
                }
                this.fDescription = repositoryName != null ? String.format("%s [%s]", this.fQueryName, repositoryName) : (processAreaName != null ? NLS.bind((String)Messages.SyncStatusContentProvider_PROJECT_AREA_UNSYNCHRONIZED_QUERY_DESCRIPTION, (Object)this.fQueryName, (Object[])new Object[]{processAreaName}) : (this.fSyncRules != null && this.fSyncRules.size() != 0 ? NLS.bind((String)Messages.SyncStatusContentProvider_SYNCRULES_UNSYNCHRONIZED_QUERY_DESCRIPTION, (Object)this.fQueryName, (Object[])new Object[0]) : this.fQueryName));
            }
            return this.fDescription;
        }
    }
}

