/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.views;

import com.ibm.team.interop.ide.ui.internal.views.Messages;
import com.ibm.team.interop.rcp.ui.internal.ExternalProxyWorkingCopy;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ResyncMultipleItemsJob
extends Job {
    public static int DEFAULT_MAX_IN_PARALLEL = 5;
    public static String PARALLEL_RESYNC = "com.ibm.team.interop.ide.ui.parallel.resynch";
    private int fMaxParallelJobs = DEFAULT_MAX_IN_PARALLEL;
    private List<ExternalProxyWorkingCopy> fWorkingCopies;
    private int fCount;
    private IProgressMonitor fProgressGroup;

    public ResyncMultipleItemsJob(List<ExternalProxyWorkingCopy> aList) {
        super(Messages.ResyncMultipleItemsJob_MULTIPLE_RESYNCHRONIZATION);
        this.workingCopies(aList);
    }

    public int count() {
        return this.fCount;
    }

    private void incr(int i) {
        this.fCount += i;
    }

    private void workingCopies(List<ExternalProxyWorkingCopy> aList) {
        this.fWorkingCopies = aList;
    }

    private List<ExternalProxyWorkingCopy> workingCopies() {
        return this.fWorkingCopies;
    }

    private int maxParallelJobs() {
        String aValue = System.getProperty(PARALLEL_RESYNC);
        if (aValue != null) {
            this.fMaxParallelJobs = Math.max(1, Integer.valueOf(aValue));
        }
        return this.fMaxParallelJobs;
    }

    public void maxParallelJobs(int n) {
        this.fMaxParallelJobs = n;
    }

    private IProgressMonitor progressGroup() {
        if (this.fProgressGroup == null) {
            this.fProgressGroup = Job.getJobManager().createProgressGroup();
        }
        return this.fProgressGroup;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.setProgressGroup(this.progressGroup(), this.workingCopies().size());
        this.progressGroup().beginTask(Messages.ResyncMultipleItemsJob_RESYNCHRONIZING, this.workingCopies().size());
        try {
            monitor.beginTask(NLS.bind((String)Messages.ResyncMultipleItemsJob_RESYNCING_N_ITEMS, (Object)this.workingCopies().size(), (Object[])new Object[]{this.maxParallelJobs()}), this.workingCopies().size());
            NWayIterator<ExternalProxyWorkingCopy> it = new NWayIterator<ExternalProxyWorkingCopy>(ExternalProxyWorkingCopy.class, this.workingCopies(), this.maxParallelJobs());
            while (it.hasNext()) {
                ExternalProxyWorkingCopy[] a = it.next();
                this.createAndJoinSyncJobs(a);
                this.progressGroup().worked(a.length);
                monitor.worked(a.length);
                if (!monitor.isCanceled() && !this.progressGroup().isCanceled()) continue;
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            this.progressGroup().done();
        }
        return Status.OK_STATUS;
    }

    private void createAndJoinSyncJobs(ExternalProxyWorkingCopy[] workingCopies) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        int i = 0;
        while (i < workingCopies.length) {
            ExternalProxyWorkingCopy each = workingCopies[i];
            Job aJob = each.synchronizeBothDirections();
            aJob.setProgressGroup(this.progressGroup(), 1);
            jobs.add(aJob);
            this.incr(1);
            ++i;
        }
        for (Job each : jobs) {
            try {
                each.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class NWayIterator<E> {
        private int fWidth = 1;
        private Iterator<E> fBaseIterator;
        private Class<E> fTargetClass;

        public NWayIterator(Class<E> aClass, Collection<E> aCollection, int w) {
            this.targetClass(aClass);
            this.width(w);
            this.baseIterator(aCollection.iterator());
        }

        private Class<E> targetClass() {
            return this.fTargetClass;
        }

        private void targetClass(Class<E> aClass) {
            this.fTargetClass = aClass;
        }

        private void baseIterator(Iterator<E> it) {
            this.fBaseIterator = it;
        }

        private Iterator<E> baseIterator() {
            return this.fBaseIterator;
        }

        private void width(int i) {
            this.fWidth = i;
        }

        private int width() {
            return this.fWidth;
        }

        public boolean hasNext() {
            return this.baseIterator().hasNext();
        }

        public E[] next() {
            int n = 0;
            Object[] a = (Object[])Array.newInstance(this.targetClass(), this.width());
            while (n < this.width()) {
                if (this.hasNext()) {
                    a[n++] = this.baseIterator().next();
                    continue;
                }
                return Arrays.copyOf(a, n);
            }
            return a;
        }
    }
}

