/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.views;

import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.ExportSyncRulesDialog;
import com.ibm.team.interop.ide.ui.internal.ExternalRepositoryConnectionDialog;
import com.ibm.team.interop.ide.ui.internal.ExternalRepositoryConnectionWizard;
import com.ibm.team.interop.ide.ui.internal.ImportSyncRulesDialog;
import com.ibm.team.interop.ide.ui.internal.NewSyncRuleAction;
import com.ibm.team.interop.ide.ui.internal.views.InteropExplorerContentProvider;
import com.ibm.team.interop.ide.ui.internal.views.Messages;
import com.ibm.team.interop.ide.ui.internal.views.OutgoingSyncOptionsDialog;
import com.ibm.team.interop.ide.ui.internal.views.SyncStatusContentProvider;
import com.ibm.team.interop.ide.ui.internal.views.SyncStatusView;
import com.ibm.team.interop.rcp.ui.internal.ExternalRepositoryConnectionWorkingCopy;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.utils.ItemHandleComparer;
import com.ibm.team.repository.rcp.ui.workingcopy.SaveConflictException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class InteropExplorerView
extends ViewPart {
    private static final String OPEN_EXTERNAL_REPOSITORY_CONNECTION_ACTION_ID = "com.ibm.team.interop.ide.ui.openExternalRepositoryConnection";
    private static final String OPEN_SYNCRULE_ACTION_ID = "com.ibm.team.interop.ide.ui.openSyncRule";
    private static final int CONFIRM_UNCONFIRMED = -1;
    private static final int CONFIRM_YES = 0;
    private static final int CONFIRM_YES_TO_ALL = 1;
    private static final int CONFIRM_NO = 2;
    private static final int CONFIRM_NO_TO_ALL = 3;
    private static final int CONFIRM_CANCEL = 4;
    private static String[] fgConfirmMultipleButtons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
    private static final IExternalProxy.SynchronizationStatus[] UNSYNCHRONIZED_STATUS = new IExternalProxy.SynchronizationStatus[]{IExternalProxy.SynchronizationStatus.CONFLICT, IExternalProxy.SynchronizationStatus.CYCLE, IExternalProxy.SynchronizationStatus.INCOMING_ERROR, IExternalProxy.SynchronizationStatus.OUTGOING_ERROR, IExternalProxy.SynchronizationStatus.PENDING, IExternalProxy.SynchronizationStatus.UNINITIALIZED};
    private TreeViewer fTreeViewer;
    private InteropExplorerContentProvider fContentProvider;
    private final DoubleClickListener fDoubleClickListener = new DoubleClickListener();
    private final ProjectAreaListener fProjectAreaListener = new ProjectAreaListener();
    private final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

    public void createPartControl(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent, 770);
        this.fTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ExplorerLabelProvider(this.fStandardLabelProvider));
        this.fContentProvider = new InteropExplorerContentProvider(this.fTreeViewer);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setComparator((ViewerComparator)new ExplorerViewerComparator());
        this.fTreeViewer.setComparer((IElementComparer)new ItemHandleComparer());
        this.fTreeViewer.setInput(new Object());
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.createContextMenu();
        this.createActionMenu();
        this.hookListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.interop.ide.ui.syncRulesView");
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    public void dispose() {
        this.unhookListeners();
        this.fStandardLabelProvider.dispose();
        super.dispose();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopUpMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                List syncRules;
                List processAreas;
                List externalConnections;
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
                if (InteropExplorerView.this.isExternalRepositoryConnectionsRootSelected()) {
                    IMenuManager newMenu = manager.findMenuUsingPath("jazz.new");
                    newMenu.appendToGroup("group1", (IAction)new CreateExternalRepositoryConnectionAction());
                    manager.appendToGroup("jazz.refactoring.group", (IAction)new RefreshAction());
                }
                if ((externalConnections = InteropExplorerView.this.getSelectedExternalRepositoryConnections()).size() > 0) {
                    if (externalConnections.size() == 1) {
                        manager.appendToGroup("jazz.open.group", (IAction)new OpenExternalRepositoryConnectionAction());
                    }
                    manager.appendToGroup("jazz.refactoring.group", (IAction)new RefreshAction());
                    manager.appendToGroup("jazz.refactoring.group", (IAction)new DeleteExternalRepositoryConnectionsAction());
                }
                if ((processAreas = InteropExplorerView.this.getSelectedProcessAreas()).size() == 1) {
                    IMenuManager newMenu = manager.findMenuUsingPath("jazz.new");
                    newMenu.appendToGroup("group1", (IAction)new NewSyncRuleAction((IProcessArea)processAreas.get(0)));
                    manager.appendToGroup("jazz.new.group", (IAction)new ImportSyncRulesAction());
                    manager.appendToGroup("jazz.navigate.group", (IAction)new ShowAllUnsyncedAction());
                    manager.appendToGroup("jazz.navigate.group", (IAction)new ShowProcessAreaUnsyncedAction());
                }
                if ((syncRules = InteropExplorerView.this.getSelectedSyncRules()).size() != 0) {
                    if (processAreas.size() != 1) {
                        manager.appendToGroup("jazz.navigate.group", (IAction)new ShowSyncRulesUnsyncedAction());
                    }
                    manager.appendToGroup("jazz.refactoring.group", (IAction)new ExportSyncRulesAction());
                }
                if (syncRules.size() == 1) {
                    manager.appendToGroup("jazz.open.group", (IAction)new OpenSyncRuleAction());
                    manager.appendToGroup("jazz.navigate.group", (IAction)new OutgoingSyncAction());
                    manager.appendToGroup("jazz.refactoring.group", (IAction)new DeleteSyncRuleAction());
                }
                if (processAreas.size() != 0 || syncRules.size() != 0) {
                    manager.appendToGroup("jazz.refactoring.group", (IAction)new RefreshAction());
                }
            }
        });
        final Menu menu = menuMgr.createContextMenu(this.fTreeViewer.getControl());
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                IStructuredSelection selection = (IStructuredSelection)InteropExplorerView.this.getSite().getSelectionProvider().getSelection();
                if (selection.getFirstElement() instanceof IExternalRepositoryConnection) {
                    menu.setDefaultItem(InteropExplorerView.this.findItemForAction(menu, InteropExplorerView.OPEN_EXTERNAL_REPOSITORY_CONNECTION_ACTION_ID));
                } else if (selection.getFirstElement() instanceof ISyncRule) {
                    menu.setDefaultItem(InteropExplorerView.this.findItemForAction(menu, InteropExplorerView.OPEN_SYNCRULE_ACTION_ID));
                }
            }
        });
        this.fTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    private MenuItem findItemForAction(Menu menu, String id) {
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            ActionContributionItem ci;
            MenuItem item = items[i];
            if (item.getData() instanceof ActionContributionItem && id.equals((ci = (ActionContributionItem)item.getData()).getId())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void createActionMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)new ShowArchivedAction());
    }

    private void hookListeners() {
        this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this.fDoubleClickListener);
        ConnectedProjectAreaRegistry.getDefault().addListener((IConnectedProjectAreaRegistryListener)this.fProjectAreaListener);
    }

    private void unhookListeners() {
        this.fTreeViewer.removeDoubleClickListener((IDoubleClickListener)this.fDoubleClickListener);
        ConnectedProjectAreaRegistry.getDefault().removeListener((IConnectedProjectAreaRegistryListener)this.fProjectAreaListener);
    }

    private List<IProcessArea> getSelectedProcessAreas() {
        ArrayList<IProcessArea> processAreas = new ArrayList<IProcessArea>();
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object selected : ss) {
                if (!(selected instanceof IProcessArea)) continue;
                processAreas.add((IProcessArea)selected);
            }
        }
        return processAreas;
    }

    private List<ISyncRule> getSelectedSyncRules() {
        ArrayList<ISyncRule> syncRules = new ArrayList<ISyncRule>();
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object selected : ss) {
                if (!(selected instanceof ISyncRule)) continue;
                syncRules.add((ISyncRule)selected);
            }
        }
        return syncRules;
    }

    private List<IExternalRepositoryConnection> getSelectedExternalRepositoryConnections() {
        ArrayList<IExternalRepositoryConnection> connections = new ArrayList<IExternalRepositoryConnection>();
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object selected : ss) {
                if (!(selected instanceof IExternalRepositoryConnection)) continue;
                connections.add((IExternalRepositoryConnection)selected);
            }
        }
        return connections;
    }

    private boolean isExternalRepositoryConnectionsRootSelected() {
        IStructuredSelection ss;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        return selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && this.fContentProvider.isExternalRepositoryConnectionsRoot(ss.getFirstElement());
    }

    private List getSelectedElements() {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return ss.toList();
        }
        return Collections.EMPTY_LIST;
    }

    private void openSyncRule() {
        List<ISyncRule> syncRules = this.getSelectedSyncRules();
        if (syncRules.size() == 1) {
            OpenAction.openObject((Object)syncRules.get(0), (Shell)this.getSite().getShell(), (IWorkbenchPage)this.getSite().getPage());
        }
    }

    private void createExternalRepositoryConnection() {
        ArrayList<ITeamRepository> repositories = new ArrayList<ITeamRepository>();
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            if (repo.loggedIn()) {
                repositories.add(repo);
            }
            ++n2;
        }
        if (repositories.size() == 0) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.InteropExplorerView_NOT_LOGGED_IN_ERROR_TITLE, (String)Messages.InteropExplorerView_NOT_LOGGED_IN_ERROR_MESSAGE);
            return;
        }
        this.runExternalRepositoryConnectionWizard(Messages.InteropExplorerView_CREATE_EXTERNAL_REPOSITORY_CONNECTION_WIZARD_TITLE, true, repositories, null);
    }

    private void openExternalRepositoryConnection() {
        List<IExternalRepositoryConnection> connections = this.getSelectedExternalRepositoryConnections();
        if (connections.size() == 1) {
            IExternalRepositoryConnection connection = connections.get(0);
            ITeamRepository repository = (ITeamRepository)connection.getOrigin();
            ExternalRepositoryConnectionWorkingCopy workingCopy = new ExternalRepositoryConnectionWorkingCopy(connection, repository);
            this.editExternalRepositoryConnection(workingCopy);
        }
    }

    private void editExternalRepositoryConnection(ExternalRepositoryConnectionWorkingCopy workingCopy) {
        ExternalRepositoryConnectionDialog dialog = new ExternalRepositoryConnectionDialog(this.getSite().getShell(), workingCopy, this.fResourceManager);
        if (dialog.open() == 0) {
            try {
                workingCopy.save(null);
                this.fContentProvider.refresh(Collections.singletonList(this.fContentProvider.getExternalRepositoryConnectionsRoot()));
            }
            catch (CoreException e) {
                if (e.getStatus() == null || !(e.getStatus().getException() instanceof TeamOperationCanceledException)) {
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.InteropExplorerView_SAVE_ERROR_DIALOG_TITLE, (String)Messages.InteropExplorerView_ERROR_SAVING__EXTERNAL_REPOSITORY_CONNECTION, (IStatus)StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                }
            }
            catch (SaveConflictException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.InteropExplorerView_SAVE_ERROR_DIALOG_TITLE, (String)Messages.InteropExplorerView_ERROR_EXTERNAL_REPOSITORY_STALE_DATA);
            }
        }
    }

    private void deleteExternalRepositoryConnections() {
        List<IExternalRepositoryConnection> externalConnections = this.getSelectedExternalRepositoryConnections();
        for (IExternalRepositoryConnection externalConnection : externalConnections) {
            this.fContentProvider.deleteExternalRepositoryConnection(externalConnection);
        }
    }

    private boolean runExternalRepositoryConnectionWizard(String title, boolean createOnly, List<ITeamRepository> repositories, List<IExternalRepositoryConnection> result) {
        ExternalRepositoryConnectionWizard wizard = new ExternalRepositoryConnectionWizard(createOnly, repositories, title);
        WizardDialog wizardDialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
        wizardDialog.create();
        wizardDialog.getShell().pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "com.ibm.team.interop.ide.ui.externalRepositoryConnectionWizard");
        if (wizardDialog.open() != 0) {
            return false;
        }
        IExternalRepositoryConnection externalConnection = wizard.getSelectedConnection();
        if (externalConnection != null) {
            if (result != null) {
                result.add(externalConnection);
            }
            this.fContentProvider.refresh(Collections.singletonList(this.fContentProvider.getExternalRepositoryConnectionsRoot()));
        }
        return true;
    }

    private void refreshSelection() {
        List elements = this.getSelectedElements();
        if (elements.size() != 0) {
            this.fContentProvider.refresh(elements);
        }
    }

    private void showSyncStatus(IExternalProxy.SynchronizationStatus[] statuses, boolean all, String queryName) {
        ITeamRepository repository = null;
        List<IProcessArea> processAreas = this.getSelectedProcessAreas();
        List<ISyncRule> syncRules = null;
        if (processAreas.size() == 1) {
            repository = (ITeamRepository)processAreas.get(0).getOrigin();
        } else {
            syncRules = this.getSelectedSyncRules();
            if (syncRules.size() != 0) {
                repository = (ITeamRepository)syncRules.get(0).getOrigin();
            }
        }
        SyncStatusContentProvider.QueryInput query = null;
        if (all && repository != null) {
            query = new SyncStatusContentProvider.QueryInput(repository, statuses, queryName);
        } else if (processAreas.size() != 0) {
            query = new SyncStatusContentProvider.QueryInput(processAreas.get(0), statuses, queryName);
        } else if (syncRules.size() != 0) {
            query = new SyncStatusContentProvider.QueryInput(syncRules, statuses, queryName);
        }
        try {
            IViewPart view = this.getSite().getPage().showView("com.ibm.team.interop.syncStatusView");
            if (view != null && query != null) {
                ((SyncStatusView)view).showSyncStatus(query);
            }
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.InteropExplorerView_ERROR_CREATING_VIEW, null, (IStatus)e.getStatus());
        }
    }

    private void deleteSyncRule() {
        List<ISyncRule> syncRules = this.getSelectedSyncRules();
        if (syncRules.size() == 1) {
            this.fContentProvider.deleteSyncRule(syncRules.get(0));
        }
    }

    private void importSyncRules() {
        ImportSyncRulesDialog dialog;
        List<File> files;
        List<IProcessArea> processAreas = this.getSelectedProcessAreas();
        if (processAreas.size() != 1) {
            return;
        }
        IProcessArea processArea = processAreas.get(0);
        ITeamRepository repository = (ITeamRepository)processArea.getOrigin();
        ArrayList<IExternalRepositoryConnection> result = new ArrayList<IExternalRepositoryConnection>();
        if (!this.runExternalRepositoryConnectionWizard(Messages.InteropExplorerView_IMPORT_SYNCRULES_WIZARD_TITLE, false, Collections.singletonList(repository), result)) {
            return;
        }
        IExternalRepositoryConnection externalConnection = null;
        if (result.size() > 0) {
            externalConnection = (IExternalRepositoryConnection)result.get(0);
        }
        if ((files = (dialog = new ImportSyncRulesDialog(this.getSite().getShell(), true)).open()) == null || files.size() == 0) {
            return;
        }
        this.fContentProvider.importSyncRules(processArea, externalConnection, files);
    }

    private void exportSyncRules() {
        List<ISyncRule> syncRules = this.getSelectedSyncRules();
        if (syncRules.size() == 0) {
            return;
        }
        if (syncRules.size() == 1) {
            ISyncRule syncRule = syncRules.get(0);
            String defaultFileName = String.valueOf(syncRule.getName()) + ".xml";
            ExportSyncRulesDialog dialog = new ExportSyncRulesDialog(this.getSite().getShell(), defaultFileName);
            File file = dialog.open();
            if (file == null) {
                return;
            }
            this.fContentProvider.exportSyncRule(syncRule, file, false);
        } else if (syncRules.size() > 1) {
            ExportSyncRulesDialog dialog = new ExportSyncRulesDialog(this.getSite().getShell(), null);
            File directory = dialog.open();
            if (directory == null) {
                return;
            }
            int confirm = -1;
            for (ISyncRule syncRule : syncRules) {
                File file = new File(directory, String.valueOf(syncRule.getName()) + ".xml");
                if (confirm != 1 && file.exists()) {
                    if (confirm != 3) {
                        confirm = this.confirmMultiple(Messages.InteropExplorerView_CONFIRM_FILE_OVERWRITE_TITLE, NLS.bind((String)Messages.InteropExplorerView_CONFIRM_FILE_OVERWRITE_PROMPT, (Object)file.getName(), (Object[])new Object[]{file.getParent()}));
                    }
                    if (confirm == 4) {
                        return;
                    }
                    if (confirm == 2 || confirm == 3) continue;
                }
                this.fContentProvider.exportSyncRule(syncRule, file, true);
            }
        }
    }

    private void synchronizeOut() {
        List<ISyncRule> syncRules = this.getSelectedSyncRules();
        if (syncRules.size() != 1) {
            return;
        }
        OutgoingSyncOptionsDialog dialog = new OutgoingSyncOptionsDialog(this.getSite().getShell());
        if (dialog.open() == 0) {
            this.fContentProvider.synchronizeOut(syncRules.get(0), dialog.getOption());
        }
    }

    private int confirmMultiple(String title, String message) {
        MessageDialog dialog = new MessageDialog(this.fTreeViewer.getControl().getShell(), title, null, message, 3, fgConfirmMultipleButtons, 0);
        int response = dialog.open();
        if (response == -1) {
            return 4;
        }
        return response;
    }

    private class CreateExternalRepositoryConnectionAction
    extends Action {
        public CreateExternalRepositoryConnectionAction() {
            super(Messages.InteropExplorerView_CREATE_EXTERNAL_REPOSITORY_CONNECTION_ACTION_NAME);
        }

        public void run() {
            InteropExplorerView.this.createExternalRepositoryConnection();
        }
    }

    private class DeleteExternalRepositoryConnectionsAction
    extends Action {
        public DeleteExternalRepositoryConnectionsAction() {
            super(Messages.InteropExplorerView_DELETE_ACTION_NAME);
        }

        public void run() {
            if (!MessageDialog.openConfirm((Shell)InteropExplorerView.this.getSite().getShell(), (String)Messages.InteropExplorerView_CONFIRM_DELETE_EXTERNAL_REPOSITORY_CONNECTIONS_TITLE, (String)Messages.InteropExplorerView_CONFIRM_DELETE_EXTERNAL_REPOSITORY_CONNECTIONS_PROMPT)) {
                return;
            }
            InteropExplorerView.this.deleteExternalRepositoryConnections();
        }
    }

    private class DeleteSyncRuleAction
    extends Action {
        public DeleteSyncRuleAction() {
            super(Messages.InteropExplorerView_DELETE_ACTION_NAME);
        }

        public void run() {
            if (!MessageDialog.openConfirm((Shell)InteropExplorerView.this.getSite().getShell(), (String)Messages.InteropExplorerView_CONFIRM_DELETE_SYNCRULE_TITLE, (String)Messages.InteropExplorerView_COMFIRM_DELETE_SYNCRULE_PROMPT)) {
                return;
            }
            InteropExplorerView.this.deleteSyncRule();
        }
    }

    private class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() != 1) {
                    return;
                }
                Object element = selection.getFirstElement();
                if (InteropExplorerView.this.fContentProvider.isExternalRepositoryConnectionsRoot(element) || element instanceof IProjectArea) {
                    boolean expanded = InteropExplorerView.this.fTreeViewer.getExpandedState(element);
                    InteropExplorerView.this.fTreeViewer.setExpandedState(element, !expanded);
                } else if (element instanceof ISyncRule) {
                    InteropExplorerView.this.openSyncRule();
                } else if (element instanceof IExternalRepositoryConnection) {
                    InteropExplorerView.this.openExternalRepositoryConnection();
                }
            }
        }
    }

    private class ExplorerLabelProvider
    extends LabelProvider {
        private final StandardLabelProvider fStandardLabelProvider;

        public ExplorerLabelProvider(StandardLabelProvider standardLabelProvider) {
            this.fStandardLabelProvider = standardLabelProvider;
        }

        public Image getImage(Object element) {
            if (InteropExplorerView.this.fContentProvider.isExternalRepositoryConnectionsRoot(element)) {
                return InteropExplorerView.this.fResourceManager.createImage(InteropIdeUIPlugin.EXTERNAL_REPOS_IMAGE_DESCRIPTOR);
            }
            return this.fStandardLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (InteropExplorerView.this.fContentProvider.isExternalRepositoryConnectionsRoot(element)) {
                return Messages.InteropExplorerView_EXTERNAL_REPOSITORY_CONNECTIONS_LABEL;
            }
            return this.fStandardLabelProvider.getText(element);
        }
    }

    private class ExplorerViewerComparator
    extends ViewerComparator {
        private ExplorerViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 == e2) {
                return 0;
            }
            if (InteropExplorerView.this.fContentProvider.isExternalRepositoryConnectionsRoot(e1)) {
                return -1;
            }
            if (InteropExplorerView.this.fContentProvider.isExternalRepositoryConnectionsRoot(e2)) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class ExportSyncRulesAction
    extends Action {
        public ExportSyncRulesAction() {
            super(Messages.InteropExplorerView_EXPORT_SYNCRULES_ACTION_NAME);
        }

        public void run() {
            InteropExplorerView.this.exportSyncRules();
        }
    }

    private class ImportSyncRulesAction
    extends Action {
        public ImportSyncRulesAction() {
            super(Messages.InteropExplorerView_IMPORT_SYNCRULES_ACTION_NAME);
        }

        public void run() {
            InteropExplorerView.this.importSyncRules();
        }
    }

    private class OpenExternalRepositoryConnectionAction
    extends Action {
        public OpenExternalRepositoryConnectionAction() {
            super(Messages.InteropExplorerView_OPEN_ACTION_NAME);
            this.setId(InteropExplorerView.OPEN_EXTERNAL_REPOSITORY_CONNECTION_ACTION_ID);
        }

        public void run() {
            InteropExplorerView.this.openExternalRepositoryConnection();
        }
    }

    private class OpenSyncRuleAction
    extends Action {
        public OpenSyncRuleAction() {
            super(Messages.InteropExplorerView_OPEN_ACTION_NAME);
            this.setId(InteropExplorerView.OPEN_SYNCRULE_ACTION_ID);
        }

        public void run() {
            InteropExplorerView.this.openSyncRule();
        }
    }

    private class OutgoingSyncAction
    extends Action {
        public OutgoingSyncAction() {
            super(Messages.InteropExplorerView_SYNC_OUT_ACTION_NAME);
        }

        public void run() {
            InteropExplorerView.this.synchronizeOut();
        }
    }

    private class ProjectAreaListener
    implements IConnectedProjectAreaRegistryListener {
        private ProjectAreaListener() {
        }

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            if (InteropExplorerView.this.fContentProvider == null) {
                return;
            }
            switch (changeEvent.getType()) {
                case 3: {
                    InteropExplorerView.this.fContentProvider.updateProcessArea((IProcessAreaHandle)changeEvent.getProjectAreaHandle());
                    break;
                }
                case 0: {
                    InteropExplorerView.this.fContentProvider.updateAll();
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    if (changeEvent.getAddedProjectArea() != null) {
                        InteropExplorerView.this.fContentProvider.addProcessArea((IProcessAreaHandle)changeEvent.getAddedProjectArea());
                        break;
                    }
                    if (changeEvent.getRemovedProjectArea() == null) break;
                    InteropExplorerView.this.fContentProvider.removeProcessArea((IProcessAreaHandle)changeEvent.getRemovedProjectArea());
                }
            }
        }
    }

    private class RefreshAction
    extends Action {
        public RefreshAction() {
            super(Messages.InteropExplorerView_REFRESH_ACTION_NAME);
        }

        public void run() {
            InteropExplorerView.this.refreshSelection();
        }
    }

    private class ShowAllUnsyncedAction
    extends Action {
        public ShowAllUnsyncedAction() {
            super(Messages.InteropExplorerView_SHOW_ALL_UNSYNCED_ACTION_NAME);
        }

        public void run() {
            InteropExplorerView.this.showSyncStatus(UNSYNCHRONIZED_STATUS, true, Messages.InteropExplorerView_ALL_UNSYNCED_QUERY_NAME);
        }
    }

    private class ShowArchivedAction
    extends Action {
        private boolean fShowArchived;

        public ShowArchivedAction() {
            super(Messages.InteropExplorerView_SHOW_ARCHIVED_ACTION_NAME);
            this.fShowArchived = InteropIdeUIPlugin.getDefault().getPreferenceStore().getBoolean("syncRulesView.showArchivedProjectAreas");
            this.setChecked(this.fShowArchived);
        }

        public void run() {
            this.fShowArchived = !this.fShowArchived;
            InteropIdeUIPlugin.getDefault().getPreferenceStore().setValue("syncRulesView.showArchivedProjectAreas", this.fShowArchived);
            this.setChecked(this.fShowArchived);
        }
    }

    private class ShowProcessAreaUnsyncedAction
    extends Action {
        public ShowProcessAreaUnsyncedAction() {
            super(Messages.InteropExplorerView_SHOW_UNSYNCED_ACTION_NAME);
        }

        public void run() {
            InteropExplorerView.this.showSyncStatus(UNSYNCHRONIZED_STATUS, false, Messages.InteropExplorerView_UNSYNCED_QUERY_NAME);
        }
    }

    private class ShowSyncRulesUnsyncedAction
    extends Action {
        public ShowSyncRulesUnsyncedAction() {
            super(Messages.InteropExplorerView_UNSYNCED_SYNCRULES_ACTION_NAME);
        }

        public void run() {
            InteropExplorerView.this.showSyncStatus(UNSYNCHRONIZED_STATUS, false, Messages.InteropExplorerView_UNSYNCED_SYNCRULES_QUERY_NAME);
        }
    }
}

