/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.views;

import com.ibm.team.interop.client.IInteropManager;
import com.ibm.team.interop.client.admin.IItemConnectorAdminClient;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.common.IExternalRepositoryConnectionHandle;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.common.ISyncRuleHandle;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.views.Messages;
import com.ibm.team.interop.ide.ui.internal.views.OutgoingSyncOptionsDialog;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class InteropExplorerContentProvider
implements ITreeContentProvider,
IDeferredWorkbenchAdapter {
    private final ISharedItemChangeListener fAssociatedItemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(final List events) {
            Job job = new Job(Messages.InteropExplorerContentProvider_UPDATE_SYNCRULES_JOB_NAME){

                protected IStatus run(IProgressMonitor monitor) {
                    for (Object object : events) {
                        ISharedItemChangeEvent event = (ISharedItemChangeEvent)object;
                        IItem item = event.getSharedItem();
                        if (!(item instanceof ISyncRule)) continue;
                        ISyncRule syncRule = (ISyncRule)item;
                        IProjectAreaHandle processAreaHandle = null;
                        if (event.getAfterState() != null) {
                            processAreaHandle = syncRule.getProjectArea();
                        }
                        if (processAreaHandle == null) {
                            if (event.getBeforeState() == null) continue;
                            processAreaHandle = ((ISyncRule)event.getBeforeState()).getProjectArea();
                            InteropExplorerContentProvider.this.removeAssociatedSyncRule(syncRule, (IProcessAreaHandle)processAreaHandle);
                            continue;
                        }
                        InteropExplorerContentProvider.this.updateAssociatedSyncRule(syncRule, (IProcessAreaHandle)processAreaHandle);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    };
    private final ITeamRepositoryService.IRepositoryServiceListener fRepositoryServiceListener = new ITeamRepositoryService.IRepositoryServiceListener(){

        public void addedRepository(ITeamRepository repository) {
            InteropExplorerContentProvider.this.refresh(Collections.singletonList(InteropExplorerContentProvider.this.fExternalRepositoryConnectionsRoot));
        }

        public void removedRepository(ITeamRepository repository) {
            InteropExplorerContentProvider.this.refresh(Collections.singletonList(InteropExplorerContentProvider.this.fExternalRepositoryConnectionsRoot));
        }
    };
    private final IPropertyChangeListener fPreferencePropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("syncRulesView.showArchivedProjectAreas")) {
                InteropExplorerContentProvider.this.fShowArchived = Boolean.parseBoolean(event.getNewValue().toString());
                if (!InteropExplorerContentProvider.this.fTreeViewer.getControl().isDisposed()) {
                    InteropExplorerContentProvider.this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            InteropExplorerContentProvider.this.fTreeViewer.refresh();
                        }
                    });
                }
            }
        }
    };
    private static Charset UTF8 = Charset.forName("UTF-8");
    private final Set<ITeamRepository> fHookedRepositories = new HashSet<ITeamRepository>();
    private final DeferredTreeContentManager fContentManager;
    private final TreeViewer fTreeViewer;
    private final Object fExternalRepositoryConnectionsRoot = new Object();
    private final Map<UUID, List> fProjectAreaIdToSyncRulesMap = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, IProcessArea> fSyncRuleIdToProjectAreaMap = Collections.synchronizedMap(new HashMap());
    private boolean fShowArchived;
    private List<IExternalRepositoryConnection> fExternalRepositoryConnections;

    public InteropExplorerContentProvider(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
        this.fContentManager = new DeferredInteropContentManager(this, (AbstractTreeViewer)this.fTreeViewer);
        IPreferenceStore preferenceStore = InteropIdeUIPlugin.getDefault().getPreferenceStore();
        this.fShowArchived = preferenceStore.getBoolean("syncRulesView.showArchivedProjectAreas");
        preferenceStore.addPropertyChangeListener(this.fPreferencePropertyChangeListener);
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepositoryServiceListener);
    }

    public Object[] getChildren(Object parentElement) {
        return this.fContentManager.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof ISyncRule) {
            return this.fSyncRuleIdToProjectAreaMap.get(((ISyncRule)element).getItemId());
        }
        if (element instanceof IExternalRepositoryConnection) {
            return this.fExternalRepositoryConnectionsRoot;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProcessArea) {
            return true;
        }
        return this.isExternalRepositoryConnectionsRoot(element);
    }

    public Object[] getElements(Object inputElement) {
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null, this.fShowArchived);
        Object[] elements = new Object[projectAreas.size() + 1];
        elements[0] = this.fExternalRepositoryConnectionsRoot;
        int index = 1;
        for (Object object : projectAreas) {
            this.hookRepositoryListeners((IItemHandle)object);
            elements[index++] = object;
        }
        return elements;
    }

    public void dispose() {
        this.unhookRepositoryListeners();
        InteropIdeUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPreferencePropertyChangeListener);
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepositoryServiceListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void fetchDeferredChildren(Object element, IElementCollector collector, IProgressMonitor monitor) {
        if (element instanceof IProcessArea) {
            IProcessArea processArea = (IProcessArea)element;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                try {
                    List items = this.getAssociatedSyncRules(processArea, false, (IProgressMonitor)progress.newChild(8));
                    if (items != null) {
                        collector.add(items.toArray(), (IProgressMonitor)progress.newChild(2));
                    }
                    progress.worked(2);
                }
                catch (NotLoggedInException items) {
                    collector.done();
                }
                catch (TeamRepositoryException e) {
                    InteropIdeUIPlugin.getDefault().log(Messages.InteropExplorerContentProvider_ERROR_FETCHING_SYNCRULES, e);
                    collector.done();
                }
            }
            finally {
                collector.done();
            }
        } else if (this.isExternalRepositoryConnectionsRoot(element)) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                List<IExternalRepositoryConnection> items = this.getExternalRepositoryConnections(false, (IProgressMonitor)progress.newChild(8));
                if (items != null) {
                    collector.add(items.toArray(), (IProgressMonitor)progress.newChild(2));
                } else {
                    progress.worked(2);
                }
            }
            catch (NotLoggedInException items) {
            }
            catch (TeamRepositoryException e) {
                InteropIdeUIPlugin.getDefault().log(Messages.InteropExplorerContentProvider_ERROR_FETCHING_EXTERNAL_REPOSITORY_CONNECTIONS, e);
            }
        }
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    void addProcessArea(IProcessAreaHandle processAreaHandle) {
        if (!this.fTreeViewer.getControl().isDisposed()) {
            this.hookRepositoryListeners((IItemHandle)processAreaHandle);
            this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InteropExplorerContentProvider.this.fTreeViewer.refresh();
                }
            });
        }
    }

    void removeProcessArea(IProcessAreaHandle processAreaHandle) {
        this.removeCachedProcessArea(processAreaHandle);
        if (!this.fTreeViewer.getControl().isDisposed()) {
            final IProcessArea processArea = (IProcessArea)this.itemManager((IItemHandle)processAreaHandle).getSharedItemIfKnown((IItemHandle)processAreaHandle);
            this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (processArea != null) {
                        InteropExplorerContentProvider.this.fTreeViewer.remove((Object)processArea);
                    } else {
                        InteropExplorerContentProvider.this.fTreeViewer.refresh();
                    }
                }
            });
        }
    }

    void updateProcessArea(final IProcessAreaHandle processAreaHandle) {
        this.removeCachedProcessArea(processAreaHandle);
        Job job = new Job(Messages.InteropExplorerContentProvider_UPDATING_SYNCRULES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                if (!InteropExplorerContentProvider.this.fTreeViewer.getControl().isDisposed() && !monitor.isCanceled()) {
                    try {
                        final IProcessArea processArea = (IProcessArea)InteropExplorerContentProvider.this.itemManager((IItemHandle)processAreaHandle).fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
                        InteropExplorerContentProvider.this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                InteropExplorerContentProvider.this.fTreeViewer.refresh((Object)processArea);
                            }
                        });
                    }
                    catch (ItemNotFoundException processArea) {
                    }
                    catch (NotLoggedInException processArea) {
                    }
                    catch (TeamRepositoryException e) {
                        InteropIdeUIPlugin.getDefault().log(Messages.InteropExplorerContentProvider_ERROR_FETCHING_PROCESS_AREA, e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAll() {
        this.fProjectAreaIdToSyncRulesMap.clear();
        this.fSyncRuleIdToProjectAreaMap.clear();
        Object object = this.fExternalRepositoryConnectionsRoot;
        synchronized (object) {
            this.fExternalRepositoryConnections = null;
        }
        if (!this.fTreeViewer.getControl().isDisposed()) {
            this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InteropExplorerContentProvider.this.fTreeViewer.refresh();
                }
            });
        }
    }

    void refresh(final List elements) {
        Job job = new Job(Messages.InteropExplorerContentProvider_REFRESH_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(elements.size() * 2));
                for (final Object element : elements) {
                    try {
                        Object processArea;
                        if (InteropExplorerContentProvider.this.isExternalRepositoryConnectionsRoot(element)) {
                            InteropExplorerContentProvider.this.getExternalRepositoryConnections(true, (IProgressMonitor)progress.newChild(2));
                            if (!InteropExplorerContentProvider.this.fTreeViewer.getControl().isDisposed()) {
                                InteropExplorerContentProvider.this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        InteropExplorerContentProvider.this.fTreeViewer.refresh(element);
                                    }
                                });
                            }
                            return Status.OK_STATUS;
                        }
                        if (!(element instanceof IItem)) {
                            return Status.OK_STATUS;
                        }
                        final IItem item = (IItem)element;
                        IItem refreshedItem = InteropExplorerContentProvider.this.itemManager((IItemHandle)item).fetchCompleteItem((IItemHandle)item, 1, (IProgressMonitor)progress.newChild(1));
                        if (refreshedItem instanceof IProcessArea) {
                            processArea = (IProcessArea)refreshedItem;
                            InteropExplorerContentProvider.this.getAssociatedSyncRules(processArea, true, (IProgressMonitor)progress.newChild(1));
                        } else {
                            IProjectAreaHandle projectAreaHandle;
                            processArea = refreshedItem instanceof ISyncRule ? ((projectAreaHandle = ((ISyncRule)refreshedItem).getProjectArea()) != null ? (IProcessArea)InteropExplorerContentProvider.this.itemManager((IItemHandle)refreshedItem).fetchCompleteItem((IItemHandle)projectAreaHandle, 1, (IProgressMonitor)progress.newChild(1)) : null) : null;
                        }
                        if (processArea != null) {
                            InteropExplorerContentProvider.this.removeCachedProcessArea((IProcessAreaHandle)processArea);
                            if (InteropExplorerContentProvider.this.fTreeViewer.getControl().isDisposed()) continue;
                            InteropExplorerContentProvider.this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable((IProcessArea)processArea){
                                private final /* synthetic */ IProcessArea val$processArea;
                                {
                                    this.val$processArea = iProcessArea;
                                }

                                @Override
                                public void run() {
                                    InteropExplorerContentProvider.this.fTreeViewer.refresh((Object)this.val$processArea);
                                }
                            });
                            continue;
                        }
                        if (!InteropExplorerContentProvider.this.fTreeViewer.getControl().isDisposed()) {
                            InteropExplorerContentProvider.this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    InteropExplorerContentProvider.this.fTreeViewer.update((Object)item, null);
                                }
                            });
                        }
                        progress.worked(1);
                    }
                    catch (NotLoggedInException item) {
                    }
                    catch (TeamRepositoryException e) {
                        InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_REFRESHING_ITEM, e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
    }

    void associate(final IProcessArea processArea, final List<ISyncRule> items) {
        Job job = new Job(Messages.InteropExplorerContentProvider_ASSOCIATE_SYNCRULES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                IProjectAreaHandle projectAreaHandle = processArea.getProjectArea();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)items.size());
                for (ISyncRule syncRule : items) {
                    try {
                        IProjectAreaHandle previousProjectAreaHandle = syncRule.getProjectArea();
                        if (previousProjectAreaHandle != null) {
                            InteropExplorerContentProvider.this.removeAssociatedSyncRule(syncRule, (IProcessAreaHandle)previousProjectAreaHandle);
                        }
                        ISyncRule workingSyncRule = (ISyncRule)syncRule.getWorkingCopy();
                        workingSyncRule.setProjectArea(projectAreaHandle);
                        workingSyncRule.getEnabledTeamAreas().clear();
                        InteropExplorerContentProvider.this.interopManager((IItemHandle)processArea).saveSyncRule(workingSyncRule, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (NotLoggedInException previousProjectAreaHandle) {
                    }
                    catch (TeamRepositoryException e) {
                        InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_ASSOCIATING_SYNCRULES, e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
    }

    void unassociate(List<ISyncRule> items) {
        final HashMap<IProcessArea, ArrayList<ISyncRule>> areaItemsMap = new HashMap<IProcessArea, ArrayList<ISyncRule>>();
        int itemCount = 0;
        for (ISyncRule item : items) {
            IProcessArea processArea = (IProcessArea)this.getParent(item);
            if (processArea == null) continue;
            ArrayList<ISyncRule> areaItems = (ArrayList<ISyncRule>)areaItemsMap.get(processArea);
            if (areaItems == null) {
                areaItems = new ArrayList<ISyncRule>();
                areaItemsMap.put(processArea, areaItems);
            }
            areaItems.add(item);
            ++itemCount;
        }
        final int itemWork = itemCount;
        Job job = new Job(Messages.InteropExplorerContentProvider_UNASSOCIATE_SYNCRULES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)itemWork);
                for (Map.Entry entry : areaItemsMap.entrySet()) {
                    IProcessArea processArea = (IProcessArea)entry.getKey();
                    List areaItems = (List)entry.getValue();
                    for (ISyncRule syncRule : areaItems) {
                        try {
                            ISyncRule workingSyncRule = (ISyncRule)syncRule.getWorkingCopy();
                            workingSyncRule.setProjectArea(null);
                            InteropExplorerContentProvider.this.interopManager((IItemHandle)processArea).saveSyncRule(workingSyncRule, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (NotLoggedInException workingSyncRule) {
                        }
                        catch (TeamRepositoryException e) {
                            InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_UNASSOCIATING_SYNCRULES, e);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
    }

    void deleteSyncRule(final ISyncRule syncRule) {
        Job job = new Job(Messages.InteropExplorerContentProvider_DELETE_SYNCRULES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                IInteropManager manager = InteropExplorerContentProvider.this.interopManager((IItemHandle)syncRule);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    manager.setSynchronizationEnabled(syncRule, false, (IProgressMonitor)progress.newChild(5));
                    IExternalProxyHandle[] proxyHandles = manager.findProxiesBySyncRule((ISyncRuleHandle)syncRule, (IProgressMonitor)progress.newChild(20));
                    SubMonitor loopProgress = progress.newChild(70).setWorkRemaining(proxyHandles.length);
                    IExternalProxyHandle[] iExternalProxyHandleArray = proxyHandles;
                    int n = proxyHandles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExternalProxyHandle proxyHandle = iExternalProxyHandleArray[n2];
                        manager.synchronizeDeletionAndWait(proxyHandle, (IProgressMonitor)loopProgress.newChild(1));
                        ++n2;
                    }
                    manager.deleteSyncRule((ISyncRuleHandle)syncRule, (IProgressMonitor)progress.newChild(5));
                }
                catch (NotLoggedInException proxyHandles) {
                }
                catch (TeamRepositoryException e) {
                    InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_DELETING_SYNCRULE, e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    void importSyncRules(final IProcessArea processArea, final IExternalRepositoryConnection externalConnection, final List<File> files) {
        Job job = new Job(Messages.InteropExplorerContentProvider_IMPORT_SYNCRULES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(files.size() * 2));
                IProjectAreaHandle projectAreaHandle = processArea.getProjectArea();
                for (File file : files) {
                    InputStreamReader reader = null;
                    try {
                        if (progress.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            ISyncRule syncRule = InteropFactory.INSTANCE.createSyncRule();
                            reader = new InputStreamReader((InputStream)new FileInputStream(file), UTF8);
                            syncRule.importDefinition((Reader)reader);
                            syncRule.setProjectArea(projectAreaHandle);
                            if (externalConnection != null) {
                                syncRule.setExternalRepository((IExternalRepositoryConnectionHandle)externalConnection);
                            }
                            progress.worked(1);
                            InteropExplorerContentProvider.this.interopManager((IItemHandle)processArea).saveSyncRule(syncRule, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (TeamRepositoryException e) {
                            InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_IMPORTING_SYNCRULES, e);
                            break;
                        }
                        catch (FileNotFoundException e) {
                            InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_IMPORTING_SYNCRULES, NLS.bind((String)Messages.InteropExplorerContentProvider_ERROR_FILE_NOT_FOUND, (Object)file.getAbsolutePath(), (Object[])new Object[0]), null);
                            break;
                        }
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
    }

    void exportSyncRule(final ISyncRule syncRule, final File file, boolean wait) {
        Job job = new Job(Messages.InteropExplorerContentProvider_EXPORT_SYNCRULES_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.InteropExplorerContentProvider_EXPORT_SYNCRULES_TASK_NAME, 1);
                OutputStreamWriter writer = null;
                try {
                    try {
                        writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);
                        syncRule.exportDefinition((Writer)writer);
                    }
                    catch (TeamRepositoryException e) {
                        InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_EXPORTING_SYNCRULE, e);
                        monitor.done();
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (IOException e) {
                        InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_EXPORTING_SYNCRULE, NLS.bind((String)Messages.InteropExplorerContentProvider_ERROR_CANNOT_WRITE_FILE, (Object)file.getAbsoluteFile(), (Object[])new Object[0]), e);
                        monitor.done();
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                finally {
                    monitor.done();
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
        if (wait) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void synchronizeOut(final ISyncRule syncRule, final OutgoingSyncOptionsDialog.SyncOption option) {
        Job job = new Job(Messages.InteropExplorerContentProvider_OUTGOING_SYNC_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ITeamRepository repository = (ITeamRepository)syncRule.getOrigin();
                    switch (option) {
                        case SINCE_SYNC_RULE_MODIFIED: {
                            InteropExplorerContentProvider.this.adminClient(repository).resetLastSearchTime(syncRule, false, monitor);
                            break;
                        }
                        case ALL_ITEMS: {
                            InteropExplorerContentProvider.this.adminClient(repository).resetLastSearchTime(syncRule, true, monitor);
                        }
                    }
                    InteropExplorerContentProvider.this.adminClient(repository).synchronizeOutgoingAllItems((ISyncRuleHandle)syncRule, monitor);
                }
                catch (TeamRepositoryException e) {
                    InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_TRIGGERING_OUTGOING_SYNC, e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
    }

    boolean isExternalRepositoryConnectionsRoot(Object element) {
        return element == this.fExternalRepositoryConnectionsRoot;
    }

    Object getExternalRepositoryConnectionsRoot() {
        return this.fExternalRepositoryConnectionsRoot;
    }

    void deleteExternalRepositoryConnection(final IExternalRepositoryConnection externalConnection) {
        Job job = new Job(Messages.InteropExplorerContentProvider_DELETE_EXTERNAL_REPOSITORY_CONNECTION_TASK_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ITeamRepository repository = (ITeamRepository)externalConnection.getOrigin();
                    InteropExplorerContentProvider.this.adminClient(repository).deleteExternalRepositoryConnection((IExternalRepositoryConnectionHandle)externalConnection, monitor);
                    InteropExplorerContentProvider.this.refresh(Collections.singletonList(InteropExplorerContentProvider.this.fExternalRepositoryConnectionsRoot));
                }
                catch (TeamRepositoryException e) {
                    InteropExplorerContentProvider.this.reportError(Messages.InteropExplorerContentProvider_ERROR_DELETING_EXTERNAL_REPOSITORY_CONNECTION, e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private synchronized void hookRepositoryListeners(IItemHandle itemHandle) {
        ITeamRepository repository = this.teamRepository(itemHandle);
        if (!this.fHookedRepositories.contains(repository)) {
            repository.itemManager().addItemChangeListener(ISyncRule.ITEM_TYPE, this.fAssociatedItemChangeListener);
            this.fHookedRepositories.add(repository);
        }
    }

    private synchronized void unhookRepositoryListeners() {
        for (ITeamRepository repository : this.fHookedRepositories) {
            repository.itemManager().removeItemChangeListener(ISyncRule.ITEM_TYPE, this.fAssociatedItemChangeListener);
        }
        this.fHookedRepositories.clear();
    }

    private List getAssociatedSyncRules(IProcessArea processArea, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        List items = null;
        if (!refresh && (items = this.fProjectAreaIdToSyncRulesMap.get(processArea.getItemId())) != null) {
            return items;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ISyncRuleHandle[] itemHandles = this.interopManager((IItemHandle)processArea).findSyncRulesByProjectArea(processArea.getProjectArea(), (IProgressMonitor)progress.newChild(3));
        if (itemHandles == null) {
            this.fProjectAreaIdToSyncRulesMap.remove(processArea.getItemId());
            progress.worked(7);
            return null;
        }
        items = this.itemManager((IItemHandle)processArea).fetchCompleteItems(Arrays.asList(itemHandles), refresh ? 1 : 0, (IProgressMonitor)progress.newChild(7));
        this.fProjectAreaIdToSyncRulesMap.put(processArea.getItemId(), items);
        for (Object item : items) {
            this.fSyncRuleIdToProjectAreaMap.put(((IItem)item).getItemId(), processArea);
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAssociatedSyncRule(final ISyncRule syncRule, IProcessAreaHandle processAreaHandle) {
        IProjectArea processArea = null;
        Map<UUID, List> map = this.fProjectAreaIdToSyncRulesMap;
        synchronized (map) {
            ArrayList<ISyncRule> childList = this.fProjectAreaIdToSyncRulesMap.get(processAreaHandle.getItemId());
            boolean found = false;
            if (childList != null) {
                for (ISyncRule child : childList) {
                    if (!syncRule.sameItemId((IItemHandle)child)) continue;
                    found = true;
                    break;
                }
            }
            if (!found && (processArea = this.resolveProjectArea(processAreaHandle)) != null) {
                if (childList == null) {
                    childList = new ArrayList<ISyncRule>();
                }
                childList.add(syncRule);
                this.fProjectAreaIdToSyncRulesMap.put(processAreaHandle.getItemId(), childList);
                this.fSyncRuleIdToProjectAreaMap.put(syncRule.getItemId(), (IProcessArea)processArea);
            }
        }
        if (!this.fTreeViewer.getControl().isDisposed()) {
            final IProjectArea parent = processArea;
            this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (parent == null) {
                        InteropExplorerContentProvider.this.fTreeViewer.refresh((Object)syncRule);
                    } else {
                        InteropExplorerContentProvider.this.fTreeViewer.add(parent, (Object)syncRule);
                    }
                }
            });
        }
    }

    private void removeAssociatedSyncRule(final ISyncRule syncRule, IProcessAreaHandle processAreaHandle) {
        IProjectArea processArea = this.resolveProjectArea(processAreaHandle);
        this.removeCachedSyncRule(syncRule);
        if (processArea != null && !this.fTreeViewer.getControl().isDisposed()) {
            this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InteropExplorerContentProvider.this.fTreeViewer.remove((Object)syncRule);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IExternalRepositoryConnection> getExternalRepositoryConnections(boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        Object object = this.fExternalRepositoryConnectionsRoot;
        synchronized (object) {
            if (refresh || this.fExternalRepositoryConnections == null) {
                if (this.fExternalRepositoryConnections == null) {
                    this.fExternalRepositoryConnections = new ArrayList<IExternalRepositoryConnection>();
                } else {
                    this.fExternalRepositoryConnections.clear();
                }
                ITeamRepositoryService repoService = TeamPlatform.getTeamRepositoryService();
                ITeamRepository[] repositories = repoService.getTeamRepositories();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)repositories.length);
                ITeamRepository[] iTeamRepositoryArray = repositories;
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    ITeamRepository repository = iTeamRepositoryArray[n2];
                    if (repository.loggedIn()) {
                        SubMonitor childProgress = progress.newChild(1);
                        IExternalRepositoryConnection[] conns = this.adminClient(repository).getAllExternalRepositoryConnections((IProgressMonitor)childProgress);
                        if (conns.length > 0) {
                            this.fExternalRepositoryConnections.addAll(Arrays.asList(conns));
                        }
                    }
                    ++n2;
                }
            }
        }
        return this.fExternalRepositoryConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedProcessArea(IProcessAreaHandle processAreaHandle) {
        this.fProjectAreaIdToSyncRulesMap.remove(processAreaHandle.getItemId());
        Map<UUID, IProcessArea> map = this.fSyncRuleIdToProjectAreaMap;
        synchronized (map) {
            Collection<IProcessArea> parents = this.fSyncRuleIdToProjectAreaMap.values();
            Iterator<IProcessArea> iterator = parents.iterator();
            while (iterator.hasNext()) {
                IProcessArea parent = iterator.next();
                if (!parent.sameItemId((IItemHandle)processAreaHandle)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedSyncRule(ISyncRule syncRule) {
        IProcessArea processArea = this.fSyncRuleIdToProjectAreaMap.get(syncRule.getItemId());
        this.fSyncRuleIdToProjectAreaMap.remove(syncRule.getItemId());
        if (processArea != null) {
            Map<UUID, List> map = this.fProjectAreaIdToSyncRulesMap;
            synchronized (map) {
                List childList = this.fProjectAreaIdToSyncRulesMap.get(processArea.getItemId());
                if (childList != null) {
                    Iterator iterator = childList.iterator();
                    while (iterator.hasNext()) {
                        ISyncRule child = (ISyncRule)iterator.next();
                        if (!syncRule.sameItemId((IItemHandle)child)) continue;
                        iterator.remove();
                        break;
                    }
                }
            }
        }
    }

    private IProjectArea resolveProjectArea(IProcessAreaHandle processAreaHandle) {
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null, true);
        for (IProjectAreaHandle handle : projectAreas) {
            if (!handle.sameItemId((IItemHandle)processAreaHandle) || !(handle instanceof IProjectArea)) continue;
            return (IProjectArea)handle;
        }
        return null;
    }

    private void reportError(String title, Throwable e) {
        this.reportError(title, e.getLocalizedMessage(), e);
    }

    private void reportError(final String title, final String message, final Throwable e) {
        if (!this.fTreeViewer.getControl().isDisposed()) {
            this.fTreeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)InteropExplorerContentProvider.this.fTreeViewer.getControl().getShell(), (String)title, null, (IStatus)new Status(4, "com.ibm.team.interop.ide.ui", message, e));
                }
            });
        }
    }

    private ITeamRepository teamRepository(IItemHandle itemHandle) {
        return (ITeamRepository)itemHandle.getOrigin();
    }

    private IInteropManager interopManager(IItemHandle itemHandle) {
        return (IInteropManager)this.teamRepository(itemHandle).getClientLibrary(IInteropManager.class);
    }

    private IItemConnectorAdminClient adminClient(ITeamRepository repository) {
        return (IItemConnectorAdminClient)repository.getClientLibrary(IItemConnectorAdminClient.class);
    }

    private IItemManager itemManager(IItemHandle itemHandle) {
        return this.teamRepository(itemHandle).itemManager();
    }

    private class DeferredInteropContentManager
    extends DeferredTreeContentManager {
        public DeferredInteropContentManager(ITreeContentProvider provider, AbstractTreeViewer viewer) {
            super(provider, viewer);
        }

        protected IDeferredWorkbenchAdapter getAdapter(Object element) {
            if (InteropExplorerContentProvider.this.hasChildren(element)) {
                return InteropExplorerContentProvider.this;
            }
            return super.getAdapter(element);
        }
    }
}

