/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.rcp.ui.InteropRcpUiPlugin;
import com.ibm.team.interop.rcp.ui.internal.SyncRuleWorkingCopy;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.workingcopy.SaveConflictException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class SyncRuleEditorInput
extends PlatformObject
implements IEditorInput {
    private SyncRuleWorkingCopy fSyncRuleWorkingCopy;

    public SyncRuleEditorInput(ISyncRule syncRule, ITeamRepository repository, IProcessArea processArea) {
        if (syncRule == null) {
            throw new IllegalArgumentException("syncRule cannot be null");
        }
        if (repository == null) {
            throw new IllegalArgumentException("repository cannot be null");
        }
        this.fSyncRuleWorkingCopy = new SyncRuleWorkingCopy(syncRule, repository, processArea);
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return InteropRcpUiPlugin.SYNC_RULE_IMAGE_DESCRIPTOR;
    }

    public String getName() {
        return this.fSyncRuleWorkingCopy.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fSyncRuleWorkingCopy.getToolTipText();
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SyncRuleEditorInput) {
            SyncRuleEditorInput input = (SyncRuleEditorInput)((Object)obj);
            return this.getSyncRule().sameItemId((IItemHandle)input.getSyncRule());
        }
        return super.equals(obj);
    }

    public ISyncRule getSyncRule() {
        return this.fSyncRuleWorkingCopy.getSyncRule();
    }

    public SyncRuleWorkingCopy getWorkingCopy() {
        return this.fSyncRuleWorkingCopy;
    }

    public void saveSyncRule(IProgressMonitor monitor) throws CoreException {
        if (this.fSyncRuleWorkingCopy == null) {
            return;
        }
        try {
            this.fSyncRuleWorkingCopy.save(monitor);
        }
        catch (SaveConflictException e) {
            throw new CoreException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }
}

