/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleEditorInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class SyncRuleDocumentProvider
extends AbstractDocumentProvider {
    public void updateDocument(Object element, IDocument document) throws CoreException {
        if (!(element instanceof SyncRuleEditorInput)) {
            return;
        }
        try {
            SyncRuleEditorInput input = (SyncRuleEditorInput)((Object)element);
            ISyncRule syncRule = input.getSyncRule();
            StringWriter writer = new StringWriter();
            syncRule.exportDefinition((Writer)writer);
            String text = writer.toString().replaceAll("<(\\w+)/>", "<$1></$1>");
            document.set(text);
        }
        catch (TeamRepositoryException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.interop.ide.ui", Messages.SyncRuleDocumentProvider_ERROR_CREATING_DOCUMENT, (Throwable)e));
        }
    }

    public void commitDocument(Object element, IDocument document) throws CoreException {
        if (!(element instanceof SyncRuleEditorInput)) {
            return;
        }
        SyncRuleEditorInput input = (SyncRuleEditorInput)((Object)element);
        ISyncRule syncRule = input.getSyncRule();
        StringReader reader = new StringReader(document.get());
        try {
            syncRule.importDefinition((Reader)reader);
        }
        catch (TeamRepositoryException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.interop.ide.ui", Messages.SyncRuleDocumentProvider_ERROR_UPDATING_SYNC_RULE, (Throwable)e));
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (!(element instanceof SyncRuleEditorInput)) {
            return null;
        }
        Document doc = new Document();
        this.updateDocument(element, (IDocument)doc);
        return doc;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!(element instanceof SyncRuleEditorInput)) {
            return;
        }
        SyncRuleEditorInput input = (SyncRuleEditorInput)((Object)element);
        this.commitDocument(element, document);
        input.saveSyncRule(monitor);
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
        };
    }

    public boolean isModifiable(Object element) {
        return element instanceof SyncRuleEditorInput;
    }

    public boolean isReadOnly(Object element) {
        return !this.isModifiable(element);
    }
}

