/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.IPropertyMapping;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class RequiredPropertiesDialog
extends TitleAreaDialog {
    private final List<IPropertyMapping> fMappings;
    private final IPropertyMapping fCurrentMapping;
    private final ResourceManager fResourceManager;
    private CheckboxTableViewer fRequiredItemPropertiesTableViewer;
    private CheckboxTableViewer fRequiredExternalPropertiesTableViewer;
    private List fRequiredItemProperties = Collections.EMPTY_LIST;
    private List fRequiredExternalProperties = Collections.EMPTY_LIST;

    public RequiredPropertiesDialog(Shell parentShell, List<IPropertyMapping> mappings, IPropertyMapping currentMapping, ResourceManager resourceManager) {
        super(parentShell);
        this.fMappings = mappings;
        this.fCurrentMapping = currentMapping;
        this.fResourceManager = resourceManager;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public List getRequiredItemProperties() {
        return this.fRequiredItemProperties;
    }

    public List getRequiredExternalProperties() {
        return this.fRequiredExternalProperties;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.RequiredPropertiesDialog_DIALOG_TITLE);
        this.setMessage(Messages.RequiredPropertiesDialog_DIALOG_DESCRIPTION);
        this.setTitleImage(this.fResourceManager.createImage(InteropIdeUIPlugin.PROPERTY_MAPPINGS_WIZBAN_IMAGE_DESCRIPTOR));
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.RequiredPropertiesDialog_ITEM_PROPERTIES_LABEL);
        label = new Label(composite, 0);
        label.setText(Messages.RequiredPropertiesDialog_EXTERNAL_PROPERTIES_LABEL);
        this.fRequiredItemPropertiesTableViewer = new CheckboxTableViewer(new Table(composite, 2850));
        GridDataFactory.fillDefaults().align(1, 128).applyTo((Control)this.fRequiredItemPropertiesTableViewer.getTable());
        this.fRequiredItemPropertiesTableViewer.setContentProvider((IContentProvider)new RequiredPropertiesContentProvider(PropertyType.ITEM_PROPERTIES));
        this.fRequiredItemPropertiesTableViewer.setLabelProvider((IBaseLabelProvider)new RequiredPropertiesLabelProvider());
        this.fRequiredItemPropertiesTableViewer.setInput(this.fMappings);
        this.fRequiredItemPropertiesTableViewer.setCheckedElements(this.fCurrentMapping.getRequiredItemPropertiesList().toArray());
        this.fRequiredExternalPropertiesTableViewer = new CheckboxTableViewer(new Table(composite, 2850));
        GridDataFactory.fillDefaults().align(1, 128).applyTo((Control)this.fRequiredExternalPropertiesTableViewer.getTable());
        this.fRequiredExternalPropertiesTableViewer.setContentProvider((IContentProvider)new RequiredPropertiesContentProvider(PropertyType.EXTERNAL_PROPERTIES));
        this.fRequiredExternalPropertiesTableViewer.setLabelProvider((IBaseLabelProvider)new RequiredPropertiesLabelProvider());
        this.fRequiredExternalPropertiesTableViewer.setInput(this.fMappings);
        this.fRequiredExternalPropertiesTableViewer.setCheckedElements(this.fCurrentMapping.getRequiredExternalPropertiesList().toArray());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.interop.ide.ui.requiredPropertiesDialog");
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RequiredPropertiesDialog_SHELL_TITLE);
    }

    protected void okPressed() {
        Object[] elements = this.fRequiredItemPropertiesTableViewer.getCheckedElements();
        this.fRequiredItemProperties = Arrays.asList(elements);
        elements = this.fRequiredExternalPropertiesTableViewer.getCheckedElements();
        this.fRequiredExternalProperties = Arrays.asList(elements);
        super.okPressed();
    }

    private static enum PropertyType {
        ITEM_PROPERTIES,
        EXTERNAL_PROPERTIES;

    }

    private static class RequiredPropertiesContentProvider
    implements IStructuredContentProvider {
        private final PropertyType fPropertyType;
        private List<String> fItemProperties = new ArrayList<String>();
        private List<String> fExternalProperties = new ArrayList<String>();

        RequiredPropertiesContentProvider(PropertyType propertyType) {
            this.fPropertyType = propertyType;
        }

        public Object[] getElements(Object inputElement) {
            switch (this.fPropertyType) {
                case ITEM_PROPERTIES: {
                    return this.fItemProperties.toArray();
                }
                case EXTERNAL_PROPERTIES: {
                    return this.fExternalProperties.toArray();
                }
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fItemProperties.clear();
            this.fExternalProperties.clear();
            if (newInput != null) {
                List mappings = (List)newInput;
                for (IPropertyMapping mapping : mappings) {
                    if (mapping.getItemPropertyName() != null && mapping.getItemPropertyName().length() != 0) {
                        this.fItemProperties.add(mapping.getItemPropertyName());
                    }
                    if (mapping.getExternalPropertyName() == null || mapping.getExternalPropertyName().length() == 0) continue;
                    this.fExternalProperties.add(mapping.getExternalPropertyName());
                }
            }
        }
    }

    private static class RequiredPropertiesLabelProvider
    extends LabelProvider {
        private RequiredPropertiesLabelProvider() {
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

