/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.IPropertyMapping;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.interop.common.dto.IPropertyInfoDTO;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.TableColumnInfo;
import com.ibm.team.interop.ide.ui.internal.WidgetUtil;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleOverviewPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PropertyMappingDialog
extends TitleAreaDialog {
    private SelectionListener fItemPropertyButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (PropertyMappingDialog.this.fNoItemPropertyButton.getSelection()) {
                WidgetUtil.setComboSelection(PropertyMappingDialog.this.fItemPropertyNameCombo, null, PropertyMappingDialog.this.fItemPropertyChoices);
                PropertyMappingDialog.this.fItemPropertyNameCombo.setEnabled(false);
            } else {
                PropertyMappingDialog.this.fItemPropertyNameCombo.setEnabled(true);
            }
            PropertyMappingDialog.this.updateButtons();
        }
    };
    private SelectionListener fExternalPropertyButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (PropertyMappingDialog.this.fNoExternalPropertyButton.getSelection()) {
                WidgetUtil.setComboSelection(PropertyMappingDialog.this.fExternalPropertyNameCombo, null, PropertyMappingDialog.this.fExternalPropertyChoices);
                PropertyMappingDialog.this.fExternalPropertyNameCombo.setEnabled(false);
            } else {
                PropertyMappingDialog.this.fExternalPropertyNameCombo.setEnabled(true);
            }
            PropertyMappingDialog.this.updateButtons();
        }
    };
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            PropertyMappingDialog.this.updateButtons();
        }
    };
    static final int ITEM_VALUE_COLUMN = 0;
    static final String ITEM_VALUE_COLUMN_NAME = Messages.PropertyMappingDialog_ITEM_VALUE_COLUMN_HEADER;
    static final int EXTERNAL_VALUE_COLUMN = 1;
    static final String EXTERNAL_VALUE_COLUMN_NAME = Messages.PropertyMappingDialog_EXTERNAL_VALUE_COLUMN_HEADER;
    static final TableColumnInfo[] VALUE_MAPPINGS_COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(0, 16384, (ColumnLayoutData)new ColumnWeightData(50, true), ITEM_VALUE_COLUMN_NAME, null), new TableColumnInfo(1, 16384, (ColumnLayoutData)new ColumnWeightData(50, true), EXTERNAL_VALUE_COLUMN_NAME, null)};
    private static final int ADD_BUTTON_ID = 1024;
    private final ResourceManager fResourceManager;
    private final List<IPropertyMapping> fPropertyMappings = new ArrayList<IPropertyMapping>();
    private final WidgetUtil.ComboChoices<IPropertyInfoDTO> fItemPropertyChoices;
    private final WidgetUtil.ComboChoices<IPropertyInfoDTO> fExternalPropertyChoices;
    private final WidgetUtil.ComboChoices<SyncRuleOverviewPage.SyncDirection> fSyncDirectionChoices;
    private Combo fItemPropertyNameCombo;
    private Combo fExternalPropertyNameCombo;
    private Combo fSyncDirectionCombo;
    private Button fNoItemPropertyButton;
    private Button fChooseItemPropertyButton;
    private Button fNoExternalPropertyButton;
    private Button fChooseExternalPropertyButton;
    private Button fItemIdentifierButton;
    private Button fExternalIdentifierButton;
    private Button fExternalModifierButton;

    public PropertyMappingDialog(Shell parentShell, WidgetUtil.ComboChoices<IPropertyInfoDTO> itemPropertyChoices, WidgetUtil.ComboChoices<IPropertyInfoDTO> externalPropertyChoices, WidgetUtil.ComboChoices<SyncRuleOverviewPage.SyncDirection> syncDirectionChoices, ResourceManager resourceManager) {
        super(parentShell);
        this.fResourceManager = resourceManager;
        this.fItemPropertyChoices = itemPropertyChoices;
        this.fExternalPropertyChoices = externalPropertyChoices;
        this.fSyncDirectionChoices = syncDirectionChoices;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public IPropertyMapping[] getPropertyMappings() {
        return this.fPropertyMappings.toArray(new IPropertyMapping[this.fPropertyMappings.size()]);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.PropertyMappingDialog_DIALOG_TITLE);
        this.setTitleImage(this.fResourceManager.createImage(InteropIdeUIPlugin.PROPERTY_MAPPINGS_WIZBAN_IMAGE_DESCRIPTOR));
        this.setMessage(Messages.PropertyMappingDialog_DIALOG_DESCRIPTION);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        int INDENT = 20;
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.marginWidth = LayoutConstants.getMargins().x;
        rowLayout.marginHeight = LayoutConstants.getMargins().y;
        rowLayout.spacing = LayoutConstants.getSpacing().x;
        composite.setLayout((Layout)rowLayout);
        Composite itemPropertyComposite = new Composite(composite, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = LayoutConstants.getMargins().x;
        layout.marginHeight = LayoutConstants.getMargins().y;
        layout.spacing = LayoutConstants.getSpacing().x;
        itemPropertyComposite.setLayout((Layout)layout);
        Label label = new Label(itemPropertyComposite, 0);
        label.setText(Messages.PropertyMappingDialog_ITEM_PROPERTY_LABEL);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.top = new FormAttachment(0);
        label.setLayoutData((Object)layoutData);
        this.fNoItemPropertyButton = new Button(itemPropertyComposite, 16);
        this.fNoItemPropertyButton.setText(Messages.PropertyMappingDialog_CHOOSE_NONE_BUTTON_LABEL);
        this.fNoItemPropertyButton.setSelection(false);
        this.fNoItemPropertyButton.addSelectionListener(this.fItemPropertyButtonListener);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.top = new FormAttachment((Control)label);
        this.fNoItemPropertyButton.setLayoutData((Object)layoutData);
        this.fChooseItemPropertyButton = new Button(itemPropertyComposite, 16);
        this.fChooseItemPropertyButton.setText(Messages.PropertyMappingDialog_CHOOSE_BUTTON_LABEL);
        this.fChooseItemPropertyButton.setSelection(true);
        this.fChooseItemPropertyButton.addSelectionListener(this.fItemPropertyButtonListener);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.top = new FormAttachment((Control)this.fNoItemPropertyButton);
        this.fChooseItemPropertyButton.setLayoutData((Object)layoutData);
        this.fItemPropertyNameCombo = new Combo(itemPropertyComposite, 4);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 20);
        layoutData.top = new FormAttachment((Control)this.fChooseItemPropertyButton);
        this.fItemPropertyNameCombo.setLayoutData((Object)layoutData);
        WidgetUtil.setComboChoices(this.fItemPropertyNameCombo, this.fItemPropertyChoices, false);
        this.fItemPropertyNameCombo.addModifyListener(this.fModifyListener);
        this.fItemPropertyNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyMappingDialog.this.itemPropertySelected();
            }
        });
        this.fItemIdentifierButton = new Button(itemPropertyComposite, 32);
        this.fItemIdentifierButton.setText(Messages.PropertyMappingDialog_ITEM_IDENTIFIER_LABEL);
        this.fItemIdentifierButton.setToolTipText(Messages.PropertyMappingDialog_ITEM_IDENTIFIER_TOOLTIP);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 20);
        layoutData.top = new FormAttachment((Control)this.fItemPropertyNameCombo);
        this.fItemIdentifierButton.setLayoutData((Object)layoutData);
        Composite syncDirectionComposite = new Composite(composite, 0);
        layout = new FormLayout();
        layout.marginWidth = LayoutConstants.getMargins().x;
        layout.marginHeight = LayoutConstants.getMargins().y;
        layout.spacing = LayoutConstants.getSpacing().x;
        syncDirectionComposite.setLayout((Layout)layout);
        label = new Label(syncDirectionComposite, 0);
        label.setText(Messages.PropertyMappingDialog_SYNC_DIRECTION_LABEL);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.top = new FormAttachment(0);
        label.setLayoutData((Object)layoutData);
        this.fSyncDirectionCombo = new Combo(syncDirectionComposite, 4);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 20);
        layoutData.top = new FormAttachment((Control)label);
        this.fSyncDirectionCombo.setLayoutData((Object)layoutData);
        WidgetUtil.setComboChoices(this.fSyncDirectionCombo, this.fSyncDirectionChoices, false);
        Composite externalPropertyComposite = new Composite(composite, 0);
        layout = new FormLayout();
        layout.marginWidth = LayoutConstants.getMargins().x;
        layout.marginHeight = LayoutConstants.getMargins().y;
        layout.spacing = LayoutConstants.getSpacing().x;
        externalPropertyComposite.setLayout((Layout)layout);
        label = new Label(externalPropertyComposite, 0);
        label.setText(Messages.PropertyMappingDialog_EXTERNAL_PROPERTY_LABEL);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.top = new FormAttachment(0);
        label.setLayoutData((Object)layoutData);
        this.fNoExternalPropertyButton = new Button(externalPropertyComposite, 16);
        this.fNoExternalPropertyButton.setText(Messages.PropertyMappingDialog_CHOOSE_NONE_BUTTON_LABEL);
        this.fNoExternalPropertyButton.setSelection(false);
        this.fNoExternalPropertyButton.addSelectionListener(this.fExternalPropertyButtonListener);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.top = new FormAttachment((Control)label);
        this.fNoExternalPropertyButton.setLayoutData((Object)layoutData);
        this.fChooseExternalPropertyButton = new Button(externalPropertyComposite, 16);
        this.fChooseExternalPropertyButton.setText(Messages.PropertyMappingDialog_CHOOSE_BUTTON_LABEL);
        this.fChooseExternalPropertyButton.setSelection(true);
        this.fChooseExternalPropertyButton.addSelectionListener(this.fExternalPropertyButtonListener);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0);
        layoutData.top = new FormAttachment((Control)this.fNoExternalPropertyButton);
        this.fChooseExternalPropertyButton.setLayoutData((Object)layoutData);
        this.fExternalPropertyNameCombo = new Combo(externalPropertyComposite, 4);
        this.fExternalPropertyNameCombo.setToolTipText(Messages.PropertyMappingDialog_EXTERNAL_PROPERTY_TOOLTIP);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 20);
        layoutData.top = new FormAttachment((Control)this.fChooseExternalPropertyButton);
        this.fExternalPropertyNameCombo.setLayoutData((Object)layoutData);
        WidgetUtil.setComboChoices(this.fExternalPropertyNameCombo, this.fExternalPropertyChoices, false);
        this.fExternalPropertyNameCombo.addModifyListener(this.fModifyListener);
        this.fExternalPropertyNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyMappingDialog.this.externalPropertySelected();
            }
        });
        this.fExternalIdentifierButton = new Button(externalPropertyComposite, 32);
        this.fExternalIdentifierButton.setText(Messages.PropertyMappingDialog_EXTERNAL_IDENTIFIER_LABEL);
        this.fExternalIdentifierButton.setToolTipText(Messages.PropertyMappingDialog_EXTERNAL_IDENTIFIER_TOOLTIP);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 20);
        layoutData.top = new FormAttachment((Control)this.fExternalPropertyNameCombo);
        this.fExternalIdentifierButton.setLayoutData((Object)layoutData);
        this.fExternalModifierButton = new Button(externalPropertyComposite, 32);
        this.fExternalModifierButton.setText(Messages.PropertyMappingDialog_EXTERNAL_MODIFIER_LABEL);
        this.fExternalModifierButton.setToolTipText(Messages.PropertyMappingDialog_EXTERNAL_MODIFIER_TOOLTIP);
        layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 20);
        layoutData.top = new FormAttachment((Control)this.fExternalIdentifierButton);
        this.fExternalModifierButton.setLayoutData((Object)layoutData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.interop.ide.ui.propertyMappingsDialog");
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1024, Messages.PropertyMappingDialog_ADD_MAPPING_BUTTON_LABEL, false);
        button.setEnabled(false);
        button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        button.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PropertyMappingDialog_SHELL_TITLE);
    }

    protected void okPressed() {
        this.addButtonPressed();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.addButtonPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void addButtonPressed() {
        IPropertyMapping mapping = InteropFactory.INSTANCE.createPropertyMapping();
        this.commit(mapping);
        String itemPropertyName = mapping.getItemPropertyName();
        String externalPropertyName = mapping.getExternalPropertyName();
        if (!(itemPropertyName != null && itemPropertyName.length() != 0 || externalPropertyName != null && externalPropertyName.length() != 0)) {
            return;
        }
        this.fPropertyMappings.add(mapping);
        this.clear();
        this.updateButtons();
    }

    private void commit(IPropertyMapping mapping) {
        IPropertyInfoDTO propertyInfo = WidgetUtil.getComboSelection(this.fItemPropertyNameCombo, this.fItemPropertyChoices);
        if (propertyInfo != null) {
            mapping.setItemPropertyName(propertyInfo.getName());
        } else {
            mapping.setItemPropertyName(this.fItemPropertyNameCombo.getText());
        }
        propertyInfo = WidgetUtil.getComboSelection(this.fExternalPropertyNameCombo, this.fExternalPropertyChoices);
        if (propertyInfo != null) {
            mapping.setExternalPropertyName(propertyInfo.getName());
        } else {
            mapping.setExternalPropertyName(this.fExternalPropertyNameCombo.getText());
        }
        SyncRuleOverviewPage.SyncDirection syncDirection = WidgetUtil.getComboSelection(this.fSyncDirectionCombo, this.fSyncDirectionChoices);
        if (syncDirection == null) {
            syncDirection = SyncRuleOverviewPage.SyncDirection.NONE;
        }
        switch (syncDirection) {
            case NONE: {
                mapping.setIncoming(false);
                mapping.setOutgoing(false);
                break;
            }
            case IN: {
                mapping.setIncoming(true);
                mapping.setOutgoing(false);
                break;
            }
            case OUT: {
                mapping.setIncoming(false);
                mapping.setOutgoing(true);
                break;
            }
            case IN_OUT: {
                mapping.setIncoming(true);
                mapping.setOutgoing(true);
            }
        }
        mapping.setItemIdentifier(this.fItemIdentifierButton.getSelection());
        mapping.setExternalIdentifier(this.fExternalIdentifierButton.getSelection());
        mapping.setExternalModifier(this.fExternalModifierButton.getSelection());
    }

    private void clear() {
        this.fNoItemPropertyButton.setSelection(false);
        this.fChooseItemPropertyButton.setSelection(true);
        this.fNoExternalPropertyButton.setSelection(false);
        this.fChooseExternalPropertyButton.setSelection(true);
        WidgetUtil.setComboSelection(this.fItemPropertyNameCombo, null, this.fItemPropertyChoices);
        WidgetUtil.setComboSelection(this.fExternalPropertyNameCombo, null, this.fExternalPropertyChoices);
        WidgetUtil.setComboSelection(this.fSyncDirectionCombo, null, this.fSyncDirectionChoices);
        this.fItemIdentifierButton.setSelection(false);
        this.fExternalIdentifierButton.setSelection(false);
        this.fExternalModifierButton.setSelection(false);
    }

    private void itemPropertySelected() {
        IPropertyInfoDTO info = WidgetUtil.getComboSelection(this.fItemPropertyNameCombo, this.fItemPropertyChoices);
        if (info != null) {
            this.fItemIdentifierButton.setSelection(info.isIdentifier());
        }
        this.updateButtons();
    }

    private void externalPropertySelected() {
        IPropertyInfoDTO info = WidgetUtil.getComboSelection(this.fExternalPropertyNameCombo, this.fExternalPropertyChoices);
        if (info != null) {
            this.fExternalIdentifierButton.setSelection(info.isIdentifier());
            this.fExternalModifierButton.setSelection(info.isModifier());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        String itemPropertyName = this.fItemPropertyNameCombo.getText();
        String externalPropertyName = this.fExternalPropertyNameCombo.getText();
        boolean propertyNameSpecified = itemPropertyName != null && itemPropertyName.length() != 0 || externalPropertyName != null && externalPropertyName.length() != 0;
        Button button = this.getButton(1024);
        if (button != null) {
            button.setEnabled(propertyNameSpecified);
        }
        if ((button = this.getButton(0)) != null) {
            button.setEnabled(propertyNameSpecified || !this.fPropertyMappings.isEmpty());
        }
    }
}

