/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.IPropertyMapping;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.ide.ui.internal.ConstrainedTableViewer;
import com.ibm.team.interop.ide.ui.internal.TableColumnInfo;
import com.ibm.team.interop.ide.ui.internal.editors.ExternalProxyEditor;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleEditor;
import com.ibm.team.interop.rcp.ui.internal.ExternalProxyWorkingCopy;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.ui.editor.TeamFormPage;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ExternalProxyOverviewPage
extends TeamFormPage {
    private ViewerComparator fStateTableViewerComparator = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s2;
            String s1;
            Table table = ((TableViewer)viewer).getTable();
            TableColumn sortColumn = table.getSortColumn();
            int columnIndex = sortColumn == null ? 0 : table.indexOf(sortColumn);
            int direction = table.getSortDirection();
            StateTableElement element1 = (StateTableElement)((Object)e1);
            StateTableElement element2 = (StateTableElement)((Object)e2);
            switch (columnIndex) {
                case 0: {
                    s1 = element1.fItemPropertyName;
                    s2 = element2.fItemPropertyName;
                    break;
                }
                case 2: {
                    s1 = element1.fExternalPropertyName;
                    s2 = element2.fExternalPropertyName;
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (s1 == null) {
                s1 = EMPTY;
            }
            if (s2 == null) {
                s2 = EMPTY;
            }
            int result = s1.compareToIgnoreCase(s2);
            return direction == 128 ? result : -result;
        }
    };
    private SelectionListener fColumnSortListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn sortColumn;
            TableColumn column = (TableColumn)e.getSource();
            if (column == (sortColumn = ExternalProxyOverviewPage.this.fStateTable.getSortColumn())) {
                int currentDirection = ExternalProxyOverviewPage.this.fStateTable.getSortDirection();
                ExternalProxyOverviewPage.this.fStateTable.setSortDirection(currentDirection == 128 ? 1024 : 128);
            } else {
                ExternalProxyOverviewPage.this.fStateTable.setSortColumn(column);
            }
            ExternalProxyOverviewPage.this.fStateTableViewer.refresh();
        }
    };
    private IChangeListener fChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            String syncDirectionText;
            Hyperlink link;
            IExternalProxy blockingProxy;
            int n;
            int n2;
            IExternalProxy[] iExternalProxyArray;
            if (property != IWorkingCopy.PROP_VALID || !ExternalProxyOverviewPage.this.fWorkingCopy.isValid()) {
                return;
            }
            IExternalProxy proxy = ExternalProxyOverviewPage.this.fWorkingCopy.getExternalProxy();
            if (proxy == null) {
                MessageDialog.openInformation((Shell)ExternalProxyOverviewPage.this.getSite().getShell(), (String)Messages.ExternalProxyOverviewPage_SYNC_STATUS_NOT_FOUND_TITLE, (String)Messages.ExternalProxyOverviewPage_SYNC_STATUS_NOT_FOUND_MESSAGE);
                return;
            }
            String uri = ExternalProxyOverviewPage.this.fWorkingCopy.getExternalUri();
            if (uri == null) {
                ExternalProxyOverviewPage.this.fUriText.setText("");
            } else {
                ExternalProxyOverviewPage.this.fUriText.setText(uri);
            }
            ExternalProxyOverviewPage.this.fStatusText.setText(ExternalProxyOverviewPage.this.fWorkingCopy.getSyncStatusText());
            Control[] blockedByCompositeChildren = ExternalProxyOverviewPage.this.fBlockedByComposite.getChildren();
            if (blockedByCompositeChildren.length != 0) {
                blockedByCompositeChildren[0].dispose();
                ExternalProxyOverviewPage.this.fItemIdToHyperlinkMap.clear();
            }
            Composite blockingLinksComposite = ExternalProxyOverviewPage.this.fToolkit.createComposite(ExternalProxyOverviewPage.this.fBlockedByComposite);
            blockingLinksComposite.setLayout((Layout)new RowLayout(512));
            if (ExternalProxyOverviewPage.this.fWorkingCopy.isIncomingBlocked()) {
                iExternalProxyArray = ExternalProxyOverviewPage.this.fWorkingCopy.getIncomingBlocking();
                n2 = iExternalProxyArray.length;
                n = 0;
                while (n < n2) {
                    blockingProxy = iExternalProxyArray[n];
                    link = ExternalProxyOverviewPage.this.fToolkit.createHyperlink(blockingLinksComposite, ExternalProxyOverviewPage.this.getProxyLinkText(blockingProxy), 0);
                    link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            IWorkbenchPage page = ExternalProxyOverviewPage.this.getEditorSite().getPage();
                            ExternalProxyEditor.openEditor(page, blockingProxy);
                        }
                    });
                    ExternalProxyOverviewPage.this.fItemIdToHyperlinkMap.put(blockingProxy.getItemId(), link);
                    ++n;
                }
            }
            if (ExternalProxyOverviewPage.this.fWorkingCopy.isOutgoingBlocked()) {
                iExternalProxyArray = ExternalProxyOverviewPage.this.fWorkingCopy.getOutgoingBlocking();
                n2 = iExternalProxyArray.length;
                n = 0;
                while (n < n2) {
                    blockingProxy = iExternalProxyArray[n];
                    link = ExternalProxyOverviewPage.this.fToolkit.createHyperlink(blockingLinksComposite, ExternalProxyOverviewPage.this.getProxyLinkText(blockingProxy), 0);
                    link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            IWorkbenchPage page = ExternalProxyOverviewPage.this.getEditorSite().getPage();
                            ExternalProxyEditor.openEditor(page, blockingProxy);
                        }
                    });
                    ExternalProxyOverviewPage.this.fItemIdToHyperlinkMap.put(blockingProxy.getItemId(), link);
                    ++n;
                }
            }
            if (blockingLinksComposite.getChildren().length == 0) {
                ExternalProxyOverviewPage.this.fToolkit.createLabel(blockingLinksComposite, Messages.ExternalProxyOverviewPage_NOT_BLOCKED_STATUS);
            }
            ExternalProxyOverviewPage.this.fBlockedByComposite.layout(true, true);
            IExternalProxy.SynchronizationDirection syncDirection = proxy.getLastSynchronizationDirection();
            switch (syncDirection) {
                case INCOMING: {
                    syncDirectionText = Messages.ExternalProxyOverviewPage_SYNC_DIRECTION_INCOMING;
                    break;
                }
                case OUTGOING: {
                    syncDirectionText = Messages.ExternalProxyOverviewPage_SYNC_DIRECTION_OUTGOING;
                    break;
                }
                default: {
                    syncDirectionText = Messages.ExternalProxyOverviewPage_SYNC_DIRECTION_NONE;
                }
            }
            String syncTimeText = proxy.modified() == null ? Messages.ExternalProxyOverviewPage_UNKNOWN_MOD_TIME : DateFormat.getDateTimeInstance(3, 1).format(proxy.modified());
            String lastSyncInfo = proxy.getLastErrorString() == null || proxy.getLastErrorString().length() == 0 ? NLS.bind((String)Messages.ExternalProxyOverviewPage_LAST_SYNC_INFO_NO_ERROR, (Object)syncDirectionText, (Object[])new Object[]{syncTimeText}) : NLS.bind((String)Messages.ExternalProxyOverviewPage_LAST_SYNC_INFO_WITH_ERROR, (Object)syncDirectionText, (Object[])new Object[]{syncTimeText, proxy.getLastErrorString()});
            ExternalProxyOverviewPage.this.fLastSyncAttemptText.setText(lastSyncInfo);
            GridData gridData = (GridData)ExternalProxyOverviewPage.this.fLastSyncAttemptText.getLayoutData();
            int lineCount = ExternalProxyOverviewPage.this.fLastSyncAttemptText.getLineCount();
            gridData.heightHint = lineCount <= 10 ? -1 : ExternalProxyOverviewPage.this.fLastSyncAttemptText.getLineHeight() * 10;
            Composite textParent = ExternalProxyOverviewPage.this.fLastSyncAttemptText.getParent();
            Rectangle clientArea = textParent.getClientArea();
            Rectangle textBounds = ExternalProxyOverviewPage.this.fLastSyncAttemptText.getBounds();
            gridData.widthHint = clientArea.width - textBounds.x - 100;
            ISyncRule syncRule = ExternalProxyOverviewPage.this.fWorkingCopy.getSyncRule();
            if (syncRule == null) {
                ExternalProxyOverviewPage.this.fSyncRuleLink.setText("");
            } else {
                ExternalProxyOverviewPage.this.fSyncRuleLink.setText(syncRule.getName());
            }
            if (ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemHandle() == null) {
                ExternalProxyOverviewPage.this.fItemLink.setText("");
            } else if (ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemHandle().hasFullState()) {
                Object value;
                String idPropName;
                IItem item = ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemHandle().getFullState();
                String label = ExternalProxyOverviewPage.this.fLabelProvider.getText((Object)item);
                if (label == null && (idPropName = ((ItemType)item.getItemType()).idPropertyName()) != null && (value = ((Item)item).getPropertyValue(idPropName)) != null) {
                    label = value.toString();
                }
                if (label == null) {
                    label = "";
                }
                ExternalProxyOverviewPage.this.fItemLink.setText(NLS.bind((String)Messages.ExternalProxyOverviewPage_ITEM_LINK_TEXT, (Object)item.getItemType().getName(), (Object[])new Object[]{label}));
                ExternalProxyOverviewPage.this.fItemLink.setUnderlined(true);
            } else {
                String errorMessage = ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemError() instanceof ItemNotFoundException ? NLS.bind((String)Messages.ExternalProxyOverviewPage_ERROR_ITEM_NOT_FOUND, (Object)ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemHandle().getItemId().getUuidValue(), (Object[])new Object[0]) : NLS.bind((String)Messages.ExternalProxyOverviewPage_ERROR_RESOLVING_ITEM, (Object)ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemHandle().getItemId().getUuidValue(), (Object[])new Object[]{ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemError() == null ? "" : ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemError().toString()});
                ExternalProxyOverviewPage.this.fItemLink.setText(errorMessage);
                ExternalProxyOverviewPage.this.fItemLink.setUnderlined(false);
            }
            ExternalProxyOverviewPage.this.fCycleCountText.setText(Integer.toString(proxy.getCycleCount()));
            ExternalProxyOverviewPage.this.fStateTableViewer.refresh();
            boolean isConflict = proxy.getSynchronizationStatus() == IExternalProxy.SynchronizationStatus.CONFLICT;
            ExternalProxyOverviewPage.this.fAcceptExternalStateButton.setVisible(isConflict);
            ExternalProxyOverviewPage.this.fAcceptExternalStateButton.setEnabled(isConflict);
            ExternalProxyOverviewPage.this.fAcceptItemStateButton.setVisible(isConflict);
            ExternalProxyOverviewPage.this.fAcceptItemStateButton.setEnabled(isConflict);
            boolean raw = ExternalProxyOverviewPage.this.fShowRawDataButton.getSelection();
            Map externalState = ExternalProxyOverviewPage.this.fWorkingCopy.getExternalState(raw);
            Map itemState = ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemState(raw);
            boolean enableIncomingRetry = externalState != null;
            boolean enableOutgoingRetry = itemState != null;
            ExternalProxyOverviewPage.this.fRetryIncomingSyncButton.setEnabled(enableIncomingRetry);
            ExternalProxyOverviewPage.this.fRetryOutgoingSyncButton.setEnabled(enableOutgoingRetry);
            ExternalProxyOverviewPage.this.fForm.reflow(true);
        }
    };
    private final ILabelProviderListener fLabelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements != null) {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof IExternalProxy) {
                        IExternalProxy proxy = (IExternalProxy)element;
                        Hyperlink link = (Hyperlink)ExternalProxyOverviewPage.this.fItemIdToHyperlinkMap.get(proxy.getItemId());
                        if (link != null) {
                            String text = ExternalProxyOverviewPage.this.getProxyLinkText(proxy);
                            link.setText(text);
                            link.setToolTipText(text);
                        }
                    }
                    ++n2;
                }
                ExternalProxyOverviewPage.this.fBlockedByComposite.layout(true, true);
            }
        }
    };
    private static final String PAGE_ID = "com.ibm.team.interop.ide.ui.ExternalProxyEditor.Overview";
    private static final String PAGE_TITLE = Messages.ExternalProxyOverviewPage_OVERVIEW_PAGE_TITLE;
    private static final int MAX_TEXT_LINES = 10;
    private static final String EMPTY = new String();
    private static final int ITEM_PROPERTY_COLUMN = 0;
    private static final String ITEM_PROPERTY_COLUMN_NAME = Messages.ExternalProxyOverviewPage_ITEM_PROPERTY_COLUMN_HEADER;
    private static final int ITEM_VALUE_COLUMN = 1;
    private static final String ITEM_VALUE_COLUMN_NAME = Messages.ExternalProxyOverviewPage_ITEM_VALUE_COLUMN_HEADER;
    private static final int EXTERNAL_PROPERTY_COLUMN = 2;
    private static final String EXTERNAL_PROPERTY_COLUMN_NAME = Messages.ExternalProxyOverviewPage_EXTERNAL_PROPERTY_COLUMN_HEADER;
    private static final int EXTERNAL_VALUE_COLUMN = 3;
    private static final String EXTERNAL_VALUE_COLUMN_NAME = Messages.ExternalProxyOverviewPage_EXTERNAL_VALUE_COLUMN_HEADER;
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(0, 16384, (ColumnLayoutData)new ColumnWeightData(15, true), ITEM_PROPERTY_COLUMN_NAME, null), new TableColumnInfo(1, 16384, (ColumnLayoutData)new ColumnWeightData(35, true), ITEM_VALUE_COLUMN_NAME, null), new TableColumnInfo(2, 16384, (ColumnLayoutData)new ColumnWeightData(15, true), EXTERNAL_PROPERTY_COLUMN_NAME, null), new TableColumnInfo(3, 16384, (ColumnLayoutData)new ColumnWeightData(35, true), EXTERNAL_VALUE_COLUMN_NAME, null)};
    private final ExternalProxyWorkingCopy fWorkingCopy;
    private final ResourceManager fResourceManager;
    private final StandardLabelProvider fLabelProvider;
    private final Map<UUID, Hyperlink> fItemIdToHyperlinkMap = new HashMap<UUID, Hyperlink>();
    private FormToolkit fToolkit;
    private ScrolledForm fForm;
    private Composite fStatusComposite;
    private Label fUriText;
    private Label fStatusText;
    private Composite fBlockedByComposite;
    private Text fLastSyncAttemptText;
    private Label fCycleCountText;
    private Table fStateTable;
    private TableViewer fStateTableViewer;
    private Hyperlink fItemLink;
    private Hyperlink fSyncRuleLink;
    private Button fRetryIncomingSyncButton;
    private Button fRetryOutgoingSyncButton;
    private Button fAcceptExternalStateButton;
    private Button fAcceptItemStateButton;
    private Button fShowRawDataButton;

    public ExternalProxyOverviewPage(FormEditor editor, ExternalProxyWorkingCopy workingCopy, ResourceManager resourceManager) {
        super(editor, PAGE_ID, PAGE_TITLE);
        this.fWorkingCopy = workingCopy;
        this.fResourceManager = resourceManager;
        this.fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.fLabelProvider.addListener(this.fLabelProviderListener);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fToolkit = this.getManagedForm().getToolkit();
        this.fForm = managedForm.getForm();
        Composite formComposite = this.fForm.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(formComposite);
        Section section = this.createSection(this.fToolkit, formComposite, 450, Messages.ExternalProxyOverviewPage_STATUS_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        this.fStatusComposite = this.fToolkit.createComposite((Composite)section);
        section.setClient((Control)this.fStatusComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fStatusComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(10, 0).spacing(LayoutConstants.getSpacing()).applyTo(this.fStatusComposite);
        this.fToolkit.createLabel(this.fStatusComposite, Messages.ExternalProxyOverviewPage_EXTERNAL_URI_LABEL);
        this.fUriText = this.fToolkit.createLabel(this.fStatusComposite, "");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fUriText);
        this.fToolkit.createLabel(this.fStatusComposite, Messages.ExternalProxyOverviewPage_LINKED_ITEM_LABEL);
        this.fItemLink = this.fToolkit.createHyperlink(this.fStatusComposite, "", 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fItemLink);
        this.fItemLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemHandle() != null && ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemHandle().hasFullState()) {
                    Location location = Location.itemLocation((IItemHandle)ExternalProxyOverviewPage.this.fWorkingCopy.getLinkedItemHandle(), (String)ExternalProxyOverviewPage.this.fWorkingCopy.getRepository().getRepositoryURI());
                    Hyperlinks.open((URI)location.toAbsoluteUri(), null);
                }
            }
        });
        this.fToolkit.createLabel(this.fStatusComposite, Messages.ExternalProxyOverviewPage_SYNC_STATUS_LABEL);
        this.fStatusText = this.fToolkit.createLabel(this.fStatusComposite, "");
        GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)this.fStatusText);
        this.fRetryIncomingSyncButton = this.fToolkit.createButton(this.fStatusComposite, Messages.ExternalProxyOverviewPage_RETRY_INCOMING_BUTTON_LABEL, 8);
        this.fRetryIncomingSyncButton.setEnabled(false);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)this.fRetryIncomingSyncButton);
        this.fRetryIncomingSyncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalProxyOverviewPage.this.disableActionButtons();
                ExternalProxyOverviewPage.this.fWorkingCopy.synchronizeIncoming();
            }
        });
        this.fRetryOutgoingSyncButton = this.fToolkit.createButton(this.fStatusComposite, Messages.ExternalProxyOverviewPage_RETRY_OUTGOING_BUTTON_LABEL, 8);
        this.fRetryOutgoingSyncButton.setEnabled(false);
        GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)this.fRetryOutgoingSyncButton);
        this.fRetryOutgoingSyncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalProxyOverviewPage.this.disableActionButtons();
                ExternalProxyOverviewPage.this.fWorkingCopy.synchronizeOutgoing();
            }
        });
        Label label = this.fToolkit.createLabel(this.fStatusComposite, Messages.ExternalProxyOverviewPage_BLOCKED_LABEL);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)label);
        this.fBlockedByComposite = this.fToolkit.createComposite(this.fStatusComposite);
        this.fBlockedByComposite.setLayout((Layout)new FillLayout());
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fBlockedByComposite);
        label = this.fToolkit.createLabel(this.fStatusComposite, Messages.ExternalProxyOverviewPage_LAST_SYNC_ATTEMPT_LABEL);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)label);
        this.fLastSyncAttemptText = this.fToolkit.createText(this.fStatusComposite, "", 17226);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fLastSyncAttemptText);
        this.fToolkit.createLabel(this.fStatusComposite, Messages.ExternalProxyOverviewPage_SYNC_RULE_LABEL);
        this.fSyncRuleLink = this.fToolkit.createHyperlink(this.fStatusComposite, "", 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fSyncRuleLink);
        this.fSyncRuleLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ISyncRule syncRule = ExternalProxyOverviewPage.this.fWorkingCopy.getSyncRule();
                if (syncRule != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    SyncRuleEditor.openEditor(page, syncRule, ExternalProxyOverviewPage.this.fWorkingCopy.getRepository(), null);
                }
            }
        });
        this.fToolkit.createLabel(this.fStatusComposite, Messages.ExternalProxyOverviewPage_CYCLE_COUNT_LABEL);
        this.fCycleCountText = this.fToolkit.createLabel(this.fStatusComposite, "");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.fCycleCountText);
        Section stateSection = this.createSection(this.fToolkit, formComposite, 450, Messages.ExternalProxyOverviewPage_CURRENT_STATE_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)stateSection);
        stateSection.marginHeight = 0;
        stateSection.marginWidth = 0;
        stateSection.setDescription(Messages.ExternalProxyOverviewPage_CURRENT_STATE_SECTION_DESCRIPTION);
        Composite stateComposite = this.fToolkit.createComposite((Composite)stateSection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)stateComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(10, 0).spacing(LayoutConstants.getSpacing()).applyTo(stateComposite);
        stateSection.setClient((Control)stateComposite);
        Composite stateDataComposite = this.fToolkit.createComposite(stateComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)stateDataComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(LayoutConstants.getSpacing()).applyTo(stateDataComposite);
        this.fShowRawDataButton = this.fToolkit.createButton(stateDataComposite, Messages.ExternalProxyOverviewPage_RAW_DATA_BUTTON_LABEL, 32);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.fShowRawDataButton);
        this.fShowRawDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalProxyOverviewPage.this.fStateTableViewer.refresh();
            }
        });
        this.fStateTableViewer = new ConstrainedTableViewer(this.fToolkit, stateDataComposite, 84738, false);
        this.fStateTable = this.fStateTableViewer.getTable();
        this.fStateTable.setHeaderVisible(true);
        this.fStateTable.setLinesVisible(true);
        this.fStateTable.setEnabled(true);
        TableColumnInfo.createColumns(this.fStateTable, COLUMN_INFO, this.fResourceManager);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fStateTable);
        this.fStateTableViewer.setContentProvider((IContentProvider)new StateTableContentProvider());
        this.fStateTableViewer.setLabelProvider((IBaseLabelProvider)new StateTableLabelProvider(this.fLabelProvider));
        this.fStateTableViewer.setComparator(this.fStateTableViewerComparator);
        this.fStateTable.getColumn(0).addSelectionListener(this.fColumnSortListener);
        this.fStateTable.getColumn(2).addSelectionListener(this.fColumnSortListener);
        this.fStateTable.setSortColumn(this.fStateTable.getColumn(0));
        this.fStateTable.setSortDirection(128);
        ConstrainedTableViewer.hookResizeHandler((Composite)section, this.fStateTable, COLUMN_INFO);
        Composite buttonComposite = this.fToolkit.createComposite(stateComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 0).spacing(LayoutConstants.getSpacing()).applyTo(buttonComposite);
        this.fAcceptExternalStateButton = this.fToolkit.createButton(buttonComposite, Messages.ExternalProxyOverviewPage_ACCEPT_EXTERNAL_STATE_BUTTON_LABEL, 8);
        this.fAcceptExternalStateButton.setEnabled(false);
        this.fAcceptExternalStateButton.setVisible(false);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.fAcceptExternalStateButton);
        this.fAcceptExternalStateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalProxyOverviewPage.this.disableActionButtons();
                ExternalProxyOverviewPage.this.fWorkingCopy.acceptExternalStateAsMerged();
            }
        });
        this.fAcceptItemStateButton = this.fToolkit.createButton(buttonComposite, Messages.ExternalProxyOverviewPage_ACCEPT_ITEM_STATE_BUTTON_LABEL, 8);
        this.fAcceptItemStateButton.setEnabled(false);
        this.fAcceptItemStateButton.setVisible(false);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.fAcceptItemStateButton);
        this.fAcceptItemStateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalProxyOverviewPage.this.disableActionButtons();
                ExternalProxyOverviewPage.this.fWorkingCopy.acceptItemStateAsMerged();
            }
        });
        this.fWorkingCopy.addListener(this.fChangeListener);
        this.fStateTableViewer.setInput((Object)this.fWorkingCopy);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)formComposite, "com.ibm.team.interop.ide.ui.syncStatusDisplayOverview");
    }

    public void dispose() {
        this.fWorkingCopy.removeListener(this.fChangeListener);
        this.fLabelProvider.dispose();
        super.dispose();
    }

    private Section createSection(FormToolkit toolkit, Composite parent, int style, String title) {
        Section section = toolkit.createSection(parent, style | 0x2000);
        section.setText(title);
        return section;
    }

    private void disableActionButtons() {
        this.fRetryIncomingSyncButton.setEnabled(false);
        this.fRetryOutgoingSyncButton.setEnabled(false);
        this.fAcceptExternalStateButton.setEnabled(false);
        this.fAcceptItemStateButton.setEnabled(false);
    }

    private String getProxyLinkText(IExternalProxy proxy) {
        return this.fLabelProvider.getText((Object)proxy);
    }

    private class StateTableContentProvider
    implements IStructuredContentProvider {
        private ExternalProxyWorkingCopy fWorkingCopy;

        private StateTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.fWorkingCopy == null) {
                return new Object[0];
            }
            ISyncRule syncRule = this.fWorkingCopy.getSyncRule();
            if (syncRule == null) {
                return new Object[0];
            }
            boolean raw = ExternalProxyOverviewPage.this.fShowRawDataButton.getSelection();
            Map externalState = this.fWorkingCopy.getExternalState(raw);
            Map itemState = this.fWorkingCopy.getLinkedItemState(raw);
            Map itemDisplayNames = this.fWorkingCopy.getLinkedItemPropertyDisplayNamesMap();
            List mappings = syncRule.getPropertyMappings();
            ArrayList<StateTableElement> elements = new ArrayList<StateTableElement>(mappings.size());
            for (IPropertyMapping iPropertyMapping : mappings) {
                Object itemPropertyValue;
                String externalPropertyName = iPropertyMapping.getExternalPropertyName();
                String itemPropertyName = iPropertyMapping.getItemPropertyName();
                Object externalPropertyValue = externalPropertyName == null || externalState == null ? null : externalState.get(externalPropertyName);
                Object v0 = itemPropertyValue = itemPropertyName == null || itemState == null ? null : itemState.get(itemPropertyName);
                if (itemDisplayNames != null && itemDisplayNames.get(itemPropertyName) != null) {
                    itemPropertyName = (String)itemDisplayNames.get(itemPropertyName);
                }
                elements.add(new StateTableElement(externalPropertyName, externalPropertyValue, itemPropertyName, itemPropertyValue));
            }
            if (externalState != null) {
                for (Map.Entry entry : externalState.entrySet()) {
                    if (syncRule.getExternalPropertyMapping((String)entry.getKey()) != null) continue;
                    elements.add(new StateTableElement((String)entry.getKey(), entry.getValue(), null, null));
                }
            }
            return elements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof ExternalProxyWorkingCopy) {
                this.fWorkingCopy = (ExternalProxyWorkingCopy)newInput;
            }
        }
    }

    private static class StateTableElement
    extends PlatformObject {
        final String fExternalPropertyName;
        final Object fExternalPropertyValue;
        final String fItemPropertyName;
        final Object fItemPropertyValue;

        public StateTableElement(String externalPropertyName, Object externalPropertyValue, String itemPropertyName, Object itemPropertyValue) {
            this.fExternalPropertyName = externalPropertyName;
            this.fExternalPropertyValue = externalPropertyValue;
            this.fItemPropertyName = itemPropertyName;
            this.fItemPropertyValue = itemPropertyValue;
        }
    }

    private static class StateTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final StandardLabelProvider fStdLabelProvider;

        public StateTableLabelProvider(StandardLabelProvider stdLabelProvider) {
            this.fStdLabelProvider = stdLabelProvider;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof StateTableElement)) {
                return null;
            }
            StateTableElement tableElement = (StateTableElement)((Object)element);
            Object value = null;
            switch (columnIndex) {
                case 2: {
                    return tableElement.fExternalPropertyName;
                }
                case 3: {
                    value = tableElement.fExternalPropertyValue;
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof Collection) {
                        return NLS.bind((String)Messages.ExternalProxyOverviewPage_REFERENCE_VALUE, (Object)StateTableLabelProvider.getItemCollectionText((Collection)value, this.fStdLabelProvider), (Object[])new Object[0]);
                    }
                    if (value instanceof IItem) {
                        return NLS.bind((String)Messages.ExternalProxyOverviewPage_REFERENCE_VALUE, (Object)StateTableLabelProvider.getItemText((IItem)value, this.fStdLabelProvider), (Object[])new Object[0]);
                    }
                    return value.toString();
                }
                case 0: {
                    return tableElement.fItemPropertyName;
                }
                case 1: {
                    value = tableElement.fItemPropertyValue;
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof Collection) {
                        return NLS.bind((String)Messages.ExternalProxyOverviewPage_REFERENCE_VALUE, (Object)StateTableLabelProvider.getItemCollectionText((Collection)value, this.fStdLabelProvider), (Object[])new Object[0]);
                    }
                    if (value instanceof IItem) {
                        return NLS.bind((String)Messages.ExternalProxyOverviewPage_REFERENCE_VALUE, (Object)StateTableLabelProvider.getItemText((IItem)value, this.fStdLabelProvider), (Object[])new Object[0]);
                    }
                    return value.toString();
                }
            }
            return null;
        }

        static String getItemText(IItem item, StandardLabelProvider stdLabelProvider) {
            String itemText = item instanceof IExternalProxy ? ((IExternalProxy)item).getExternalIdHint() : stdLabelProvider.getText((Object)item);
            if (itemText == null) {
                itemText = item.getItemType().getName();
            }
            return itemText;
        }

        static String getItemCollectionText(Collection items, StandardLabelProvider stdLabelProvider) {
            StringBuilder s = new StringBuilder();
            Iterator iterator = items.iterator();
            while (iterator.hasNext()) {
                Object item;
                if (s.length() > 0) {
                    s.append(' ');
                }
                if ((item = iterator.next()) instanceof IItem) {
                    s.append(StateTableLabelProvider.getItemText((IItem)item, stdLabelProvider));
                    continue;
                }
                s.append(item.toString());
            }
            return s.toString();
        }
    }
}

