/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal.editors;

import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.editors.ExternalProxyEditorHeader;
import com.ibm.team.interop.ide.ui.internal.editors.ExternalProxyEditorInput;
import com.ibm.team.interop.ide.ui.internal.editors.ExternalProxyOverviewPage;
import com.ibm.team.interop.ide.ui.internal.editors.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.ui.editor.TeamFormEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class ExternalProxyEditor
extends TeamFormEditor {
    private ExternalProxyEditorHeader fHeader;
    private ExternalProxyOverviewPage fOverviewPage;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static void openEditor(IWorkbenchPage page, IExternalProxy proxy) {
        ExternalProxyEditor.openEditor(page, (ITeamRepository)proxy.getOrigin(), proxy.getItemId(), null);
    }

    public static void openEditor(IWorkbenchPage page, ITeamRepository repository, UUID itemId, UUID stateId) {
        ExternalProxyEditorInput input = new ExternalProxyEditorInput(repository, itemId);
        try {
            page.openEditor((IEditorInput)input, "com.ibm.team.interop.externalProxyEditor");
        }
        catch (PartInitException e) {
            InteropIdeUIPlugin.getDefault().log(Messages.ExternalProxyEditor_ERROR_OPENING_SYNC_STATUS, e);
        }
    }

    public void dispose() {
        ExternalProxyEditorInput input = (ExternalProxyEditorInput)this.getEditorInput();
        input.getWorkingCopy().dispose();
        this.fResourceManager.dispose();
        super.dispose();
    }

    protected void createPages() {
        super.createPages();
        ExternalProxyEditorInput input = (ExternalProxyEditorInput)this.getEditorInput();
        try {
            input.getWorkingCopy().revert(null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.ExternalProxyEditor_ERROR_RELOADING_STATUS, null, (IStatus)e.getStatus());
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        ExternalProxyEditorInput input = (ExternalProxyEditorInput)this.getEditorInput();
        this.fHeader = new ExternalProxyEditorHeader((IEditorPart)this, headerForm, input.getWorkingCopy(), this.fResourceManager);
        headerForm.addPart((IFormPart)this.fHeader);
    }

    protected void addPages() {
        this.createOverviewPage();
        this.setPartName(this.getEditorInput().getName());
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void createOverviewPage() {
        ExternalProxyEditorInput input = (ExternalProxyEditorInput)this.getEditorInput();
        try {
            this.fOverviewPage = new ExternalProxyOverviewPage((FormEditor)this, input.getWorkingCopy(), this.fResourceManager);
            this.addPage((IFormPage)this.fOverviewPage);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.ExternalProxyEditor_ERROR_CREATING_OVERVIEW_PAGE, null, (IStatus)e.getStatus());
        }
    }
}

