/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.interop.common.IExternalProxy;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.interop.common.ISyncRule;
import com.ibm.team.interop.common.ISyncRuleHandle;
import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.Messages;
import com.ibm.team.interop.ide.ui.internal.editors.ExternalProxyEditor;
import com.ibm.team.interop.ide.ui.internal.editors.SyncRuleEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;

public class InteropHyperlinkHandler
extends HyperlinkHandler {
    public boolean handles(URI uri) {
        try {
            return this.parseURI(uri, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public IStatus open2(URI uri, ContextProvider context, IProgressMonitor monitor) {
        try {
            StringBuilder repositoryURI = new StringBuilder();
            final IItemHandle itemHandle = this.parseURI(uri, repositoryURI);
            if (itemHandle == null) {
                return Status.OK_STATUS;
            }
            final ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI.toString(), monitor);
            ISyncRule localSyncRule = null;
            if (itemHandle instanceof ISyncRuleHandle) {
                localSyncRule = (ISyncRule)repository.itemManager().fetchCompleteItem(itemHandle, 1, monitor);
            }
            final ISyncRule syncRule = localSyncRule;
            final IWorkbenchPage page = InteropIdeUIPlugin.getWorkbenchPage();
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (syncRule != null) {
                        SyncRuleEditor.openEditor(page, syncRule, repository, null);
                    } else if (itemHandle instanceof IExternalProxyHandle) {
                        ExternalProxyEditor.openEditor(page, repository, itemHandle.getItemId(), itemHandle.getStateId());
                    }
                }
            });
        }
        catch (Exception e) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.InteropHyperlinkHandler_ERROR_OPENING_HYPERLINK, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private IItemHandle parseURI(URI uri, StringBuilder repositoryPart) {
        Location location;
        block4: {
            try {
                location = Location.location((URI)uri);
                IItemType itemType = location.getItemType();
                if (itemType != null && (IExternalProxy.ITEM_TYPE.equals(itemType) || ISyncRule.ITEM_TYPE.equals(itemType))) break block4;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (repositoryPart != null) {
            repositoryPart.append(location.getRepoUri());
        }
        return location.getItemHandle();
    }
}

