/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.interop.ide.ui.InteropIdeUIPlugin;
import com.ibm.team.interop.ide.ui.internal.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportSyncRulesDialog {
    private static final String IMPORT_DIALOG_SETTINGS = "importSyncRules";
    private static final String SETTINGS_DIRECTORY_KEY = "directoryPath";
    private final Shell fShell;
    private final boolean fMulti;

    public ImportSyncRulesDialog(Shell shell, boolean multi) {
        this.fShell = shell;
        this.fMulti = multi;
    }

    public List<File> open() {
        String defaultDirectoryPath = null;
        IDialogSettings allSettings = InteropIdeUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = allSettings.getSection(IMPORT_DIALOG_SETTINGS);
        if (settings == null) {
            settings = allSettings.addNewSection(IMPORT_DIALOG_SETTINGS);
        } else {
            defaultDirectoryPath = settings.get(SETTINGS_DIRECTORY_KEY);
        }
        FileDialog fileDialog = new FileDialog(this.fShell, this.fMulti ? 2 : 0);
        fileDialog.setFilterExtensions(new String[]{"*.xml"});
        fileDialog.setText(Messages.ImportSyncRulesDialog_FILE_DIALOG_TITLE);
        fileDialog.setFilterPath(defaultDirectoryPath);
        if (fileDialog.open() == null) {
            return null;
        }
        String[] fileNames = fileDialog.getFileNames();
        if (fileNames == null || fileNames.length == 0) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        String directory = fileDialog.getFilterPath();
        settings.put(SETTINGS_DIRECTORY_KEY, fileDialog.getFilterPath());
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            files.add(new File(directory, fileName));
            ++n2;
        }
        return files;
    }
}

