/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.ide.ui.internal;

import com.ibm.team.interop.ide.ui.internal.ExternalRepositoryConnectionProperties;
import com.ibm.team.interop.ide.ui.internal.Messages;
import com.ibm.team.interop.rcp.ui.internal.ExternalRepositoryConnectionWorkingCopy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExternalRepositoryConnectionDialog
extends TitleAreaDialog {
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ExternalRepositoryConnectionDialog.this.updateButtons();
        }
    };
    private final ExternalRepositoryConnectionWorkingCopy fWorkingCopy;
    private ExternalRepositoryConnectionProperties fProperties;

    public ExternalRepositoryConnectionDialog(Shell parentShell, ExternalRepositoryConnectionWorkingCopy workingCopy, ResourceManager resourceManager) {
        super(parentShell);
        this.fWorkingCopy = workingCopy;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.ExternalRepositoryConnectionDialog_DIALOG_TITLE);
        if (this.fWorkingCopy.getExternalRepositoryConnection().isNewItem()) {
            this.setMessage(Messages.ExternalRepositoryConnectionDialog_CREATE_MESSAGE);
        } else {
            this.setMessage(Messages.ExternalRepositoryConnectionDialog_EDIT_MESSAGE);
        }
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.fProperties = new ExternalRepositoryConnectionProperties(composite);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.team.interop.ide.ui.externalRepositoryConnectionDialog");
        this.revert();
        this.refresh();
        this.fProperties.addRequiredPropertiesModifyListener(this.fModifyListener);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fWorkingCopy.getExternalRepositoryConnection().isNewItem()) {
            newShell.setText(Messages.ExternalRepositoryConnectionDialog_CREATE_SHELL_TITLE);
        } else {
            newShell.setText(Messages.ExternalRepositoryConnectionDialog_EDIT_SHELL_TITLE);
        }
    }

    protected void okPressed() {
        this.commit();
        super.okPressed();
    }

    private void revert() {
        Job job = new Job(Messages.ExternalRepositoryConnectionDialog_FETCH_EXTERNAL_CONNECTION_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                ExternalRepositoryConnectionDialog.this.fWorkingCopy.revert(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.fWorkingCopy.getStatus() != null && !this.fWorkingCopy.getStatus().isOK()) {
            this.setErrorMessage(this.fWorkingCopy.getStatus().getMessage());
        }
    }

    private void refresh() {
        this.fProperties.refresh(this.fWorkingCopy);
    }

    private void commit() {
        this.fProperties.commit(this.fWorkingCopy);
    }

    private void updateButtons() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            boolean enabled = this.fWorkingCopy.isLicensed() && this.fProperties != null && this.fProperties.requiredPropertiesSet();
            okButton.setEnabled(enabled);
        }
    }
}

