/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.search;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.ide.ui.internal.ResultItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IMemento;

public class ResultFilter
extends ViewerFilter {
    private static final String PREF_FILTER_BY_SCORE = "com.ibm.team.fulltext.ide.ui.internal.search.PrefFilterByScore";
    private static final String PREF_FILTER_BY_RESULT = "com.ibm.team.fulltext.ide.ui.internal.search.PrefFilterByResult";
    private long fFilterByScore = 0L;
    private int fFilterByResultCount = 0;
    private String fFilterText;

    public void loadFrom(IMemento memento) {
        Integer filterByResultCount;
        if (memento == null) {
            return;
        }
        Integer filterByScore = memento.getInteger(PREF_FILTER_BY_SCORE);
        if (filterByScore != null) {
            this.fFilterByScore = filterByScore.intValue();
        }
        if ((filterByResultCount = memento.getInteger(PREF_FILTER_BY_RESULT)) != null) {
            this.fFilterByResultCount = filterByResultCount;
        }
    }

    public void saveTo(IMemento memento) {
        memento.putInteger(PREF_FILTER_BY_RESULT, this.fFilterByResultCount);
        memento.putInteger(PREF_FILTER_BY_SCORE, (int)this.fFilterByScore);
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        ArrayList selectedObjects = new ArrayList();
        ArrayList<Object> sortedInputElements = new ArrayList<Object>();
        sortedInputElements.addAll(Arrays.asList(elements));
        if (this.fFilterByResultCount > 0) {
            Collections.sort(sortedInputElements, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    ResultItem item1 = (ResultItem)o1;
                    ResultItem item2 = (ResultItem)o2;
                    return item2.getResult().getScore() > item1.getResult().getScore() ? 1 : -1;
                }
            });
        }
        int i = 0;
        while (i < sortedInputElements.size()) {
            Object obj = sortedInputElements.get(i);
            if (this.select(viewer, parent, obj)) {
                if (this.fFilterByResultCount > 0 && selectedObjects.size() == this.fFilterByResultCount) break;
                selectedObjects.add(obj);
            }
            ++i;
        }
        return selectedObjects.toArray();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ResultItem item = (ResultItem)element;
        if (this.fFilterByScore != 0L && item.getResult().getScore() <= this.fFilterByScore) {
            return false;
        }
        if (this.fFilterText != null && this.fFilterText.length() > 0) {
            Collection<ResultItem> children = item.getChildren();
            if (this.matches(item, this.fFilterText)) {
                return true;
            }
            if (children != null) {
                for (ResultItem child : children) {
                    if (!this.matches(child, this.fFilterText)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean matches(ResultItem item, String pattern) {
        String details;
        URIReference result = item.getResult().getResult();
        String name = result.getName().toLowerCase();
        String string = details = result.getDetails() != null ? result.getDetails().toLowerCase() : null;
        return name.contains(pattern.toLowerCase()) || details != null && details.contains(pattern.toLowerCase());
    }

    public boolean isFiltering() {
        return this.fFilterByScore > 0L || this.fFilterByResultCount > 0 || this.fFilterText != null && this.fFilterText.length() > 0;
    }

    public String getFilterText() {
        return this.fFilterText;
    }

    public long getFilterByScore() {
        return this.fFilterByScore;
    }

    public void setFilterByScore(long filterByScore) {
        this.fFilterByScore = filterByScore;
    }

    public void setFilterText(String filterText) {
        this.fFilterText = filterText;
    }

    public int getFilterByResultCount() {
        return this.fFilterByResultCount;
    }

    public void setFilterByResultCount(int filterByResultCount) {
        this.fFilterByResultCount = filterByResultCount;
    }
}

