/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.search;

import com.ibm.icu.text.NumberFormat;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.fulltext.ide.ui.internal.FulltextUIPlugin;
import com.ibm.team.fulltext.ide.ui.internal.QuickFilter;
import com.ibm.team.fulltext.ide.ui.internal.ResultItem;
import com.ibm.team.fulltext.ide.ui.internal.ResultModel;
import com.ibm.team.fulltext.ide.ui.internal.ResultUtils;
import com.ibm.team.fulltext.ide.ui.internal.search.ArtifactSearchQuery;
import com.ibm.team.fulltext.ide.ui.internal.search.ArtifactSearchResult;
import com.ibm.team.fulltext.ide.ui.internal.search.Messages;
import com.ibm.team.fulltext.ide.ui.internal.search.ResultContentProvider;
import com.ibm.team.fulltext.ide.ui.internal.search.ResultFilter;
import com.ibm.team.fulltext.ide.ui.internal.search.ResultLabelProvider;
import com.ibm.team.fulltext.ide.ui.internal.search.ResultSorter;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

public class ArtifactSearchResultPage
implements ISearchResultPage,
ISearchResultListener {
    private static final String MEMENTO_DIALOG_SETTINGS = "memento";
    private static final String MEMENTO_RESULT_PAGE = "resultpage";
    private static final String PAGE_ID = "com.ibm.team.fulltext.ide.ui.internal.search.ArtifactSearchResultPage";
    private static final String PREF_COL_ORDER_MEMENTO = "com.ibm.team.fulltext.ide.ui.internal.search.PrefColOrderMemento";
    private static final String PREF_COL_ORDER = "com.ibm.team.fulltext.ide.ui.internal.search.PrefColOrder";
    private static final String PREF_COL_RATIO_MEMENTO = "com.ibm.team.fulltext.ide.ui.internal.search.PrefColRatioMemento";
    private static final String PREF_COL_RATIO = "com.ibm.team.fulltext.ide.ui.internal.search.PrefColRatio";
    private static final String DOWN_ID = "com.ibm.team.fulltext.ide.ui.internal.search.Down";
    private static final String UP_ID = "com.ibm.team.fulltext.ide.ui.internal.search.Up";
    private static final String FIND_RELATED_ID = "com.ibm.team.fulltext.ide.ui.internal.search.FindRelated";
    private static final String FIND_DUPLICATE_ID = "com.ibm.team.fulltext.ide.ui.internal.search.FindDuplicate";
    private static final String REMOVE_FILTERS_ID = "com.ibm.team.fulltext.ide.ui.internal.search.ShowAll";
    private IPageSite fSite;
    private Composite fPageContainer;
    private String fId;
    private IActionBars fActionBars;
    private TreeViewer fViewer;
    private ISearchResult fSearchResult;
    private ITeamRepository fSelectedRepository;
    private Link fStatusLink;
    private Action fFindRelatedAction;
    private Action fFindDuplicateAction;
    private Action fOpenPreviousAction;
    private Action fOpenNextAction;
    private final NumberFormat fCachedFormat = NumberFormat.getPercentInstance();
    private ResultFilter fResultFilter;
    private IMemento fMemento;
    private ResultLabelProvider fResultLabelProvider;
    private int[] fCachedColumnOrder;
    private int[] fCachedColumnRatio = new int[]{40, 5, 15, 40};
    private Action fExpandAction;
    private Action fCollapseAction;
    private Action fFindAction;
    private boolean fBlockResize;
    private QuickFilter fQuickFilter;
    private URIReference fCurrentDropData;
    private ISearchResultViewPart fViewPart;
    private ResultToReferenceConverter fResultToReferenceConverter;
    private FilterAction fFilterAction;

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        return "";
    }

    public Object getUIState() {
        return null;
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void setID(String id) {
        this.fId = id;
    }

    public void setInput(ISearchResult result, Object uiState) {
        Assert.isTrue((result instanceof ArtifactSearchResult || result == null ? 1 : 0) != 0);
        if (this.fSearchResult != null) {
            this.fSearchResult.removeListener((ISearchResultListener)this);
        }
        this.fSearchResult = result;
        if (this.fSearchResult != null) {
            this.fSelectedRepository = ((ArtifactSearchResult)this.fSearchResult).getRepository();
            this.fSearchResult.addListener((ISearchResultListener)this);
            this.fViewer.setInput((Object)new ResultModel(((ArtifactSearchResult)this.fSearchResult).getResults()));
            this.updateStatusLink();
        } else {
            this.fSelectedRepository = null;
            this.fStatusLink.setText("");
        }
    }

    private void updateStatusLink() {
        String label = ((ArtifactSearchResult)this.fSearchResult).getLinkLabel();
        if (this.fResultFilter.isFiltering()) {
            TreeItem[] treeitems;
            IScoredResult[] items = ((ArtifactSearchResult)this.fSearchResult).getResults();
            int allItemsCount = items.length;
            AtomicInteger visibleItemCount = new AtomicInteger();
            TreeItem[] treeItemArray = treeitems = this.fViewer.getTree().getItems();
            int n = treeitems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                visibleItemCount.incrementAndGet();
                this.calcItemCount(visibleItemCount, treeItem);
                ++n2;
            }
            String removeFilters = Messages.ArtifactSearchResultPage_REMOVE_FILTERS;
            String removeFiltersLink = "<a href=\"com.ibm.team.fulltext.ide.ui.internal.search.ShowAll\">" + removeFilters + "</a>";
            int dif = allItemsCount - visibleItemCount.get();
            label = dif == 0 ? NLS.bind((String)Messages.ArtifactSearchResultPage_ZERO_MATCHES_FILTERED, (Object)label, (Object[])new Object[0]) : (dif == 1 ? NLS.bind((String)Messages.ArtifactSearchResultPage_ONE_MATCH_FILTERED, (Object)label, (Object[])new Object[]{removeFiltersLink}) : NLS.bind((String)Messages.ArtifactSearchResultPage_N_MATCHES_FILTERED, (Object)label, (Object[])new Object[]{dif, removeFiltersLink}));
        }
        this.fStatusLink.setText(label);
    }

    private void calcItemCount(AtomicInteger count, TreeItem parent) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = parent.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.calcItemCount(count, item);
            ++n2;
        }
        count.set(count.get() + items.length);
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.fViewPart = part;
    }

    public IPageSite getSite() {
        return this.fSite;
    }

    public void init(IPageSite site) {
        String settings;
        this.fSite = site;
        IDialogSettings section = FulltextUIPlugin.getDefault().getDialogSettings().getSection(PAGE_ID);
        if (section != null && (settings = section.get(MEMENTO_DIALOG_SETTINGS)) != null) {
            try {
                this.fMemento = XMLMemento.createReadRoot((Reader)new StringReader(settings));
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
    }

    public void searchResultChanged(SearchResultEvent e) {
        final ISearchResult searchResult = e.getSearchResult();
        if (searchResult instanceof ArtifactSearchResult) {
            FoundationUIJob uiJob = new FoundationUIJob(""){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    ArtifactSearchResultPage.this.fViewer.setInput((Object)new ResultModel(searchResult != null ? ((ArtifactSearchResult)searchResult).getResults() : new IScoredResult[]{}));
                    ArtifactSearchResultPage.this.fViewer.getTree().getParent().layout();
                    ArtifactSearchResultPage.this.updateStatusLink();
                    ArtifactSearchResultPage.this.updateActions();
                    return Status.OK_STATUS;
                }
            };
            uiJob.setSystem(true);
            uiJob.schedule();
        }
    }

    public void createControl(Composite parent) {
        this.fPageContainer = new Composite(parent, 0);
        this.fPageContainer.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)this.fPageContainer.getLayout()).marginWidth = 0;
        ((GridLayout)this.fPageContainer.getLayout()).marginHeight = 0;
        ((GridLayout)this.fPageContainer.getLayout()).verticalSpacing = 0;
        this.fPageContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.makeActions();
        this.createStatusBar(this.fPageContainer);
        this.createViewer(this.fPageContainer);
        this.createFilter(this.fPageContainer);
        this.fillContextualMenu();
        this.hookDragSupport();
        this.hookDropSupport();
    }

    private void createFilter(Composite pageContainer) {
        this.fQuickFilter = new QuickFilter(pageContainer, this.fViewer.getControl());
        this.fQuickFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                String filterText = text.getText();
                Job.getJobManager().cancel((Object)ArtifactSearchResultPage.this);
                if (filterText.length() > 0) {
                    new QuickFilterJob(filterText).schedule(100L);
                } else {
                    ArtifactSearchResultPage.this.onFilterByText(filterText);
                }
            }
        });
    }

    private void fillViewMenu() {
        IMenuManager menuManager = this.fActionBars.getMenuManager();
        menuManager.add((IContributionItem)new Separator());
        Action showScoreAction = new Action(Messages.ArtifactSearchResultPage_SHOW_NUMERICAL_SCORE, 2){

            public void run() {
                ArtifactSearchResultPage.this.fResultLabelProvider.setShowScore(!ArtifactSearchResultPage.this.fResultLabelProvider.isScoreShown());
                ArtifactSearchResultPage.this.fViewer.getTree().redraw();
            }
        };
        showScoreAction.setChecked(this.fResultLabelProvider.isScoreShown());
        menuManager.add((IAction)showScoreAction);
    }

    private void onFilterByText(String text) {
        this.fResultFilter.setFilterText(text);
        this.fViewer.refresh();
        if (text.length() > 0) {
            this.fViewer.expandAll();
        }
        this.updateStatusLink();
        this.updateActions();
        this.fViewer.getTree().getParent().layout();
    }

    private void onFilterByScore(long score) {
        this.fResultFilter.setFilterByScore(score);
        this.fViewer.refresh();
        this.updateStatusLink();
        this.updateActions();
        this.fViewer.getTree().getParent().layout();
    }

    private void onFilterByResults(int count) {
        this.fResultFilter.setFilterByResultCount(count);
        this.fViewer.refresh();
        this.updateStatusLink();
        this.updateActions();
        this.fViewer.getTree().getParent().layout();
    }

    private void makeActions() {
        this.fOpenNextAction = new Action(){

            public void run() {
                ArtifactSearchResultPage.this.onOpenNext();
            }

            public String getId() {
                return ArtifactSearchResultPage.DOWN_ID;
            }

            public String getActionDefinitionId() {
                return "org.eclipse.ui.navigate.next";
            }

            public ImageDescriptor getImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/etool16/down.gif");
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/dtool16/down.gif");
            }

            public String getToolTipText() {
                return Messages.ArtifactSearchResultPage_OPEN_NEXT_ARTIFACT;
            }

            public String getText() {
                return Messages.ArtifactSearchResultPage_OPEN_NEXT_ARTIFACT;
            }
        };
        this.fOpenPreviousAction = new Action(){

            public void run() {
                ArtifactSearchResultPage.this.onOpenPrevious();
            }

            public String getId() {
                return ArtifactSearchResultPage.UP_ID;
            }

            public String getActionDefinitionId() {
                return "org.eclipse.ui.navigate.previous";
            }

            public ImageDescriptor getImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/etool16/up.gif");
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/dtool16/up.gif");
            }

            public String getToolTipText() {
                return Messages.ArtifactSearchResultPage_OPEN_PREVIOUS_ARTIFACT;
            }

            public String getText() {
                return Messages.ArtifactSearchResultPage_OPEN_PREVIOUS_ARTIFACT;
            }
        };
        this.fFindAction = new Action(Messages.ArtifactSearchResultPage_JAZZ_TEXT_SEARCH){

            public void run() {
                NewSearchUI.openSearchDialog((IWorkbenchWindow)ArtifactSearchResultPage.this.fSite.getWorkbenchWindow(), (String)"com.ibm.team.fulltext.rcp.ui.ArtifactSearchPage");
            }

            public ImageDescriptor getImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/view16/artifact_view.gif");
            }

            public String getActionDefinitionId() {
                return "com.ibm.team.fulltext.ide.ui.SearchJazzArtifactsAction";
            }
        };
        this.fFindRelatedAction = new Action(Messages.ArtifactSearchResultPage_FIND_SIMILAR_ARTIFACTS){

            public void run() {
                ArtifactSearchResultPage.this.onSearch(((ResultItem)((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).getFirstElement()).getResult().getResult(), false);
            }

            public boolean isEnabled() {
                return ((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).size() == 1;
            }

            public ImageDescriptor getImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_related.gif");
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/dtool16/find_related.gif");
            }

            public String getId() {
                return ArtifactSearchResultPage.FIND_RELATED_ID;
            }
        };
        this.fFindDuplicateAction = new Action(Messages.ArtifactSearchResultPage_FIND_SIMILAR_ARTIFACTS_OF_SAME_TYPE){

            public void run() {
                ArtifactSearchResultPage.this.onSearch(((ResultItem)((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).getFirstElement()).getResult().getResult(), true);
            }

            public boolean isEnabled() {
                return ((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).size() == 1;
            }

            public ImageDescriptor getImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_duplicate.gif");
            }

            public ImageDescriptor getDisabledImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/dtool16/find_duplicate.gif");
            }

            public String getId() {
                return ArtifactSearchResultPage.FIND_DUPLICATE_ID;
            }
        };
        this.fExpandAction = new Action(){

            public void run() {
                ArtifactSearchResultPage.this.fViewer.expandAll();
            }

            public ImageDescriptor getImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/etool16/expand.gif");
            }

            public String getToolTipText() {
                return Messages.ArtifactSearchResultPage_EXPAND_ALL;
            }
        };
        this.fCollapseAction = new Action(){

            public void run() {
                ArtifactSearchResultPage.this.fViewer.collapseAll();
            }

            public ImageDescriptor getImageDescriptor() {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/etool16/collapse.gif");
            }

            public String getToolTipText() {
                return Messages.ArtifactSearchResultPage_COLLAPSE_ALL;
            }
        };
        this.fFilterAction = new FilterAction();
    }

    private void createStatusBar(Composite parent) {
        final Composite linkContainer = new Composite(parent, 0);
        linkContainer.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)linkContainer.getLayout()).marginWidth = 3;
        ((GridLayout)linkContainer.getLayout()).marginHeight = 3;
        ((GridLayout)linkContainer.getLayout()).marginBottom = 1;
        linkContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        linkContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(linkContainer.getDisplay().getSystemColor(15));
                Rectangle clArea = linkContainer.getClientArea();
                gc.drawLine(clArea.x, clArea.y + clArea.height - 1, clArea.x + clArea.width, clArea.y + clArea.height - 1);
            }
        });
        this.fStatusLink = new Link(linkContainer, 0);
        this.fStatusLink.setText(Messages.ArtifactSearchResultPage_SEARCHING_FOR_ARTIFACTS);
        this.fStatusLink.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fStatusLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ArtifactSearchResultPage.REMOVE_FILTERS_ID.equals(e.text)) {
                    ArtifactSearchResultPage.this.fResultFilter.setFilterByResultCount(0);
                    ArtifactSearchResultPage.this.fResultFilter.setFilterByScore(0L);
                    ArtifactSearchResultPage.this.fResultFilter.setFilterText("");
                    ArtifactSearchResultPage.this.fQuickFilter.hideQuickFilterArea();
                    ArtifactSearchResultPage.this.fViewer.refresh();
                    ArtifactSearchResultPage.this.updateStatusLink();
                    ArtifactSearchResultPage.this.updateActions();
                    ArtifactSearchResultPage.this.fViewer.getTree().getParent().layout();
                } else {
                    ArtifactSearchQuery query = (ArtifactSearchQuery)((ArtifactSearchResult)ArtifactSearchResultPage.this.fSearchResult).getQuery();
                    if (query.getType() != ArtifactSearchQuery.QueryType.TEXT) {
                        URIReference queryInput = (URIReference)query.getQueryInput();
                        final URI itemUri = ResultUtils.relativeToAbsolute(queryInput.getURI(), ArtifactSearchResultPage.this.fSelectedRepository);
                        FoundationJob openJob = new FoundationJob(Messages.ArtifactSearchResultPage_OPENING_ARTIFACT){

                            protected IStatus runProtected(IProgressMonitor monitor) {
                                return Hyperlinks.open((URI)itemUri, null, (IProgressMonitor)monitor);
                            }
                        };
                        openJob.schedule();
                    }
                }
            }
        });
        new DragSupport((Control)this.fStatusLink){

            public ISelection getSelection() {
                ArtifactSearchQuery query;
                if (ArtifactSearchResultPage.this.fSearchResult != null && (query = (ArtifactSearchQuery)((ArtifactSearchResult)ArtifactSearchResultPage.this.fSearchResult).getQuery()).getType() != ArtifactSearchQuery.QueryType.TEXT) {
                    URIReference relRef = (URIReference)query.getQueryInput();
                    ResultURIReference absRef = new ResultURIReference(relRef.getName(), relRef.getDetails(), relRef.getType(), ResultUtils.relativeToAbsolute(relRef.getURI(), ArtifactSearchResultPage.this.fSelectedRepository));
                    return new StructuredSelection((Object)absRef);
                }
                return StructuredSelection.EMPTY;
            }
        };
        new TooltipSupport((Control)this.fStatusLink, true, true){

            protected void openRequested(Object element) {
                ArtifactSearchResultPage.this.onOpen(Arrays.asList(element));
            }

            public Object getElement(Control control, int x, int y) {
                ArtifactSearchQuery query;
                if (ArtifactSearchResultPage.this.fSearchResult != null && (query = (ArtifactSearchQuery)((ArtifactSearchResult)ArtifactSearchResultPage.this.fSearchResult).getQuery()).getType() != ArtifactSearchQuery.QueryType.TEXT) {
                    URIReference relRef = (URIReference)query.getQueryInput();
                    return new ResultURIReference(relRef.getName(), relRef.getDetails(), relRef.getType(), ResultUtils.relativeToAbsolute(relRef.getURI(), ArtifactSearchResultPage.this.fSelectedRepository));
                }
                return null;
            }

            protected boolean useDomainAdapter(Object element) {
                return false;
            }

            protected String getMarkupInBackground(IDomainAdapter adapter, Object element, IDomainAdapter.Info info, IProgressMonitor monitor) {
                block4: {
                    if (element == null) {
                        return null;
                    }
                    URIReference item = (URIReference)element;
                    URI itemUri = ResultUtils.relativeToAbsolute(item.getURI(), ArtifactSearchResultPage.this.fSelectedRepository);
                    try {
                        Object resolvedItem = Hyperlinks.resolve((URI)itemUri, null, null);
                        if (resolvedItem != null && (adapter = DomainAdapterUtils.getDomainAdapter((Object)resolvedItem)) != null) {
                            return DomainAdapterUtils.generateContentAsHTML((IDomainAdapter)adapter, (Object)resolvedItem, (IDomainAdapter.Info)info);
                        }
                    }
                    catch (CoreException e) {
                        IStatus status = e.getStatus();
                        if (status == null || !(status.getException() instanceof PermissionDeniedException)) break block4;
                        return Messages.ArtifactSearchResultPage_PERMISSION_DENIED;
                    }
                }
                return Messages.ArtifactSearchResultPage_NO_ADDITIONAL_INFO;
            }
        };
    }

    private void fillViewToolbar() {
        IToolBarManager toolBarManager = this.fActionBars.getToolBarManager();
        toolBarManager.appendToGroup("group.show", (IAction)this.fOpenNextAction);
        toolBarManager.appendToGroup("group.show", (IAction)this.fOpenPreviousAction);
        toolBarManager.appendToGroup("group.show", (IContributionItem)new Separator());
        toolBarManager.appendToGroup("group.show", (IAction)this.fExpandAction);
        toolBarManager.appendToGroup("group.show", (IAction)this.fCollapseAction);
        toolBarManager.appendToGroup("group.show", (IContributionItem)new Separator());
        toolBarManager.appendToGroup("group.show", (IAction)this.fFindAction);
        toolBarManager.appendToGroup("group.show", (IAction)this.fFindRelatedAction);
        toolBarManager.appendToGroup("group.show", (IAction)this.fFindDuplicateAction);
        toolBarManager.appendToGroup("group.show", (IAction)this.fFindDuplicateAction);
        toolBarManager.appendToGroup("group.show", (IContributionItem)new Separator());
        toolBarManager.appendToGroup("group.show", (IAction)this.fFilterAction);
        this.fActionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fOpenPreviousAction);
        this.fActionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fOpenNextAction);
        this.fActionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)new Action(){

            public void run() {
                ArtifactSearchResultPage.this.fQuickFilter.showQuickFilterArea("");
            }
        });
        this.fActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action(){

            public void run() {
                ArtifactSearchResultPage.this.fViewer.getTree().selectAll();
            }
        });
        this.fActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

            public void run() {
                ArtifactSearchResultPage.this.onCopyToClipboard();
            }
        });
    }

    private void hookDragSupport() {
        new DragSupport(this.fViewer.getControl()){

            protected URIReference[] createReferences(Object[] elements) {
                ArrayList<URIReference> references = new ArrayList<URIReference>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    references.add((URIReference)object);
                    ++n2;
                }
                return references.toArray(new URIReference[references.size()]);
            }

            public ISelection getSelection() {
                return ArtifactSearchResultPage.this.fViewer.getSelection();
            }

            protected ISelection convertSelection(ISelection selection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object[] references = this.convertToReferences(structuredSelection.toArray());
                return new StructuredSelection(references);
            }

            protected URIReference[] convertToReferences(Object[] elements) {
                ArrayList<ResultURIReference> references = new ArrayList<ResultURIReference>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    URIReference relRef = ((ResultItem)object).getResult().getResult();
                    ResultURIReference absRef = new ResultURIReference(relRef.getName(), relRef.getDetails(), relRef.getType(), ResultUtils.relativeToAbsolute(relRef.getURI(), ArtifactSearchResultPage.this.fSelectedRepository));
                    references.add(absRef);
                    ++n2;
                }
                return references.toArray(new URIReference[references.size()]);
            }
        };
    }

    private void hookDropSupport() {
        ViewerDropAdapter viewerDropAdapter = new ViewerDropAdapter((Viewer)this.fViewer){

            public boolean performDrop(Object data) {
                URIReference uriReference = null;
                if (data instanceof IStructuredSelection && !((IStructuredSelection)data).isEmpty()) {
                    uriReference = Hyperlinks.create((Object)((IStructuredSelection)data).getFirstElement(), null);
                } else if (data instanceof Object[] && ((Object[])data).length > 0) {
                    uriReference = Hyperlinks.create((Object)((Object[])data)[0], null);
                } else if (data instanceof URIReference[] && ((URIReference[])data).length > 0) {
                    uriReference = ((URIReference[])data)[0];
                } else if (data instanceof URIReference) {
                    uriReference = (URIReference)data;
                }
                if (uriReference != null) {
                    try {
                        String type;
                        Location location = Location.location((URI)uriReference.getURI());
                        URI relativeUri = location.toRelativeUri();
                        String string = type = uriReference.getType() != null ? uriReference.getType() : String.valueOf(location.getItemType().getNamespaceURI()) + "." + location.getItemType().getName();
                        if (FulltextUIPlugin.getDefault().isSupported(type)) {
                            ArtifactSearchResultPage.this.fCurrentDropData = new URIReference(uriReference.getName(), uriReference.getDetails(), type, relativeUri);
                            ArtifactSearchResultPage.this.fViewer.getTree().getMenu().setVisible(true);
                        }
                    }
                    catch (Exception e) {
                        FoundationLog.log((IStatus)new Status(2, "com.ibm.team.fulltext.ide.ui", e.getMessage(), (Throwable)e));
                    }
                }
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                return !(selection instanceof IStructuredSelection) || !(((IStructuredSelection)selection).getFirstElement() instanceof ResultURIReference);
            }

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 4;
                }
                super.dragEnter(event);
            }
        };
        viewerDropAdapter.setFeedbackEnabled(false);
        viewerDropAdapter.setSelectionFeedbackEnabled(false);
        viewerDropAdapter.setScrollExpandEnabled(false);
        this.fViewer.addDropSupport(31, new Transfer[]{URIReferenceTransfer.getInstance(), LocalSelectionTransfer.getTransfer()}, (DropTargetListener)viewerDropAdapter);
    }

    private void fillContextualMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (ArtifactSearchResultPage.this.fCurrentDropData != null) {
                    final URIReference tmpCurrentDropData = ArtifactSearchResultPage.this.fCurrentDropData;
                    ArtifactSearchResultPage.this.fCurrentDropData = null;
                    Action findRelatedMenuAction = new Action(Messages.ArtifactSearchResultPage_FIND_SIMILAR_ARTIFACTS){

                        public void run() {
                            ArtifactSearchResultPage.this.onSearch(tmpCurrentDropData, false);
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_related.gif");
                        }
                    };
                    Action findDuplicateMenuAction = new Action(Messages.ArtifactSearchResultPage_FIND_SIMILAR_ARTIFACTS_OF_SAME_TYPE){

                        public void run() {
                            ArtifactSearchResultPage.this.onSearch(tmpCurrentDropData, true);
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_duplicate.gif");
                        }
                    };
                    manager.add((IAction)findRelatedMenuAction);
                    manager.add((IAction)findDuplicateMenuAction);
                } else {
                    Action openAction = new Action(Messages.ArtifactSearchResultPage_OPEN){

                        public void run() {
                            ArtifactSearchResultPage.this.onOpen();
                        }

                        public boolean isEnabled() {
                            return !((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).isEmpty();
                        }
                    };
                    Action copyAction = new Action(Messages.ArtifactSearchResultPage_COPY_NAME){

                        public void run() {
                            ArtifactSearchResultPage.this.onCopyToClipboard();
                        }

                        public boolean isEnabled() {
                            return !((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).isEmpty();
                        }
                    };
                    manager.add((IAction)openAction);
                    manager.add((IAction)copyAction);
                    manager.add((IContributionItem)new Separator());
                    Action openNextMenuAction = new Action(){

                        public void run() {
                            ArtifactSearchResultPage.this.onOpenNext();
                        }

                        public String getActionDefinitionId() {
                            return ArtifactSearchResultPage.this.fOpenNextAction.getActionDefinitionId();
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/etool16/down.gif");
                        }

                        public ImageDescriptor getDisabledImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/dtool16/down.gif");
                        }

                        public String getText() {
                            return Messages.ArtifactSearchResultPage_OPEN_NEXT_ARTIFACT;
                        }
                    };
                    Action openPreviousMenuAction = new Action(){

                        public void run() {
                            ArtifactSearchResultPage.this.onOpenPrevious();
                        }

                        public String getActionDefinitionId() {
                            return ArtifactSearchResultPage.this.fOpenPreviousAction.getActionDefinitionId();
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/etool16/up.gif");
                        }

                        public ImageDescriptor getDisabledImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/dtool16/up.gif");
                        }

                        public String getText() {
                            return Messages.ArtifactSearchResultPage_OPEN_PREVIOUS_ARTIFACT;
                        }
                    };
                    manager.add((IAction)openNextMenuAction);
                    manager.add((IAction)openPreviousMenuAction);
                    manager.add((IContributionItem)new Separator());
                    Action findRelatedMenuAction = new Action(Messages.ArtifactSearchResultPage_FIND_SIMILAR_ARTIFACTS){

                        public void run() {
                            ArtifactSearchResultPage.this.onSearch(((ResultItem)((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).getFirstElement()).getResult().getResult(), false);
                        }

                        public boolean isEnabled() {
                            return ((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).size() == 1;
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_related.gif");
                        }

                        public ImageDescriptor getDisabledImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/dtool16/find_related.gif");
                        }
                    };
                    Action findDuplicateMenuAction = new Action(Messages.ArtifactSearchResultPage_FIND_SIMILAR_ARTIFACTS_OF_SAME_TYPE){

                        public void run() {
                            ArtifactSearchResultPage.this.onSearch(((ResultItem)((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).getFirstElement()).getResult().getResult(), true);
                        }

                        public boolean isEnabled() {
                            return ((IStructuredSelection)ArtifactSearchResultPage.this.fViewer.getSelection()).size() == 1;
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_duplicate.gif");
                        }

                        public ImageDescriptor getDisabledImageDescriptor() {
                            return FulltextUIPlugin.getDefault().createDescriptor("icons/dtool16/find_duplicate.gif");
                        }
                    };
                    manager.add((IAction)findRelatedMenuAction);
                    manager.add((IAction)findDuplicateMenuAction);
                    manager.add((IContributionItem)new Separator());
                    FoundationUIUtils.contributeObjectActions((IWorkbenchPart)ArtifactSearchResultPage.this.fViewPart, (IMenuManager)manager, (ISelectionProvider)ArtifactSearchResultPage.this.fResultToReferenceConverter);
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(menu);
    }

    private void onOpenNext() {
        TreeItem[] selection = this.fViewer.getTree().getSelection();
        Object nextData = null;
        if (selection.length > 0) {
            int treeItemCount;
            int indexOfParentItem;
            int itemCount;
            TreeItem parentItem;
            int indexOfItem;
            int itemCount2;
            int indexOfItem2;
            TreeItem curItem = selection[selection.length - 1];
            nextData = curItem.getParentItem() == null ? ((indexOfItem2 = this.fViewer.getTree().indexOf(curItem)) < (itemCount2 = this.fViewer.getTree().getItemCount()) - 1 ? this.fViewer.getTree().getItem(indexOfItem2 + 1).getData() : this.fViewer.getTree().getItem(0).getData()) : ((indexOfItem = (parentItem = curItem.getParentItem()).indexOf(curItem)) < (itemCount = parentItem.getItemCount()) - 1 ? parentItem.getItem(indexOfItem + 1).getData() : ((indexOfParentItem = this.fViewer.getTree().indexOf(parentItem)) < (treeItemCount = this.fViewer.getTree().getItemCount()) - 1 ? this.fViewer.getTree().getItem(indexOfParentItem + 1).getData() : this.fViewer.getTree().getItem(0).getData()));
        } else if (this.fViewer.getTree().getItemCount() > 0) {
            TreeItem item = this.fViewer.getTree().getItem(0);
            nextData = item.getData();
        }
        if (nextData != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(nextData));
            this.onOpen();
        }
    }

    private void onOpenPrevious() {
        TreeItem[] selection = this.fViewer.getTree().getSelection();
        Object previousData = null;
        if (selection.length > 0) {
            TreeItem curItem = selection[0];
            if (curItem.getParentItem() == null) {
                int indexOfItem = this.fViewer.getTree().indexOf(curItem);
                int itemCount = this.fViewer.getTree().getItemCount();
                previousData = indexOfItem > 0 ? this.fViewer.getTree().getItem(indexOfItem - 1).getData() : this.fViewer.getTree().getItem(itemCount - 1).getData();
            } else {
                TreeItem parentItem = curItem.getParentItem();
                int indexOfItem = parentItem.indexOf(curItem);
                if (indexOfItem > 0) {
                    previousData = parentItem.getItem(indexOfItem - 1).getData();
                } else {
                    int indexOfParentItem = this.fViewer.getTree().indexOf(parentItem);
                    int treeItemCount = this.fViewer.getTree().getItemCount();
                    previousData = indexOfParentItem > 0 ? this.fViewer.getTree().getItem(indexOfParentItem - 1).getData() : this.fViewer.getTree().getItem(treeItemCount - 1).getData();
                }
            }
        } else if (this.fViewer.getTree().getItemCount() > 0) {
            TreeItem item = this.fViewer.getTree().getItem(this.fViewer.getTree().getItemCount() - 1);
            this.fViewer.setSelection((ISelection)new StructuredSelection(item.getData()));
            this.onOpen();
        }
        if (previousData != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(previousData));
            this.onOpen();
        }
    }

    private void onSearch(URIReference item, boolean isDuplicateSearch) {
        NewSearchUI.runQueryInBackground((ISearchQuery)new ArtifactSearchQuery(this.fSelectedRepository, item, isDuplicateSearch));
    }

    private void onCopyToClipboard() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Clipboard cb = new Clipboard(this.fSite.getShell().getDisplay());
        StringBuilder strB = new StringBuilder();
        List list = selection.toList();
        for (Object object : list) {
            ResultItem item = (ResultItem)object;
            URIReference ref = item.getResult().getResult();
            strB.append(ref.getName()).append("\n");
        }
        if (strB.length() > 0) {
            strB.delete(strB.length() - 1, strB.length());
        }
        cb.setContents(new Object[]{strB.toString()}, new Transfer[]{TextTransfer.getInstance()});
        cb.dispose();
    }

    private void createViewer(Composite parent) {
        Composite treeContainer = new Composite(parent, 0);
        treeContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeContainer.setLayout((Layout)treeLayout);
        this.fViewer = new TreeViewer(treeContainer, 66306);
        this.fViewer.getTree().setHeaderVisible(true);
        this.fViewer.getTree().setLinesVisible(true);
        this.fResultToReferenceConverter = new ResultToReferenceConverter((ISelectionProvider)this.fViewer);
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ArtifactSearchResultPage.this.onOpen();
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArtifactSearchResultPage.this.updateActions();
            }
        });
        final TreeViewerColumn col1 = new TreeViewerColumn(this.fViewer, 16384);
        col1.getColumn().setText(Messages.ArtifactSearchResultPage_NAME);
        col1.getColumn().setData((Object)ArtifactColumn.NAME);
        col1.getColumn().setMoveable(true);
        final TreeViewerColumn col2 = new TreeViewerColumn(this.fViewer, 16384);
        col2.getColumn().setText(Messages.ArtifactSearchResultPage_SCORE);
        col2.getColumn().setData((Object)ArtifactColumn.SCORE);
        col2.getColumn().setMoveable(true);
        this.fViewer.getTree().setSortColumn(col2.getColumn());
        this.fViewer.getTree().setSortDirection(1024);
        final TreeViewerColumn col3 = new TreeViewerColumn(this.fViewer, 16384);
        col3.getColumn().setText(Messages.ArtifactSearchResultPage_DETAILS);
        col3.getColumn().setData((Object)ArtifactColumn.DETAILS);
        col3.getColumn().setMoveable(true);
        final TreeViewerColumn col4 = new TreeViewerColumn(this.fViewer, 16384);
        col4.getColumn().setText(Messages.ArtifactSearchResultPage_TYPE);
        col4.getColumn().setData((Object)ArtifactColumn.TYPE);
        col4.getColumn().setMoveable(true);
        if (this.fMemento != null) {
            IMemento[] children = this.fMemento.getChildren(PREF_COL_ORDER_MEMENTO);
            int[] colOrders = new int[children.length];
            int i = 0;
            while (i < children.length) {
                Integer colOrder = children[i].getInteger(PREF_COL_ORDER);
                if (colOrder != null) {
                    colOrders[i] = colOrder;
                }
                ++i;
            }
            if (colOrders.length > 0) {
                this.fViewer.getTree().setColumnOrder(colOrders);
            }
        }
        Listener colMoveListener = new Listener(){

            public void handleEvent(Event event) {
                ArtifactSearchResultPage.this.fCachedColumnOrder = ArtifactSearchResultPage.this.fViewer.getTree().getColumnOrder();
            }
        };
        col1.getColumn().addListener(10, colMoveListener);
        col2.getColumn().addListener(10, colMoveListener);
        col3.getColumn().addListener(10, colMoveListener);
        col4.getColumn().addListener(10, colMoveListener);
        SelectionAdapter colSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSorter resultSorter = (ResultSorter)ArtifactSearchResultPage.this.fViewer.getComparator();
                ArtifactColumn newSortCol = (ArtifactColumn)((Object)((TreeColumn)e.widget).getData());
                ArtifactColumn oldSortcol = resultSorter.getSortBy();
                SortOrder sortOrder = resultSorter.getSortOrder();
                if (newSortCol == oldSortcol) {
                    resultSorter.setSortOrder(sortOrder == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING);
                    ArtifactSearchResultPage.this.fViewer.getTree().setSortDirection(sortOrder == SortOrder.ASCENDING ? 1024 : 128);
                } else {
                    resultSorter.setSortBy(newSortCol);
                    resultSorter.setSortOrder(SortOrder.DESCENDING);
                    ArtifactSearchResultPage.this.fViewer.getTree().setSortColumn((TreeColumn)e.widget);
                    ArtifactSearchResultPage.this.fViewer.getTree().setSortDirection(1024);
                }
                ArtifactSearchResultPage.this.fViewer.refresh();
                ArtifactSearchResultPage.this.updateActions();
                ArtifactSearchResultPage.this.updateStatusLink();
            }
        };
        this.fViewer.getTree().addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                ArtifactSearchResultPage.this.blockResize(100);
            }

            public void treeExpanded(TreeEvent e) {
                ArtifactSearchResultPage.this.blockResize(100);
            }
        });
        Listener colResizeListener = new Listener(){

            public void handleEvent(Event event) {
                int col4Width;
                int col3Width;
                int col2Width;
                if (ArtifactSearchResultPage.this.fBlockResize) {
                    return;
                }
                int col1Width = col1.getColumn().getWidth();
                float allWidth = col1Width + (col2Width = col2.getColumn().getWidth()) + (col3Width = col3.getColumn().getWidth()) + (col4Width = col4.getColumn().getWidth());
                if (allWidth != 0.0f) {
                    int newRatio1 = (int)((float)(col1Width * 100) / allWidth);
                    int newRatio2 = (int)((float)(col2Width * 100) / allWidth);
                    int newRatio3 = (int)((float)(col3Width * 100) / allWidth);
                    if (newRatio1 - ArtifactSearchResultPage.this.fCachedColumnRatio[0] > 2 || newRatio1 - ArtifactSearchResultPage.this.fCachedColumnRatio[0] < -2) {
                        ((ArtifactSearchResultPage)ArtifactSearchResultPage.this).fCachedColumnRatio[0] = (int)((float)(col1Width * 100) / allWidth);
                    }
                    if (newRatio2 - ArtifactSearchResultPage.this.fCachedColumnRatio[1] > 2 || newRatio2 - ArtifactSearchResultPage.this.fCachedColumnRatio[1] < -2) {
                        ((ArtifactSearchResultPage)ArtifactSearchResultPage.this).fCachedColumnRatio[1] = (int)((float)(col2Width * 100) / allWidth);
                    }
                    if (newRatio3 - ArtifactSearchResultPage.this.fCachedColumnRatio[2] > 2 || newRatio3 - ArtifactSearchResultPage.this.fCachedColumnRatio[2] < -2) {
                        ((ArtifactSearchResultPage)ArtifactSearchResultPage.this).fCachedColumnRatio[2] = (int)((float)(col3Width * 100) / allWidth);
                    }
                    ((ArtifactSearchResultPage)ArtifactSearchResultPage.this).fCachedColumnRatio[3] = 100 - ArtifactSearchResultPage.this.fCachedColumnRatio[0] - ArtifactSearchResultPage.this.fCachedColumnRatio[1] - ArtifactSearchResultPage.this.fCachedColumnRatio[2];
                }
            }
        };
        col1.getColumn().addSelectionListener((SelectionListener)colSelectionListener);
        col2.getColumn().addSelectionListener((SelectionListener)colSelectionListener);
        col3.getColumn().addSelectionListener((SelectionListener)colSelectionListener);
        col4.getColumn().addSelectionListener((SelectionListener)colSelectionListener);
        col1.getColumn().addListener(11, colResizeListener);
        col2.getColumn().addListener(11, colResizeListener);
        col3.getColumn().addListener(11, colResizeListener);
        col4.getColumn().addListener(11, colResizeListener);
        this.blockResize(1000);
        if (this.fMemento != null) {
            IMemento[] children = this.fMemento.getChildren(PREF_COL_RATIO_MEMENTO);
            int i = 0;
            while (i < children.length) {
                Integer colRatio = children[i].getInteger(PREF_COL_RATIO);
                if (colRatio != null) {
                    this.fCachedColumnRatio[i] = colRatio;
                }
                ++i;
            }
        }
        if (this.fCachedColumnRatio.length == 4) {
            treeLayout.setColumnData((Widget)col1.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fCachedColumnRatio[0]));
            treeLayout.setColumnData((Widget)col2.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fCachedColumnRatio[1]));
            treeLayout.setColumnData((Widget)col3.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fCachedColumnRatio[2]));
            treeLayout.setColumnData((Widget)col4.getColumn(), (ColumnLayoutData)new ColumnWeightData(this.fCachedColumnRatio[3]));
        }
        this.fViewer.setContentProvider((IContentProvider)new ResultContentProvider());
        this.fViewer.setComparator((ViewerComparator)new ResultSorter());
        this.fResultLabelProvider = new ResultLabelProvider();
        this.fResultLabelProvider.loadFrom(this.fMemento);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fResultLabelProvider);
        this.fResultFilter = new ResultFilter();
        this.fResultFilter.loadFrom(this.fMemento);
        this.fViewer.addFilter((ViewerFilter)this.fResultFilter);
        new TooltipSupport(this.fViewer.getControl(), true, true){

            protected void openRequested(Object element) {
                ArtifactSearchResultPage.this.onOpen(Arrays.asList(element));
            }

            public boolean isHoverHotspotReduced() {
                return true;
            }

            protected boolean useDomainAdapter(Object element) {
                return false;
            }

            public Object getElement(Control control, int x, int y) {
                TreeItem item = ((Tree)control).getItem(new Point(x, y));
                if (item == null) {
                    return null;
                }
                if (!this.isHoverHotspotReduced() || item.getImageBounds(0).contains(x, y)) {
                    ResultItem resultItem = (ResultItem)item.getData();
                    return ResultUtils.relativeToAbsolute(resultItem.getResult().getResult().getURI(), ArtifactSearchResultPage.this.fSelectedRepository);
                }
                return null;
            }

            protected String getMarkupInBackground(IDomainAdapter adapter, Object element, IDomainAdapter.Info info, IProgressMonitor monitor) {
                block4: {
                    if (element == null || !(element instanceof URI)) {
                        return null;
                    }
                    URI itemUri = (URI)element;
                    try {
                        Object resolvedItem = Hyperlinks.resolve((URI)itemUri, null, null);
                        if (resolvedItem != null && (adapter = DomainAdapterUtils.getDomainAdapter((Object)resolvedItem)) != null) {
                            return DomainAdapterUtils.generateContentAsHTML((IDomainAdapter)adapter, (Object)resolvedItem, (IDomainAdapter.Info)info);
                        }
                    }
                    catch (CoreException e) {
                        IStatus status = e.getStatus();
                        if (status == null || !(status.getException() instanceof PermissionDeniedException)) break block4;
                        return Messages.ArtifactSearchResultPage_PERMISSION_DENIED;
                    }
                }
                return Messages.ArtifactSearchResultPage_NO_ADDITIONAL_INFO;
            }
        };
        new TooltipSupport(this.fViewer.getControl(), false, false){

            public Object getElement(Control control, int x, int y) {
                TreeItem item = ((Tree)control).getItem(new Point(x, y));
                if (item == null) {
                    return null;
                }
                if (ArtifactSearchResultPage.this.fResultLabelProvider.isScoreShown()) {
                    return null;
                }
                if (item.getBounds(1).contains(x, y)) {
                    ResultItem resultItem = (ResultItem)item.getData();
                    int score = (int)((float)resultItem.getResult().getScore() / 1000.0f);
                    return NLS.bind((String)Messages.ArtifactSearchResultPage_SCORE_VAL, (Object)ArtifactSearchResultPage.this.fCachedFormat.format((double)Math.max(score, 1) / 100.0), (Object[])new Object[0]);
                }
                return null;
            }

            protected String getMarkup(Object element, boolean isFocus) {
                if (element instanceof String) {
                    return (String)element;
                }
                return null;
            }
        }.setUseBrowser(false);
    }

    private void blockResize(int millies) {
        this.fBlockResize = true;
        this.fViewer.getControl().getDisplay().timerExec(millies, new Runnable(){

            @Override
            public void run() {
                ArtifactSearchResultPage.this.fBlockResize = false;
            }
        });
    }

    private void onOpen() {
        this.updateActions();
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (!selection.isEmpty()) {
            this.onOpen(selection.toList());
        }
    }

    private void onOpen(final List<?> elements) {
        BusyIndicator.showWhile((Display)this.fSite.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                final ArrayList<URI> urisToOpen = new ArrayList<URI>();
                for (Object selected : elements) {
                    URI itemUri = selected instanceof URIReference ? ((URIReference)selected).getURI() : (selected instanceof URI ? (URI)selected : ResultUtils.relativeToAbsolute(((ResultItem)selected).getResult().getResult().getURI(), ArtifactSearchResultPage.this.fSelectedRepository));
                    urisToOpen.add(itemUri);
                }
                FoundationJob openJob = new FoundationJob(Messages.ArtifactSearchResultPage_OPENING_ARTIFACT){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        return Hyperlinks.open((List)urisToOpen, null, (IProgressMonitor)monitor);
                    }
                };
                openJob.schedule();
            }
        });
    }

    public void dispose() {
        IMemento child;
        int n;
        int n2;
        int[] nArray;
        if (this.fSearchResult != null) {
            this.fSearchResult.removeListener((ISearchResultListener)this);
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)MEMENTO_RESULT_PAGE);
        if (this.fResultFilter != null) {
            this.fResultFilter.saveTo((IMemento)memento);
        }
        if (this.fResultLabelProvider != null) {
            this.fResultLabelProvider.saveTo((IMemento)memento);
        }
        if (this.fCachedColumnOrder != null) {
            nArray = this.fCachedColumnOrder;
            n2 = this.fCachedColumnOrder.length;
            n = 0;
            while (n < n2) {
                int colOrder = nArray[n];
                child = memento.createChild(PREF_COL_ORDER_MEMENTO);
                child.putInteger(PREF_COL_ORDER, colOrder);
                ++n;
            }
        }
        if (this.fCachedColumnRatio != null) {
            nArray = this.fCachedColumnRatio;
            n2 = this.fCachedColumnRatio.length;
            n = 0;
            while (n < n2) {
                int colRatio = nArray[n];
                child = memento.createChild(PREF_COL_RATIO_MEMENTO);
                child.putInteger(PREF_COL_RATIO, colRatio);
                ++n;
            }
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            String sectionName = PAGE_ID;
            IDialogSettings section = FulltextUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
            if (section == null) {
                section = FulltextUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
            }
            section.put(MEMENTO_DIALOG_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Control getControl() {
        return this.fPageContainer;
    }

    public void setActionBars(IActionBars actionBars) {
        this.fActionBars = actionBars;
        this.fillViewToolbar();
        this.fillViewMenu();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    private void updateActions() {
        this.fActionBars.getToolBarManager().find(DOWN_ID).update();
        this.fActionBars.getToolBarManager().find(UP_ID).update();
        this.fActionBars.getToolBarManager().find(FIND_DUPLICATE_ID).update();
        this.fActionBars.getToolBarManager().find(FIND_RELATED_ID).update();
    }

    public static enum ArtifactColumn {
        SCORE,
        TYPE,
        NAME,
        DETAILS;

    }

    private class FilterAction
    extends Action
    implements IMenuCreator {
        private MenuManager fMenuManager;
        private IAction fShowQuickFindAction;

        public FilterAction() {
            super("", 4);
            this.fShowQuickFindAction = new Action(Messages.ArtifactSearchResultPage_SHOW_FILTER_BOX, 2){

                public void run() {
                    if (this.isChecked()) {
                        ArtifactSearchResultPage.this.fQuickFilter.showQuickFilterArea("");
                    } else {
                        ArtifactSearchResultPage.this.fQuickFilter.hideQuickFilterArea();
                    }
                }
            };
            this.setToolTipText(Messages.ArtifactSearchResultPage_FILTER_RESULTS);
            this.setImageDescriptor(FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/filter.gif"));
            this.fMenuManager = new MenuManager();
        }

        public void run() {
            this.fShowQuickFindAction.setChecked(!this.fShowQuickFindAction.isChecked());
            this.fShowQuickFindAction.run();
        }

        public IMenuCreator getMenuCreator() {
            return this;
        }

        public void dispose() {
            this.fMenuManager.dispose();
        }

        public Menu getMenu(Control parent) {
            this.fMenuManager.removeAll();
            MenuManager filterByScoreManager = new MenuManager(Messages.ArtifactSearchResultPage_FILTER_BY_SCORE);
            filterByScoreManager.setRemoveAllWhenShown(true);
            filterByScoreManager.add((IAction)new Action(){});
            filterByScoreManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    Action item1 = new Action(Messages.ArtifactSearchResultPage_FILTER_DISABLED, 8){

                        public void run() {
                            ArtifactSearchResultPage.this.onFilterByScore(0L);
                        }
                    };
                    manager.add((IAction)item1);
                    manager.add((IContributionItem)new Separator());
                    Action item2 = new Action(Messages.ArtifactSearchResultPage_SCORE_GT_75, 8){

                        public void run() {
                            ArtifactSearchResultPage.this.onFilterByScore(75000L);
                        }
                    };
                    manager.add((IAction)item2);
                    Action item3 = new Action(Messages.ArtifactSearchResultPage_SCORE_GT_50, 8){

                        public void run() {
                            ArtifactSearchResultPage.this.onFilterByScore(50000L);
                        }
                    };
                    manager.add((IAction)item3);
                    Action item4 = new Action(Messages.ArtifactSearchResultPage_SCORE_GT_25, 8){

                        public void run() {
                            ArtifactSearchResultPage.this.onFilterByScore(25000L);
                        }
                    };
                    manager.add((IAction)item4);
                    if (ArtifactSearchResultPage.this.fResultFilter != null) {
                        long filterByScore = ArtifactSearchResultPage.this.fResultFilter.getFilterByScore();
                        if (filterByScore == 0L) {
                            item1.setChecked(true);
                        } else if (filterByScore == 75000L) {
                            item2.setChecked(true);
                        } else if (filterByScore == 50000L) {
                            item3.setChecked(true);
                        } else if (filterByScore == 25000L) {
                            item4.setChecked(true);
                        }
                    }
                }
            });
            this.fMenuManager.add((IContributionItem)filterByScoreManager);
            MenuManager filterByResultsManager = new MenuManager(Messages.ArtifactSearchResultPage_FILTER_BY_RESULTS);
            filterByResultsManager.setRemoveAllWhenShown(true);
            filterByResultsManager.add((IAction)new Action(){});
            filterByResultsManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    Action item1 = new Action(Messages.ArtifactSearchResultPage_FILTER_DISABLED, 8){

                        public void run() {
                            ArtifactSearchResultPage.this.onFilterByResults(0);
                        }
                    };
                    manager.add((IAction)item1);
                    manager.add((IContributionItem)new Separator());
                    Action item2 = new Action(Messages.ArtifactSearchResultPage_SHOW_MAX_100_RESULTS, 8){

                        public void run() {
                            ArtifactSearchResultPage.this.onFilterByResults(100);
                        }
                    };
                    manager.add((IAction)item2);
                    Action item3 = new Action(Messages.ArtifactSearchResultPage_SHOW_MAX_50_RESULTS, 8){

                        public void run() {
                            ArtifactSearchResultPage.this.onFilterByResults(50);
                        }
                    };
                    manager.add((IAction)item3);
                    Action item4 = new Action(Messages.ArtifactSearchResultPage_SHOW_MAX_20_RESULTS, 8){

                        public void run() {
                            ArtifactSearchResultPage.this.onFilterByResults(20);
                        }
                    };
                    manager.add((IAction)item4);
                    if (ArtifactSearchResultPage.this.fResultFilter != null) {
                        int filterByResultCount = ArtifactSearchResultPage.this.fResultFilter.getFilterByResultCount();
                        if (filterByResultCount == 0) {
                            item1.setChecked(true);
                        } else if (filterByResultCount == 100) {
                            item2.setChecked(true);
                        } else if (filterByResultCount == 50) {
                            item3.setChecked(true);
                        } else if (filterByResultCount == 20) {
                            item4.setChecked(true);
                        }
                    }
                }
            });
            this.fMenuManager.add((IContributionItem)filterByResultsManager);
            this.fMenuManager.add((IContributionItem)new Separator());
            this.fMenuManager.add(this.fShowQuickFindAction);
            this.fShowQuickFindAction.setChecked(ArtifactSearchResultPage.this.fQuickFilter.isVisible());
            return this.fMenuManager.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    private class QuickFilterJob
    extends FoundationJob {
        private final String fFilterText;

        QuickFilterJob(String filterText) {
            super(Messages.ArtifactSearchResultPage_FILTER_QUERY_RESULTS);
            this.fFilterText = filterText;
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            if (!ArtifactSearchResultPage.this.fViewer.getControl().isDisposed() && !monitor.isCanceled()) {
                ArtifactSearchResultPage.this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ArtifactSearchResultPage.this.onFilterByText(QuickFilterJob.this.fFilterText);
                    }
                });
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == ArtifactSearchResultPage.this;
        }
    }

    private class ResultToReferenceConverter
    extends ConvertingSelectionProvider {
        ResultToReferenceConverter(ISelectionProvider provider) {
            super(provider);
        }

        protected ISelection convertFrom(ISelection viewerSelection) {
            Object[] viewerSelectionArray = ((IStructuredSelection)viewerSelection).toArray();
            ArrayList<IItemHandle> convertedSelection = new ArrayList<IItemHandle>(viewerSelectionArray.length);
            Object[] objectArray = viewerSelectionArray;
            int n = viewerSelectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ResultItem item = (ResultItem)object;
                URI itemUri = item.getResult().getResult().getURI();
                try {
                    IItemHandle itemHandle = Location.location((URI)itemUri).getItemHandle();
                    ((ItemHandle)itemHandle).setOrigin((Object)ArtifactSearchResultPage.this.fSelectedRepository);
                    convertedSelection.add(itemHandle);
                }
                catch (TeamRepositoryException e) {
                    FoundationLog.log((IStatus)new Status(4, "com.ibm.team.fulltext.ide.ui", e.getMessage(), (Throwable)e));
                }
                ++n2;
            }
            return new StructuredSelection(convertedSelection);
        }
    }

    private class ResultURIReference
    extends URIReference
    implements IModelAccessor {
        ResultURIReference(String name, String details, String type, URI uri) {
            super(name, details, type, uri);
        }

        public Object getModelInstance() {
            try {
                IItemHandle itemHandle = Location.location((URI)this.getURI()).getItemHandle();
                if (itemHandle != null) {
                    ((ItemHandle)itemHandle).setOrigin((Object)ArtifactSearchResultPage.this.fSelectedRepository);
                }
                return itemHandle;
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return null;
            }
        }
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }
}

