/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.search;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.fulltext.ide.ui.internal.ArtifactType;
import com.ibm.team.fulltext.ide.ui.internal.FulltextUIPlugin;
import com.ibm.team.fulltext.ide.ui.internal.search.ArtifactSearchQuery;
import com.ibm.team.fulltext.ide.ui.internal.search.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;

public class ArtifactSearchResult
implements ISearchResult {
    private IScoredResult[] fResults = new IScoredResult[0];
    private ArtifactSearchQuery fQuery;
    private final List<ISearchResultListener> fListeners = new ArrayList<ISearchResultListener>();
    private ITeamRepository fRepository;
    private boolean fSearchFinished;

    public ArtifactSearchResult(ITeamRepository repository, ArtifactSearchQuery query) {
        this.fRepository = repository;
        this.fQuery = query;
    }

    public ImageDescriptor getImageDescriptor() {
        ArtifactSearchQuery.QueryType type = this.fQuery.getType();
        switch (type) {
            case TEXT: {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_text.gif");
            }
            case DUPLICATE: {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_duplicate.gif");
            }
            case RELATED: {
                return FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/find_related.gif");
            }
        }
        return null;
    }

    public String getLabel() {
        return this.internalGetLabel(false);
    }

    public String getLinkLabel() {
        return this.internalGetLabel(true);
    }

    private String internalGetLabel(boolean isLink) {
        String resultsStr = "";
        resultsStr = !this.fSearchFinished ? Messages.ArtifactSearchResult_SEARCH_NOT_COMPLETE : (this.fResults.length == 0 ? Messages.ArtifactSearchResult_FOUND_NO_RESULTS : (this.fResults.length == 1 ? Messages.ArtifactSearchResult_ONE_RESULT : NLS.bind((String)Messages.ArtifactSearchResult_N_RESULTS, (Object)this.fResults.length, (Object[])new Object[0])));
        ArtifactSearchQuery.QueryType type = this.fQuery.getType();
        switch (type) {
            case TEXT: {
                if (this.fQuery.getSearchScope() != null && !this.fQuery.getSearchScope().isEmpty()) {
                    String searchScopeStr = "";
                    List<ArtifactType> searchScope = this.fQuery.getSearchScope();
                    int i = 0;
                    while (i < searchScope.size()) {
                        searchScopeStr = i == 0 ? searchScope.get(i).getName() : NLS.bind((String)Messages.ArtifactSearchResult_RESULT_LOOP, (Object)searchScopeStr, (Object[])new Object[]{searchScope.get(i).getName()});
                        ++i;
                    }
                    return NLS.bind((String)Messages.ArtifactSearchResult_TEXT_SEARCH_RESULT_WITH_LOOP, (Object)resultsStr, (Object[])new Object[]{this.fQuery.getQueryInput(), searchScopeStr});
                }
                return NLS.bind((String)Messages.ArtifactSearchResult_TEXT_SEARCH_RESULT_WITHOUT_LOOP, (Object)resultsStr, (Object[])new Object[]{this.fQuery.getQueryInput()});
            }
            case DUPLICATE: {
                String name = ((URIReference)this.fQuery.getQueryInput()).getName();
                if (isLink) {
                    name = "<a>" + name + "</a>";
                }
                return NLS.bind((String)Messages.ArtifactSearchResult_SIMILAR_ARTIFACTS_RESULT, (Object)resultsStr, (Object[])new Object[]{name});
            }
            case RELATED: {
                String name = ((URIReference)this.fQuery.getQueryInput()).getName();
                if (isLink) {
                    name = "<a>" + name + "</a>";
                }
                return NLS.bind((String)Messages.ArtifactSearchResult_RELATED_ARTIFACTS_RESULT, (Object)resultsStr, (Object[])new Object[]{name});
            }
        }
        return null;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public String getTooltip() {
        return null;
    }

    public void fireSearchResultsChanged(SearchResultEvent event) {
        for (ISearchResultListener listener : this.fListeners) {
            listener.searchResultChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            if (!this.fListeners.contains(l)) {
                this.fListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }

    public IScoredResult[] getResults() {
        return this.fResults;
    }

    public void setResults(IScoredResult[] results) {
        this.fSearchFinished = true;
        this.fResults = results;
    }

    public ITeamRepository getRepository() {
        return this.fRepository;
    }
}

