/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.search;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.fulltext.client.IFullTextClientLibrary;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.fulltext.ide.ui.internal.ArtifactType;
import com.ibm.team.fulltext.ide.ui.internal.search.ArtifactSearchResult;
import com.ibm.team.fulltext.ide.ui.internal.search.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.SearchResultEvent;

public class ArtifactSearchQuery
implements ISearchQuery {
    private String fSearchFor;
    private List<ArtifactType> fSearchScope;
    private ITeamRepository fRepository;
    private URIReference fInputItem;
    private QueryType fQueryType;
    private ArtifactSearchResult fSearchResult;

    public ArtifactSearchQuery(ITeamRepository repository, String searchFor, List<ArtifactType> searchScope) {
        this.fSearchFor = searchFor;
        this.fSearchScope = searchScope;
        this.fRepository = repository;
        this.fQueryType = QueryType.TEXT;
        this.fSearchResult = new ArtifactSearchResult(this.fRepository, this);
    }

    public ArtifactSearchQuery(ITeamRepository repository, URIReference item, boolean isDuplicateSearch) {
        this.fRepository = repository;
        this.fInputItem = item;
        this.fQueryType = isDuplicateSearch ? QueryType.DUPLICATE : QueryType.RELATED;
        this.fSearchResult = new ArtifactSearchResult(this.fRepository, this);
    }

    public Object getQueryInput() {
        return this.fQueryType == QueryType.TEXT ? this.fSearchFor : this.fInputItem;
    }

    public List<ArtifactType> getSearchScope() {
        return this.fSearchScope;
    }

    public QueryType getType() {
        return this.fQueryType;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return Messages.ArtifactSearchQuery_JAZZ_TEXT_SEARCH;
    }

    public ISearchResult getSearchResult() {
        return this.fSearchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            monitor.beginTask(this.getLabel(), -1);
            IFullTextClientLibrary fulltextLib = (IFullTextClientLibrary)this.fRepository.getClientLibrary(IFullTextClientLibrary.class);
            IScoredResult[] result = null;
            switch (this.fQueryType) {
                case TEXT: {
                    String[] scope = null;
                    if (this.fSearchScope != null && !this.fSearchScope.isEmpty()) {
                        scope = new String[this.fSearchScope.size()];
                        int i = 0;
                        while (i < this.fSearchScope.size()) {
                            scope[i] = this.fSearchScope.get(i).getId();
                            ++i;
                        }
                    }
                    result = fulltextLib.find(this.fSearchFor, scope, null, monitor);
                    break;
                }
                case DUPLICATE: {
                    result = fulltextLib.findDuplicate(this.fInputItem, null, null, null, null, monitor);
                    break;
                }
                case RELATED: {
                    result = fulltextLib.findRelated(this.fInputItem, monitor);
                }
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                this.fSearchResult.setResults(result);
                SearchResultEvent event = new SearchResultEvent(this.fSearchResult){};
                this.fSearchResult.fireSearchResultsChanged(event);
            }
            catch (TeamRepositoryException e) {
                Status status = new Status(4, "com.ibm.team.fulltext.ide.ui", e.getMessage(), (Throwable)e);
                return status;
            }
            catch (Exception e) {
                if (e.getCause() instanceof AssertionFailedException) {
                    FoundationLog.log((IStatus)new Status(4, "com.ibm.team.fulltext.ide.ui", e.getMessage(), (Throwable)e));
                    this.fSearchResult.setResults(new IScoredResult[0]);
                    SearchResultEvent event = new SearchResultEvent(this.fSearchResult){};
                    this.fSearchResult.fireSearchResultsChanged(event);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                Status status = new Status(4, "com.ibm.team.fulltext.ide.ui", e.getMessage(), (Throwable)e);
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public static enum QueryType {
        TEXT,
        RELATED,
        DUPLICATE;

    }
}

