/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.search;

import com.ibm.team.fulltext.ide.ui.internal.ArtifactType;
import com.ibm.team.fulltext.ide.ui.internal.FulltextUIPlugin;
import com.ibm.team.fulltext.ide.ui.internal.HistoryItem;
import com.ibm.team.fulltext.ide.ui.internal.search.ArtifactSearchQuery;
import com.ibm.team.fulltext.ide.ui.internal.search.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.UUID;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ArtifactSearchPage
extends DialogPage
implements ISearchPage,
IListener {
    public static final String ID = "com.ibm.team.fulltext.rcp.ui.ArtifactSearchPage";
    private static final String ITERATION_PLAN_TYPE = "com.ibm.team.apt.IterationPlanRecord";
    private static final String WIKI_TYPE = "com.ibm.team.foundation.wiki.WikiPage";
    private static final String MEMENTO_SEARCH_PAGE = "searchpage";
    private static final String MEMENTO_DIALOG_SETTINGS = "memento";
    private static final String PREF_SELECTED_REPOSITORY = "com.ibm.team.fulltext.ide.ui.internal.search.PrefSelectedRepository";
    private static final List<HistoryItem> HISTORY = new ArrayList<HistoryItem>();
    private static final int MAX_HISTORY = 15;
    private ITeamRepositoryService fTeamRepoService;
    private ITeamRepository fSelectedRepository;
    private Combo fSearchCombo;
    private LocalResourceManager fResources;
    private List<Button> fScopeChecks;
    private Label fInfoLabel;
    private Label fHintsInfoLabel;
    private XMLMemento fMemento;
    private ISearchPageContainer fSearchPageContainer;
    private ToolItem fSelectRepositoryItem;
    private StandardLabelProvider fStandardLabelProvider;
    private final Collator fCollator = Collator.getInstance();

    public ArtifactSearchPage() {
    }

    public ArtifactSearchPage(String title) {
        super(title);
    }

    public ArtifactSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void createControl(Composite parent) {
        if (this.fMemento != null && HISTORY.isEmpty()) {
            HISTORY.addAll(HistoryItem.loadFrom((IMemento)this.fMemento));
        }
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayout((Layout)new GridLayout(1, false));
        pageContainer.getDisplay().timerExec(100, new Runnable(){

            @Override
            public void run() {
                ArtifactSearchPage.this.fSearchPageContainer.setPerformActionEnabled(ArtifactSearchPage.this.fSelectedRepository != null && ArtifactSearchPage.this.fSelectedRepository.loggedIn() && ArtifactSearchPage.this.fSearchCombo.getText().length() > 0);
            }
        });
        this.fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.fInfoLabel = new Label(pageContainer, 0);
        this.fInfoLabel.setText(Messages.ArtifactSearchPage_CONTAINING_TEXT);
        this.fInfoLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fSearchCombo = new Combo(pageContainer, 2048);
        this.fSearchCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSearchCombo.setVisibleItemCount(10);
        this.fSearchCombo.setEnabled(this.fSelectedRepository != null && this.fSelectedRepository.loggedIn());
        this.fSearchCombo.setFocus();
        this.fHintsInfoLabel = new Label(pageContainer, 0);
        this.fHintsInfoLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fHintsInfoLabel.setText(Messages.ArtifactSearchPage_SEARCH_HINTS);
        ComboViewer comboViewer = new ComboViewer(this.fSearchCombo);
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                HistoryItem item = (HistoryItem)element;
                return item.getQuery();
            }
        });
        this.fSearchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArtifactSearchPage.this.fSearchPageContainer.setPerformActionEnabled(ArtifactSearchPage.this.fSearchCombo.getText().length() > 0);
                if (!ArtifactSearchPage.this.isValidPhraseSearch(ArtifactSearchPage.this.fSearchCombo.getText())) {
                    ArtifactSearchPage.this.showWarning(Messages.ArtifactSearchPage_INVALID_PHRASE_SEARCH);
                } else {
                    ArtifactSearchPage.this.showWarning(null);
                }
            }
        });
        int i = HISTORY.size() - 1;
        int j = 0;
        while (i >= 0 && j < 15) {
            comboViewer.add((Object)HISTORY.get(i));
            --i;
            ++j;
        }
        ISelection sel = this.fSearchPageContainer.getSelection();
        if (sel instanceof ITextSelection && ((ITextSelection)sel).getLength() > 0) {
            this.fSearchCombo.setText(this.getText((ITextSelection)sel));
        } else if (!HISTORY.isEmpty()) {
            this.fSearchCombo.select(0);
        }
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ArtifactSearchPage.this.updateScopes((HistoryItem)selection.getFirstElement());
                }
            }
        });
        Composite groupContainer = new Composite(pageContainer, 0);
        groupContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        groupContainer.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)groupContainer.getLayout()).marginTop = 10;
        ((GridLayout)groupContainer.getLayout()).marginHeight = 0;
        ((GridLayout)groupContainer.getLayout()).marginWidth = 0;
        Group optionsGroup = new Group(groupContainer, 0);
        optionsGroup.setText(Messages.ArtifactSearchPage_OPTIONS);
        optionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        optionsGroup.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)optionsGroup.getLayout()).marginHeight = 0;
        ((GridLayout)optionsGroup.getLayout()).verticalSpacing = 2;
        Label repoLabel = new Label((Composite)optionsGroup, 0);
        repoLabel.setText(Messages.ArtifactSearchPage_REPOSITORY);
        this.createRepositorySelector((Composite)optionsGroup);
        Label scopeLabel = new Label((Composite)optionsGroup, 0);
        scopeLabel.setText(Messages.ArtifactSearchPage_LIMIT_SEARCH_TO);
        Composite scopeContainer = new Composite((Composite)optionsGroup, 0);
        scopeContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        RowLayout layout = new RowLayout(256);
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        layout.spacing = 5;
        scopeContainer.setLayout((Layout)layout);
        ArrayList<ArtifactType> searchScopes = new ArrayList<ArtifactType>(FulltextUIPlugin.getDefault().getServerArtifactTypes());
        Collections.sort(searchScopes, new Comparator<ArtifactType>(){

            @Override
            public int compare(ArtifactType o1, ArtifactType o2) {
                return ArtifactSearchPage.this.fCollator.compare(o1.getName(), o2.getName());
            }
        });
        this.fScopeChecks = new ArrayList<Button>(searchScopes.size());
        for (ArtifactType scope : searchScopes) {
            Button scopeCheck = new Button(scopeContainer, 32);
            scopeCheck.setText(scope.getName());
            scopeCheck.setImage(this.fResources.createImage(scope.getIcon()));
            scopeCheck.setData((Object)scope);
            this.fScopeChecks.add(scopeCheck);
        }
        this.setControl((Control)pageContainer);
        IStructuredSelection selection = (IStructuredSelection)comboViewer.getSelection();
        if (!selection.isEmpty()) {
            this.updateScopes((HistoryItem)selection.getFirstElement());
        }
        Dialog.applyDialogFont((Control)pageContainer);
    }

    private boolean isValidPhraseSearch(String search) {
        int quoteIndex;
        if (search == null || search.length() == 0) {
            return true;
        }
        search = search.trim();
        int quoteCount = 0;
        int i = 0;
        while (i < search.length()) {
            if (search.charAt(i) == '\"') {
                ++quoteCount;
            }
            ++i;
        }
        if (quoteCount < 2) {
            return true;
        }
        boolean startsWithQuote = search.startsWith("\"");
        boolean endsWithQuote = search.endsWith("\"");
        boolean containsQuote = search.contains("\"");
        if (startsWithQuote && !endsWithQuote) {
            return false;
        }
        if (!startsWithQuote && endsWithQuote) {
            return false;
        }
        if (!startsWithQuote && !endsWithQuote && containsQuote) {
            return false;
        }
        return !startsWithQuote || !endsWithQuote || (quoteIndex = search.indexOf("\"", 1)) + 1 == search.length();
    }

    private String getText(ITextSelection sel) {
        String text = sel.getText();
        if (text == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new StringReader(text));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            return "";
        }
    }

    private void updateScopes(HistoryItem item) {
        List<String> scope = item.getSearchScope();
        block0: for (Button button : this.fScopeChecks) {
            button.setSelection(false);
            for (String scopeVal : scope) {
                ArtifactType type = (ArtifactType)button.getData();
                if (!type.getId().equals(scopeVal)) continue;
                button.setSelection(true);
                continue block0;
            }
        }
    }

    private void createRepositorySelector(Composite parent) {
        final ToolBar toolBar = new ToolBar(parent, 0x820000);
        toolBar.setLayoutData((Object)new GridData(4, 1, false, false));
        this.fSelectRepositoryItem = new ToolItem(toolBar, 4);
        this.updateRepositorySelector();
        final Menu menu = new Menu((Control)toolBar);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menu.dispose();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                ITeamRepository[] teamRepositories;
                MenuItem[] items;
                MenuItem[] menuItemArray = items = menu.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                ITeamRepository[] iTeamRepositoryArray = teamRepositories = ArtifactSearchPage.this.fTeamRepoService.getTeamRepositories();
                int n3 = teamRepositories.length;
                n = 0;
                while (n < n3) {
                    final ITeamRepository repository = iTeamRepositoryArray[n];
                    MenuItem item = new MenuItem(menu, 16);
                    item.setText(ArtifactSearchPage.this.fStandardLabelProvider.getText((Object)repository));
                    item.setImage(ArtifactSearchPage.this.fStandardLabelProvider.getImage((Object)repository));
                    item.setEnabled(repository.loggedIn());
                    item.setSelection(ArtifactSearchPage.this.fSelectedRepository.equals(repository));
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (ArtifactSearchPage.this.fSelectedRepository != null) {
                                ArtifactSearchPage.this.fSelectedRepository.removeGenericListener((Object)"state", (IListener)ArtifactSearchPage.this);
                            }
                            ArtifactSearchPage.this.fSelectedRepository = repository;
                            ArtifactSearchPage.this.fSelectedRepository.addGenericListener((Object)"state", (IListener)ArtifactSearchPage.this);
                            if (ArtifactSearchPage.this.fSelectedRepository.loggedIn()) {
                                ArtifactSearchPage.this.handleLogin();
                            } else {
                                ArtifactSearchPage.this.handleLogout();
                            }
                        }
                    });
                    ++n;
                }
            }
        });
        this.fSelectRepositoryItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = ArtifactSearchPage.this.fSelectRepositoryItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        if (this.fSelectedRepository == null || !this.fSelectedRepository.loggedIn()) {
            this.showError(Messages.ArtifactSearchPage_SELECT_LOGGED_IN_REPOSITORY);
        }
    }

    private void updateRepositorySelector() {
        if (this.fSelectedRepository != null) {
            this.fSelectRepositoryItem.setImage(this.fStandardLabelProvider.getImage((Object)this.fSelectedRepository));
            this.fSelectRepositoryItem.setText(this.fStandardLabelProvider.getText((Object)this.fSelectedRepository));
        } else {
            this.fSelectRepositoryItem.setImage(this.fResources.createImage(FulltextUIPlugin.getDefault().createDescriptor("icons/obj16/repo_loggedout.gif")));
            this.fSelectRepositoryItem.setText(Messages.ArtifactSearchPage_SELECT_REPOSITORY);
        }
    }

    public boolean performAction() {
        ArrayList<ArtifactType> searchScopeValues = new ArrayList<ArtifactType>();
        for (Button button : this.fScopeChecks) {
            if (!button.getSelection()) continue;
            searchScopeValues.add((ArtifactType)button.getData());
        }
        ArtifactType planType = FulltextUIPlugin.getDefault().getArtifactType(ITERATION_PLAN_TYPE);
        ArtifactType wikiType = FulltextUIPlugin.getDefault().getArtifactType(WIKI_TYPE);
        if (searchScopeValues.contains(planType) && !searchScopeValues.contains(wikiType)) {
            searchScopeValues.add(wikiType);
        }
        String searchFor = this.fSearchCombo.getText();
        ArrayList<String> scope = new ArrayList<String>();
        for (ArtifactType artifactType : searchScopeValues) {
            scope.add(artifactType.getId());
        }
        HistoryItem historyItem = new HistoryItem(searchFor, scope);
        if (HISTORY.contains(historyItem)) {
            HISTORY.remove(historyItem);
        }
        HISTORY.add(historyItem);
        NewSearchUI.runQueryInBackground((ISearchQuery)new ArtifactSearchQuery(this.fSelectedRepository, searchFor, searchScopeValues));
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.fSelectedRepository != null) {
            this.fSelectedRepository.removeGenericListener((Object)"state", (IListener)this);
        }
        this.fResources.dispose();
        XMLMemento memento = XMLMemento.createWriteRoot((String)MEMENTO_SEARCH_PAGE);
        if (HISTORY.size() > 15) {
            HistoryItem.saveTo((IMemento)memento, HISTORY.subList(HISTORY.size() - 15, HISTORY.size()));
        } else {
            HistoryItem.saveTo((IMemento)memento, HISTORY);
        }
        if (this.fSelectedRepository != null && this.fSelectedRepository.getId() != null) {
            memento.putString(PREF_SELECTED_REPOSITORY, this.fSelectedRepository.getId().getUuidValue());
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            String sectionName = ID;
            IDialogSettings section = FulltextUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
            if (section == null) {
                section = FulltextUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
            }
            section.put(MEMENTO_DIALOG_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setContainer(ISearchPageContainer container) {
        String settings;
        this.fSearchPageContainer = container;
        this.fTeamRepoService = TeamPlatform.getTeamRepositoryService();
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        IDialogSettings section = FulltextUIPlugin.getDefault().getDialogSettings().getSection(ID);
        if (section != null && (settings = section.get(MEMENTO_DIALOG_SETTINGS)) != null) {
            try {
                this.fMemento = XMLMemento.createReadRoot((Reader)new StringReader(settings));
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
        this.fSelectedRepository = this.getDefaultRepository();
        if (this.fSelectedRepository != null) {
            this.fSelectedRepository.addGenericListener((Object)"state", (IListener)this);
        }
        if (this.fSelectedRepository != null && !this.fSelectedRepository.loggedIn()) {
            this.showError(Messages.ArtifactSearchPage_SELECT_LOGGED_IN_REPOSITORY);
        }
    }

    private ITeamRepository getDefaultRepository() {
        ITeamRepository[] teamRepositories;
        String oldUuid = null;
        if (this.fMemento != null) {
            oldUuid = this.fMemento.getString(PREF_SELECTED_REPOSITORY);
        }
        ITeamRepository[] iTeamRepositoryArray = teamRepositories = this.fTeamRepoService.getTeamRepositories();
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if (oldUuid == null && teamRepository.loggedIn()) {
                return teamRepository;
            }
            UUID teamRepoId = teamRepository.getId();
            if (oldUuid != null && teamRepoId != null && oldUuid.equals(teamRepoId.getUuidValue())) {
                return teamRepository;
            }
            ++n2;
        }
        if (teamRepositories.length > 0) {
            return teamRepositories[0];
        }
        return null;
    }

    private void showError(String error) {
        if (this.fInfoLabel == null) {
            return;
        }
        if (error != null) {
            this.fInfoLabel.setText(error);
            this.fInfoLabel.setForeground(this.fInfoLabel.getDisplay().getSystemColor(3));
        } else {
            this.fInfoLabel.setText(Messages.ArtifactSearchPage_CONTAINING_TEXT);
            this.fInfoLabel.setForeground(null);
        }
    }

    private void showWarning(String warning) {
        if (this.fInfoLabel == null) {
            return;
        }
        if (warning != null) {
            this.fInfoLabel.setText(warning);
            this.fInfoLabel.setForeground(this.fInfoLabel.getDisplay().getSystemColor(8));
        } else {
            this.fInfoLabel.setText(Messages.ArtifactSearchPage_CONTAINING_TEXT);
            this.fInfoLabel.setForeground(null);
        }
    }

    public void handleEvents(List events) {
        for (Object event : events) {
            IEventSource source;
            PropertyChangeEvent extended;
            Object property;
            if (!(event instanceof PropertyChangeEvent) || !"state".equals(property = (extended = (PropertyChangeEvent)event).getProperty()) || !((source = extended.getEventSource()) instanceof ITeamRepository)) continue;
            ITeamRepository repository = (ITeamRepository)source;
            int state = repository.getState();
            switch (state) {
                case 1: {
                    this.handleLogin();
                    break;
                }
                case 3: {
                    this.handleLogout();
                }
            }
        }
    }

    void handleLogin() {
        this.fSearchCombo.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArtifactSearchPage.this.fSearchCombo.setEnabled(true);
                ArtifactSearchPage.this.fSearchPageContainer.setPerformActionEnabled(ArtifactSearchPage.this.fSearchCombo.getText().length() > 0);
                ArtifactSearchPage.this.fSearchCombo.setFocus();
                ArtifactSearchPage.this.showError(null);
                ArtifactSearchPage.this.updateRepositorySelector();
            }
        });
    }

    void handleLogout() {
        this.fSearchCombo.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArtifactSearchPage.this.fSearchCombo.setEnabled(false);
                ArtifactSearchPage.this.fSearchPageContainer.setPerformActionEnabled(false);
                ArtifactSearchPage.this.showError(Messages.ArtifactSearchPage_SELECT_LOGGED_IN_REPOSITORY);
                ArtifactSearchPage.this.updateRepositorySelector();
            }
        });
    }
}

