/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.history;

import com.ibm.team.fulltext.common.model.IScoredResult;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ResultModel {
    private Map<String, CategoryElement> fCategories = new HashMap<String, CategoryElement>();
    private List<IScoredResult> fResults;

    public ResultModel(List<IScoredResult> list) {
        this.fResults = list == null ? Collections.EMPTY_LIST : list;
        for (IScoredResult result : this.fResults) {
            URI uri = result.getResult().getURI();
            String type = result.getResult().getType();
            CategoryElement element = this.fCategories.get(type);
            if (element == null) {
                element = new CategoryElement(uri, uri, this.fCategories.size());
                this.fCategories.put(type, element);
                continue;
            }
            element.setLast(uri);
        }
    }

    public List<IScoredResult> getItems() {
        return this.fResults;
    }

    public boolean isFirstInCategory(IScoredResult element) {
        URI firstInCategory;
        String type = element.getResult().getType();
        URI uri = element.getResult().getURI();
        CategoryElement category = this.fCategories.get(type);
        if (category != null && (firstInCategory = category.getFirst()) != null) {
            return firstInCategory.equals(uri);
        }
        return false;
    }

    public boolean isLastInCategory(IScoredResult element) {
        URI lastInCategory;
        String type = element.getResult().getType();
        URI uri = element.getResult().getURI();
        CategoryElement category = this.fCategories.get(type);
        if (category != null && (lastInCategory = category.getLast()) != null) {
            return lastInCategory.equals(uri);
        }
        return false;
    }

    public int category(IScoredResult element) {
        String type = element.getResult().getType();
        return this.fCategories.get(type).getOridinal();
    }

    private static class CategoryElement {
        private URI fFirst;
        private URI fLast;
        private int fOridinal;

        public CategoryElement(URI first, URI last, int oridinal) {
            this.fFirst = first;
            this.fLast = last;
            this.fOridinal = oridinal;
        }

        public URI getFirst() {
            return this.fFirst;
        }

        public URI getLast() {
            return this.fLast;
        }

        public void setLast(URI last) {
            this.fLast = last;
        }

        public int getOridinal() {
            return this.fOridinal;
        }
    }
}

