/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.history;

import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.util.List;

class ArtifactHistoryUtils {
    ArtifactHistoryUtils() {
    }

    public static IItemHandle getItemHandle(IScoredResult element) {
        Location location = ArtifactHistoryUtils.getLocation(element);
        if (location == null) {
            return null;
        }
        return location.getItemHandle();
    }

    private static Location getLocation(IScoredResult element) {
        try {
            URI uri = element.getResult().getURI();
            return Location.location((URI)uri);
        }
        catch (TeamRepositoryException e) {
            return null;
        }
    }

    public static IItem getSharedItemIfKnown(IItemHandle handle, List<ITeamRepository> repositories) {
        for (ITeamRepository repository : repositories) {
            IItem item = repository.itemManager().getSharedItemIfKnown(handle);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static String removeQueryPadding(String text) {
        if ((text = text.trim()).startsWith("*") || text.startsWith("?") || text.startsWith("\"")) {
            text = text.substring(1);
        }
        if (text.endsWith("*") || text.endsWith("?") || text.endsWith("\"")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

