/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal.history;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.fulltext.client.IClientFullText;
import com.ibm.team.fulltext.client.internal.ArtifactHistoryProvider;
import com.ibm.team.fulltext.client.internal.FullTextClientPlugin;
import com.ibm.team.fulltext.common.FulltextException;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.fulltext.ide.ui.internal.ArtifactType;
import com.ibm.team.fulltext.ide.ui.internal.FulltextUIPlugin;
import com.ibm.team.fulltext.ide.ui.internal.ScoredResultAdapter;
import com.ibm.team.fulltext.ide.ui.internal.history.ArtifactHistoryUtils;
import com.ibm.team.fulltext.ide.ui.internal.history.Messages;
import com.ibm.team.fulltext.ide.ui.internal.history.ResultModel;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

class ArtifactHistorySearchDialog
extends PopupDialog {
    private static final String MEMENTO_ROOT = "artifacthistory";
    private static final String DIALOG_SETTINGS = "ArtifactHistorySearchDialog";
    private static final String PREF_ID = "com.ibm.team.fulltext.ide.ui.internal.history.ArtifactHistorySearchDialog";
    private static final String PREF_SORT_BY_RELEVANCE = "sortByRelevance";
    private static final String PREF_OPENED_RESULTS_HISTORY_KEY = "openedResultsHistory";
    private static final String PREF_URIREFERENCE_URI = "uriReferenceUri";
    private static final String PREF_URIREFERENCE_TYPE = "uriReferenceType";
    private static final String PREF_URIREFERENCE_NAME = "uriReferenceName";
    private static final int SEARCH_DELAY = 300;
    private static final int MAX_OPENED_RESULTS_HISTORY_ENTRIES = 20;
    private Text fFilterText;
    private Table fTable;
    private TableViewer fViewer;
    private IClientFullText fClientFullText;
    private List<ITeamRepository> fRepositories;
    private Map<String, ArtifactType> fMapIdToArtifactType;
    private final FilterJob fFilterJob = new FilterJob();
    private Label fProgressLabel;
    private JobChangeAdapter fJobListener;
    private IMemento fSettings;
    private boolean fSortByRelevance;
    private LinkedList<IScoredResult> fOpenedResultsHistory = new LinkedList();
    private boolean fDragInProgress;

    public ArtifactHistorySearchDialog(IWorkbenchWindow window) {
        super(window.getShell(), 16, true, true, false, true, true, null, null);
        this.fClientFullText = FullTextClientPlugin.getDefault().getClientFullText();
        this.fRepositories = Arrays.asList(TeamPlatform.getTeamRepositoryService().getTeamRepositories());
        this.fSettings = this.loadSettings();
        if (this.fSettings != null) {
            IMemento[] entries;
            if (this.fSettings.getBoolean(PREF_SORT_BY_RELEVANCE) != null) {
                this.fSortByRelevance = this.fSettings.getBoolean(PREF_SORT_BY_RELEVANCE);
            }
            if ((entries = this.fSettings.getChildren(PREF_OPENED_RESULTS_HISTORY_KEY)) != null) {
                IMemento[] iMementoArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento entry = iMementoArray[n2];
                    String uriReferenceUri = entry.getString(PREF_URIREFERENCE_URI);
                    String uriReferenceType = entry.getString(PREF_URIREFERENCE_TYPE);
                    String uriReferenceName = entry.getString(PREF_URIREFERENCE_NAME);
                    if (uriReferenceUri != null && uriReferenceType != null && uriReferenceName != null) {
                        ScoredResultAdapter result = new ScoredResultAdapter(new URIReference(uriReferenceName, uriReferenceName, uriReferenceType, URI.create(uriReferenceUri)), 0L);
                        this.fOpenedResultsHistory.addLast(result);
                    }
                    ++n2;
                }
            }
        }
        Collection<ArtifactType> types = FulltextUIPlugin.getDefault().getClientArtifactTypes();
        this.fMapIdToArtifactType = new ConcurrentHashMap<String, ArtifactType>();
        for (ArtifactType type : types) {
            this.fMapIdToArtifactType.put(type.getId(), type);
        }
        this.setInfoText(Messages.ArtifactHistorySearchDialog_TEAM_HISTORY_INFO);
    }

    protected Point getDefaultSize() {
        Display display = this.getShell().getDisplay();
        GC gc = new GC((Drawable)display);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            int width = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)100);
            int height = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)30);
            Point point = new Point(width, height);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings all = FulltextUIPlugin.getDefault().getDialogSettings();
        IDialogSettings result = all.getSection(DIALOG_SETTINGS);
        if (result == null) {
            result = new DialogSettings(DIALOG_SETTINGS);
            all.addSection(result);
        }
        return result;
    }

    protected Control getFocusControl() {
        return this.fFilterText;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        if (this.fRepositories.isEmpty()) {
            this.fFilterText.setText(Messages.ArtifactHistorySearchDialog_NOT_CONNECTED);
            this.fFilterText.setEnabled(false);
        } else {
            this.fFilterJob.schedule();
        }
        return result;
    }

    private boolean shouldShowOpenedResultsHistory(String term) {
        if (term == null || term.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < term.length()) {
            if (term.charAt(i) != '*' && term.charAt(i) != '?') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Control createTitleControl(Composite parent) {
        Job[] runningJobs;
        Composite titleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleArea.setLayout((Layout)layout);
        titleArea.setLayoutData((Object)new GridData(768));
        this.fFilterText = new Text(titleArea, 0);
        this.fFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    ArtifactHistorySearchDialog.this.handleSelection();
                    return;
                }
                if (e.keyCode == 0x1000002) {
                    int index = ArtifactHistorySearchDialog.this.fTable.getSelectionIndex();
                    if (ArtifactHistorySearchDialog.this.fTable.getItemCount() > index + 1) {
                        ArtifactHistorySearchDialog.this.fTable.setSelection(index + 1);
                    }
                    ArtifactHistorySearchDialog.this.fTable.setFocus();
                } else if (e.keyCode == 0x1000001) {
                    int index = ArtifactHistorySearchDialog.this.fTable.getSelectionIndex();
                    if (index != -1 && index >= 1) {
                        ArtifactHistorySearchDialog.this.fTable.setSelection(index - 1);
                        ArtifactHistorySearchDialog.this.fTable.setFocus();
                    }
                } else if (e.character == '\u001b') {
                    ArtifactHistorySearchDialog.this.close(true);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArtifactHistorySearchDialog.this.fFilterJob.cancel();
                ArtifactHistorySearchDialog.this.fFilterJob.schedule(300L);
            }
        });
        this.fProgressLabel = new Label(titleArea, 0);
        this.fProgressLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.fJobListener = new JobChangeAdapter(){

            public void scheduled(IJobChangeEvent event) {
                if (event.getJob().belongsTo(ArtifactHistoryProvider.INDEX_JOB_FAMILY)) {
                    ArtifactHistorySearchDialog.this.setProgressLabel(Messages.ArtifactHistorySearchDialog_UPDATING_HISTORY);
                }
            }

            public void done(IJobChangeEvent event) {
                if (event.getJob().belongsTo(ArtifactHistoryProvider.INDEX_JOB_FAMILY)) {
                    ArtifactHistorySearchDialog.this.setProgressLabel("");
                }
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.fJobListener);
        Job[] jobArray = runningJobs = Job.getJobManager().find(ArtifactHistoryProvider.INDEX_JOB_FAMILY);
        int n = runningJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job runningJob = jobArray[n2];
            if ((runningJob.getState() == 4 || runningJob.getState() == 2) && runningJob.belongsTo(ArtifactHistoryProvider.INDEX_JOB_FAMILY)) {
                this.setProgressLabel(Messages.ArtifactHistorySearchDialog_UPDATING_HISTORY);
                break;
            }
            ++n2;
        }
        return titleArea;
    }

    private void setProgressLabel(final String label) {
        new FoundationUIJob(""){

            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                if (!ArtifactHistorySearchDialog.this.fProgressLabel.isDisposed()) {
                    ArtifactHistorySearchDialog.this.fProgressLabel.setText(label);
                    ArtifactHistorySearchDialog.this.fProgressLabel.getParent().layout();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        dialogMenu.add((IContributionItem)new Separator());
        dialogMenu.add((IContributionItem)new Separator());
        Action action = new Action(Messages.ArtifactHistorySearchDialog_SORT_BY_DATE, 8){

            public void run() {
                ArtifactHistorySearchDialog.this.fSortByRelevance = false;
                ArtifactHistorySearchDialog.this.onSort();
            }
        };
        if (!this.fSortByRelevance) {
            action.setChecked(true);
        }
        dialogMenu.add((IAction)action);
        action = new Action(Messages.ArtifactHistorySearchDialog_SORT_BY_RELEVANCE, 8){

            public void run() {
                ArtifactHistorySearchDialog.this.fSortByRelevance = true;
                ArtifactHistorySearchDialog.this.onSort();
            }
        };
        if (this.fSortByRelevance) {
            action.setChecked(true);
        }
        dialogMenu.add((IAction)action);
        dialogMenu.add((IContributionItem)new Separator());
        dialogMenu.add((IAction)new Action(Messages.ArtifactHistorySearchDialog_CLEAR_HISTORY){

            public void run() {
                ArtifactHistorySearchDialog.this.onClear();
            }
        });
    }

    private void onClear() {
        boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.ArtifactHistorySearchDialog_CONFIRM_CLEAR_HISTORY, (String)Messages.ArtifactHistorySearchDialog_CONFIRM_CLEAR_HISTORY_MSG);
        if (!confirmed) {
            return;
        }
        this.fOpenedResultsHistory.clear();
        new UIUpdaterJob(""){

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    ArtifactHistorySearchDialog.this.fClientFullText.clear(monitor);
                }
                catch (FulltextException e) {
                    FulltextUIPlugin.getDefault().log(e);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                ArtifactHistorySearchDialog.this.fFilterJob.cancel();
                ArtifactHistorySearchDialog.this.fFilterJob.schedule(300L);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void onSort() {
        this.fFilterJob.cancel();
        this.fFilterJob.schedule(300L);
    }

    private void onDelete() {
        final IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        List items = selection.toList();
        for (Object item : items) {
            if (!(item instanceof IScoredResult)) continue;
            IScoredResult result = (IScoredResult)item;
            IScoredResult existingResult = null;
            for (IScoredResult historyEntry : this.fOpenedResultsHistory) {
                if (!historyEntry.getResult().equals((Object)result.getResult())) continue;
                existingResult = historyEntry;
                break;
            }
            if (existingResult == null) continue;
            this.fOpenedResultsHistory.remove(existingResult);
        }
        new UIUpdaterJob(""){

            public IStatus runInBackground(IProgressMonitor monitor) {
                List items = selection.toList();
                for (Object item : items) {
                    if (!(item instanceof IScoredResult)) continue;
                    IScoredResult result = (IScoredResult)item;
                    try {
                        ArtifactHistorySearchDialog.this.fClientFullText.delete(result.getResult(), result.getContainers() != null && result.getContainers().length == 1 ? result.getContainers()[0] : null, monitor);
                    }
                    catch (FulltextException e) {
                        FulltextUIPlugin.getDefault().log(e);
                    }
                }
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                ArtifactHistorySearchDialog.this.fFilterJob.cancel();
                ArtifactHistorySearchDialog.this.fFilterJob.schedule(300L);
                return super.runInUI(monitor);
            }
        }.schedule();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        this.fTable = new Table(composite, 0x10010002);
        this.fTable.setBackground(composite.getBackground());
        this.fTable.setHeaderVisible(false);
        this.fTable.setLinesVisible(false);
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.fTable, 0), (ColumnLayoutData)new ColumnWeightData(0, 120));
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.fTable, 0), (ColumnLayoutData)new ColumnWeightData(100, 150));
        this.fViewer = new TableViewer(this.fTable);
        this.fViewer.setUseHashlookup(true);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ArtifactHistorySearchDialog.this.getModel().getItems().toArray();
            }
        });
        this.fViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return ArtifactHistorySearchDialog.this.getModel().category((IScoredResult)element);
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                int result = this.category(e1) - this.category(e2);
                if (result != 0) {
                    return result;
                }
                return -1;
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ResultLabelProvider());
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ArtifactHistorySearchDialog.this.handleSelection();
            }
        });
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IWorkbenchPart part;
                IWorkbenchPage page;
                ISelection selection = ArtifactHistorySearchDialog.this.fViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                manager.add((IAction)new Action(Messages.ArtifactHistorySearchDialog_REMOVE_FROM_HISTORY){

                    public void run() {
                        ArtifactHistorySearchDialog.this.onDelete();
                    }
                });
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null) {
                    manager.add((IContributionItem)new Separator());
                    FoundationUIUtils.contributeObjectActions((IWorkbenchPart)part, (IMenuManager)manager, (ISelectionProvider)new ResultToReferenceConverter((ISelectionProvider)ArtifactHistorySearchDialog.this.fViewer));
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
        new DragSupport(this.fViewer.getControl()){

            protected void dragStarting(DragSourceEvent event) {
                super.dragStarting(event);
                ArtifactHistorySearchDialog.this.fDragInProgress = true;
            }

            public ISelection getSelection() {
                return ArtifactHistorySearchDialog.this.fViewer.getSelection();
            }

            protected ISelection convertSelection(ISelection selection) {
                ResultToReferenceConverter converter = new ResultToReferenceConverter((ISelectionProvider)ArtifactHistorySearchDialog.this.fViewer);
                return converter.convertFrom(selection);
            }

            protected void dragFinished(DragSourceEvent event) {
                super.dragFinished(event);
                ArtifactHistorySearchDialog.this.fDragInProgress = false;
                if (event.detail != 0) {
                    ArtifactHistorySearchDialog.this.close();
                }
            }
        };
        return composite;
    }

    public boolean close() {
        return this.close(false);
    }

    private boolean close(boolean force) {
        if (this.fDragInProgress && !force) {
            return false;
        }
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.fJobListener);
        this.saveSettings();
        return super.close();
    }

    private ResultModel getModel() {
        return (ResultModel)this.fViewer.getInput();
    }

    private void refresh(String filter, IProgressMonitor monitor) {
        if (this.fRepositories.isEmpty()) {
            return;
        }
        List<Object> input = null;
        boolean isShowingOpenedResultsHistory = false;
        if (this.shouldShowOpenedResultsHistory(filter)) {
            input = this.fOpenedResultsHistory;
            isShowingOpenedResultsHistory = true;
        } else {
            try {
                input = this.fClientFullText.find(filter, null, null, null, !this.fSortByRelevance, monitor);
            }
            catch (FulltextException e) {
                FulltextUIPlugin.getDefault().log(e);
            }
        }
        this.fViewer.setInput((Object)new ResultModel(input));
        if (isShowingOpenedResultsHistory) {
            if (input != null && !input.isEmpty()) {
                this.setProgressLabel(Messages.ArtifactHistorySearchDialog_PREVIOUS_CHOICES);
            } else {
                this.setProgressLabel(Messages.ArtifactHistorySearchDialog_TYPE_TO_SEARCH);
            }
        } else if (input != null) {
            if (input.size() == 1) {
                this.setProgressLabel(NLS.bind((String)Messages.ArtifactHistorySearchDialog_SINGLE_RESULT, (Object)input.size(), (Object[])new Object[0]));
            } else {
                this.setProgressLabel(NLS.bind((String)Messages.ArtifactHistorySearchDialog_N_RESULTS, (Object)input.size(), (Object[])new Object[0]));
            }
        } else {
            this.setProgressLabel("");
        }
    }

    private void handleSelection() {
        IScoredResult result;
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        List items = selection.toList();
        for (Object item : items) {
            if (!(item instanceof IScoredResult)) continue;
            result = (IScoredResult)item;
            IScoredResult existingResult = null;
            for (IScoredResult historyResult : this.fOpenedResultsHistory) {
                if (!historyResult.getResult().equals((Object)result.getResult())) continue;
                existingResult = historyResult;
                break;
            }
            if (existingResult != null) {
                this.fOpenedResultsHistory.remove(existingResult);
            }
            this.fOpenedResultsHistory.addFirst(result);
            if (this.fOpenedResultsHistory.size() <= 20) continue;
            this.fOpenedResultsHistory.removeLast();
        }
        this.close(true);
        for (Object item : items) {
            if (!(item instanceof IScoredResult)) continue;
            result = (IScoredResult)item;
            Hyperlinks.open((URI)result.getResult().getURI(), null);
        }
    }

    private IMemento loadSettings() {
        Preferences preference = FulltextUIPlugin.getDefault().getPluginPreferences();
        String mementoAsString = preference.getString(PREF_ID);
        if (mementoAsString != null && mementoAsString.length() > 0) {
            try {
                return XMLMemento.createReadRoot((Reader)new StringReader(mementoAsString));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private void saveSettings() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MEMENTO_ROOT);
        memento.putBoolean(PREF_SORT_BY_RELEVANCE, this.fSortByRelevance);
        for (IScoredResult result : this.fOpenedResultsHistory) {
            IMemento historyMemento = memento.createChild(PREF_OPENED_RESULTS_HISTORY_KEY);
            historyMemento.putString(PREF_URIREFERENCE_URI, result.getResult().getURI().toString());
            historyMemento.putString(PREF_URIREFERENCE_NAME, result.getResult().getName());
            historyMemento.putString(PREF_URIREFERENCE_TYPE, result.getResult().getType());
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            String prefIdentifier = PREF_ID;
            Preferences preference = FulltextUIPlugin.getDefault().getPluginPreferences();
            preference.setValue(prefIdentifier, writer.getBuffer().toString());
            FulltextUIPlugin.getDefault().savePluginPreferences();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class FilterJob
    extends FoundationUIJob {
        FilterJob() {
            super("");
        }

        protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
            if (!(monitor.isCanceled() || ArtifactHistorySearchDialog.this.fTable.isDisposed() || ArtifactHistorySearchDialog.this.fFilterText.isDisposed())) {
                ArtifactHistorySearchDialog.this.refresh(ArtifactHistorySearchDialog.this.fFilterText.getText(), monitor);
            }
            return Status.OK_STATUS;
        }
    }

    private class ResultLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProviderListener {
        private final StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        private final LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
        private final boolean fUseReducedColors = "org.eclipse.ui.ide.systemDefault".equals(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());

        public ResultLabelProvider() {
            this.fStandardLabelProvider.addListener((ILabelProviderListener)this);
        }

        protected void paint(Event event, Object element) {
            super.paint(event, element);
            boolean lastInCategory = ArtifactHistorySearchDialog.this.getModel().isLastInCategory((IScoredResult)element);
            if (lastInCategory) {
                ViewerCell cell;
                GC gc = event.gc;
                if (!this.fUseReducedColors) {
                    gc.setForeground(gc.getDevice().getSystemColor(15));
                }
                if ((cell = ArtifactHistorySearchDialog.this.fViewer.getCell(new Point(event.x, event.y))) != null && cell.getViewerRow() != null) {
                    Rectangle bounds = cell.getViewerRow().getBounds();
                    bounds.x = 0;
                    bounds.width = ((ArtifactHistorySearchDialog)ArtifactHistorySearchDialog.this).fViewer.getTable().getBounds().width;
                    gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.width, bounds.y + bounds.height - 1);
                }
            }
        }

        public void update(ViewerCell cell) {
            IScoredResult element = (IScoredResult)cell.getElement();
            ArtifactType artifactType = (ArtifactType)ArtifactHistorySearchDialog.this.fMapIdToArtifactType.get(element.getResult().getType());
            int index = cell.getColumnIndex();
            if (index == 0 && ArtifactHistorySearchDialog.this.getModel().isFirstInCategory(element)) {
                if (artifactType != null) {
                    cell.setText(artifactType.getName());
                    if (!this.fUseReducedColors) {
                        cell.setForeground(JazzResources.getColor((String)"com.ibm.team.jface.itemview.TitleColor"));
                    }
                    if (artifactType.getIcon() != null) {
                        cell.setImage(this.fResources.createImage(artifactType.getIcon()));
                    }
                }
            } else if (index == 1) {
                IItem item;
                String text = null;
                Image image = null;
                IItemHandle handle = ArtifactHistoryUtils.getItemHandle(element);
                if (handle != null && (item = ArtifactHistoryUtils.getSharedItemIfKnown(handle, ArtifactHistorySearchDialog.this.fRepositories)) != null) {
                    image = this.fStandardLabelProvider.getImage((Object)item);
                    text = this.fStandardLabelProvider.getText((Object)item);
                    if (text != null) {
                        ViewerLabel label = new ViewerLabel(text, image);
                        this.fStandardLabelProvider.invokeDecorators(label, (Object)element);
                        image = label.getImage();
                        text = label.getText();
                    }
                }
                if (image == null && artifactType != null) {
                    image = this.fResources.createImage(artifactType.getIcon());
                }
                if (text == null) {
                    text = element.getResult().getName();
                }
                if (!this.fUseReducedColors) {
                    cell.setStyleRanges(this.getStyledText(text).getStyleRanges());
                }
                cell.setText(text);
                cell.setImage(image);
            }
            super.update(cell);
        }

        private StyledString getStyledText(String text) {
            StyledString styledString = new StyledString(text);
            String searchValueLowercase = ArtifactHistoryUtils.removeQueryPadding(ArtifactHistorySearchDialog.this.fFilterText.getText()).toLowerCase().trim();
            String textValueLowercase = text.toLowerCase();
            StringTokenizer filterTokenizer = new StringTokenizer(searchValueLowercase);
            while (filterTokenizer.hasMoreTokens()) {
                String token = filterTokenizer.nextToken();
                this.styleText(styledString, textValueLowercase, token);
            }
            return styledString;
        }

        private void styleText(StyledString styledString, String targetValue, String token) {
            int indexOfToken;
            int offset = 0;
            while ((indexOfToken = targetValue.indexOf(token, offset)) != -1) {
                styledString.setStyle(indexOfToken, token.length(), StyledString.COUNTER_STYLER);
                offset = indexOfToken + 1;
            }
        }

        public void dispose() {
            this.fResources.dispose();
            this.fStandardLabelProvider.removeListener((ILabelProviderListener)this);
            this.fStandardLabelProvider.dispose();
            super.dispose();
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            if (event.getElements() != null) {
                ArtifactHistorySearchDialog.this.fViewer.update(event.getElements(), null);
            }
        }
    }

    private class ResultToReferenceConverter
    extends ConvertingSelectionProvider {
        ResultToReferenceConverter(ISelectionProvider provider) {
            super(provider);
        }

        protected ISelection convertFrom(ISelection viewerSelection) {
            Object[] viewerSelectionArray = ((IStructuredSelection)viewerSelection).toArray();
            ArrayList<IItemHandle> convertedSelection = new ArrayList<IItemHandle>(viewerSelectionArray.length);
            Object[] objectArray = viewerSelectionArray;
            int n = viewerSelectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScoredResult item;
                URI itemUri;
                Object object = objectArray[n2];
                if (object instanceof IScoredResult && (itemUri = (item = (IScoredResult)object).getResult().getURI()) != null && itemUri.isAbsolute()) {
                    try {
                        IItemHandle itemHandle;
                        ITeamRepository repository = ClientURIUtils.findTeamRepository((URI)itemUri);
                        if (repository != null && (itemHandle = Location.location((URI)itemUri).getItemHandle()) != null) {
                            ((ItemHandle)itemHandle).setOrigin((Object)repository);
                            convertedSelection.add(itemHandle);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        FoundationLog.log((IStatus)new Status(4, "com.ibm.team.fulltext.ide.ui", e.getMessage(), (Throwable)e));
                    }
                }
                ++n2;
            }
            return new StructuredSelection(convertedSelection);
        }
    }
}

