/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal;

import com.ibm.team.fulltext.ide.ui.internal.FulltextUIPlugin;
import com.ibm.team.jface.JazzResources;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class QuickFilter {
    private static final int SEARCH_FIELD_WIDTH = 150;
    private Composite fQuickFilterArea;
    private Text fQuickFilterInput;
    private ResourceManager fResourceManager;
    private final Control fKeyControl;
    private boolean fIsVisible;

    public QuickFilter(Composite parent, Control keyControl) {
        this.fKeyControl = keyControl;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.createQuickFilterArea(parent);
        this.fKeyControl.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character > ' ') {
                    QuickFilter.this.showQuickFilterArea(String.valueOf(e.character));
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.fQuickFilterInput.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.fQuickFilterInput.removeModifyListener(listener);
    }

    public void dispose() {
        this.fIsVisible = false;
        this.fResourceManager.dispose();
    }

    public boolean isVisible() {
        return this.fIsVisible;
    }

    private void createQuickFilterArea(Composite parent) {
        this.fQuickFilterArea = new Composite(parent, 0);
        this.fQuickFilterArea.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fQuickFilterArea.getLayoutData()).exclude = true;
        this.fQuickFilterArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(QuickFilter.this.fQuickFilterArea.getDisplay().getSystemColor(16));
                Rectangle clArea = QuickFilter.this.fQuickFilterArea.getClientArea();
                gc.drawLine(clArea.x, clArea.y, clArea.x + clArea.width, clArea.y);
            }
        });
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 2;
        this.fQuickFilterArea.setLayout((Layout)gridLayout);
        Label icon = new Label(this.fQuickFilterArea, 0);
        icon.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/filter.gif")));
        this.fQuickFilterInput = new Text(this.fQuickFilterArea, 2432);
        this.fQuickFilterInput.setLayoutData((Object)new GridData(150, -1));
        this.fQuickFilterInput.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                Text filter = (Text)e.widget;
                if (filter.getCharCount() == 0) {
                    QuickFilter.this.hideQuickFilterArea();
                }
            }
        });
        this.fQuickFilterInput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    QuickFilter.this.hideQuickFilterArea();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        ToolBar bar = new ToolBar(this.fQuickFilterArea, 0x800000);
        bar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        if ((this.fQuickFilterInput.getStyle() & 0x100) == 0) {
            ToolItem clearItem = new ToolItem(bar, 8);
            clearItem.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)FulltextUIPlugin.getDefault().createDescriptor("icons/elcl16/clear.gif")));
            clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QuickFilter.this.fQuickFilterInput.setText("");
                    if (!QuickFilter.this.fQuickFilterInput.isFocusControl()) {
                        QuickFilter.this.hideQuickFilterArea();
                    }
                }
            });
        }
        ToolItem hideItem = new ToolItem(bar, 8);
        hideItem.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)FulltextUIPlugin.getDefault().createDescriptor("icons/etool16/close.gif")));
        hideItem.setHotImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)FulltextUIPlugin.getDefault().createDescriptor("icons/etool16/close_hov.gif")));
        hideItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickFilter.this.hideQuickFilterArea();
            }
        });
    }

    public void showQuickFilterArea(String initial) {
        this.fIsVisible = true;
        this.fQuickFilterArea.setVisible(true);
        this.fQuickFilterArea.setFocus();
        ((GridData)this.fQuickFilterArea.getLayoutData()).exclude = false;
        this.fQuickFilterArea.getParent().layout();
        this.fQuickFilterInput.setText(initial);
        this.fQuickFilterInput.setSelection(initial.length());
    }

    public void hideQuickFilterArea() {
        this.fIsVisible = false;
        this.fQuickFilterInput.setText("");
        this.fQuickFilterArea.setVisible(false);
        ((GridData)this.fQuickFilterArea.getLayoutData()).exclude = true;
        this.fQuickFilterArea.getParent().layout();
        if (!this.fKeyControl.isDisposed() && this.fKeyControl instanceof Composite) {
            ((Composite)this.fKeyControl).setFocus();
        }
    }
}

