/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.jdt.internal;

import com.ibm.team.fulltext.jdt.internal.StackTraceElement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StackTraceLineDetector {
    private final Pattern fLinePattern;
    private final int fTypeGroup;
    private final int fMethodGroup;
    private final char fSeparator;
    private static final Log logger = LogFactory.getLog(StackTraceLineDetector.class);
    private static final int MAXIMUM_STACK_TRACE_LINE_LENGTH = 2000;
    private static final String RESTRICT_STACKTRACE_LINE_LENGTH = "com.ibm.team.repository.restrictStackTraceLineLength";
    private static final String STACKTRACE_LINE_LENGTH = "com.ibm.team.repository.stackTraceLineLength";
    static boolean restrictStackTraceLength = StackTraceLineDetector.booleanValue("com.ibm.team.repository.restrictStackTraceLineLength", true);
    static int lineLength = Integer.getInteger("com.ibm.team.repository.stackTraceLineLength", 2000);

    public StackTraceLineDetector(Pattern linePattern, char separator, int typeGroup) {
        this(linePattern, separator, typeGroup, -1);
    }

    public StackTraceLineDetector(Pattern linePattern, char separator, int typeGroup, int methodGroup) {
        this.fLinePattern = linePattern;
        this.fTypeGroup = typeGroup;
        this.fMethodGroup = methodGroup;
        this.fSeparator = separator;
    }

    public Collection<StackTraceElement> getMatches(String line) {
        LinkedList<StackTraceElement> matches = new LinkedList<StackTraceElement>();
        if (restrictStackTraceLength) {
            if (line.length() <= lineLength) {
                this.getMatches(line, matches);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping the regex matching for line : " + line.substring(0, 49) + "... ; of length : " + line.length()));
            }
        } else {
            this.getMatches(line, matches);
        }
        return matches;
    }

    private Collection<StackTraceElement> getMatches(String line, List<StackTraceElement> matches) {
        Matcher matcher = this.createMatcher(line);
        try {
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                String methodReference = this.getMethodReference(line, matcher);
                String unqualifiedTypeReference = this.getUnqualifiedMethodReference(line, matcher);
                matches.add(new StackTraceElement(start, end, methodReference, unqualifiedTypeReference));
            }
        }
        catch (StackOverflowError e) {
            Pattern oldPattern = matcher.pattern();
            try {
                String JAVA_IDENTIFIER = "[\\w\\p{Sc}<>]";
                String JAVA_IDENTIFIER2 = "[\\S]";
                String pattern = oldPattern.pattern();
                if (!pattern.contains(JAVA_IDENTIFIER)) {
                    throw e;
                }
                String newPatternString = pattern.replace(JAVA_IDENTIFIER, JAVA_IDENTIFIER2);
                matcher.usePattern(Pattern.compile(newPatternString));
                matcher.reset();
                boolean found = false;
                while (matcher.find()) {
                    found = true;
                    int start = matcher.start();
                    int end = matcher.end();
                    String methodReference = this.getMethodReference(line, matcher);
                    String unqualifiedTypeReference = this.getUnqualifiedMethodReference(line, matcher);
                    matches.add(new StackTraceElement(start, end, methodReference, unqualifiedTypeReference));
                }
                if (!found) {
                    throw e;
                }
            }
            finally {
                matcher.usePattern(oldPattern);
                matcher.reset();
            }
        }
        return matches;
    }

    protected Matcher createMatcher(String line) {
        return this.fLinePattern.matcher(line);
    }

    private String getMethodReference(String line, Matcher matcher) {
        if (this.fMethodGroup == -1) {
            return line.substring(matcher.start(this.getTypeGroup()), matcher.end(this.getTypeGroup()));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(line.substring(matcher.start(this.getTypeGroup()), matcher.end(this.getTypeGroup())));
        buffer.append(this.fSeparator);
        buffer.append(line.substring(matcher.start(this.getMethodGroup()), matcher.end(this.getMethodGroup())));
        return buffer.toString();
    }

    private String getUnqualifiedTypeReference(String line, Matcher matcher) {
        int index;
        int start = matcher.start(this.getTypeGroup());
        int end = matcher.end(this.getTypeGroup());
        if (end > 0 && this.fSeparator != '\u0000' && (index = line.lastIndexOf(this.fSeparator, end - 1)) > -1 && start < index && index < end) {
            start = index + 1;
        }
        return line.substring(start, end);
    }

    private String getUnqualifiedMethodReference(String line, Matcher matcher) {
        StringBuilder buffer = new StringBuilder();
        if (this.fMethodGroup > -1) {
            buffer.append(this.getUnqualifiedTypeReference(line, matcher));
            buffer.append(this.fSeparator);
            buffer.append(line.substring(matcher.start(this.getMethodGroup()), matcher.end(this.getMethodGroup())));
        }
        return buffer.toString();
    }

    protected int getTypeGroup() {
        return this.fTypeGroup;
    }

    protected int getMethodGroup() {
        return this.fMethodGroup;
    }

    private static boolean booleanValue(String propName, boolean defaultValue) {
        String prop = System.getProperty(propName);
        boolean val = prop == null ? defaultValue : Boolean.valueOf(prop.trim());
        return val;
    }
}

