/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.jdt.internal;

import com.ibm.team.fulltext.common.AbstractLineTokenizer;
import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import com.ibm.team.fulltext.common.internal.analysis.WordSpliter;
import com.ibm.team.fulltext.common.internal.index.IndexManagerImpl;
import com.ibm.team.fulltext.jdt.internal.JavaStackTraceDetector;
import com.ibm.team.fulltext.jdt.internal.StackTraceElement;
import com.ibm.team.repository.common.util.JazzLog;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;

public class JavaTokenizer
extends AbstractLineTokenizer {
    private static final String DEFAULT_TOKEN_TYPE = "word";
    private final JavaStackTraceDetector fDetector = JavaStackTraceDetector.getDefault();
    JazzLog logger = JazzLog.getLog((String)JavaTokenizer.class.getName());
    private static final EnumSet<TokenizerTypes> ALL_TOKENIZERS = EnumSet.of(TokenizerTypes.SPLIT_WHITESPACE, new TokenizerTypes[]{TokenizerTypes.SPLIT_NON_ALPHANUM, TokenizerTypes.EXPAND_CAMELCASE, TokenizerTypes.NORMALIZE_EXPAND_MULTICHARACTER, TokenizerTypes.LOWERCASE_TOKENS, TokenizerTypes.FILTER_STOP_WORDS, TokenizerTypes.PORTER_STEM_WORDS});
    private static Pattern DELIMITER_PATTERN = Pattern.compile("[\\.#\\$]");

    @Override
    public void tokenize(ArtifactToken lineToken) throws IOException {
        StackTraceElement curStackElement;
        String lineTokenText = lineToken.term();
        int offset = lineToken.startOffset();
        Collection<StackTraceElement> stackTraceElements = this.fDetector.getMatches(lineTokenText);
        Iterator<StackTraceElement> stackTraceElementIterator = stackTraceElements.iterator();
        StackTraceElement stackTraceElement = curStackElement = stackTraceElementIterator.hasNext() ? stackTraceElementIterator.next() : null;
        if (stackTraceElements.isEmpty()) {
            WordSpliter.Options options = IndexManagerImpl.getInstance().getOptions(false);
            try {
                options.useNewCJKAnalyzer();
            }
            catch (Exception e) {
                this.logger.warn((Object)e.getMessage(), e.getCause());
            }
            TokenStream tokenStream = WordSpliter.newSimpleWordSpliter(new StringReader(lineTokenText), options);
            ArtifactAttributeImpl attribute = ArtifactAttributeImpl.addAttributeToStream(tokenStream);
            tokenStream.reset();
            try {
                while (tokenStream.incrementToken()) {
                    this.addToken(attribute.toToken());
                }
                tokenStream.end();
            }
            finally {
                tokenStream.close();
            }
        }
        int i = 0;
        while (i < lineTokenText.length()) {
            if (curStackElement != null && curStackElement.getStartPosition() == i) {
                String methodReference = curStackElement.getMethodReference();
                ArtifactToken token = new ArtifactToken(methodReference, offset + i, offset + i + methodReference.length());
                token.setType("<com.ibm.team.fulltext.jdt.METHOD_REFERENCE>");
                this.addToken(token);
                String unqualifiedMethodReference = curStackElement.getUnqualifiedMethodReference();
                this.addUnqualifiedMethodReferenceToken(unqualifiedMethodReference, offset + lineTokenText.indexOf(unqualifiedMethodReference), "<com.ibm.team.fulltext.jdt.UNQUALIFIED_METHOD_REFERENCE>");
                i = curStackElement.getEndPosition() - 1;
                curStackElement = stackTraceElementIterator.hasNext() ? stackTraceElementIterator.next() : null;
            }
            ++i;
        }
    }

    private void addToken(ArtifactToken token) {
        String tokenText = (token = this.removeLeadingTrailingPuncation(token)).term();
        if (tokenText == null) {
            return;
        }
        String[] parts = DELIMITER_PATTERN.split(tokenText);
        if (parts.length > 1) {
            String type = DEFAULT_TOKEN_TYPE.equals(token.type()) ? "<com.ibm.team.fulltext.jdt.IDENTIFIER>" : token.type();
            ArtifactToken identifierToken = new ArtifactToken(tokenText, token.startOffset(), token.endOffset(), type);
            this.addToQueue(identifierToken);
            int i = 0;
            while (i < parts.length) {
                ArtifactToken t = new ArtifactToken(parts[i], token.startOffset(), token.endOffset(), "<com.ibm.team.fulltext.jdt.IDENTIFIER_PART>", identifierToken);
                t.setPositionIncrement(0);
                this.addToQueue(t);
                ++i;
            }
        } else if (DEFAULT_TOKEN_TYPE.equals(token.type())) {
            this.addToQueue(new ArtifactToken(tokenText, token.startOffset(), token.endOffset(), token.type(), ALL_TOKENIZERS));
        } else {
            this.addToQueue(new ArtifactToken(tokenText, token.startOffset(), token.endOffset(), token.type()));
        }
    }

    private ArtifactToken removeLeadingTrailingPuncation(ArtifactToken input) {
        String text = input.term();
        int length = text.length();
        int skipStart = 0;
        int skipEnd = length;
        int offset = input.startOffset();
        while (skipStart < length && !Character.isLetterOrDigit(text.charAt(skipStart))) {
            ++skipStart;
        }
        while (skipEnd > 0 && !Character.isLetterOrDigit(text.charAt(skipEnd - 1))) {
            --skipEnd;
        }
        if ((skipStart > 0 || skipEnd < length) && skipStart < skipEnd) {
            String newText = text.substring(skipStart, skipEnd);
            ArtifactToken token = new ArtifactToken(newText, offset + skipStart, offset + skipEnd);
            token.setType(input.type());
            return token;
        }
        return input;
    }

    private void addUnqualifiedMethodReferenceToken(String tokenString, int startOffset, String type) {
        ArtifactToken token = new ArtifactToken(tokenString, startOffset, startOffset + tokenString.length(), type);
        token.setPositionIncrement(0);
        this.addToQueue(token);
    }
}

