/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.jdt.internal;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.IQueryProvider;
import com.ibm.team.fulltext.common.ITokenGroup;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class JavaQueryProvider
implements IQueryProvider {
    @Override
    public Query createQuery(String tokenType, Analyzer analyzer, ITokenGroup tokenGroup) {
        boolean potentialStacktrace = tokenGroup.getTokenTypes().contains("<com.ibm.team.fulltext.jdt.METHOD_REFERENCE>");
        if ("<com.ibm.team.fulltext.jdt.METHOD_REFERENCE>".equals(tokenType)) {
            return this.createMethodReferenceQuery(tokenGroup);
        }
        if (!potentialStacktrace && "<com.ibm.team.fulltext.jdt.IDENTIFIER>".equals(tokenType)) {
            return this.createIdentifierQuery(tokenGroup);
        }
        return null;
    }

    private Query createMethodReferenceQuery(ITokenGroup tokenGroup) {
        BooleanQuery.Builder qb = new BooleanQuery.Builder();
        ITokenGroup subGroup = tokenGroup.getSubGroup("<com.ibm.team.fulltext.jdt.METHOD_REFERENCE>");
        for (ArtifactToken token : subGroup) {
            Term methodRefTerm = new Term("_content", token.term().toLowerCase());
            TermQuery termQuery = new TermQuery(methodRefTerm);
            qb = qb.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return qb.build();
    }

    private Query createIdentifierQuery(ITokenGroup tokenGroup) {
        BooleanQuery.Builder qb = new BooleanQuery.Builder();
        ITokenGroup subGroup = tokenGroup.getSubGroup("<com.ibm.team.fulltext.jdt.IDENTIFIER>");
        for (ArtifactToken identifierToken : subGroup) {
            ArrayList<TermQuery> disjuncts = new ArrayList<TermQuery>();
            ITokenGroup compoundGroup = tokenGroup.getSubGroup(identifierToken, Arrays.asList("<com.ibm.team.fulltext.jdt.IDENTIFIER_PART>"));
            ITokenGroup identifierParts = compoundGroup.getSubGroup("<com.ibm.team.fulltext.jdt.IDENTIFIER_PART>");
            TermQuery query = new TermQuery(new Term("_name", identifierToken.term()));
            query = new BoostQuery((Query)query, 2.0f);
            disjuncts.add(query);
            query = identifierParts.toBooleanQuery("_name", BooleanClause.Occur.MUST, false);
            query = new BoostQuery((Query)query, 2.0f);
            disjuncts.add(query);
            query = new TermQuery(new Term("_content", identifierToken.term()));
            disjuncts.add(query);
            query = identifierParts.toBooleanQuery("_content", BooleanClause.Occur.MUST, false);
            disjuncts.add(query);
            query = new PrefixQuery(new Term("_tags", identifierToken.term()));
            disjuncts.add(query);
            query = identifierParts.toBooleanQuery("_tags", BooleanClause.Occur.MUST, true);
            disjuncts.add(query);
            query = new TermQuery(new Term("_meta", identifierToken.term()));
            disjuncts.add(query);
            query = identifierParts.toBooleanQuery("_meta", BooleanClause.Occur.MUST, false);
            disjuncts.add(query);
            DisjunctionMaxQuery identifierQuery = new DisjunctionMaxQuery(disjuncts, 0.0f);
            qb.add((Query)identifierQuery, BooleanClause.Occur.MUST);
        }
        return qb.build();
    }
}

