/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.service;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.model.IFilter;
import com.ibm.team.fulltext.common.model.IInformationArtifact;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public interface IFullTextService {
    public void index(Collection<IInformationArtifact> var1, boolean var2) throws TeamRepositoryException;

    public void delete(URIReference var1, URIReference var2) throws TeamRepositoryException;

    public IScoredResult[] find(String var1, String[] var2, String var3, UUID[] var4) throws TeamRepositoryException;

    public IScoredResult[] findRelatedByReference(String var1, String var2) throws TeamRepositoryException;

    public IScoredResult[] findRelated(String var1, String var2) throws TeamRepositoryException;

    public IScoredResult[] findDuplicateByReference(String var1, String var2, String var3, String var4, String[] var5, UUID[] var6) throws TeamRepositoryException;

    public IScoredResult[] findDuplicate(String var1, String var2, String var3, String[] var4, UUID[] var5) throws TeamRepositoryException;

    public IScoredResult[] search(SearchOptions var1) throws TeamRepositoryException;

    public boolean updateIndex(IProgressMonitor var1) throws TeamRepositoryException;

    public void backup(ZipOutputStream var1, String var2, Map<String, Long> var3) throws IOException;

    public String getIndexLocation();

    public long getIndexDiskSpace();

    public String getFullIndexName();

    public long getBackupIndexSize(String var1) throws IOException;

    public void clearBackup(String var1) throws IOException;

    public boolean corruptedIndexes();

    public void renderProgress(PrintStream var1);

    public void cleanUpUnusedVersions();

    public void cleanUpUnusedVersions2(IProgressMonitor var1);

    public Boolean verifyFullTextIndexes(Boolean var1, String var2) throws TeamRepositoryException, IOException;

    public static class SearchOptions {
        public SearchType searchType = SearchType.FIND;
        public String name;
        public String content;
        public URIReference[] containerReferences;
        public String language;
        public String[] searchScope;
        public String constrainType;
        public UUID[] owners;
        public String[] frontSideUris;
        public int resultLimit;
        public int searchDuration;
        public String type;
        public String id;
        public IFilter userFilter;
    }

    public static enum SearchType {
        FIND,
        FIND_DUPLICATE,
        FIND_DUPLICATE_BY_REFERENCE,
        FIND_RELATED,
        FIND_RELATED_BY_REFERENCE,
        FIND_BY_CONTAINER_REFERENCE;

    }
}

